/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.DynamicBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ValueMarkerPresentationDialogBase
extends DialogWrapper {
    private static final Color DEFAULT_COLOR = JBColor.RED;
    @NotNull
    private final Set<String> myExistingMarkups;
    private SimpleColoredComponent myColorSample;
    private Color myColor;
    private JPanel myMainPanel;
    private JTextField myLabelField;
    private FixedSizeButton myChooseColorButton;
    private JPanel mySamplePanel;
    private JPanel myErrorPanel;

    public ValueMarkerPresentationDialogBase(@Nullable Component parent, @Nullable String defaultText, @NotNull Collection<ValueMarkup> markups) {
        if (markups == null) {
            ValueMarkerPresentationDialogBase.$$$reportNull$$$0(0);
        }
        super(parent, true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(XDebuggerBundle.message((String)"value.marker.dialog.select.object.label", (Object[])objectArray));
        this.setModal(true);
        this.myExistingMarkups = StreamEx.of(markups).map(ValueMarkup::getText).toSet();
        this.myLabelField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ValueMarkerPresentationDialogBase.this.updateLabelSample();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/tree/ValueMarkerPresentationDialogBase$1", "textChanged"));
            }
        });
        this.myChooseColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = ColorChooser.chooseColor((Component)ValueMarkerPresentationDialogBase.this.myColorSample, (String)XDebuggerBundle.message((String)"value.marker.dialog.choose.label.color", (Object[])new Object[0]), (Color)ValueMarkerPresentationDialogBase.this.myColor);
                if (color != null) {
                    ValueMarkerPresentationDialogBase.this.myColor = color;
                    ValueMarkerPresentationDialogBase.this.updateLabelSample();
                }
            }
        });
        this.myColor = DEFAULT_COLOR;
        if (defaultText != null) {
            defaultText = UniqueNameGenerator.generateUniqueName((String)defaultText, this.myExistingMarkups);
            this.myLabelField.setText(defaultText.trim());
            this.updateLabelSample();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myLabelField;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private void updateLabelSample() {
        this.myColorSample.clear();
        SimpleTextAttributes attributes = new SimpleTextAttributes(1, this.myColor);
        String text = this.myLabelField.getText().trim();
        this.myColorSample.append(text, attributes);
        this.myErrorPanel.removeAll();
        if (this.myExistingMarkups.contains(text)) {
            this.myErrorPanel.add(new JLabel(XDebuggerBundle.message((String)"xdebugger.mark.dialog.duplicate.warning", (Object[])new Object[0]), UIUtil.getBalloonWarningIcon(), 2));
        }
    }

    @Nullable
    public ValueMarkup getConfiguredMarkup() {
        String text = this.myLabelField.getText().trim();
        return text.isEmpty() ? null : new ValueMarkup(text, this.myColor, null);
    }

    private void createUIComponents() {
        this.myColorSample = new SimpleColoredComponent();
        this.mySamplePanel = new JPanel(new BorderLayout());
        this.mySamplePanel.setBorder(BorderFactory.createEtchedBorder());
        this.mySamplePanel.add("Center", (Component)this.myColorSample);
        this.myChooseColorButton = new FixedSizeButton((JComponent)this.mySamplePanel);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel2;
        JTextField jTextField;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), 0, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", ValueMarkerPresentationDialogBase.class).getString("value.marker.dialog.label.text"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLabelField = jTextField = new JTextField();
        jTextField.setColumns(30);
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", ValueMarkerPresentationDialogBase.class).getString("value.marker.dialog.preview.label"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = this.mySamplePanel;
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 3, null, new Dimension(406, 0), null));
        FixedSizeButton fixedSizeButton = this.myChooseColorButton;
        jPanel3.add((Component)fixedSizeButton, new GridConstraints(1, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myErrorPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markups", "com/intellij/xdebugger/impl/ui/tree/ValueMarkerPresentationDialogBase", "<init>"));
    }
}

