/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.AppTopics;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.startup.ServiceNotReadyException;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorHighlighterCache;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AsyncEventSupport;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.cache.impl.id.PlatformIdTableBuilding;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartFMap;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.gist.GistManager;
import com.intellij.util.indexing.AuthenticContent;
import com.intellij.util.indexing.ChangedFilesCollector;
import com.intellij.util.indexing.CorruptionMarker;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.DeletedVirtualFileStub;
import com.intellij.util.indexing.DocumentChangeDependentIndex;
import com.intellij.util.indexing.DocumentContent;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexFileTypeListener;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileBasedIndexPluginListener;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.GlobalIndexFilter;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexConfiguration;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexVersionRegistrationSink;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableFilesFilter;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedFileImpl;
import com.intellij.util.indexing.IndexedFileWrapper;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.LazyFileContentImpl;
import com.intellij.util.indexing.PerIndexDocumentVersionMap;
import com.intellij.util.indexing.PersistentIndicesConfiguration;
import com.intellij.util.indexing.ProjectFilesCondition;
import com.intellij.util.indexing.ProjectIndexableFilesFilter;
import com.intellij.util.indexing.PsiContent;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.RegisteredIndexes;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageBufferingHandler;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.UpdateTask;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.contentQueue.CachedFileContent;
import com.intellij.util.indexing.diagnostic.FileIndexingStatistics;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.storage.TransientChangesIndexStorage;
import com.intellij.util.indexing.impl.storage.VfsAwareMapIndexStorage;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.memory.InMemoryIndexStorage;
import com.intellij.util.indexing.snapshot.SnapshotHashEnumeratorService;
import com.intellij.util.indexing.snapshot.SnapshotInputMappings;
import com.intellij.util.indexing.snapshot.SnapshotSingleValueIndexStorage;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.SimpleMessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileBasedIndexImpl
extends FileBasedIndexEx {
    private static final ThreadLocal<VirtualFile> ourIndexedFile = new ThreadLocal();
    private static final ThreadLocal<VirtualFile> ourFileToBeIndexed = new ThreadLocal();
    private static final ThreadLocal<Stack<DumbModeAccessType>> ourDumbModeAccessTypeStack = ThreadLocal.withInitial(() -> new Stack());
    public static final Logger LOG = Logger.getInstance(FileBasedIndexImpl.class);
    private volatile RegisteredIndexes myRegisteredIndexes;
    private final PerIndexDocumentVersionMap myLastIndexedDocStamps = new PerIndexDocumentVersionMap();
    private final NotNullLazyValue<ChangedFilesCollector> myChangedFilesCollector = NotNullLazyValue.createValue(() -> (ChangedFilesCollector)AsyncEventSupport.EP_NAME.findExtensionOrFail(ChangedFilesCollector.class));
    private final List<IndexableFileSet> myIndexableSets = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Map<IndexableFileSet, Project> myIndexableSetToProjectMap = new THashMap();
    private final SimpleMessageBusConnection myConnection;
    private final FileDocumentManager myFileDocumentManager;
    private final Set<ID<?, ?>> myUpToDateIndicesForUnsavedOrTransactedDocuments = ContainerUtil.newConcurrentSet();
    private volatile SmartFMap<Document, PsiFile> myTransactionMap = SmartFMap.emptyMap();
    private final boolean myIsUnitTestMode;
    @Nullable
    private Runnable myShutDownTask;
    @Nullable
    private ScheduledFuture<?> myFlushingFuture;
    private final AtomicInteger myLocalModCount = new AtomicInteger();
    private final AtomicInteger myFilesModCount = new AtomicInteger();
    private final Set<Project> myProjectsBeingUpdated = ContainerUtil.newConcurrentSet();
    private final Lock myReadLock;
    final Lock myWriteLock;
    private static final ThreadLocal<Integer> myUpToDateCheckState = new ThreadLocal();
    private final ThreadLocal<Boolean> myReentrancyGuard = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final Key<SoftReference<ProjectIndexableFilesFilter>> ourProjectFilesSetKey = Key.create((String)"projectFiles");
    private final Lock myCalcIndexableFilesLock = new ReentrantLock();
    private static final Key<WeakReference<FileContentImpl>> ourFileContentKey = Key.create((String)"unsaved.document.index.content");
    private final StorageBufferingHandler myStorageBufferingHandler = new StorageBufferingHandler(){

        @Override
        @NotNull
        protected Stream<UpdatableIndex<?, ?, ?>> getIndexes() {
            IndexConfiguration state = FileBasedIndexImpl.this.getState();
            Stream<UpdatableIndex<?, ?, ?>> stream = state.getIndexIDs().stream().map(id2 -> state.getIndex(id2));
            if (stream == null) {
                5.$$$reportNull$$$0(0);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl$5", "getIndexes"));
        }
    };
    private final VirtualFileUpdateTask myForceUpdateTask = new VirtualFileUpdateTask();
    private volatile long myLastOtherProjectInclusionStamp;
    private static final boolean INDICES_ARE_PSI_DEPENDENT_BY_DEFAULT = SystemProperties.getBooleanProperty((String)"idea.indices.psi.dependent.default", (boolean)true);
    public static final boolean DO_TRACE_STUB_INDEX_UPDATE = SystemProperties.getBooleanProperty((String)"idea.trace.stub.index.update", (boolean)false);

    private IndexConfiguration getState() {
        return this.myRegisteredIndexes.getConfigurationState();
    }

    void dropRegisteredIndexes() {
        ScheduledFuture<?> flushingFuture = this.myFlushingFuture;
        LOG.assertTrue(flushingFuture == null || flushingFuture.isCancelled() || flushingFuture.isDone());
        LOG.assertTrue(this.myUpToDateIndicesForUnsavedOrTransactedDocuments.isEmpty());
        LOG.assertTrue(this.myProjectsBeingUpdated.isEmpty());
        LOG.assertTrue(!this.getChangedFilesCollector().isUpdateInProgress());
        LOG.assertTrue(this.myTransactionMap.isEmpty());
        this.myRegisteredIndexes = null;
    }

    public FileBasedIndexImpl() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.myReadLock = lock.readLock();
        this.myWriteLock = lock.writeLock();
        this.myFileDocumentManager = FileDocumentManager.getInstance();
        this.myIsUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        SimpleMessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().simpleConnect();
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new FileBasedIndexPluginListener(this));
        connection.subscribe(PsiDocumentTransactionListener.TOPIC, (Object)new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(@NotNull Document doc, @NotNull PsiFile file2) {
                if (doc == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.plus((Object)doc, (Object)file2);
                FileBasedIndexImpl.this.clearUpToDateIndexesForUnsavedOrTransactedDocs();
            }

            @Override
            public void transactionCompleted(@NotNull Document doc, @NotNull PsiFile file2) {
                if (doc == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.minus((Object)doc);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "doc";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transactionStarted";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transactionCompleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileBasedIndexFileTypeListener());
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    2.$$$reportNull$$$0(1);
                }
                FileBasedIndexImpl.this.cleanupMemoryStorage(true);
            }

            public void unsavedDocumentsDropped() {
                FileBasedIndexImpl.this.cleanupMemoryStorage(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/util/indexing/FileBasedIndexImpl$2";
                objectArray[2] = "fileContentReloaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appWillBeClosed(boolean isRestart) {
                if (!FileBasedIndexImpl.this.myRegisteredIndexes.areIndexesReady()) {
                    new Task.Modal(null, IndexingBundle.message((String)"indexes.preparing.to.shutdown.message", (Object[])new Object[0]), false){

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            FileBasedIndexImpl.this.myRegisteredIndexes.waitUntilAllIndicesAreInitialized();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/indexing/FileBasedIndexImpl$3$1", "run"));
                        }
                    }.queue();
                }
            }
        });
        this.myConnection = connection;
        FileBasedIndexExtension.EXTENSION_POINT_NAME.addExtensionPointListener(new ExtensionPointListener<FileBasedIndexExtension<?, ?>>(){

            public void extensionRemoved(@NotNull FileBasedIndexExtension<?, ?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(1);
                }
                ID.unloadId((ID)extension.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/util/indexing/FileBasedIndexImpl$4";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)ApplicationManager.getApplication());
        this.initComponent();
    }

    void scheduleFullIndexesRescan(@NotNull Collection<ID<?, ?>> indexesToRebuild, @NotNull String reason) {
        if (indexesToRebuild == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(0);
        }
        if (reason == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(1);
        }
        FileBasedIndexImpl.cleanupProcessedFlag();
        this.doClearIndices(id2 -> indexesToRebuild.contains(id2));
        FileBasedIndexImpl.scheduleIndexRebuild(reason);
    }

    @VisibleForTesting
    void doClearIndices(@NotNull Predicate<? super ID<?, ?>> filter2) {
        if (filter2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(2);
        }
        try {
            this.waitUntilIndicesAreInitialized();
        }
        catch (ProcessCanceledException e) {
            return;
        }
        IndexingStamp.flushCaches();
        ArrayList clearedIndexes = new ArrayList();
        ArrayList survivedIndexes = new ArrayList();
        for (ID<?, ?> indexId : this.getState().getIndexIDs()) {
            if (filter2.test(indexId)) {
                try {
                    this.clearIndex(indexId);
                }
                catch (StorageException e) {
                    LOG.info((Throwable)e);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                clearedIndexes.add(indexId);
                continue;
            }
            survivedIndexes.add(indexId);
        }
        LOG.info("indexes cleared: " + clearedIndexes.stream().map(id2 -> id2.getName()).collect(Collectors.joining(", ")) + "\nsurvived indexes: " + survivedIndexes.stream().map(id2 -> id2.getName()).collect(Collectors.joining(", ")));
    }

    boolean processChangedFiles(@NotNull Project project, @NotNull Processor<? super VirtualFile> processor2) {
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(4);
        }
        return Stream.concat(this.getChangedFilesCollector().getEventMerger().getChangedFiles(), this.getChangedFilesCollector().getFilesToUpdate()).filter(this.filesToBeIndexedForProjectCondition(project)).distinct().mapToInt(f -> processor2.process(f) ? 1 : 0).allMatch(success -> success == 1);
    }

    RegisteredIndexes getRegisteredIndexes() {
        return this.myRegisteredIndexes;
    }

    void setUpShutDownTask() {
        this.myShutDownTask = new MyShutDownTask();
        ShutDownTracker.getInstance().registerShutdownTask(this.myShutDownTask);
    }

    @ApiStatus.Internal
    public void dumpIndexStatistics() {
        IndexConfiguration state = this.getRegisteredIndexes().getState();
        for (ID<?, ?> id2 : state.getIndexIDs()) {
            state.getIndex(id2).dumpStatistics();
        }
    }

    public static boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file2, @Nullable FileType fileType) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(5);
        }
        return ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file2, (FileType)fileType);
    }

    static boolean belongsToScope(VirtualFile file2, VirtualFile restrictedTo, GlobalSearchScope filter2) {
        if (!(file2 instanceof VirtualFileWithId) || !file2.isValid()) {
            return false;
        }
        return !(restrictedTo != null && !Comparing.equal((Object)file2, (Object)restrictedTo) || filter2 != null && restrictedTo == null && !filter2.accept(file2));
    }

    public void requestReindex(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(6);
        }
        this.requestReindex(file2, true);
    }

    @ApiStatus.Internal
    public void requestReindex(@NotNull VirtualFile file2, boolean forceRebuildRequest) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(7);
        }
        GistManager.getInstance().invalidateData(file2);
        ChangedFilesCollector changedFilesCollector = this.getChangedFilesCollector();
        changedFilesCollector.invalidateIndicesRecursively(file2, true, forceRebuildRequest, changedFilesCollector.getEventMerger());
        if (this.myRegisteredIndexes.isInitialized()) {
            changedFilesCollector.ensureUpToDateAsync();
        }
    }

    void initComponent() {
        LOG.assertTrue(this.myRegisteredIndexes == null);
        this.myStorageBufferingHandler.resetState();
        this.myRegisteredIndexes = new RegisteredIndexes(this.myFileDocumentManager, this);
    }

    @Override
    public void waitUntilIndicesAreInitialized() {
        if (this.myRegisteredIndexes == null) {
            throw new ProcessCanceledException();
        }
        this.myRegisteredIndexes.waitUntilIndicesAreInitialized();
    }

    static <K, V> void registerIndexer(@NotNull FileBasedIndexExtension<K, V> extension, @NotNull IndexConfiguration state, @NotNull IndexVersionRegistrationSink registrationStatusSink) throws IOException {
        if (extension == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(8);
        }
        if (state == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(9);
        }
        if (registrationStatusSink == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(10);
        }
        ID name = extension.getName();
        int version2 = FileBasedIndexImpl.getIndexExtensionVersion(extension);
        File versionFile = IndexInfrastructure.getVersionFile(name);
        IndexingStamp.IndexVersionDiff diff = IndexingStamp.versionDiffers(name, version2);
        registrationStatusSink.setIndexVersionDiff(name, diff);
        if (diff != IndexingStamp.IndexVersionDiff.UP_TO_DATE) {
            boolean versionFileExisted = versionFile.exists();
            if (extension.hasSnapshotMapping() && versionFileExisted) {
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getPersistentIndexRootDir(name));
            }
            File rootDir = IndexInfrastructure.getIndexRootDir(name);
            if (versionFileExisted) {
                FileUtil.deleteWithRenaming((File)rootDir);
            }
            IndexingStamp.rewriteVersion(name, version2);
            try {
                if (versionFileExisted) {
                    for (FileBasedIndexInfrastructureExtension ex : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                        ex.onFileBasedIndexVersionChanged(name);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        FileBasedIndexImpl.initIndexStorage(extension, version2, state, registrationStatusSink);
    }

    private static <K, V> void initIndexStorage(@NotNull FileBasedIndexExtension<K, V> extension, int version2, @NotNull IndexConfiguration state, @NotNull IndexVersionRegistrationSink registrationStatusSink) throws IOException {
        THashSet addedTypes;
        if (extension == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(11);
        }
        if (state == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(12);
        }
        if (registrationStatusSink == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(13);
        }
        VfsAwareIndexStorage<K, V> storage = null;
        ID name = extension.getName();
        boolean contentHashesEnumeratorOk = false;
        FileBasedIndex.InputFilter inputFilter = extension.getInputFilter();
        if (inputFilter instanceof FileBasedIndex.FileTypeSpecificInputFilter) {
            addedTypes = new THashSet();
            ((FileBasedIndex.FileTypeSpecificInputFilter)inputFilter).registerFileTypesUsedForIndexing(arg_0 -> FileBasedIndexImpl.lambda$initIndexStorage$7((Set)addedTypes, arg_0));
        } else {
            addedTypes = null;
        }
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                if (VfsAwareMapReduceIndex.hasSnapshotMapping(extension) && !(contentHashesEnumeratorOk = SnapshotHashEnumeratorService.getInstance().initialize())) {
                    throw new IOException("content hash enumerator will be forcibly clean");
                }
                storage = FileBasedIndexImpl.createIndexStorage(extension);
                UpdatableIndex<K, V, FileContent> index = FileBasedIndexImpl.createIndex(extension, new TransientChangesIndexStorage<K, V>(storage, name));
                for (FileBasedIndexInfrastructureExtension infrastructureExtension : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                    UpdatableIndex<K, V, FileContent> intermediateIndex = infrastructureExtension.combineIndex(extension, index);
                    if (intermediateIndex == null) continue;
                    index = intermediateIndex;
                }
                state.registerIndex(name, index, file2 -> file2 instanceof VirtualFileWithId && inputFilter.acceptInput(file2) && !GlobalIndexFilter.isExcludedFromIndexViaFilters(file2, name), version2 + GlobalIndexFilter.getFiltersVersion(name), (Collection<? extends FileType>)addedTypes);
                break;
            }
            catch (Exception e) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.error((Throwable)e);
                } else {
                    LOG.info((Throwable)e);
                }
                boolean instantiatedStorage = storage != null;
                try {
                    if (storage != null) {
                        storage.close();
                    }
                    storage = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getIndexRootDir(name));
                if (extension.hasSnapshotMapping() && (!contentHashesEnumeratorOk || instantiatedStorage)) {
                    FileUtil.deleteWithRenaming((File)IndexInfrastructure.getPersistentIndexRootDir(name));
                }
                registrationStatusSink.setIndexVersionDiff(name, new IndexingStamp.IndexVersionDiff.CorruptedRebuild(version2));
                IndexingStamp.rewriteVersion(name, version2);
                continue;
            }
        }
    }

    @NotNull
    private static <K, V> VfsAwareIndexStorage<K, V> createIndexStorage(FileBasedIndexExtension<K, V> extension) throws IOException {
        if (USE_IN_MEMORY_INDEX) {
            return new InMemoryIndexStorage();
        }
        boolean createSnapshotStorage = VfsAwareMapReduceIndex.hasSnapshotMapping(extension) && extension instanceof SingleEntryFileBasedIndexExtension;
        return createSnapshotStorage ? new SnapshotSingleValueIndexStorage(extension.getCacheSize()) : new VfsAwareMapIndexStorage(IndexInfrastructure.getStorageFile(extension.getName()).toPath(), extension.getKeyDescriptor(), extension.getValueExternalizer(), extension.getCacheSize(), extension.keyIsUniqueForIndexedFile(), extension.traceKeyHashToVirtualFileMapping());
    }

    @NotNull
    private static <K, V> UpdatableIndex<K, V, FileContent> createIndex(@NotNull FileBasedIndexExtension<K, V> extension, @NotNull TransientChangesIndexStorage<K, V> storage) throws StorageException, IOException {
        if (extension == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(14);
        }
        if (storage == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(15);
        }
        return extension instanceof CustomImplementationFileBasedIndexExtension ? ((CustomImplementationFileBasedIndexExtension)extension).createIndexImplementation(extension, storage) : new VfsAwareMapReduceIndex<K, V>(extension, storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performShutdown(boolean keepConnection) {
        RegisteredIndexes registeredIndexes = this.myRegisteredIndexes;
        if (registeredIndexes == null || !registeredIndexes.performShutdown()) {
            return;
        }
        registeredIndexes.waitUntilAllIndicesAreInitialized();
        try {
            if (this.myShutDownTask != null) {
                ShutDownTracker.getInstance().unregisterShutdownTask(this.myShutDownTask);
            }
            if (this.myFlushingFuture != null) {
                this.myFlushingFuture.cancel(false);
                this.myFlushingFuture = null;
            }
        }
        finally {
            LOG.info("START INDEX SHUTDOWN");
            try {
                PersistentIndicesConfiguration.saveConfiguration();
                for (VirtualFile file2 : this.getChangedFilesCollector().getAllPossibleFilesToUpdate()) {
                    int fileId = FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2);
                    if (file2.isValid()) {
                        this.dropNontrivialIndexedStates(fileId);
                        continue;
                    }
                    this.removeDataFromIndicesForFile(Math.abs(fileId), file2);
                }
                this.getChangedFilesCollector().clearFilesToUpdate();
                IndexingStamp.flushCaches();
                IndexConfiguration state = this.getState();
                for (ID<?, ?> indexId : state.getIndexIDs()) {
                    try {
                        UpdatableIndex<?, ?, FileContent> index = state.getIndex(indexId);
                        assert (index != null);
                        if (!RebuildStatus.isOk(indexId)) {
                            index.clear();
                        }
                        index.dispose();
                    }
                    catch (Throwable throwable) {
                        LOG.info("Problem disposing " + indexId, throwable);
                    }
                }
                FileBasedIndexInfrastructureExtension.EP_NAME.extensions().forEach(ex -> ex.shutdown());
                SnapshotHashEnumeratorService.getInstance().close();
                if (!keepConnection) {
                    this.myConnection.disconnect();
                }
            }
            catch (Throwable e) {
                LOG.error("Problems during index shutdown", e);
            }
            LOG.info("END INDEX SHUTDOWN");
        }
    }

    private void removeDataFromIndicesForFile(int fileId, VirtualFile file2) {
        VirtualFile originalFile = file2 instanceof DeletedVirtualFileStub ? ((DeletedVirtualFileStub)file2).getOriginalFile() : file2;
        List<ID<?, ?>> states = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        if (!states.isEmpty()) {
            ProgressManager.getInstance().executeNonCancelableSection(() -> this.removeFileDataFromIndices(states, fileId, originalFile));
        }
    }

    private void removeFileDataFromIndices(@NotNull Collection<? extends ID<?, ?>> affectedIndices, int inputId, VirtualFile file2) {
        if (affectedIndices == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(16);
        }
        this.removeTransientFileDataFromIndices(affectedIndices, inputId, file2);
        Throwable unexpectedError = null;
        for (ID<?, ?> indexId : affectedIndices) {
            try {
                this.updateSingleIndex(indexId, null, inputId, null);
            }
            catch (ProcessCanceledException pce) {
                LOG.error((Throwable)pce);
            }
            catch (Throwable e) {
                LOG.info(e);
                if (unexpectedError != null) continue;
                unexpectedError = e;
            }
        }
        IndexingStamp.flushCache(inputId);
        if (unexpectedError != null) {
            LOG.error(unexpectedError);
        }
    }

    private void removeTransientFileDataFromIndices(Collection<? extends ID<?, ?>> indices, int inputId, VirtualFile file2) {
        for (ID<?, ?> indexId : indices) {
            UpdatableIndex<?, ?, FileContent> index = this.myRegisteredIndexes.getState().getIndex(indexId);
            if (index == null) {
                throw new AssertionError((Object)("index '" + indexId.getName() + "' can't be found among registered indexes: " + this.myRegisteredIndexes.getState().getIndexIDs()));
            }
            index.removeTransientDataForFile(inputId);
        }
        Document document = this.myFileDocumentManager.getCachedDocument(file2);
        if (document != null) {
            this.myLastIndexedDocStamps.clearForDocument(document);
            document.putUserData(ourFileContentKey, null);
        }
        this.clearUpToDateIndexesForUnsavedOrTransactedDocs();
    }

    private void flushAllIndices(long modCount) {
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            return;
        }
        IndexingStamp.flushCaches();
        IndexConfiguration state = this.getState();
        for (ID<?, ?> indexId : new ArrayList(state.getIndexIDs())) {
            if (HeavyProcessLatch.INSTANCE.isRunning() || modCount != (long)this.myLocalModCount.get()) {
                return;
            }
            try {
                UpdatableIndex<?, ?, FileContent> index = state.getIndex(indexId);
                if (index == null) continue;
                index.flush();
            }
            catch (Throwable e) {
                this.requestRebuild(indexId, e);
            }
        }
        SnapshotHashEnumeratorService.getInstance().flush();
    }

    public static <T, E extends Throwable> T disableUpToDateCheckIn(@NotNull ThrowableComputable<T, E> runnable2) throws E {
        if (runnable2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(17);
        }
        FileBasedIndexImpl.disableUpToDateCheckForCurrentThread();
        try {
            Object object = runnable2.compute();
            return (T)object;
        }
        finally {
            FileBasedIndexImpl.enableUpToDateCheckForCurrentThread();
        }
    }

    private static void disableUpToDateCheckForCurrentThread() {
        Integer currentValue = myUpToDateCheckState.get();
        myUpToDateCheckState.set(currentValue == null ? 1 : currentValue + 1);
    }

    private static void enableUpToDateCheckForCurrentThread() {
        Integer currentValue = myUpToDateCheckState.get();
        if (currentValue != null) {
            int newValue2 = currentValue - 1;
            if (newValue2 != 0) {
                myUpToDateCheckState.set(newValue2);
            } else {
                myUpToDateCheckState.remove();
            }
        }
    }

    static boolean isUpToDateCheckEnabled() {
        Integer value2 = myUpToDateCheckState.get();
        return value2 == null || value2 == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @ApiStatus.Experimental
    public <T, E extends Throwable> T ignoreDumbMode(@NotNull DumbModeAccessType dumbModeAccessType, @NotNull ThrowableComputable<T, E> computable) throws E {
        if (dumbModeAccessType == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(18);
        }
        if (computable == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(19);
        }
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        if (FileBasedIndex.isIndexAccessDuringDumbModeEnabled()) {
            Stack<DumbModeAccessType> dumbModeAccessTypeStack = ourDumbModeAccessTypeStack.get();
            dumbModeAccessTypeStack.push((Object)dumbModeAccessType);
            try {
                Object object = computable.compute();
                return (T)object;
            }
            finally {
                DumbModeAccessType type = (DumbModeAccessType)dumbModeAccessTypeStack.pop();
                assert (dumbModeAccessType == type);
            }
        }
        return (T)computable.compute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K> boolean ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project, @Nullable GlobalSearchScope filter2, @Nullable VirtualFile restrictedFile) {
        block16: {
            if (indexId == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(20);
            }
            ProgressManager.checkCanceled();
            this.getChangedFilesCollector().ensureUpToDate();
            ApplicationManager.getApplication().assertReadAccessAllowed();
            NoAccessDuringPsiEvents.checkCallContext(indexId);
            if (!this.needsFileContentLoading(indexId)) {
                return true;
            }
            if (filter2 == GlobalSearchScope.EMPTY_SCOPE) {
                return false;
            }
            boolean dumbModeAccessRestricted = ourDumbModeAccessTypeStack.get().isEmpty();
            if (dumbModeAccessRestricted && ActionUtil.isDumbMode((Project)project)) {
                FileBasedIndexImpl.handleDumbMode(project);
            }
            if (this.myReentrancyGuard.get().booleanValue()) {
                return true;
            }
            this.myReentrancyGuard.set(Boolean.TRUE);
            try {
                block17: {
                    if (!FileBasedIndexImpl.isUpToDateCheckEnabled()) break block16;
                    try {
                        if (RebuildStatus.isOk(indexId)) break block17;
                        if (dumbModeAccessRestricted) {
                            throw new ServiceNotReadyException();
                        }
                        boolean bl = false;
                        return bl;
                    }
                    catch (RuntimeException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof StorageException || cause instanceof IOException) {
                            this.scheduleRebuild(indexId, e);
                            break block16;
                        }
                        throw e;
                    }
                }
                if (dumbModeAccessRestricted || !ActionUtil.isDumbMode((Project)project)) {
                    this.forceUpdate(project, filter2, restrictedFile);
                }
                if (!this.areUnsavedDocumentsIndexed(indexId)) {
                    this.indexUnsavedDocuments(indexId, project, filter2, restrictedFile);
                }
            }
            finally {
                this.myReentrancyGuard.set(Boolean.FALSE);
            }
        }
        return true;
    }

    private boolean areUnsavedDocumentsIndexed(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(21);
        }
        return this.myUpToDateIndicesForUnsavedOrTransactedDocuments.contains(indexId);
    }

    private static void handleDumbMode(@Nullable Project project) throws IndexNotReadyException {
        ProgressManager.checkCanceled();
        throw IndexNotReadyException.create(project == null ? null : DumbServiceImpl.getInstance(project).getDumbModeStartTrace());
    }

    public void cleanupForNextTest() {
        this.getChangedFilesCollector().ensureUpToDate();
        this.myTransactionMap = SmartFMap.emptyMap();
        IndexConfiguration state = this.getState();
        for (ID<?, ?> indexId : state.getIndexIDs()) {
            UpdatableIndex<?, ?, FileContent> index = state.getIndex(indexId);
            assert (index != null);
            index.cleanupForNextTest();
        }
    }

    @ApiStatus.Internal
    public ChangedFilesCollector getChangedFilesCollector() {
        return (ChangedFilesCollector)this.myChangedFilesCollector.getValue();
    }

    void incrementFilesModCount() {
        this.myFilesModCount.incrementAndGet();
    }

    void filesUpdateStarted(Project project) {
        this.getChangedFilesCollector().ensureUpToDate();
        this.myProjectsBeingUpdated.add(project);
        this.incrementFilesModCount();
    }

    void filesUpdateFinished(@NotNull Project project) {
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(22);
        }
        this.myProjectsBeingUpdated.remove(project);
        this.incrementFilesModCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ProjectIndexableFilesFilter projectIndexableFiles(@Nullable Project project) {
        if (project == null || project.isDefault() || this.getChangedFilesCollector().isUpdateInProgress()) {
            return null;
        }
        if (this.myProjectsBeingUpdated.contains(project)) {
            return null;
        }
        SoftReference reference2 = (SoftReference)project.getUserData(ourProjectFilesSetKey);
        ProjectIndexableFilesFilter data2 = (ProjectIndexableFilesFilter)((Object)com.intellij.reference.SoftReference.dereference((Reference)reference2));
        int currentFileModCount = this.myFilesModCount.get();
        if (data2 != null && data2.getModificationCount() == currentFileModCount) {
            return data2;
        }
        if (this.myCalcIndexableFilesLock.tryLock()) {
            try {
                reference2 = (SoftReference)project.getUserData(ourProjectFilesSetKey);
                data2 = (ProjectIndexableFilesFilter)((Object)com.intellij.reference.SoftReference.dereference((Reference)reference2));
                if (data2 != null) {
                    if (data2.getModificationCount() == currentFileModCount) {
                        ProjectIndexableFilesFilter projectIndexableFilesFilter = data2;
                        return projectIndexableFilesFilter;
                    }
                } else if (!FileBasedIndexImpl.isUpToDateCheckEnabled()) {
                    ProjectIndexableFilesFilter projectIndexableFilesFilter = null;
                    return projectIndexableFilesFilter;
                }
                long start2 = System.currentTimeMillis();
                TIntArrayList filesSet = new TIntArrayList();
                this.iterateIndexableFiles(fileOrDir -> {
                    if (fileOrDir instanceof VirtualFileWithId) {
                        filesSet.add(((VirtualFileWithId)fileOrDir).getId());
                    }
                    return true;
                }, project, null);
                ProjectIndexableFilesFilter filter2 = new ProjectIndexableFilesFilter(filesSet, currentFileModCount);
                project.putUserData(ourProjectFilesSetKey, new SoftReference<ProjectIndexableFilesFilter>(filter2));
                long finish = System.currentTimeMillis();
                LOG.debug(filesSet.size() + " files iterated in " + (finish - start2) + " ms");
                ProjectIndexableFilesFilter projectIndexableFilesFilter = filter2;
                return projectIndexableFilesFilter;
            }
            finally {
                this.myCalcIndexableFilesLock.unlock();
            }
        }
        return null;
    }

    @Nullable
    public static Throwable getCauseToRebuildIndex(@NotNull RuntimeException e) {
        if (e == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(23);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (e instanceof ProcessCanceledException) {
            return null;
        }
        if (e instanceof MapReduceIndex.MapInputException) {
            return null;
        }
        if (e instanceof IndexOutOfBoundsException) {
            return e;
        }
        Throwable cause = e.getCause();
        if (cause instanceof StorageException || cause instanceof IOException || cause instanceof IllegalArgumentException) {
            return cause;
        }
        return null;
    }

    private static void scheduleIndexRebuild(String reason) {
        LOG.info("scheduleIndexRebuild, reason: " + reason);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DumbService.getInstance((Project)project).queueTask((DumbModeTask)new UnindexedFilesUpdater(project));
        }
    }

    void clearIndicesIfNecessary() {
        this.waitUntilIndicesAreInitialized();
        for (ID<?, ?> indexId : this.getState().getIndexIDs()) {
            try {
                RebuildStatus.clearIndexIfNecessary(indexId, (ThrowableRunnable<? extends StorageException>)((ThrowableRunnable)() -> this.getIndex(indexId).clear()));
            }
            catch (StorageException e) {
                this.requestRebuild(indexId);
                LOG.error((Throwable)e);
            }
        }
    }

    void clearIndex(@NotNull ID<?, ?> indexId) throws StorageException {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(24);
        }
        this.advanceIndexVersion(indexId);
        UpdatableIndex<?, ?, FileContent> index = this.myRegisteredIndexes.getState().getIndex(indexId);
        assert (index != null) : "Index with key " + indexId + " not found or not registered properly";
        index.clear();
    }

    private void advanceIndexVersion(ID<?, ?> indexId) {
        try {
            IndexingStamp.rewriteVersion(indexId, this.myRegisteredIndexes.getState().getIndexVersion(indexId));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private Set<Document> getUnsavedDocuments() {
        Object[] documents = this.myFileDocumentManager.getUnsavedDocuments();
        if (documents.length == 0) {
            Set<Document> set = Collections.emptySet();
            if (set == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(25);
            }
            return set;
        }
        if (documents.length == 1) {
            Set<Object> set = Collections.singleton(documents[0]);
            if (set == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(26);
            }
            return set;
        }
        Set set = ContainerUtil.set((Object[])documents);
        if (set == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(27);
        }
        return set;
    }

    @NotNull
    private Set<Document> getTransactedDocuments() {
        Set set = this.myTransactionMap.keySet();
        if (set == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(28);
        }
        return set;
    }

    private void indexUnsavedDocuments(@NotNull ID<?, ?> indexId, @Nullable Project project, GlobalSearchScope filter2, VirtualFile restrictedFile) {
        List documentsToProcessForProject;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(29);
        }
        if (this.myUpToDateIndicesForUnsavedOrTransactedDocuments.contains(indexId)) {
            return;
        }
        Object documents = this.getUnsavedDocuments();
        boolean psiBasedIndex = this.myRegisteredIndexes.isPsiDependentIndex(indexId);
        if (psiBasedIndex) {
            Document[] uncommittedDocuments;
            Set<Document> transactedDocuments = this.getTransactedDocuments();
            if (documents.isEmpty()) {
                documents = transactedDocuments;
            } else if (!transactedDocuments.isEmpty()) {
                documents = new THashSet(documents);
                documents.addAll(transactedDocuments);
            }
            Document[] documentArray = uncommittedDocuments = project != null ? PsiDocumentManager.getInstance((Project)project).getUncommittedDocuments() : Document.EMPTY_ARRAY;
            if (uncommittedDocuments.length > 0) {
                List<Document> uncommittedDocumentsCollection = Arrays.asList(uncommittedDocuments);
                if (documents.isEmpty()) {
                    documents = uncommittedDocumentsCollection;
                } else {
                    if (!(documents instanceof THashSet)) {
                        documents = new THashSet((Collection)documents);
                    }
                    documents.addAll(uncommittedDocumentsCollection);
                }
            }
        }
        if (!documents.isEmpty() && !(documentsToProcessForProject = ContainerUtil.filter(documents, document -> FileBasedIndexImpl.belongsToScope(this.myFileDocumentManager.getFile(document), restrictedFile, filter2))).isEmpty()) {
            UpdateTask<Document> task2 = this.myRegisteredIndexes.getUnsavedDataUpdateTask(indexId);
            assert (task2 != null) : "Task for unsaved data indexing was not initialized for index " + indexId;
            if (this.myStorageBufferingHandler.runUpdate(true, (Computable<Boolean>)((Computable)() -> task2.processAll(documentsToProcessForProject, project))) && documentsToProcessForProject.size() == documents.size() && !this.hasActiveTransactions()) {
                ProgressManager.checkCanceled();
                this.myUpToDateIndicesForUnsavedOrTransactedDocuments.add(indexId);
            }
        }
    }

    private boolean hasActiveTransactions() {
        return !this.myTransactionMap.isEmpty();
    }

    void indexUnsavedDocument(@NotNull Document document, @NotNull ID<?, ?> requestedIndexId, Project project, @NotNull VirtualFile vFile) {
        if (document == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(30);
        }
        if (requestedIndexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(31);
        }
        if (vFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(32);
        }
        PsiFile dominantContentFile = project == null ? null : FileBasedIndexImpl.findLatestKnownPsiForUncomittedDocument(document, project);
        DocumentContent content2 = dominantContentFile != null && dominantContentFile.getViewProvider().getModificationStamp() != document.getModificationStamp() ? new PsiContent(document, dominantContentFile) : new AuthenticContent(document);
        boolean psiBasedIndex = this.myRegisteredIndexes.isPsiDependentIndex(requestedIndexId);
        long currentDocStamp = psiBasedIndex ? PsiDocumentManager.getInstance((Project)project).getLastCommittedStamp(document) : content2.getModificationStamp();
        long previousDocStamp = this.myLastIndexedDocStamps.get(document, requestedIndexId);
        if (previousDocStamp == currentDocStamp) {
            return;
        }
        CharSequence contentText = content2.getText();
        FileBasedIndexImpl.getFileTypeManager().freezeFileTypeTemporarilyIn(vFile, () -> {
            if (this.getAffectedIndexCandidates(vFile).contains(requestedIndexId) && this.getInputFilter(requestedIndexId).acceptInput(vFile)) {
                int inputId = Math.abs(FileBasedIndexImpl.getFileId((VirtualFile)vFile));
                if (!this.isTooLarge(vFile, Long.valueOf(contentText.length()))) {
                    FileContentImpl newFc;
                    WeakReference previousContentRef = (WeakReference)document.getUserData(ourFileContentKey);
                    FileContentImpl previousContent = (FileContentImpl)((Object)((Object)com.intellij.reference.SoftReference.dereference((Reference)previousContentRef)));
                    if (previousContent != null && previousContent.getStamp() == currentDocStamp) {
                        newFc = previousContent;
                    } else {
                        newFc = new FileContentImpl(vFile, contentText, currentDocStamp);
                        document.putUserData(ourFileContentKey, new WeakReference<FileContentImpl>(newFc));
                    }
                    FileBasedIndexImpl.initFileContent(newFc, project, dominantContentFile);
                    newFc.ensureThreadSafeLighterAST();
                    if (content2 instanceof AuthenticContent) {
                        newFc.putUserData(PlatformIdTableBuilding.EDITOR_HIGHLIGHTER, EditorHighlighterCache.getEditorHighlighterForCachesBuilding(document));
                    }
                    FileBasedIndexImpl.markFileIndexed(vFile);
                    try {
                        this.getIndex(requestedIndexId).mapInputAndPrepareUpdate(inputId, (Object)newFc).compute();
                    }
                    finally {
                        FileBasedIndexImpl.unmarkBeingIndexed();
                        FileBasedIndexImpl.cleanFileContent(newFc, dominantContentFile);
                    }
                } else {
                    this.getIndex(requestedIndexId).mapInputAndPrepareUpdate(inputId, null).compute();
                }
            }
            long previousState = this.myLastIndexedDocStamps.set(document, requestedIndexId, currentDocStamp);
            assert (previousState == previousDocStamp);
        });
    }

    @Override
    @NotNull
    public <K, V> Map<K, V> getFileData(@NotNull ID<K, V> id2, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (id2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(33);
        }
        if (virtualFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(34);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(35);
        }
        if (ModelBranch.getFileBranch((VirtualFile)virtualFile) != null) {
            return this.getInMemoryData(id2, virtualFile, project);
        }
        Map<K, V> map2 = super.getFileData(id2, virtualFile, project);
        if (map2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(36);
        }
        return map2;
    }

    @NotNull
    private <K, V> Map<K, V> getInMemoryData(@NotNull ID<K, V> id2, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (id2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(37);
        }
        if (virtualFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(38);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(39);
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (document != null && psiFile != null) {
            boolean psiDependent = this.myRegisteredIndexes.isPsiDependentIndex(id2);
            PsiFile holder = psiDependent ? psiFile : document;
            Map indexValues = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)holder, () -> this.lambda$getInMemoryData$17(psiDependent, psiFile, document, virtualFile, project, (UserDataHolder)holder));
            Map map2 = (Map)indexValues.get(id2);
            if (map2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(40);
            }
            return map2;
        }
        Map map3 = Collections.emptyMap();
        if (map3 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(41);
        }
        return map3;
    }

    @ApiStatus.Internal
    public void runCleanupAction(@NotNull Runnable cleanupAction) {
        if (cleanupAction == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(42);
        }
        Computable updateComputable = () -> {
            cleanupAction.run();
            return true;
        };
        this.myStorageBufferingHandler.runUpdate(false, (Computable<Boolean>)updateComputable);
        this.myStorageBufferingHandler.runUpdate(true, (Computable<Boolean>)updateComputable);
    }

    void cleanupMemoryStorage(boolean skipPsiBasedIndices) {
        this.myLastIndexedDocStamps.clear();
        if (this.myRegisteredIndexes == null) {
            return;
        }
        IndexConfiguration state = this.myRegisteredIndexes.getState();
        if (state == null) {
            return;
        }
        for (ID<?, ?> indexId : state.getIndexIDs()) {
            if (skipPsiBasedIndices && this.myRegisteredIndexes.isPsiDependentIndex(indexId)) continue;
            UpdatableIndex<?, ?, FileContent> index = state.getIndex(indexId);
            assert (index != null);
            index.cleanupMemoryStorage();
        }
    }

    public void requestRebuild(@NotNull ID<?, ?> indexId, @NotNull Throwable throwable) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(43);
        }
        if (throwable == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(44);
        }
        if (!this.myRegisteredIndexes.isExtensionsDataLoaded()) {
            IndexInfrastructure.submitGenesisTask(() -> {
                this.waitUntilIndicesAreInitialized();
                this.doRequestRebuild(indexId, throwable);
                return null;
            });
        } else {
            this.doRequestRebuild(indexId, throwable);
        }
    }

    private void doRequestRebuild(@NotNull ID<?, ?> indexId, Throwable throwable) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(45);
        }
        FileBasedIndexImpl.cleanupProcessedFlag();
        if (!this.myRegisteredIndexes.isExtensionsDataLoaded()) {
            FileBasedIndexImpl.reportUnexpectedAsyncInitState();
        }
        if (RebuildStatus.requestRebuild(indexId)) {
            String message = "Rebuild requested for index " + indexId;
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() && app.isReadAccessAllowed() && !app.isDispatchThread()) {
                LOG.error(message, throwable);
            } else {
                LOG.info(message, throwable);
            }
            FileBasedIndexImpl.cleanupProcessedFlag();
            if (!this.myRegisteredIndexes.isInitialized()) {
                return;
            }
            this.advanceIndexVersion(indexId);
            Runnable rebuildRunnable = () -> FileBasedIndexImpl.scheduleIndexRebuild("checkRebuild");
            if (this.myIsUnitTestMode) {
                rebuildRunnable.run();
            } else {
                ((AppUIExecutor)AppUIExecutor.onWriteThread().later().expireWith((Disposable)app)).submit(rebuildRunnable);
            }
        }
    }

    private static void reportUnexpectedAsyncInitState() {
        LOG.error("Unexpected async indices initialization problem");
    }

    @Override
    public <K, V> UpdatableIndex<K, V, FileContent> getIndex(ID<K, V> indexId) {
        return this.getState().getIndex(indexId);
    }

    private FileBasedIndex.InputFilter getInputFilter(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(46);
        }
        if (!this.myRegisteredIndexes.isInitialized()) {
            this.waitUntilIndicesAreInitialized();
        }
        return this.getState().getInputFilter(indexId);
    }

    @NotNull
    Collection<VirtualFile> getFilesToUpdate(Project project) {
        List list2 = ContainerUtil.filter(this.getChangedFilesCollector().getAllFilesToUpdate(), this.filesToBeIndexedForProjectCondition(project)::test);
        if (list2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(47);
        }
        return list2;
    }

    @NotNull
    private Predicate<VirtualFile> filesToBeIndexedForProjectCondition(Project project) {
        Predicate<VirtualFile> predicate = virtualFile -> {
            if (!virtualFile.isValid()) {
                return true;
            }
            for (IndexableFileSet set : this.myIndexableSets) {
                Project proj = this.myIndexableSetToProjectMap.get(set);
                if (proj != null && !proj.equals(project) || !((Boolean)ReadAction.compute(() -> set.isInSet(virtualFile))).booleanValue()) continue;
                return true;
            }
            return false;
        };
        if (predicate == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(48);
        }
        return predicate;
    }

    public boolean isFileUpToDate(VirtualFile file2) {
        return !this.getChangedFilesCollector().isScheduledForUpdate(file2);
    }

    private void processRefreshedFile(@Nullable Project project, @NotNull CachedFileContent fileContent) {
        if (fileContent == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(49);
        }
        VirtualFile file2 = fileContent.getVirtualFile();
        if (this.getChangedFilesCollector().isScheduledForUpdate(file2)) {
            this.indexFileContent(project, fileContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public FileIndexingStatistics indexFileContent(@Nullable Project project, @NotNull CachedFileContent content2) {
        FileIndexingResult indexingResult;
        if (content2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(50);
        }
        ProgressManager.checkCanceled();
        VirtualFile file2 = content2.getVirtualFile();
        int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
        if (file2.isValid() && content2.getTimeStamp() != file2.getTimeStamp()) {
            content2 = new CachedFileContent(file2);
        }
        if (!file2.isValid() || this.isTooLarge(file2)) {
            ProgressManager.checkCanceled();
            this.removeDataFromIndicesForFile(fileId, file2);
            if (file2 instanceof DeletedVirtualFileStub && ((DeletedVirtualFileStub)file2).isResurrected()) {
                CachedFileContent resurrectedFileContent = new CachedFileContent(((DeletedVirtualFileStub)file2).getOriginalFile());
                indexingResult = this.doIndexFileContent(project, resurrectedFileContent);
            } else {
                indexingResult = new FileIndexingResult(true, Collections.emptyMap(), file2.getFileType());
            }
        } else {
            indexingResult = this.doIndexFileContent(project, content2);
        }
        if (indexingResult.setIndexedStatus && file2 instanceof VirtualFileSystemEntry) {
            ((VirtualFileSystemEntry)file2).setFileIndexed(true);
        }
        this.getChangedFilesCollector().removeFileIdFromFilesScheduledForUpdate(fileId);
        long indexingTime = indexingResult.timesPerIndexer.values().stream().mapToLong(e -> e).sum();
        FileIndexingStatistics fileIndexingStatistics = new FileIndexingStatistics(indexingTime, indexingResult.fileType, indexingResult.timesPerIndexer);
        FileIndexingStatistics fileIndexingStatistics2 = fileIndexingStatistics;
        if (fileIndexingStatistics2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(51);
        }
        return fileIndexingStatistics2;
        finally {
            IndexingStamp.flushCache(fileId);
        }
    }

    @NotNull
    private FileIndexingResult doIndexFileContent(@Nullable Project project, @NotNull CachedFileContent content2) {
        if (content2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(52);
        }
        ProgressManager.checkCanceled();
        VirtualFile file2 = content2.getVirtualFile();
        Ref setIndexedStatus = Ref.create((Object)Boolean.TRUE);
        HashMap perIndexerTimes = new HashMap();
        Ref fileTypeRef = Ref.create();
        FileBasedIndexImpl.getFileTypeManager().freezeFileTypeTemporarilyIn(file2, () -> {
            SingleIndexUpdateStats updateStats;
            ProgressManager.checkCanceled();
            LazyFileContentImpl fc = null;
            PsiFile psiFile = null;
            int inputId = Math.abs(FileBasedIndexImpl.getFileId((VirtualFile)file2));
            THashSet currentIndexedStates = new THashSet(IndexingStamp.getNontrivialFileIndexedStates(inputId));
            List<ID<?, ?>> affectedIndexCandidates = this.getAffectedIndexCandidates(file2);
            int size = affectedIndexCandidates.size();
            for (int i2 = 0; i2 < size; ++i2) {
                try {
                    ID indexId;
                    ProgressManager.checkCanceled();
                    if (fc == null) {
                        fc = new LazyFileContentImpl(file2, (NotNullComputable<byte[]>)((NotNullComputable)() -> FileBasedIndexImpl.getBytesOrNull(content2)));
                        ProgressManager.checkCanceled();
                        psiFile = (PsiFile)content2.getUserData(IndexingDataKeys.PSI_FILE);
                        FileBasedIndexImpl.initFileContent(fc, project == null ? ProjectUtil.guessProjectForFile((VirtualFile)file2) : project, psiFile);
                        fileTypeRef.set((Object)fc.getFileType());
                        ProgressManager.checkCanceled();
                    }
                    if (!this.getInputFilter(indexId = affectedIndexCandidates.get(i2)).acceptInput(file2) || !this.getIndexingState(fc, indexId).updateRequired()) continue;
                    ProgressManager.checkCanceled();
                    updateStats = this.updateSingleIndex(indexId, file2, inputId, (FileContent)fc);
                    if (updateStats == null) {
                        setIndexedStatus.set((Object)Boolean.FALSE);
                    } else {
                        perIndexerTimes.put(indexId, updateStats.mapInputTime);
                    }
                    currentIndexedStates.remove(indexId);
                    continue;
                }
                catch (ProcessCanceledException e) {
                    FileBasedIndexImpl.cleanFileContent(fc, psiFile);
                    throw e;
                }
            }
            if (psiFile != null) {
                psiFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
            }
            boolean shouldClearAllIndexedStates = fc == null;
            for (ID indexId : currentIndexedStates) {
                ProgressManager.checkCanceled();
                if (!shouldClearAllIndexedStates && !this.getIndex(indexId).getIndexingStateForFile(inputId, fc).updateRequired()) continue;
                ProgressManager.checkCanceled();
                updateStats = this.updateSingleIndex(indexId, file2, inputId, null);
                if (updateStats == null) {
                    setIndexedStatus.set((Object)Boolean.FALSE);
                    continue;
                }
                perIndexerTimes.put(indexId, updateStats.mapInputTime);
            }
            fileTypeRef.set((Object)(fc != null ? fc.getFileType() : file2.getFileType()));
        });
        file2.putUserData(IndexingDataKeys.REBUILD_REQUESTED, null);
        return new FileIndexingResult((Boolean)setIndexedStatus.get(), perIndexerTimes, (FileType)fileTypeRef.get());
    }

    private static byte @NotNull [] getBytesOrNull(@NotNull CachedFileContent content2) {
        byte[] byArray;
        if (content2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(53);
        }
        try {
            byArray = content2.getBytes();
        }
        catch (IOException e) {
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(55);
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        if (byArray == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(54);
        }
        return byArray;
    }

    public boolean isIndexingCandidate(@NotNull VirtualFile file2, @NotNull ID<?, ?> indexId) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(56);
        }
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(57);
        }
        return !this.isTooLarge(file2) && this.getAffectedIndexCandidates(file2).contains(indexId);
    }

    @NotNull
    List<ID<?, ?>> getAffectedIndexCandidates(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(58);
        }
        if (file2.isDirectory()) {
            List<ID<?, ?>> list2 = FileBasedIndexImpl.isProjectOrWorkspaceFile(file2, null) ? Collections.emptyList() : this.myRegisteredIndexes.getIndicesForDirectories();
            if (list2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(59);
            }
            return list2;
        }
        FileType fileType = file2.getFileType();
        if (FileBasedIndexImpl.isProjectOrWorkspaceFile(file2, fileType)) {
            List<ID<?, ?>> list3 = Collections.emptyList();
            if (list3 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(60);
            }
            return list3;
        }
        List<ID<?, ?>> list4 = this.getState().getFileTypesForIndex(fileType);
        if (list4 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(61);
        }
        return list4;
    }

    private static void cleanFileContent(FileContentImpl fc, PsiFile psiFile) {
        if (fc == null) {
            return;
        }
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
        }
        fc.putUserData(IndexingDataKeys.PSI_FILE, null);
    }

    private static void initFileContent(@NotNull FileContentImpl fc, Project project, PsiFile psiFile) {
        if (fc == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(62);
        }
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, (Object)true);
            fc.putUserData(IndexingDataKeys.PSI_FILE, psiFile);
        }
        fc.setProject(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="null in case index update is not necessary or the update has failed")
    @Nullable(value="null in case index update is not necessary or the update has failed") SingleIndexUpdateStats updateSingleIndex(@NotNull ID<?, ?> indexId, @Nullable VirtualFile file2, int inputId, @Nullable FileContent currentFC) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(63);
        }
        if (!this.myRegisteredIndexes.isExtensionsDataLoaded()) {
            FileBasedIndexImpl.reportUnexpectedAsyncInitState();
        }
        if (!RebuildStatus.isOk(indexId) && !this.myIsUnitTestMode) {
            return null;
        }
        this.myLocalModCount.incrementAndGet();
        UpdatableIndex<?, ?, FileContent> index = this.getIndex(indexId);
        assert (index != null);
        FileBasedIndexImpl.markFileIndexed(file2);
        try {
            Computable storageUpdate;
            long mapInputTime = System.nanoTime();
            try {
                storageUpdate = index.mapInputAndPrepareUpdate(inputId, currentFC);
            }
            finally {
                mapInputTime = System.nanoTime() - mapInputTime;
            }
            if (this.myStorageBufferingHandler.runUpdate(false, (Computable<Boolean>)storageUpdate)) {
                ConcurrencyUtil.withLock((Lock)this.myReadLock, () -> {
                    if (currentFC != null) {
                        index.setIndexedStateForFile(inputId, (IndexedFile)currentFC);
                    } else {
                        index.resetIndexedStateForFile(inputId);
                    }
                });
            }
            SingleIndexUpdateStats singleIndexUpdateStats = new SingleIndexUpdateStats(mapInputTime);
            return singleIndexUpdateStats;
        }
        catch (RuntimeException exception) {
            Throwable causeToRebuildIndex = FileBasedIndexImpl.getCauseToRebuildIndex(exception);
            if (causeToRebuildIndex != null) {
                this.requestRebuild(indexId, exception);
                SingleIndexUpdateStats singleIndexUpdateStats = null;
                return singleIndexUpdateStats;
            }
            throw exception;
        }
        finally {
            FileBasedIndexImpl.unmarkBeingIndexed();
        }
    }

    private static void markFileIndexed(@Nullable VirtualFile file2) {
        if (ourIndexedFile.get() != null || ourFileToBeIndexed.get() != null) {
            throw new AssertionError((Object)"Reentrant indexing");
        }
        ourIndexedFile.set(file2);
    }

    private static void unmarkBeingIndexed() {
        ourIndexedFile.remove();
    }

    public VirtualFile getFileBeingCurrentlyIndexed() {
        return ourIndexedFile.get();
    }

    @Nullable
    public DumbModeAccessType getCurrentDumbModeAccessType() {
        Stack<DumbModeAccessType> dumbModeAccessTypeStack = ourDumbModeAccessTypeStack.get();
        return dumbModeAccessTypeStack.isEmpty() ? null : (DumbModeAccessType)dumbModeAccessTypeStack.peek();
    }

    private void forceUpdate(@Nullable Project project, @Nullable GlobalSearchScope filter2, @Nullable VirtualFile restrictedTo) {
        Collection<VirtualFile> allFilesToUpdate = this.getChangedFilesCollector().getAllFilesToUpdate();
        if (!allFilesToUpdate.isEmpty()) {
            boolean includeFilesFromOtherProjects = restrictedTo == null && System.currentTimeMillis() - this.myLastOtherProjectInclusionStamp > 100L;
            List virtualFilesToBeUpdatedForProject = ContainerUtil.filter(allFilesToUpdate, (Condition)new ProjectFilesCondition(this.projectIndexableFiles(project), filter2, restrictedTo, includeFilesFromOtherProjects));
            if (!virtualFilesToBeUpdatedForProject.isEmpty()) {
                this.myForceUpdateTask.processAll(virtualFilesToBeUpdatedForProject, project);
            }
            if (includeFilesFromOtherProjects) {
                this.myLastOtherProjectInclusionStamp = System.currentTimeMillis();
            }
        }
    }

    boolean needsFileContentLoading(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(64);
        }
        return !this.myRegisteredIndexes.isNotRequiringContentIndex(indexId);
    }

    @Nullable
    IndexableFileSet getIndexableSetForFile(VirtualFile file2) {
        for (IndexableFileSet set : this.myIndexableSets) {
            if (!set.isInSet(file2)) continue;
            return set;
        }
        return null;
    }

    @NotNull
    List<IndexableFileSet> getIndexableSets() {
        List<IndexableFileSet> list2 = this.myIndexableSets;
        if (list2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(65);
        }
        return list2;
    }

    @ApiStatus.Internal
    public void dropNontrivialIndexedStates(int inputId) {
        for (ID<?, ?> state : IndexingStamp.getNontrivialFileIndexedStates(inputId)) {
            this.getIndex(state).resetIndexedStateForFile(inputId);
        }
    }

    void doTransientStateChangeForFile(int fileId, @NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(66);
        }
        this.waitUntilIndicesAreInitialized();
        if (!this.clearUpToDateStateForPsiIndicesOfUnsavedDocuments(file2, IndexingStamp.getNontrivialFileIndexedStates(fileId))) {
            this.clearUpToDateStateForPsiIndicesOfVirtualFile(file2);
        }
    }

    void doInvalidateIndicesForFile(int fileId, @NotNull VirtualFile file2, boolean contentChanged) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(67);
        }
        this.waitUntilIndicesAreInitialized();
        FileBasedIndexImpl.cleanProcessedFlag(file2);
        List<ID<?, ?>> nontrivialFileIndexedStates = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        Collection fileIndexedStatesToUpdate = ContainerUtil.intersection(nontrivialFileIndexedStates, this.myRegisteredIndexes.getRequiringContentIndices());
        this.removeTransientFileDataFromIndices(nontrivialFileIndexedStates, fileId, file2);
        if (contentChanged) {
            if (!fileIndexedStatesToUpdate.isEmpty()) {
                int size = nontrivialFileIndexedStates.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    ID<?, ?> indexId = nontrivialFileIndexedStates.get(i2);
                    if (!this.needsFileContentLoading(indexId)) continue;
                    this.getIndex(indexId).resetIndexedStateForFile(fileId);
                }
                if (file2.isValid()) {
                    if (!this.isTooLarge(file2)) {
                        this.getChangedFilesCollector().scheduleForUpdate(file2);
                    } else {
                        this.getChangedFilesCollector().scheduleForUpdate((VirtualFile)new DeletedVirtualFileStub((VirtualFileWithId)file2));
                    }
                } else {
                    LOG.info("Unexpected state in update:" + file2);
                }
            }
        } else {
            for (ID<?, ?> indexId : nontrivialFileIndexedStates) {
                if (!this.myRegisteredIndexes.isNotRequiringContentIndex(indexId)) continue;
                this.updateSingleIndex(indexId, null, fileId, null);
            }
            if (!fileIndexedStatesToUpdate.isEmpty()) {
                this.getChangedFilesCollector().scheduleForUpdate((VirtualFile)new DeletedVirtualFileStub((VirtualFileWithId)file2));
            } else {
                this.getChangedFilesCollector().removeScheduledFileFromUpdate(file2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleFileForIndexing(int fileId, @NotNull VirtualFile file2, boolean contentChange) {
        List filters;
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(68);
        }
        if (!(filters = IndexableFilesFilter.EP_NAME.getExtensionList()).isEmpty() && !ContainerUtil.exists((Iterable)filters, e -> e.shouldIndex(file2))) {
            return;
        }
        boolean fileIsDirectory = file2.isDirectory();
        if (!contentChange) {
            IndexedFileWrapper fileContent = null;
            for (ID<?, ?> indexId : this.getContentLessIndexes(fileIsDirectory)) {
                if (!this.getInputFilter(indexId).acceptInput(file2)) continue;
                if (fileContent == null) {
                    fileContent = new IndexedFileWrapper(new IndexedFileImpl(file2, null));
                }
                this.updateSingleIndex(indexId, file2, fileId, fileContent);
            }
        }
        if (!fileIsDirectory) {
            if (!file2.isValid() || this.isTooLarge(file2)) {
                this.getChangedFilesCollector().removeScheduledFileFromUpdate(file2);
            } else {
                ourFileToBeIndexed.set(file2);
                try {
                    FileBasedIndexImpl.getFileTypeManager().freezeFileTypeTemporarilyIn(file2, () -> {
                        List<ID<?, ?>> candidates = this.getAffectedIndexCandidates(file2);
                        boolean scheduleForUpdate = false;
                        int size = candidates.size();
                        for (int i2 = 0; i2 < size; ++i2) {
                            ID<?, ?> indexId = candidates.get(i2);
                            if (!this.needsFileContentLoading(indexId) || !this.getInputFilter(indexId).acceptInput(file2)) continue;
                            this.getIndex(indexId).resetIndexedStateForFile(fileId);
                            scheduleForUpdate = true;
                        }
                        if (scheduleForUpdate) {
                            IndexingStamp.flushCache(fileId);
                            this.getChangedFilesCollector().scheduleForUpdate(file2);
                        } else if (file2 instanceof VirtualFileSystemEntry) {
                            ((VirtualFileSystemEntry)file2).setFileIndexed(true);
                        }
                    });
                }
                finally {
                    ourFileToBeIndexed.remove();
                }
            }
        }
    }

    @NotNull
    Collection<ID<?, ?>> getContentLessIndexes(boolean isDirectory) {
        Collection<ID<?, ?>> collection = isDirectory ? this.myRegisteredIndexes.getIndicesForDirectories() : this.myRegisteredIndexes.getNotRequiringContentIndices();
        if (collection == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(69);
        }
        return collection;
    }

    static FileTypeManagerImpl getFileTypeManager() {
        return (FileTypeManagerImpl)FileTypeManager.getInstance();
    }

    private boolean clearUpToDateStateForPsiIndicesOfUnsavedDocuments(@NotNull VirtualFile file2, Collection<? extends ID<?, ?>> affectedIndices) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(70);
        }
        this.clearUpToDateIndexesForUnsavedOrTransactedDocs();
        Document document = this.myFileDocumentManager.getCachedDocument(file2);
        if (document != null && this.myFileDocumentManager.isDocumentUnsaved(document)) {
            this.myLastIndexedDocStamps.clearForDocument(document);
            document.putUserData(ourFileContentKey, null);
            return true;
        }
        this.removeTransientFileDataFromIndices(ContainerUtil.intersection(affectedIndices, this.myRegisteredIndexes.getPsiDependentIndices()), FileBasedIndexImpl.getFileId((VirtualFile)file2), file2);
        return false;
    }

    void clearUpToDateIndexesForUnsavedOrTransactedDocs() {
        if (!this.myUpToDateIndicesForUnsavedOrTransactedDocuments.isEmpty()) {
            this.myUpToDateIndicesForUnsavedOrTransactedDocuments.clear();
        }
    }

    static int getIdMaskingNonIdBasedFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(71);
        }
        return file2 instanceof VirtualFileWithId ? ((VirtualFileWithId)file2).getId() : 0;
    }

    FileIndexingState shouldIndexFile(@NotNull IndexedFile file2, @NotNull ID<?, ?> indexId) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(72);
        }
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(73);
        }
        if (!this.getInputFilter(indexId).acceptInput(file2.getFile())) {
            return this.getIndexingState(file2, indexId) == FileIndexingState.NOT_INDEXED ? FileIndexingState.UP_TO_DATE : FileIndexingState.OUT_DATED;
        }
        return this.getIndexingState(file2, indexId);
    }

    @NotNull
    private FileIndexingState getIndexingState(@NotNull IndexedFile file2, @NotNull ID<?, ?> indexId) {
        VirtualFile virtualFile;
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(74);
        }
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(75);
        }
        if (FileBasedIndexImpl.isMock(virtualFile = file2.getFile())) {
            FileIndexingState fileIndexingState = FileIndexingState.NOT_INDEXED;
            if (fileIndexingState == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(76);
            }
            return fileIndexingState;
        }
        FileIndexingState fileIndexingState = this.getIndex(indexId).getIndexingStateForFile(((NewVirtualFile)virtualFile).getId(), file2);
        if (fileIndexingState == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(77);
        }
        return fileIndexingState;
    }

    static boolean isMock(VirtualFile file2) {
        return !(file2 instanceof NewVirtualFile);
    }

    public boolean isTooLarge(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(78);
        }
        return this.isTooLarge(file2, null);
    }

    public boolean isTooLarge(@NotNull VirtualFile file2, @Nullable(value="if content size should be retrieved from a file") @Nullable(value="if content size should be retrieved from a file") Long contentSize) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(79);
        }
        return FileBasedIndexImpl.isTooLarge(file2, contentSize, this.myRegisteredIndexes.getNoLimitCheckFileTypes());
    }

    @ApiStatus.Internal
    public static boolean isTooLarge(@NotNull VirtualFile file2, @Nullable(value="if content size should be retrieved from a file") @Nullable(value="if content size should be retrieved from a file") Long contentSize, @NotNull Set<FileType> noLimitFileTypes) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(80);
        }
        if (noLimitFileTypes == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(81);
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file2, contentSize)) {
            return !noLimitFileTypes.contains(file2.getFileType()) || SingleRootFileViewProvider.isTooLargeForContentLoading(file2, contentSize);
        }
        return false;
    }

    public void registerIndexableSet(@NotNull IndexableFileSet set, @Nullable Project project) {
        if (set == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(82);
        }
        this.myIndexableSets.add(set);
        this.myIndexableSetToProjectMap.put(set, project);
        if (project != null) {
            ((PsiManagerImpl)PsiManager.getInstance((Project)project)).addTreeChangePreprocessor(event -> {
                VirtualFile virtualFile;
                PsiFile file2;
                if (event.isGenericChange() && event.getCode() == PsiTreeChangeEventImpl.PsiEventType.CHILDREN_CHANGED && (file2 = event.getFile()) != null && (virtualFile = file2.getVirtualFile()) instanceof VirtualFileWithId) {
                    this.getChangedFilesCollector().getEventMerger().recordTransientStateChangeEvent(virtualFile);
                }
            });
        }
    }

    private void clearUpToDateStateForPsiIndicesOfVirtualFile(VirtualFile virtualFile) {
        if (virtualFile instanceof VirtualFileWithId) {
            int fileId = ((VirtualFileWithId)virtualFile).getId();
            boolean wasIndexed = false;
            List<ID<?, ?>> candidates = this.getAffectedIndexCandidates(virtualFile);
            for (ID<?, ?> candidate : candidates) {
                if (!this.myRegisteredIndexes.isPsiDependentIndex(candidate) || !this.getInputFilter(candidate).acceptInput(virtualFile)) continue;
                this.getIndex(candidate).resetIndexedStateForFile(fileId);
                wasIndexed = true;
            }
            if (wasIndexed) {
                this.getChangedFilesCollector().scheduleForUpdate(virtualFile);
                IndexingStamp.flushCache(fileId);
            }
        }
    }

    public void removeIndexableSet(@NotNull IndexableFileSet set) {
        if (set == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(83);
        }
        if (!this.myIndexableSetToProjectMap.containsKey(set)) {
            return;
        }
        this.myIndexableSets.remove(set);
        this.myIndexableSetToProjectMap.remove(set);
        ChangedFilesCollector changedFilesCollector = this.getChangedFilesCollector();
        for (VirtualFile file2 : changedFilesCollector.getAllFilesToUpdate()) {
            int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
            if (!file2.isValid()) {
                this.removeDataFromIndicesForFile(fileId, file2);
                changedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
                continue;
            }
            if (this.getIndexableSetForFile(file2) != null) continue;
            changedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
        }
        IndexingStamp.flushCaches();
    }

    public VirtualFile findFileById(Project project, int id2) {
        return IndexInfrastructure.findFileById((PersistentFS)ManagingFS.getInstance(), id2);
    }

    @Nullable
    private static PsiFile findLatestKnownPsiForUncomittedDocument(@NotNull Document doc, @NotNull Project project) {
        if (doc == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(84);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(85);
        }
        return PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(doc);
    }

    @VisibleForTesting
    public static void cleanupProcessedFlag() {
        VirtualFile[] roots;
        for (VirtualFile root : roots = ManagingFS.getInstance().getRoots()) {
            FileBasedIndexImpl.cleanProcessedFlag(root);
        }
    }

    static void cleanProcessedFlag(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(86);
        }
        if (!(file2 instanceof VirtualFileSystemEntry)) {
            return;
        }
        VirtualFileSystemEntry nvf = (VirtualFileSystemEntry)file2;
        nvf.setFileIndexed(false);
        if (file2.isDirectory()) {
            for (VirtualFile child2 : nvf.getCachedChildren()) {
                FileBasedIndexImpl.cleanProcessedFlag(child2);
            }
        }
    }

    void setUpFlusher() {
        this.myFlushingFuture = FlushingDaemon.everyFiveSeconds(new Runnable(){
            private final SerializationManagerEx mySerializationManager = SerializationManagerEx.getInstanceEx();
            private int lastModCount;

            @Override
            public void run() {
                this.mySerializationManager.flushNameStorage();
                int currentModCount = FileBasedIndexImpl.this.myLocalModCount.get();
                if (this.lastModCount == currentModCount) {
                    FileBasedIndexImpl.this.flushAllIndices(this.lastModCount);
                }
                this.lastModCount = currentModCount;
            }
        });
    }

    public void invalidateCaches() {
        CorruptionMarker.requestInvalidation();
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public IntPredicate getAccessibleFileIdFilter(@Nullable Project project) {
        boolean dumb = ActionUtil.isDumbMode((Project)project);
        if (!dumb) {
            IntPredicate intPredicate = f -> true;
            if (intPredicate == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(87);
            }
            return intPredicate;
        }
        DumbModeAccessType dumbModeAccessType = this.getCurrentDumbModeAccessType();
        if (dumbModeAccessType == null) {
            IntPredicate intPredicate = __ -> true;
            if (intPredicate == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(88);
            }
            return intPredicate;
        }
        if (dumbModeAccessType == DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE) {
            IntPredicate intPredicate = f -> true;
            if (intPredicate == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(89);
            }
            return intPredicate;
        }
        assert (dumbModeAccessType == DumbModeAccessType.RELIABLE_DATA_ONLY);
        IntPredicate intPredicate = fileId -> !this.getChangedFilesCollector().containsFileId(fileId);
        if (intPredicate == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(90);
        }
        return intPredicate;
    }

    @ApiStatus.Internal
    public void flushIndexes() {
        for (ID<?, ?> id2 : this.getRegisteredIndexes().getState().getIndexIDs()) {
            try {
                this.getIndex(id2).flush();
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean isPsiDependentIndex(@NotNull IndexExtension<?, ?, ?> extension) {
        if (extension == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(91);
        }
        if (INDICES_ARE_PSI_DEPENDENT_BY_DEFAULT) {
            return extension instanceof FileBasedIndexExtension && ((FileBasedIndexExtension)extension).dependsOnFileContent() && !(extension instanceof DocumentChangeDependentIndex);
        }
        return extension instanceof PsiDependentIndex;
    }

    @ApiStatus.Internal
    static <K, V> int getIndexExtensionVersion(@NotNull FileBasedIndexExtension<K, V> extension) {
        if (extension == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(92);
        }
        int version2 = extension.getVersion();
        if (VfsAwareMapReduceIndex.hasSnapshotMapping(extension)) {
            version2 += SnapshotInputMappings.getVersion();
        }
        return version2;
    }

    private /* synthetic */ CachedValueProvider.Result lambda$getInMemoryData$17(boolean psiDependent, PsiFile psiFile, Document document, VirtualFile virtualFile, Project project, UserDataHolder holder) {
        CharSequence text = psiDependent ? psiFile.getViewProvider().getContents() : document.getImmutableCharSequence();
        FileContentImpl fc = new FileContentImpl(virtualFile, text, 0L);
        FileBasedIndexImpl.initFileContent(fc, project, psiFile);
        Map result2 = FactoryMap.create(key -> this.getIndex((ID)key).getExtension().getIndexer().map((Object)fc));
        return CachedValueProvider.Result.createSingleDependency((Object)result2, (Object)holder);
    }

    private static /* synthetic */ void lambda$initIndexStorage$7(Set addedTypes, FileType type) {
        if (type != null) {
            addedTypes.add(type);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 36: 
            case 40: 
            case 41: 
            case 47: 
            case 48: 
            case 51: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 69: 
            case 76: 
            case 77: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 36: 
            case 40: 
            case 41: 
            case 47: 
            case 48: 
            case 51: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 69: 
            case 76: 
            case 77: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexesToRebuild";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: 
            case 22: 
            case 35: 
            case 39: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 56: 
            case 58: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 78: 
            case 79: 
            case 80: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrationStatusSink";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedIndices";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumbModeAccessType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 20: 
            case 21: 
            case 24: 
            case 29: 
            case 43: 
            case 45: 
            case 46: 
            case 57: 
            case 63: 
            case 64: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 36: 
            case 40: 
            case 41: 
            case 47: 
            case 48: 
            case 51: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 69: 
            case 76: 
            case 77: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FileBasedIndexImpl";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedIndexId";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanupAction";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 50: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fc";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noLimitFileTypes";
                break;
            }
            case 82: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexImpl";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedDocuments";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransactedDocuments";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileData";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getInMemoryData";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToUpdate";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "filesToBeIndexedForProjectCondition";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "indexFileContent";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytesOrNull";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedIndexCandidates";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexableSets";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentLessIndexes";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingState";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleFileIdFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scheduleFullIndexesRescan";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doClearIndices";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processChangedFiles";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isProjectOrWorkspaceFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "requestReindex";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexer";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "initIndexStorage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createIndex";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeFileDataFromIndices";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "disableUpToDateCheckIn";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "ignoreDumbMode";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "ensureUpToDate";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "areUnsavedDocumentsIndexed";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "filesUpdateFinished";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCauseToRebuildIndex";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "clearIndex";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 36: 
            case 40: 
            case 41: 
            case 47: 
            case 48: 
            case 51: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 69: 
            case 76: 
            case 77: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "indexUnsavedDocuments";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "indexUnsavedDocument";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFileData";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getInMemoryData";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "runCleanupAction";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "requestRebuild";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "doRequestRebuild";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getInputFilter";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "processRefreshedFile";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "indexFileContent";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "doIndexFileContent";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getBytesOrNull";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isIndexingCandidate";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedIndexCandidates";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "initFileContent";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "updateSingleIndex";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "needsFileContentLoading";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "doTransientStateChangeForFile";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "doInvalidateIndicesForFile";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "scheduleFileForIndexing";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "clearUpToDateStateForPsiIndicesOfUnsavedDocuments";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getIdMaskingNonIdBasedFile";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "shouldIndexFile";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingState";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isTooLarge";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexableSet";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "removeIndexableSet";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "findLatestKnownPsiForUncomittedDocument";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "cleanProcessedFlag";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "isPsiDependentIndex";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getIndexExtensionVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 36: 
            case 40: 
            case 41: 
            case 47: 
            case 48: 
            case 51: 
            case 54: 
            case 55: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 69: 
            case 76: 
            case 77: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class VirtualFileUpdateTask
    extends UpdateTask<VirtualFile> {
        private VirtualFileUpdateTask() {
        }

        @Override
        void doProcess(VirtualFile item, Project project) {
            FileBasedIndexImpl.this.processRefreshedFile(project, new CachedFileContent(item));
        }
    }

    private static final class SingleIndexUpdateStats {
        public final long mapInputTime;

        private SingleIndexUpdateStats(long mapInputTime) {
            this.mapInputTime = mapInputTime;
        }
    }

    private static final class FileIndexingResult {
        public final boolean setIndexedStatus;
        public final Map<ID<?, ?>, Long> timesPerIndexer;
        public final FileType fileType;

        private FileIndexingResult(boolean setIndexedStatus, @NotNull Map<ID<?, ?>, Long> timesPerIndexer, @NotNull FileType type) {
            if (timesPerIndexer == null) {
                FileIndexingResult.$$$reportNull$$$0(0);
            }
            if (type == null) {
                FileIndexingResult.$$$reportNull$$$0(1);
            }
            this.setIndexedStatus = setIndexedStatus;
            this.timesPerIndexer = timesPerIndexer;
            this.fileType = type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "timesPerIndexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/indexing/FileBasedIndexImpl$FileIndexingResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class MyShutDownTask
    implements Runnable {
        MyShutDownTask() {
        }

        @Override
        public void run() {
            FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
            if (fileBasedIndex instanceof FileBasedIndexImpl) {
                ((FileBasedIndexImpl)fileBasedIndex).performShutdown(false);
            }
        }
    }
}

