/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.Splittable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.tree.TreePathBackgroundSupplier;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableModelAdapter;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class JBTreeTable
extends JComponent
implements TreePathBackgroundSupplier {
    private final Tree myTree;
    private final Table myTable;
    private final OnePixelSplitter split;
    private TreeTableModel myModel;
    private JTableHeader myTreeTableHeader;
    private float myColumnProportion;

    public JBTreeTable(@NotNull TreeTableModel model) {
        if (model == null) {
            JBTreeTable.$$$reportNull$$$0(0);
        }
        this.myColumnProportion = 0.1f;
        this.setLayout(new BorderLayout());
        this.myTree = new Tree(){

            public void repaint(long tm, int x, int y, int width, int height) {
                if (!JBTreeTable.this.addTreeTableRowDirtyRegion((JComponent)((Object)this), tm, x, y, width, height)) {
                    super.repaint(tm, x, y, width, height);
                }
            }

            public void treeDidChange() {
                super.treeDidChange();
                if (JBTreeTable.this.myTable != null) {
                    JBTreeTable.this.myTable.revalidate();
                    JBTreeTable.this.myTable.repaint();
                }
            }

            @Nullable
            public Color getPathBackground(@NotNull TreePath path, int row) {
                if (path == null) {
                    1.$$$reportNull$$$0(0);
                }
                return JBTreeTable.this.getPathBackground(path, row);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ui/components/JBTreeTable$1", "getPathBackground"));
            }
        };
        this.myTable = new Table();
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setRootVisible(false);
        this.myTree.setBorder((Border)JBUI.Borders.empty());
        this.myTable.setShowGrid(false);
        this.myTable.setSelectionMode(0);
        this.myTable.setColumnSelectionAllowed(false);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        this.split = new OnePixelSplitter(){

            protected Divider createDivider() {
                return new OnePixelDivider(this.isVertical(), (Splittable)this){

                    public void paint(Graphics g) {
                        Rectangle bounds2 = g.getClipBounds();
                        g.setColor(JBTreeTable.this.myTable.getShowVerticalLines() ? JBTreeTable.this.myTable.getGridColor() : JBTreeTable.this.myTable.getBackground());
                        g.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
                        JTableHeader header2 = JBTreeTable.this.myTreeTableHeader;
                        Rectangle rect = header2.getHeaderRect(0);
                        g.setClip(rect.x, rect.y, 2, rect.height);
                        g.translate(-rect.width + 1, 0);
                        header2.paint(g);
                    }
                };
            }
        };
        this.add((Component)this.split);
        JScrollPane treePane = ScrollPaneFactory.createScrollPane((Component)this.myTree, (int)0);
        this.split.setFirstComponent((JComponent)treePane);
        final JScrollPane tablePane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTable), (int)0);
        this.split.setSecondComponent((JComponent)tablePane);
        SelectionSupport selection = new SelectionSupport();
        treePane.setColumnHeaderView(this.myTreeTableHeader);
        treePane.getHorizontalScrollBar().addComponentListener(new ComponentAdapter(){
            {
                if (tablePane.isVisible()) {
                    tablePane.setHorizontalScrollBarPolicy(32);
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                tablePane.setHorizontalScrollBarPolicy(32);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                tablePane.setHorizontalScrollBarPolicy(31);
            }
        });
        int scrollMode = !SystemInfo.isMac ? 0 : 1;
        treePane.getViewport().setScrollMode(scrollMode);
        tablePane.setVerticalScrollBar(treePane.getVerticalScrollBar());
        tablePane.getViewport().setScrollMode(scrollMode);
        this.myTree.getSelectionModel().addTreeSelectionListener(selection);
        this.myTable.getSelectionModel().addListSelectionListener(selection);
        this.myTable.setRowMargin(0);
        this.myTable.addMouseListener(selection);
        this.myTree.addPropertyChangeListener("rowHeight", evt -> {
            int treeRowHeight = this.myTree.getRowHeight();
            if (treeRowHeight == this.myTable.getRowHeight()) {
                return;
            }
            this.myTable.setRowHeight(treeRowHeight);
        });
        this.myTree.setCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                TreeColumnModel cm = (TreeColumnModel)JBTreeTable.this.myTreeTableHeader.getColumnModel();
                TableCellRenderer renderer = JBTreeTable.this.getDefaultRenderer(TreeTableModel.class);
                return renderer.getTableCellRendererComponent((JTable)((Object)JBTreeTable.this.myTable), value2, selected2, hasFocus, row, cm.treeColumnIndex);
            }
        });
        this.myTree.putClientProperty((Object)RenderingUtil.FOCUSABLE_SIBLING, (Object)this.myTable);
        this.myTable.putClientProperty(RenderingUtil.FOCUSABLE_SIBLING, this.myTree);
        this.setModel(model);
    }

    @NotNull
    public Tree getTree() {
        Tree tree = this.myTree;
        if (tree == null) {
            JBTreeTable.$$$reportNull$$$0(1);
        }
        return tree;
    }

    @NotNull
    public JBTable getTable() {
        Table table = this.myTable;
        if (table == null) {
            JBTreeTable.$$$reportNull$$$0(2);
        }
        return table;
    }

    public void setDefaultRenderer(@NotNull Class<?> columnClass, @NotNull TableCellRenderer renderer) {
        if (columnClass == null) {
            JBTreeTable.$$$reportNull$$$0(3);
        }
        if (renderer == null) {
            JBTreeTable.$$$reportNull$$$0(4);
        }
        this.myTable.setDefaultRenderer(columnClass, renderer);
    }

    @NotNull
    public TableCellRenderer getDefaultRenderer(@NotNull Class<?> columnClass) {
        if (columnClass == null) {
            JBTreeTable.$$$reportNull$$$0(5);
        }
        TableCellRenderer tableCellRenderer = this.myTable.getDefaultRenderer(columnClass);
        if (tableCellRenderer == null) {
            JBTreeTable.$$$reportNull$$$0(6);
        }
        return tableCellRenderer;
    }

    public void setModel(@NotNull TreeTableModel model) {
        if (model == null) {
            JBTreeTable.$$$reportNull$$$0(7);
        }
        this.myModel = model;
        this.myTree.setModel((TreeModel)model);
        this.myTable.setModel((TableModel)new TreeTableModelAdapter(model, (JTree)this.myTree, (JTable)((Object)this.myTable)));
        TreeColumnModel tcm = (TreeColumnModel)this.myTreeTableHeader.getColumnModel();
        if (tcm.treeColumnIndex >= 0) {
            this.myTable.removeColumn(this.myTable.getColumnModel().getColumn(tcm.treeColumnIndex));
        }
        if (this.myTree.getRowHeight() < 1) {
            this.myTable.setRowHeight(JBUIScale.scale((int)18));
        } else {
            this.myTable.setRowHeight(this.myTree.getRowHeight());
        }
        this.setColumnProportion(this.myColumnProportion);
    }

    public void setColumnProportion(float columnProportion) {
        this.myColumnProportion = columnProportion;
        this.split.setProportion(1.0f - (float)(this.myModel.getColumnCount() - 1) * columnProportion);
    }

    public float getColumnProportion() {
        return this.myColumnProportion;
    }

    public TreeTableModel getModel() {
        return this.myModel;
    }

    @Nullable
    public Color getPathBackground(@NotNull TreePath path, int row) {
        if (path == null) {
            JBTreeTable.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Override
    public boolean hasFocus() {
        return this.myTree.hasFocus() || this.myTable.hasFocus();
    }

    /*
     * WARNING - void declaration
     */
    private boolean addTreeTableRowDirtyRegion(@NotNull JComponent component2, long tm, int x, int y, int width, int n) {
        boolean isNeedToRepaintRow;
        if (component2 == null) {
            JBTreeTable.$$$reportNull$$$0(9);
        }
        boolean bl = isNeedToRepaintRow = component2.getWidth() == width;
        if (isNeedToRepaintRow) {
            void height;
            this.repaint(tm, 0, y, this.getWidth(), (int)height);
        }
        return isNeedToRepaintRow;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/JBTreeTable";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/JBTreeTable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRenderer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPathBackground";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addTreeTableRowDirtyRegion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TreeColumnModel
    extends DefaultTableColumnModel {
        private int treeColumnIndex = -1;

        private TreeColumnModel() {
            this.addColumn(new TableColumn(0){

                @Override
                public int getWidth() {
                    return TreeColumnModel.this.getTotalColumnWidth();
                }

                @Override
                public Object getHeaderValue() {
                    return TreeColumnModel.this.treeColumnIndex < 0 ? " " : ((TreeTableModel)JBTreeTable.this.myTree.getModel()).getColumnName(TreeColumnModel.this.treeColumnIndex);
                }
            });
            this.addColumn(new TableColumn(1, 0));
            JBTreeTable.this.myTree.addPropertyChangeListener("model", evt -> {
                TreeTableModel model = (TreeTableModel)JBTreeTable.this.myTree.getModel();
                this.treeColumnIndex = -1;
                for (int i2 = 0; i2 < model.getColumnCount(); ++i2) {
                    if (!TreeTableModel.class.isAssignableFrom(model.getColumnClass(i2))) continue;
                    if (i2 != 0) {
                        throw new IllegalArgumentException("Tree column must be first");
                    }
                    this.treeColumnIndex = i2;
                    break;
                }
            });
        }

        @Override
        public int getTotalColumnWidth() {
            return ((JBTreeTable)JBTreeTable.this).myTree.getVisibleRect().width + 1;
        }
    }

    private final class Table
    extends JBTable {
        final JBTable ref = new JBTable();

        private Table() {
            JBTreeTable.this.myTreeTableHeader = (JTableHeader)new JBTable.JBTableHeader(){

                public AccessibleContext getAccessibleContext() {
                    return new MyAccessibleContext();
                }

                public int getWidth() {
                    return super.getWidth() + 1;
                }
            };
            JBTreeTable.this.myTreeTableHeader.setTable((JTable)this.ref);
            JBTreeTable.this.myTreeTableHeader.setColumnModel(new TreeColumnModel());
            JBTreeTable.this.myTreeTableHeader.setReorderingAllowed(false);
            JBTreeTable.this.myTreeTableHeader.setResizingAllowed(false);
        }

        public void setRowHeight(int rowHeight) {
            super.setRowHeight(rowHeight);
            if (JBTreeTable.this.myTree != null && JBTreeTable.this.myTree.getRowHeight() < rowHeight) {
                JBTreeTable.this.myTree.setRowHeight(this.getRowHeight());
            }
        }

        public void repaint(long tm, int x, int y, int width, int height) {
            if (!JBTreeTable.this.addTreeTableRowDirtyRegion((JComponent)((Object)this), tm, x, y, width, height)) {
                super.repaint(tm, x, y, width, height);
            }
        }

        public void updateUI() {
            super.updateUI();
            if (this.ref != null) {
                this.ref.updateUI();
            }
        }

        private final class MyAccessibleContext
        extends AccessibleContextDelegate {
            MyAccessibleContext() {
                super(JBTreeTable.this.myTable.getAccessibleContext());
            }

            protected Container getDelegateParent() {
                return JBTreeTable.this;
            }
        }
    }

    private class SelectionSupport
    extends MouseAdapter
    implements TreeSelectionListener,
    ListSelectionListener {
        private SelectionSupport() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getSource() == JBTreeTable.this.myTable) {
                int row = JBTreeTable.this.myTable.getSelectedRow();
                if (JBTreeTable.this.myTree.isCollapsed(row)) {
                    JBTreeTable.this.myTree.expandRow(row);
                } else {
                    JBTreeTable.this.myTree.collapseRow(row);
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row;
            if (e.getSource() == JBTreeTable.this.myTable.getSelectionModel() && (row = JBTreeTable.this.myTable.getSelectedRow()) >= 0) {
                JBTreeTable.this.myTree.setSelectionRow(row);
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (e.getSource() == JBTreeTable.this.myTree.getSelectionModel()) {
                int row = JBTreeTable.this.myTree.getRowForPath(JBTreeTable.this.myTree.getSelectionPath());
                if (row >= 0) {
                    JBTreeTable.this.myTable.setRowSelectionInterval(row, row);
                } else {
                    JBTreeTable.this.myTable.clearSelection();
                }
            }
        }
    }
}

