/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.move.FileReferenceContextUtil;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesDialog;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesViewDescriptor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveFilesOrDirectoriesProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(MoveFilesOrDirectoriesProcessor.class);
    protected final PsiElement[] myElementsToMove;
    private final boolean mySearchForReferences;
    protected final boolean mySearchInComments;
    protected final boolean mySearchInNonJavaFiles;
    private final PsiDirectory myNewParent;
    private final MoveCallback myMoveCallback;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private final Map<PsiFile, List<UsageInfo>> myFoundUsages;

    public MoveFilesOrDirectoriesProcessor(@NotNull Project project, PsiElement @NotNull [] elements2, @NotNull PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback, Runnable prepareSuccessfulCallback) {
        if (project == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(0);
        }
        if (newParent == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(1);
        }
        if (elements2 == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(2);
        }
        this(project, elements2, newParent, true, searchInComments, searchInNonJavaFiles, moveCallback, prepareSuccessfulCallback);
    }

    public MoveFilesOrDirectoriesProcessor(@NotNull Project project, PsiElement @NotNull [] elements2, @NotNull PsiDirectory newParent, boolean searchForReferences, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback, Runnable prepareSuccessfulCallback) {
        if (project == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(3);
        }
        if (newParent == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(4);
        }
        if (elements2 == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(5);
        }
        super(project, prepareSuccessfulCallback);
        this.myFoundUsages = new HashMap<PsiFile, List<UsageInfo>>();
        this.myElementsToMove = elements2;
        this.myNewParent = newParent;
        this.mySearchForReferences = searchForReferences;
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myMoveCallback = moveCallback;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(6);
        }
        return new MoveFilesOrDirectoriesViewDescriptor(this.myElementsToMove, this.myNewParent);
    }

    @Override
    protected UsageInfo @NotNull [] findUsages() {
        ArrayList<MyUsageInfo> result2 = new ArrayList<MyUsageInfo>();
        for (int i2 = 0; i2 < this.myElementsToMove.length; ++i2) {
            PsiElement element2 = this.myElementsToMove[i2];
            if (this.mySearchForReferences) {
                for (PsiReference reference2 : ReferencesSearch.search((PsiElement)element2, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject))) {
                    result2.add(new MyUsageInfo(reference2, i2));
                }
            }
            this.findElementUsages(result2, element2);
        }
        UsageInfo[] usageInfoArray = result2.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(7);
        }
        return usageInfoArray;
    }

    private void findElementUsages(@NotNull List<? super UsageInfo> result2, @NotNull PsiElement element2) {
        if (result2 == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(9);
        }
        if (!this.mySearchForReferences) {
            return;
        }
        if (element2 instanceof PsiFile) {
            List<UsageInfo> usages = MoveFileHandler.forElement((PsiFile)element2).findUsages((PsiFile)element2, this.myNewParent, this.mySearchInComments, this.mySearchInNonJavaFiles);
            if (usages != null) {
                result2.addAll(usages);
                this.myFoundUsages.put((PsiFile)element2, usages);
            }
        } else if (element2 instanceof PsiDirectory) {
            for (PsiElement childElement : element2.getChildren()) {
                this.findElementUsages(result2, childElement);
            }
        }
    }

    @Override
    protected void refreshElements(PsiElement @NotNull [] elements2) {
        if (elements2 == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(10);
        }
        LOG.assertTrue(elements2.length == this.myElementsToMove.length);
        System.arraycopy(elements2, 0, this.myElementsToMove, 0, elements2.length);
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        if (this.myNonCodeUsages != null) {
            RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
        }
    }

    @Override
    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(11);
        }
        try {
            LinkedHashMap<PsiFile, FileASTNode> movedFiles = new LinkedHashMap<PsiFile, FileASTNode>();
            HashMap<PsiElement, PsiElement> oldToNewMap = new HashMap<PsiElement, PsiElement>();
            if (this.mySearchForReferences) {
                for (PsiElement psiElement : this.myElementsToMove) {
                    if (psiElement instanceof PsiDirectory) {
                        MoveFilesOrDirectoriesProcessor.encodeDirectoryFiles(psiElement, movedFiles);
                        continue;
                    }
                    if (!(psiElement instanceof PsiFile)) continue;
                    FileReferenceContextUtil.encodeFileReferences(psiElement);
                }
            }
            List listeners = ContainerUtil.map((Object[])this.myElementsToMove, item -> this.getTransaction().getElementListener((PsiElement)item));
            for (int i2 = 0; i2 < this.myElementsToMove.length; ++i2) {
                PsiElement element3 = this.myElementsToMove[i2];
                if (element3 instanceof PsiDirectory) {
                    MoveFilesOrDirectoriesUtil.doMoveDirectory((PsiDirectory)element3, this.myNewParent);
                    for (PsiElement psiElement : element3.getChildren()) {
                        MoveFilesOrDirectoriesProcessor.processDirectoryFiles(movedFiles, oldToNewMap, psiElement);
                    }
                } else if (element3 instanceof PsiFile) {
                    PsiFile psiFile = (PsiFile)element3;
                    FileASTNode node = psiFile.getNode();
                    MoveFileHandler.forElement(psiFile).prepareMovedFile(psiFile, this.myNewParent, oldToNewMap);
                    PsiFile moving = this.myNewParent.findFile(psiFile.getName());
                    if (moving == null) {
                        MoveFilesOrDirectoriesUtil.doMoveFile(psiFile, this.myNewParent);
                    }
                    if ((moving = this.myNewParent.findFile(psiFile.getName())) != null) {
                        movedFiles.put(moving, moving.getNode());
                        ObjectUtils.reachabilityFence((Object)node);
                    }
                }
                ((RefactoringElementListener)listeners.get(i2)).elementMoved(element3);
            }
            CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usages);
            DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
            for (PsiFile movedFile : movedFiles.keySet()) {
                MoveFileHandler.forElement(movedFile).updateMovedFile(movedFile);
                if (!this.mySearchForReferences) continue;
                FileReferenceContextUtil.decodeFileReferences((PsiElement)movedFile);
            }
            this.retargetUsages(usages, oldToNewMap);
            if (this.myMoveCallback != null) {
                this.myMoveCallback.refactoringCompleted();
            }
            if (MoveFilesOrDirectoriesDialog.isOpenInEditorProperty()) {
                ArrayList justFiles = new ArrayList(movedFiles.keySet());
                ApplicationManager.getApplication().invokeLater(() -> EditorHelper.openFilesInEditor((PsiElement[])((PsiFile[])justFiles.stream().filter(PsiElement::isValid).toArray(PsiFile[]::new))));
            }
        }
        catch (IncorrectOperationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                LOG.info((Throwable)e);
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)this.myProject, (String)cause.getMessage(), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon()));
            }
            LOG.error((Throwable)e);
        }
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.move";
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElements(this.myElementsToMove);
        return data2;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(12);
        }
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElement((PsiElement)this.myNewParent);
        return data2;
    }

    private static void encodeDirectoryFiles(@NotNull PsiElement psiElement, @NotNull Map<PsiFile, FileASTNode> movedFiles) {
        if (psiElement == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(13);
        }
        if (movedFiles == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(14);
        }
        if (psiElement instanceof PsiFile) {
            movedFiles.put((PsiFile)psiElement, ((PsiFile)psiElement).getNode());
            FileReferenceContextUtil.encodeFileReferences(psiElement);
        } else if (psiElement instanceof PsiDirectory) {
            for (PsiElement element2 : psiElement.getChildren()) {
                MoveFilesOrDirectoriesProcessor.encodeDirectoryFiles(element2, movedFiles);
            }
        }
    }

    private static void processDirectoryFiles(@NotNull Map<PsiFile, FileASTNode> movedFiles, @NotNull Map<PsiElement, PsiElement> oldToNewMap, @NotNull PsiElement psiElement) {
        if (movedFiles == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(15);
        }
        if (oldToNewMap == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(16);
        }
        if (psiElement == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(17);
        }
        if (psiElement instanceof PsiFile) {
            PsiFile movedFile = (PsiFile)psiElement;
            movedFiles.put(movedFile, movedFile.getNode());
            MoveFileHandler.forElement(movedFile).prepareMovedFile(movedFile, movedFile.getParent(), oldToNewMap);
        } else if (psiElement instanceof PsiDirectory) {
            for (PsiElement element2 : psiElement.getChildren()) {
                MoveFilesOrDirectoriesProcessor.processDirectoryFiles(movedFiles, oldToNewMap, element2);
            }
        }
    }

    protected void retargetUsages(UsageInfo @NotNull [] usages, @NotNull Map<PsiElement, PsiElement> oldToNewMap) {
        if (oldToNewMap == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(18);
        }
        if (usages == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(19);
        }
        ArrayList<NonCodeUsageInfo> nonCodeUsages = new ArrayList<NonCodeUsageInfo>();
        for (UsageInfo usageInfo : usages) {
            if (usageInfo instanceof MyUsageInfo) {
                PsiElement refElement;
                PsiFile usageFile;
                PsiFile psiFile;
                PsiElement usageElement;
                MyUsageInfo info = (MyUsageInfo)usageInfo;
                PsiElement element2 = this.myElementsToMove[info.myIndex];
                if ((info.getReference() instanceof FileReference || info.getReference() instanceof PsiDynaReference) && (usageElement = info.getElement()) != null && (psiFile = (usageFile = usageElement.getContainingFile()).getViewProvider().getPsi(usageFile.getViewProvider().getBaseLanguage())) != null && psiFile.equals(element2) || !(refElement = info.myReference.getElement()).isValid()) continue;
                info.myReference.bindToElement(element2);
                continue;
            }
            if (!(usageInfo instanceof NonCodeUsageInfo)) continue;
            nonCodeUsages.add((NonCodeUsageInfo)usageInfo);
        }
        for (PsiFile movedFile : this.myFoundUsages.keySet()) {
            MoveFileHandler.forElement(movedFile).retargetUsages(this.myFoundUsages.get(movedFile), oldToNewMap);
        }
        this.myNonCodeUsages = nonCodeUsages.toArray(new NonCodeUsageInfo[0]);
    }

    @Override
    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"move.title");
        if (string == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Override
    protected boolean shouldDisableAccessChecks() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedFiles";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldToNewMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 7: 
            case 20: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findElementUsages";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "encodeDirectoryFiles";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processDirectoryFiles";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "retargetUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyUsageInfo
    extends UsageInfo {
        int myIndex;
        PsiReference myReference;

        MyUsageInfo(@NotNull PsiReference reference2, int index) {
            if (reference2 == null) {
                MyUsageInfo.$$$reportNull$$$0(0);
            }
            super(reference2);
            this.myIndex = index;
            this.myReference = reference2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor$MyUsageInfo", "<init>"));
        }
    }
}

