/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectIconHelper;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ChangeProjectIconForm {
    private final String myProjectPath;
    JBLabel myDefaultIcon;
    JBLabel myDarculaIcon;
    JPanel myRootPanel;
    ActionLink mySetIcon;
    ActionLink mySetIconDark;
    ActionLink myClear;
    ActionLink myClearDark;
    boolean resetIcon;
    boolean resetDarkIcon;
    VirtualFile pathToIcon;
    VirtualFile pathToDarkIcon;

    public ChangeProjectIconForm(@NotNull String projectPath) {
        if (projectPath == null) {
            ChangeProjectIconForm.$$$reportNull$$$0(0);
        }
        this.myProjectPath = projectPath;
        this.$$$setupUI$$$();
        this.myClear.setEnabled(this.getIcon() != null);
        this.myClearDark.setEnabled(this.getDarculaIcon() != null);
        RecentProjectsManagerBase recentProjectsManager = RecentProjectsManagerBase.getInstanceEx();
        Icon projectOrAppIcon = recentProjectsManager.getProjectOrAppIcon(this.myProjectPath);
        Icon defaultIcon = recentProjectsManager.getProjectIcon(this.myProjectPath, false);
        this.myDefaultIcon.setIcon(defaultIcon == null ? projectOrAppIcon : defaultIcon);
        Icon darculaIcon = recentProjectsManager.getProjectIcon(this.myProjectPath, true);
        this.myDarculaIcon.setIcon(darculaIcon == null ? this.myDefaultIcon.getIcon() : darculaIcon);
    }

    Icon getIcon() {
        return RecentProjectsManagerBase.getInstanceEx().getProjectIcon(this.myProjectPath, false);
    }

    Icon getDarculaIcon() {
        return RecentProjectsManagerBase.getInstanceEx().getProjectIcon(this.myProjectPath, true);
    }

    private void createUIComponents() {
        this.mySetIcon = new ActionLink(IdeBundle.message((String)"link.change.icon", (Object[])new Object[0]), (AnAction)new ChangeProjectIcon(false));
        this.mySetIconDark = new ActionLink(IdeBundle.message((String)"link.change.icon", (Object[])new Object[0]), (AnAction)new ChangeProjectIcon(true));
        this.myClear = new ActionLink(IdeBundle.message((String)"link.reset.icon", (Object[])new Object[0]), (AnAction)new ResetProjectIcon(false));
        this.myClearDark = new ActionLink(IdeBundle.message((String)"link.reset.icon", (Object[])new Object[0]), (AnAction)new ResetProjectIcon(true));
    }

    public void apply() throws IOException {
        File darkIcon = new File(this.myProjectPath + "/.idea/icon_dark.png");
        File icon2 = new File(this.myProjectPath + "/.idea/icon.png");
        if (this.pathToDarkIcon != null) {
            FileUtil.copy((File)new File(this.pathToDarkIcon.getPath()), (File)darkIcon);
        } else if (this.resetDarkIcon) {
            FileUtil.delete((File)darkIcon);
        }
        if (this.pathToIcon != null) {
            FileUtil.copy((File)new File(this.pathToIcon.getPath()), (File)icon2);
        } else if (this.resetIcon) {
            FileUtil.delete((File)icon2);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/IdeBundle", ChangeProjectIconForm.class).getString("label.project.icon.for.default.theme"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/IdeBundle", ChangeProjectIconForm.class).getString("label.project.icon.for.darcula.theme"));
        jPanel2.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDarculaIcon = jBLabel2 = new JBLabel();
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDefaultIcon = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        ActionLink actionLink = this.mySetIcon;
        this.$$$loadLabelText$$$((JLabel)actionLink, DynamicBundle.getBundle((String)"messages/IdeBundle", ChangeProjectIconForm.class).getString("link.change.project.icon"));
        jPanel2.add((Component)actionLink, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        ActionLink actionLink2 = this.mySetIconDark;
        this.$$$loadLabelText$$$((JLabel)actionLink2, DynamicBundle.getBundle((String)"messages/IdeBundle", ChangeProjectIconForm.class).getString("link.change.project.icon"));
        jPanel2.add((Component)actionLink2, new GridConstraints(1, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        ActionLink actionLink3 = this.myClear;
        this.$$$loadLabelText$$$((JLabel)actionLink3, DynamicBundle.getBundle((String)"messages/IdeBundle", ChangeProjectIconForm.class).getString("link.reset.project.icon"));
        jPanel2.add((Component)actionLink3, new GridConstraints(0, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        ActionLink actionLink4 = this.myClearDark;
        this.$$$loadLabelText$$$((JLabel)actionLink4, DynamicBundle.getBundle((String)"messages/IdeBundle", ChangeProjectIconForm.class).getString("link.reset.project.icon"));
        jPanel2.add((Component)actionLink4, new GridConstraints(1, 3, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/wm/impl/welcomeScreen/ChangeProjectIconForm", "<init>"));
    }

    private class ResetProjectIcon
    extends AnAction {
        private final boolean myDarcula;

        ResetProjectIcon(boolean darcula) {
            this.myDarcula = darcula;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetProjectIcon.$$$reportNull$$$0(0);
            }
            if (this.myDarcula) {
                ChangeProjectIconForm.this.myDarculaIcon.setIcon(AllIcons.Nodes.IdeaProject);
                ChangeProjectIconForm.this.resetDarkIcon = true;
            } else {
                ChangeProjectIconForm.this.myDefaultIcon.setIcon(AllIcons.Nodes.IdeaProject);
                ChangeProjectIconForm.this.resetIcon = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/ChangeProjectIconForm$ResetProjectIcon", "actionPerformed"));
        }
    }

    private class ChangeProjectIcon
    extends AnAction {
        private final boolean myDarcula;

        ChangeProjectIcon(boolean darcula) {
            this.myDarcula = darcula;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VirtualFile[] files2;
            if (e == null) {
                ChangeProjectIcon.$$$reportNull$$$0(0);
            }
            if ((files2 = FileChooserFactory.getInstance().createFileChooser(new FileChooserDescriptor(true, false, false, false, false, false).withFileFilter(file2 -> "png".equalsIgnoreCase(file2.getExtension())), null, null).choose(null, new VirtualFile[0])).length == 1) {
                try {
                    Icon newIcon = RecentProjectIconHelper.createIcon(Paths.get(files2[0].getPath(), new String[0]));
                    if (this.myDarcula) {
                        ChangeProjectIconForm.this.myDarculaIcon.setIcon(newIcon);
                        ChangeProjectIconForm.this.pathToDarkIcon = files2[0];
                    } else {
                        ChangeProjectIconForm.this.myDefaultIcon.setIcon(newIcon);
                        ChangeProjectIconForm.this.pathToIcon = files2[0];
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/ChangeProjectIconForm$ChangeProjectIcon", "actionPerformed"));
        }
    }
}

