/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public final class DirectoryAccessChecker {
    private static final Logger LOG = Logger.getInstance(DirectoryAccessChecker.class);
    private static final boolean IS_ENABLED = Registry.is((String)"directory.access.checker.enabled");
    private static final Path USER_HOME_DIR = Paths.get(System.getProperty("user.home"), new String[0]);
    private static final long REFRESH_RATE_MS = 60000L;
    private static volatile DirectoryFilter instance = DirectoryFilter.ACCEPTING_FILTER;
    private static volatile long instanceEOL = 0L;
    private static final int TIMEOUT_MS = 1000;

    private DirectoryAccessChecker() {
    }

    @NotNull
    public static FilenameFilter getFileFilter(File directory) {
        DirectoryFilter directoryFilter = !IS_ENABLED || directory.toPath().startsWith(USER_HOME_DIR) ? DirectoryFilter.ACCEPTING_FILTER : instance;
        if (directoryFilter == null) {
            DirectoryAccessChecker.$$$reportNull$$$0(0);
        }
        return directoryFilter;
    }

    public static void refresh() {
        if (IS_ENABLED) {
            Application app = ApplicationManager.getApplication();
            if (app.isDispatchThread()) {
                app.executeOnPooledThread(() -> DirectoryAccessChecker.doRefresh());
            } else {
                DirectoryAccessChecker.doRefresh();
            }
        }
    }

    private static void doRefresh() {
        if (System.currentTimeMillis() > instanceEOL) {
            instance = DirectoryAccessChecker.getChain();
            instanceEOL = System.currentTimeMillis() + 60000L;
        }
    }

    private static DirectoryFilter getChain() {
        return SystemInfo.isLinux ? LinuxDirectoryFilter.create() : DirectoryFilter.ACCEPTING_FILTER;
    }

    private static Pair<String, String> parseOptions(String fsOptions) {
        String version2 = null;
        String transport = null;
        for (String o : StringUtil.tokenize((String)fsOptions, (String)",")) {
            if (o.startsWith("vers")) {
                version2 = DirectoryAccessChecker.getValue(o);
                int p = version2.indexOf(46);
                if (p <= 0) continue;
                version2 = version2.substring(0, p);
                continue;
            }
            if (!o.startsWith("proto")) continue;
            transport = DirectoryAccessChecker.getValue(o);
        }
        return version2 != null && transport != null ? Pair.pair(version2, transport) : null;
    }

    private static List<String> split(String line) {
        return ContainerUtil.newArrayList((Iterable)StringUtil.tokenize((String)line, (String)" \t"));
    }

    private static String getValue(String entry) {
        return entry.substring(entry.indexOf("=") + 1);
    }

    private static boolean exec(String ... command) throws IOException, InterruptedException {
        return DirectoryAccessChecker.exec(new ProcessBuilder(command).start(), command);
    }

    private static boolean exec(Process p, String ... command) throws InterruptedException {
        if (p.waitFor(1000L, TimeUnit.MILLISECONDS)) {
            int rc = p.exitValue();
            if (LOG.isTraceEnabled()) {
                LOG.trace(Arrays.toString(command) + ": " + rc);
            }
            return rc == 0;
        }
        p.destroyForcibly();
        if (LOG.isTraceEnabled()) {
            LOG.trace(Arrays.toString(command) + ": timeout");
        }
        return false;
    }

    private static boolean probe(Path directory) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("probing: " + directory);
        }
        Future<PosixFileAttributes> future2 = ProcessIOExecutorService.INSTANCE.submit(() -> Files.readAttributes(directory, PosixFileAttributes.class, new LinkOption[0]));
        try {
            future2.get(1000L, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Throwable)e);
            }
            future2.cancel(true);
            return false;
        }
    }

    static {
        DirectoryAccessChecker.refresh();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/DirectoryAccessChecker", "getFileFilter"));
    }

    private static class CIFS
    implements FileSystem {
        private final File client = PathEnvironmentVariableUtil.findInPath((String)"smbclient");

        private CIFS() {
        }

        @Override
        public boolean isAccessible(String fsSpec, Path fsPath, String fsOptions) {
            try {
                String[] command;
                if (this.client != null && !DirectoryAccessChecker.exec(command = ArrayUtil.toStringArray(CIFS.command(this.client.getPath(), fsSpec, fsOptions)))) {
                    return false;
                }
                return DirectoryAccessChecker.probe(fsPath);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                return false;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        private static List<String> command(String clientPath, String fsSpec, String fsOptions) {
            String userName = null;
            String domain = null;
            String password = null;
            String authFile = null;
            String ip = null;
            String port = null;
            for (String o : StringUtil.tokenize((String)fsOptions, (String)",")) {
                if (o.startsWith("username")) {
                    userName = DirectoryAccessChecker.getValue(o);
                    continue;
                }
                if (o.startsWith("dom") || o.startsWith("workgroup")) {
                    domain = DirectoryAccessChecker.getValue(o);
                    continue;
                }
                if (o.startsWith("password")) {
                    password = DirectoryAccessChecker.getValue(o);
                    continue;
                }
                if (o.startsWith("credentials")) {
                    authFile = DirectoryAccessChecker.getValue(o);
                    continue;
                }
                if (o.startsWith("ip") || o.startsWith("addr")) {
                    ip = DirectoryAccessChecker.getValue(o);
                    continue;
                }
                if (!o.startsWith("port")) continue;
                port = DirectoryAccessChecker.getValue(o);
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add(clientPath);
            command.add(fsSpec);
            if (StringUtil.isNotEmpty(authFile)) {
                command.add("-A");
                command.add(authFile);
            } else {
                command.add(StringUtil.isNotEmpty(password) ? password : "-N");
                if (StringUtil.isNotEmpty((String)userName)) {
                    command.add("-U");
                    command.add(userName);
                }
                if (StringUtil.isNotEmpty((String)domain)) {
                    command.add("-W");
                    command.add(domain);
                }
            }
            if (StringUtil.isNotEmpty(ip)) {
                command.add("-I");
                command.add(ip);
            }
            if (StringUtil.isNotEmpty(port)) {
                command.add("-p");
                command.add(port);
            }
            command.add("-c");
            command.add("ls");
            return command;
        }
    }

    private static class NFS
    implements FileSystem {
        private final File client = PathEnvironmentVariableUtil.findInPath((String)"rpcinfo");

        private NFS() {
        }

        @Override
        public boolean isAccessible(String fsSpec, Path fsPath, String fsOptions) {
            try {
                if (this.client != null) {
                    String host = fsSpec.substring(0, fsSpec.indexOf(58));
                    String[] command = new String[]{this.client.getPath(), "-p", host};
                    Process p = new ProcessBuilder(command).start();
                    if (!DirectoryAccessChecker.exec(p, command)) {
                        return false;
                    }
                    Pair pair = DirectoryAccessChecker.parseOptions(fsOptions);
                    if (pair == null) {
                        LOG.warn("unrecognized RPC mount: " + fsOptions);
                    } else {
                        String version2 = (String)pair.first;
                        String transport = (String)pair.second;
                        String programID = null;
                        try (BufferedReader ir = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset()));){
                            String line;
                            while ((line = ir.readLine()) != null) {
                                List columns;
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("rpc: " + line);
                                }
                                if ((columns = DirectoryAccessChecker.split(line)).size() != 5 || !"nfs".equals(columns.get(4)) || !version2.equals(columns.get(1)) || !transport.equals(columns.get(2))) continue;
                                programID = (String)columns.get(0);
                                break;
                            }
                        }
                        if (programID == null) {
                            LOG.warn("unrecognized RPC info output");
                        } else if (!DirectoryAccessChecker.exec(new String[]{this.client.getPath(), "-T", transport, host, programID, version2})) {
                            return false;
                        }
                    }
                }
                return DirectoryAccessChecker.probe(fsPath);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                return false;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static interface FileSystem {
        public boolean isAccessible(String var1, Path var2, String var3);
    }

    private static class LinuxDirectoryFilter
    implements DirectoryFilter {
        private static final FileSystem NFS = new NFS();
        private static final FileSystem CIFS = new CIFS();
        private static final Path USER_HOME_PARENT = DirectoryAccessChecker.access$200().getParent();
        private static final String USER_HOME_NAME = USER_HOME_PARENT != null && USER_HOME_PARENT.getParent() != null ? DirectoryAccessChecker.access$200().getFileName().toString() : null;
        private final Collection<Path> inaccessiblePaths;
        private final boolean isUserHomeMounted;

        @NotNull
        static DirectoryFilter create() {
            HashSet<Path> inaccessible = new HashSet<Path>();
            boolean userHomeMounted = false;
            try (BufferedReader br = Files.newBufferedReader(Paths.get("/proc/mounts", new String[0]));){
                String line;
                while ((line = br.readLine()) != null) {
                    String type;
                    FileSystem fs;
                    List fields2;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("mount: " + line);
                    }
                    if ((fields2 = DirectoryAccessChecker.split(line)).size() < 4 || (fs = (type = (String)fields2.get(2)).equals("nfs") || type.equals("nfs4") ? NFS : (type.equals("cifs") ? CIFS : null)) == null) continue;
                    Path path = Paths.get((String)fields2.get(1), new String[0]);
                    if (USER_HOME_DIR.equals(path)) {
                        userHomeMounted = true;
                    }
                    if (fs.isAccessible((String)fields2.get(0), path, (String)fields2.get(3))) continue;
                    inaccessible.add(path);
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            DirectoryFilter directoryFilter = !inaccessible.isEmpty() || userHomeMounted ? new LinuxDirectoryFilter(inaccessible, userHomeMounted) : ACCEPTING_FILTER;
            if (directoryFilter == null) {
                LinuxDirectoryFilter.$$$reportNull$$$0(0);
            }
            return directoryFilter;
        }

        private LinuxDirectoryFilter(Collection<Path> inaccessible, boolean mountedHome) {
            this.inaccessiblePaths = inaccessible;
            this.isUserHomeMounted = mountedHome;
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean allowed;
            Path parentPath = dir.toPath();
            if (this.isUserHomeMounted && USER_HOME_NAME != null && USER_HOME_PARENT.equals(parentPath)) {
                allowed = USER_HOME_NAME.equals(name);
            } else {
                boolean bl = allowed = !this.inaccessiblePaths.contains(parentPath.resolve(name));
            }
            if (!allowed && LOG.isTraceEnabled()) {
                LOG.trace("hidden: " + dir + '/' + name);
            }
            return allowed;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/DirectoryAccessChecker$LinuxDirectoryFilter", "create"));
        }
    }

    private static interface DirectoryFilter
    extends FilenameFilter {
        public static final DirectoryFilter ACCEPTING_FILTER = (dir, name) -> true;
    }
}

