/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class CallCommand
extends AbstractCommand {
    public static final String PREFIX = "%call";

    public CallCommand(String text, int line) {
        super(text, line, true);
    }

    @Override
    protected Promise<Object> _execute(PlaybackContext context) {
        String cmd = this.getText().substring(PREFIX.length()).trim();
        int open2 = cmd.indexOf("(");
        if (open2 == -1) {
            context.error("( expected", this.getLine());
            return Promises.resolvedPromise();
        }
        int close2 = cmd.lastIndexOf(")");
        if (close2 == -1) {
            context.error(") expected", this.getLine());
            return Promises.resolvedPromise();
        }
        String methodName = cmd.substring(0, open2);
        String[] args = cmd.substring(open2 + 1, close2).split(",");
        boolean noArgs = args.length == 1 && args[0].length() == 0;
        Object[] types = noArgs ? new Class[1] : new Class[args.length + 1];
        types[0] = PlaybackContext.class;
        for (int i2 = 1; i2 < types.length; ++i2) {
            types[i2] = String.class;
        }
        AsyncPromise cmdResult = new AsyncPromise();
        try {
            Pair<Method, Class<?>> methodClass = CallCommand.findMethod(context, methodName, (Class[])types);
            if (methodClass == null) {
                context.error("No method \"" + methodName + "\" with parameters [" + StringUtil.join((Object[])types, type -> type.getName(), (String)", ") + "] found in facade classes: " + context.getCallClasses(), this.getLine());
                return Promises.rejectedPromise();
            }
            Method m = (Method)methodClass.getFirst();
            if (!m.getReturnType().isAssignableFrom(Promise.class)) {
                context.error("Method " + methodClass.getSecond() + ":" + methodName + " must return Promise object", this.getLine());
                return Promises.rejectedPromise();
            }
            Object[] actualArgs = noArgs ? new Object[1] : new Object[args.length + 1];
            actualArgs[0] = context;
            System.arraycopy(args, 0, actualArgs, 1, actualArgs.length - 1);
            Promise result2 = (Promise)m.invoke(null, actualArgs);
            if (result2 == null) {
                context.error("Method " + methodClass.getSecond() + ":" + methodName + " must return AsyncResult object, but was null", this.getLine());
                return Promises.rejectedPromise();
            }
            result2.onSuccess(s -> {
                if (s != null) {
                    context.message((String)s, this.getLine());
                }
                cmdResult.setResult(null);
            }).onError(error -> {
                context.error(error.getMessage(), this.getLine());
                cmdResult.setError(error);
            });
        }
        catch (InvocationTargetException ignored) {
            context.error("InvocationTargetException while executing command: " + cmd, this.getLine());
        }
        catch (IllegalAccessException ignored) {
            context.error("IllegalAccessException while executing command: " + cmd, this.getLine());
        }
        return cmdResult;
    }

    private static Pair<Method, Class<?>> findMethod(PlaybackContext context, String methodName, Class[] types) {
        Set<Class<?>> classes = context.getCallClasses();
        for (Class<?> eachClass : classes) {
            try {
                Method method2 = eachClass.getMethod(methodName, types);
                return Pair.create((Object)method2, eachClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }
}

