/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.configurationStore.SettingsSavingComponentJavaAdapter;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.SerializationKt;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.serialization.ObjectSerializer;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.VersionedFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.PathKt;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.util.xmlb.annotations.XMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ExternalProjectsData", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class ExternalProjectsDataStorage
implements SettingsSavingComponentJavaAdapter,
PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(ExternalProjectsDataStorage.class);
    public static final int STORAGE_VERSION = 6;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<Pair<ProjectSystemId, File>, InternalExternalProjectInfo> myExternalRootProjects;
    private final AtomicBoolean changed;
    private State myState;

    public static ExternalProjectsDataStorage getInstance(@NotNull Project project) {
        if (project == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(0);
        }
        return (ExternalProjectsDataStorage)ServiceManager.getService((Project)project, ExternalProjectsDataStorage.class);
    }

    public ExternalProjectsDataStorage(@NotNull Project project) {
        if (project == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(1);
        }
        this.myExternalRootProjects = ConcurrentCollectionFactory.createMap(ExternalSystemUtil.HASHING_STRATEGY);
        this.changed = new AtomicBoolean();
        this.myState = new State();
        this.myProject = project;
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)project).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                ObjectSerializer.getInstance().clearBindingCache();
            }

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                Set existingEPs = ExternalSystemManager.EP_NAME.getExtensionList().stream().map(ExternalSystemManager::getSystemId).collect(Collectors.toSet());
                Iterator iter = ExternalProjectsDataStorage.this.myExternalRootProjects.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (existingEPs.contains(((Pair)entry.getKey()).first)) continue;
                    iter.remove();
                    ExternalProjectsDataStorage.this.markDirty(((InternalExternalProjectInfo)entry.getValue()).getExternalProjectPath());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforePluginUnload";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginUnloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public synchronized void load() {
        long startTs;
        long readEnd = startTs = System.currentTimeMillis();
        try {
            List<InternalExternalProjectInfo> projectInfos = ExternalProjectsDataStorage.load(this.myProject);
            readEnd = System.currentTimeMillis();
            if (projectInfos == null || projectInfos.isEmpty() && this.myProject.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) != Boolean.TRUE && this.hasLinkedExternalProjects()) {
                this.markDirtyAllExternalProjects();
            }
            for (InternalExternalProjectInfo projectInfo : ContainerUtil.notNullize(projectInfos)) {
                Pair key = Pair.create((Object)projectInfo.getProjectSystemId(), (Object)new File(projectInfo.getExternalProjectPath()));
                InternalExternalProjectInfo projectInfoReceivedBeforeStorageInitialization = this.myExternalRootProjects.get(key);
                if (projectInfoReceivedBeforeStorageInitialization != null && projectInfoReceivedBeforeStorageInitialization.getLastSuccessfulImportTimestamp() > 0L) continue;
                if (ExternalProjectsDataStorage.validate(projectInfo)) {
                    this.myExternalRootProjects.put((Pair<ProjectSystemId, File>)key, projectInfo);
                    if (projectInfo.getLastImportTimestamp() == projectInfo.getLastSuccessfulImportTimestamp()) continue;
                    this.markDirty(projectInfo.getExternalProjectPath());
                    continue;
                }
                String projectPath = projectInfo.getNullSafeExternalProjectPath();
                if (projectPath == null) continue;
                this.markDirty(projectPath);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            this.markDirtyAllExternalProjects();
            LOG.error(e);
        }
        this.mergeLocalSettings();
        long finishTs = System.currentTimeMillis();
        LOG.info("Load external projects data in " + (finishTs - startTs) + " millis (read time: " + (readEnd - startTs) + ")");
    }

    private boolean hasLinkedExternalProjects() {
        for (ExternalSystemManager manager : ExternalSystemManager.EP_NAME.getIterable()) {
            if (((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectsSettings().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void markDirtyAllExternalProjects() {
        ExternalProjectsManager.getInstance((Project)this.myProject).getExternalProjectsWatcher().markDirtyAllExternalProjects();
    }

    private void markDirty(String projectPath) {
        ExternalProjectsManager.getInstance((Project)this.myProject).getExternalProjectsWatcher().markDirty(projectPath);
    }

    private static boolean validate(InternalExternalProjectInfo externalProjectInfo) {
        DataNode<ProjectData> projectStructure = externalProjectInfo.getExternalProjectStructure();
        if (projectStructure == null) {
            return false;
        }
        ProjectDataManagerImpl.getInstance().ensureTheDataIsReadyToUse(projectStructure);
        return externalProjectInfo.getExternalProjectPath().equals(((ProjectData)projectStructure.getData()).getLinkedExternalProjectPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSave() {
        if (!this.changed.compareAndSet(true, false)) {
            return;
        }
        try {
            ExternalProjectsDataStorage externalProjectsDataStorage = this;
            synchronized (externalProjectsDataStorage) {
                long start2 = System.currentTimeMillis();
                ExternalProjectsDataStorage.doSave(this.myProject, this.myExternalRootProjects.values());
                long duration = System.currentTimeMillis() - start2;
                LOG.info("Save external projects data in " + duration + " ms");
            }
        }
        catch (SerializationException | IOException e) {
            LOG.error(e);
        }
    }

    synchronized void update(@NotNull ExternalProjectInfo externalProjectInfo) {
        if (externalProjectInfo == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(2);
        }
        this.restoreInclusionSettings((DataNode<ProjectData>)externalProjectInfo.getExternalProjectStructure());
        ProjectSystemId projectSystemId = externalProjectInfo.getProjectSystemId();
        String projectPath = externalProjectInfo.getExternalProjectPath();
        DataNode externalProjectStructure = externalProjectInfo.getExternalProjectStructure();
        long lastSuccessfulImportTimestamp = externalProjectInfo.getLastSuccessfulImportTimestamp();
        long lastImportTimestamp = externalProjectInfo.getLastImportTimestamp();
        Pair key = Pair.create((Object)projectSystemId, (Object)new File(projectPath));
        InternalExternalProjectInfo old = this.myExternalRootProjects.get(key);
        if (old != null) {
            lastImportTimestamp = externalProjectInfo.getLastImportTimestamp();
            if (lastSuccessfulImportTimestamp == -1L) {
                lastSuccessfulImportTimestamp = old.getLastSuccessfulImportTimestamp();
            }
            externalProjectStructure = externalProjectInfo.getExternalProjectStructure() == null ? old.getExternalProjectStructure() : externalProjectInfo.getExternalProjectStructure().graphCopy();
        } else {
            externalProjectStructure = externalProjectStructure != null ? externalProjectStructure.graphCopy() : null;
        }
        InternalExternalProjectInfo merged = new InternalExternalProjectInfo(projectSystemId, projectPath, (DataNode<ProjectData>)externalProjectStructure);
        merged.setLastImportTimestamp(lastImportTimestamp);
        merged.setLastSuccessfulImportTimestamp(lastSuccessfulImportTimestamp);
        this.myExternalRootProjects.put((Pair<ProjectSystemId, File>)key, merged);
        this.markAsChangedAndScheduleSave();
    }

    synchronized void restoreInclusionSettings(@Nullable DataNode<ProjectData> projectDataNode) {
        if (projectDataNode == null) {
            return;
        }
        String rootProjectPath = ((ProjectData)projectDataNode.getData()).getLinkedExternalProjectPath();
        ProjectState projectState = this.myState.map.get(rootProjectPath);
        if (projectState == null) {
            return;
        }
        projectDataNode.visit(node -> {
            DataNode<ExternalConfigPathAware> projectOrModuleNode = ExternalProjectsDataStorage.resolveProjectNode(node);
            assert (projectOrModuleNode != null);
            ModuleState moduleState = projectState.map.get(((ExternalConfigPathAware)projectOrModuleNode.getData()).getLinkedExternalProjectPath());
            node.setIgnored(ExternalProjectsDataStorage.isIgnored(projectState, moduleState, node.getKey()));
        });
    }

    synchronized void saveInclusionSettings(@Nullable DataNode<ProjectData> projectDataNode) {
        MultiMap map2;
        if (projectDataNode == null) {
            return;
        }
        MultiMap inclusionMap = new MultiMap();
        MultiMap exclusionMap = new MultiMap();
        projectDataNode.visit(dataNode -> {
            DataNode<ExternalConfigPathAware> projectNode = ExternalProjectsDataStorage.resolveProjectNode(dataNode);
            if (projectNode != null) {
                String projectPath = ((ExternalConfigPathAware)projectNode.getData()).getLinkedExternalProjectPath();
                if (projectNode.isIgnored() || dataNode.isIgnored()) {
                    exclusionMap.putValue((Object)projectPath, (Object)dataNode.getKey().getDataType());
                } else {
                    inclusionMap.putValue((Object)projectPath, (Object)dataNode.getKey().getDataType());
                }
            }
        });
        ProjectState projectState = new ProjectState();
        if (inclusionMap.size() < exclusionMap.size()) {
            projectState.isInclusion = true;
            map2 = inclusionMap;
        } else {
            projectState.isInclusion = false;
            map2 = exclusionMap;
        }
        for (String path : map2.keySet()) {
            projectState.map.put(path, new ModuleState(map2.get((Object)path)));
        }
        this.myState.map.put(((ProjectData)projectDataNode.getData()).getLinkedExternalProjectPath(), projectState);
        this.markAsChangedAndScheduleSave();
    }

    private void markAsChangedAndScheduleSave() {
        if (this.changed.compareAndSet(false, true)) {
            SaveAndSyncHandler.getInstance().scheduleSave(SaveAndSyncHandler.SaveTask.projectIncludingAllSettings((Project)this.myProject), false);
        }
    }

    @Nullable
    synchronized ExternalProjectInfo get(@NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (projectSystemId == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(3);
        }
        if (externalProjectPath == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(4);
        }
        return this.myExternalRootProjects.get(Pair.create((Object)projectSystemId, (Object)new File(externalProjectPath)));
    }

    synchronized void remove(@NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        InternalExternalProjectInfo removed;
        if (projectSystemId == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(5);
        }
        if (externalProjectPath == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(6);
        }
        if ((removed = this.myExternalRootProjects.remove(Pair.create((Object)projectSystemId, (Object)new File(externalProjectPath)))) != null) {
            this.markAsChangedAndScheduleSave();
        }
    }

    @NotNull
    synchronized Collection<ExternalProjectInfo> list(@NotNull ProjectSystemId projectSystemId) {
        if (projectSystemId == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(7);
        }
        List list2 = ContainerUtil.mapNotNull(this.myExternalRootProjects.values(), info -> projectSystemId.equals((Object)info.getProjectSystemId()) ? info : null);
        if (list2 == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private void mergeLocalSettings() {
        for (ExternalSystemManager manager : ExternalSystemManager.EP_NAME.getIterable()) {
            ProjectSystemId systemId = manager.getSystemId();
            AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)this.myProject);
            Map availableProjects = settings.getAvailableProjects();
            for (Map.Entry entry : availableProjects.entrySet()) {
                ExternalProjectSettings linkedProjectSettings;
                ExternalProjectPojo projectPojo = (ExternalProjectPojo)entry.getKey();
                String externalProjectPath = projectPojo.getPath();
                Pair key = Pair.create((Object)systemId, (Object)new File(externalProjectPath));
                InternalExternalProjectInfo externalProjectInfo = this.myExternalRootProjects.get(key);
                if (externalProjectInfo == null) {
                    DataNode<ProjectData> dataNode = ExternalProjectsDataStorage.convert(systemId, projectPojo, (Collection)entry.getValue());
                    externalProjectInfo = new InternalExternalProjectInfo(systemId, externalProjectPath, dataNode);
                    this.myExternalRootProjects.put((Pair<ProjectSystemId, File>)key, externalProjectInfo);
                    ExternalProjectsManager.getInstance((Project)this.myProject).getExternalProjectsWatcher().markDirty(externalProjectPath);
                    this.markAsChangedAndScheduleSave();
                }
                if ((linkedProjectSettings = ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectSettings(externalProjectPath)) == null || !ContainerUtil.isEmpty((Collection)linkedProjectSettings.getModules())) continue;
                Set modulePaths = ContainerUtil.map2Set((Collection)ExternalSystemApiUtil.findAllRecursively(externalProjectInfo.getExternalProjectStructure(), (Key)ProjectKeys.MODULE), node -> ((ModuleData)node.getData()).getLinkedExternalProjectPath());
                linkedProjectSettings.setModules(modulePaths);
            }
        }
    }

    private static DataNode<ProjectData> convert(@NotNull ProjectSystemId systemId, @NotNull ExternalProjectPojo rootProject, @NotNull Collection<? extends ExternalProjectPojo> childProjects) {
        if (systemId == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(9);
        }
        if (rootProject == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(10);
        }
        if (childProjects == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(11);
        }
        ProjectData projectData2 = new ProjectData(systemId, rootProject.getName(), rootProject.getPath(), rootProject.getPath());
        DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData2, null);
        for (ExternalProjectPojo externalProjectPojo : childProjects) {
            String moduleConfigPath = externalProjectPojo.getPath();
            ModuleData moduleData = new ModuleData(externalProjectPojo.getName(), systemId, "JAVA_MODULE", externalProjectPojo.getName(), moduleConfigPath, moduleConfigPath);
            projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
        }
        return projectDataNode;
    }

    private static void doSave(@NotNull Project project, @NotNull Collection<InternalExternalProjectInfo> externalProjects) throws IOException {
        if (project == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(12);
        }
        if (externalProjects == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(13);
        }
        Iterator<InternalExternalProjectInfo> iterator2 = externalProjects.iterator();
        while (iterator2.hasNext()) {
            InternalExternalProjectInfo externalProject = iterator2.next();
            if (ExternalProjectsDataStorage.validate(externalProject)) continue;
            iterator2.remove();
        }
        ExternalProjectsDataStorage.getCacheFile(project).writeList(externalProjects, InternalExternalProjectInfo.class, SerializationKt.createCacheWriteConfiguration());
    }

    @Nullable
    private static DataNode<ExternalConfigPathAware> resolveProjectNode(@NotNull DataNode node) {
        if (node == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(14);
        }
        if ((ProjectKeys.MODULE.equals((Object)node.getKey()) || ProjectKeys.PROJECT.equals((Object)node.getKey())) && node.getData() instanceof ExternalConfigPathAware) {
            return node;
        }
        DataNode parent = ExternalSystemApiUtil.findParent((DataNode)node, (Key)ProjectKeys.MODULE);
        if (parent == null) {
            parent = ExternalSystemApiUtil.findParent((DataNode)node, (Key)ProjectKeys.PROJECT);
        }
        return parent;
    }

    @Nullable(value="null indicates that cache was invalid")
    private static @Nullable(value="null indicates that cache was invalid") List<InternalExternalProjectInfo> load(@NotNull Project project) throws IOException {
        VersionedFile cacheFile;
        BasicFileAttributes fileAttributes;
        if (project == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(15);
        }
        if ((fileAttributes = PathKt.basicAttributesIfExists((Path)(cacheFile = ExternalProjectsDataStorage.getCacheFile(project)).getFile())) == null || !fileAttributes.isRegularFile()) {
            return Collections.emptyList();
        }
        if (ExternalProjectsDataStorage.isInvalidated(cacheFile.getFile(), fileAttributes)) {
            LOG.debug("External projects data storage was invalidated");
            return null;
        }
        return cacheFile.readList(InternalExternalProjectInfo.class, SerializationKt.createCacheReadConfiguration((Logger)LOG));
    }

    private static boolean isInvalidated(@NotNull Path configurationFile, @NotNull BasicFileAttributes fileAttributes) throws IOException {
        if (configurationFile == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(16);
        }
        if (fileAttributes == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(17);
        }
        if (!Registry.is((String)"external.system.invalidate.storage", (boolean)true)) {
            return false;
        }
        long lastModified = fileAttributes.lastModifiedTime().toMillis();
        if (lastModified == 0L) {
            return true;
        }
        File brokenMarkerFile = ExternalProjectsDataStorage.getBrokenMarkerFile();
        if (brokenMarkerFile.exists() && lastModified < brokenMarkerFile.lastModified()) {
            Files.delete(configurationFile);
            return true;
        }
        return false;
    }

    @NotNull
    private static VersionedFile getCacheFile(@NotNull Project project) {
        if (project == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(18);
        }
        return new VersionedFile(ExternalProjectsDataStorage.getProjectConfigurationDir(project).resolve("project.dat"), 6);
    }

    @NotNull
    public static Path getProjectConfigurationDir(@NotNull Project project) {
        if (project == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(19);
        }
        Path path = ProjectUtil.getExternalConfigurationDir((Project)project);
        if (path == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(20);
        }
        return path;
    }

    @Nullable
    public synchronized State getState() {
        return this.myState;
    }

    public synchronized void loadState(@NotNull State state) {
        if (state == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(21);
        }
        this.myState = state;
    }

    synchronized void setIgnored(@NotNull DataNode<?> dataNode, boolean isIgnored) {
        DataNode projectDataNode;
        if (dataNode == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(22);
        }
        DataNode dataNode2 = projectDataNode = ProjectKeys.PROJECT.equals((Object)dataNode.getKey()) ? dataNode : ExternalSystemApiUtil.findParent(dataNode, (Key)ProjectKeys.PROJECT);
        if (projectDataNode == null) {
            return;
        }
        dataNode.visit(node -> node.setIgnored(isIgnored));
        this.saveInclusionSettings((DataNode<ProjectData>)projectDataNode);
    }

    synchronized boolean isIgnored(@NotNull String rootProjectPath, @NotNull String modulePath, @NotNull Key key) {
        ProjectState projectState;
        if (rootProjectPath == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(23);
        }
        if (modulePath == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(24);
        }
        if (key == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(25);
        }
        if ((projectState = this.myState.map.get(rootProjectPath)) == null) {
            return false;
        }
        ModuleState moduleState = projectState.map.get(modulePath);
        return ExternalProjectsDataStorage.isIgnored(projectState, moduleState, key);
    }

    private static boolean isIgnored(@NotNull ProjectState projectState, @Nullable ModuleState moduleState, @NotNull Key<?> key) {
        if (projectState == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(26);
        }
        if (key == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(27);
        }
        return projectState.isInclusion ^ (moduleState != null && moduleState.set.contains(key.getDataType()));
    }

    public static synchronized void invalidateCaches() {
        if (!Registry.is((String)"external.system.invalidate.storage", (boolean)true)) {
            return;
        }
        File markerFile2 = ExternalProjectsDataStorage.getBrokenMarkerFile();
        try {
            FileUtil.writeToFile((File)markerFile2, (String)String.valueOf(System.currentTimeMillis()));
        }
        catch (IOException e) {
            LOG.warn("Cannot update the invalidation marker file", (Throwable)e);
        }
    }

    @NotNull
    private static File getBrokenMarkerFile() {
        File file2 = PathManagerEx.getAppSystemDir().resolve("external_build_system").resolve(".broken").toFile();
        if (file2 == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(28);
        }
        return file2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 20: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 20: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectInfo";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 8: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProject";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childProjects";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjects";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAttributes";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNode";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProjectPath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectConfigurationDir";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenMarkerFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 8: 
            case 20: 
            case 28: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doSave";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectNode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isInvalidated";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCacheFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getProjectConfigurationDir";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setIgnored";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 20: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ModuleState {
        @Property(surroundWithTag=false)
        @XCollection(elementName="id")
        public final Set<String> set;

        ModuleState() {
            this.set = new THashSet();
        }

        ModuleState(@NotNull Collection<String> values2) {
            if (values2 == null) {
                ModuleState.$$$reportNull$$$0(0);
            }
            this.set = new THashSet(values2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage$ModuleState", "<init>"));
        }
    }

    static class ProjectState {
        @Property(surroundWithTag=false)
        @XMap(keyAttributeName="path", entryTagName="dataType")
        public final Map<String, ModuleState> map = new THashMap();
        public boolean isInclusion;

        ProjectState() {
        }
    }

    static final class State {
        @Property(surroundWithTag=false)
        @MapAnnotation(surroundWithTag=false, surroundValueWithTag=false, surroundKeyWithTag=false, keyAttributeName="path", entryTagName="projectState")
        public final Map<String, ProjectState> map = new THashMap();

        State() {
        }
    }
}

