/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.idea.Main;
import com.intellij.idea.SplashManager;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportProgressDialog;
import com.intellij.openapi.application.ConfigImportSettings;
import com.intellij.openapi.application.CustomConfigMigrationOption;
import com.intellij.openapi.application.ImportOldConfigsPanel;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.RestoreDefaultConfigCustomizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.Restarter;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.Decompressor;
import com.intellij.util.text.VersionComparatorUtil;
import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigImportHelper {
    private static final String FIRST_SESSION_KEY = "intellij.first.ide.session";
    private static final String CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY = "intellij.config.imported.in.current.session";
    private static final String CONFIG = "config";
    private static final String[] OPTIONS = new String[]{"options/other.xml", "options/ide.general.xml", "options/options.xml"};
    private static final String BIN = "bin";
    private static final String CONTENTS = "Contents";
    private static final String PLIST = "Info.plist";
    private static final String PLUGINS = "plugins";
    private static final String SYSTEM = "system";
    private static final Pattern SELECTOR_PATTERN = Pattern.compile("\\.?([^\\d]+)(\\d+(?:\\.\\d+)?)");
    private static final String SHOW_IMPORT_CONFIG_DIALOG_PROPERTY = "idea.initially.ask.config";
    public static final String CUSTOM_MARKER_FILE_NAME = "migrate.config";

    private ConfigImportHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void importConfigsTo(boolean veryFirstStartOnThisComputer, @NotNull Path newConfigDir, @NotNull Logger log) {
        boolean vmOptionFileChanged;
        block29: {
            if (newConfigDir == null) {
                ConfigImportHelper.$$$reportNull$$$0(0);
            }
            if (log == null) {
                ConfigImportHelper.$$$reportNull$$$0(1);
            }
            log.info("Importing configs to " + newConfigDir);
            System.setProperty(FIRST_SESSION_KEY, Boolean.TRUE.toString());
            CustomConfigMigrationOption customMigrationOption = CustomConfigMigrationOption.readCustomConfigMigrationOptionAndRemoveMarkerFile(newConfigDir);
            if (customMigrationOption instanceof CustomConfigMigrationOption.SetProperties) {
                List<String> properties = ((CustomConfigMigrationOption.SetProperties)customMigrationOption).getProperties();
                log.info("Enabling system properties after restart: " + properties);
                Iterator<String> iterator2 = properties.iterator();
                while (iterator2.hasNext()) {
                    String property = iterator2.next();
                    System.setProperty(property, Boolean.TRUE.toString());
                }
                return;
            }
            ConfigImportSettings settings = null;
            try {
                String customProviderName = "com.intellij.openapi.application." + PlatformUtils.getPlatformPrefix() + "ConfigImportSettings";
                Class<?> customProviderClass = Class.forName(customProviderName);
                if (ConfigImportSettings.class.isAssignableFrom(customProviderClass)) {
                    settings = (ConfigImportSettings)ReflectionUtil.newInstance(customProviderClass);
                }
            }
            catch (Exception customProviderName) {
                // empty catch block
            }
            @NotNull List<PathAndFileTime> guessedOldConfigDirs = ConfigImportHelper.findConfigDirectories(newConfigDir);
            File tempBackup = null;
            vmOptionFileChanged = false;
            try {
                Pair<Path, Path> oldConfigDirAndOldIdePath;
                block28: {
                    oldConfigDirAndOldIdePath = null;
                    if (customMigrationOption != null) {
                        log.info("Custom migration option: " + customMigrationOption);
                        vmOptionFileChanged = ConfigImportHelper.doesVmOptionFileExist(newConfigDir);
                        try {
                            if (customMigrationOption instanceof CustomConfigMigrationOption.MigrateFromCustomPlace) {
                                tempBackup = ConfigImportHelper.backupCurrentConfigToTempAndDelete(newConfigDir, log, false);
                                Path location = ((CustomConfigMigrationOption.MigrateFromCustomPlace)customMigrationOption).getLocation();
                                oldConfigDirAndOldIdePath = ConfigImportHelper.findConfigDirectoryByPath(location);
                                break block28;
                            }
                            tempBackup = ConfigImportHelper.backupCurrentConfigToTempAndDelete(newConfigDir, log, true);
                        }
                        catch (IOException e) {
                            log.error("Couldn't backup current config or delete current config directory", (Throwable)e);
                        }
                    } else if (ConfigImportHelper.shouldAskForConfig()) {
                        oldConfigDirAndOldIdePath = ConfigImportHelper.showDialogAndGetOldConfigPath(guessedOldConfigDirs);
                    } else if (guessedOldConfigDirs.isEmpty()) {
                        boolean importedFromCloud = false;
                        CloudConfigProvider configProvider = CloudConfigProvider.getProvider();
                        if (configProvider != null) {
                            importedFromCloud = configProvider.importSettingsSilently(newConfigDir);
                        }
                        if (!importedFromCloud && !veryFirstStartOnThisComputer) {
                            oldConfigDirAndOldIdePath = ConfigImportHelper.showDialogAndGetOldConfigPath(guessedOldConfigDirs);
                        }
                    } else {
                        PathAndFileTime bestConfigGuess = guessedOldConfigDirs.get(0);
                        oldConfigDirAndOldIdePath = ConfigImportHelper.isConfigOld(bestConfigGuess.fileTime) ? ConfigImportHelper.showDialogAndGetOldConfigPath(guessedOldConfigDirs) : ConfigImportHelper.findConfigDirectoryByPath(bestConfigGuess.path);
                    }
                }
                if (oldConfigDirAndOldIdePath != null) {
                    ConfigImportHelper.doImport((Path)oldConfigDirAndOldIdePath.first, newConfigDir, (Path)oldConfigDirAndOldIdePath.second, log);
                    if (settings != null) {
                        settings.importFinished(newConfigDir);
                    }
                    System.setProperty(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY, Boolean.TRUE.toString());
                } else {
                    log.info("No configs imported, starting with clean configs at " + newConfigDir);
                }
                vmOptionFileChanged |= ConfigImportHelper.doesVmOptionFileExist(newConfigDir);
                if (tempBackup == null) break block29;
            }
            catch (Throwable throwable) {
                if (tempBackup == null) throw throwable;
                try {
                    ConfigImportHelper.moveTempBackupToStandardBackup(tempBackup, log);
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn(String.format("Couldn't move the backup of current config from temp dir [%s] to backup dir [%s]", tempBackup, ConfigImportHelper.getBackupPath()), (Throwable)e);
                }
                throw throwable;
            }
            try {
                ConfigImportHelper.moveTempBackupToStandardBackup(tempBackup, log);
            }
            catch (IOException e) {
                log.warn(String.format("Couldn't move the backup of current config from temp dir [%s] to backup dir [%s]", tempBackup, ConfigImportHelper.getBackupPath()), (Throwable)e);
            }
        }
        if (!vmOptionFileChanged) return;
        log.info("The vmoptions file has changed, restarting...");
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(FIRST_SESSION_KEY);
        if (ConfigImportHelper.isConfigImported()) {
            properties.add(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY);
        }
        new CustomConfigMigrationOption.SetProperties(properties).writeConfigMarkerFile();
        ConfigImportHelper.restart();
    }

    private static boolean isConfigOld(@NotNull FileTime time) {
        if (time == null) {
            ConfigImportHelper.$$$reportNull$$$0(2);
        }
        Instant deadline = Instant.now().minus(180L, ChronoUnit.DAYS);
        return time.toInstant().compareTo(deadline) < 0;
    }

    private static boolean doesVmOptionFileExist(@NotNull Path configDir) {
        if (configDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(3);
        }
        return Files.isRegularFile(configDir.resolve(VMOptions.getCustomVMOptionsFileName()), new LinkOption[0]);
    }

    private static void restart() {
        if (Restarter.isSupported()) {
            try {
                Restarter.scheduleRestart(false, new String[0]);
            }
            catch (IOException e) {
                Main.showMessage((String)"Restart failed", (Throwable)e);
            }
            System.exit(0);
        } else {
            String no;
            String yes;
            String title = ApplicationBundle.message((String)"title.import.settings", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
            String message = ApplicationBundle.message((String)"restart.import.settings", (Object[])new Object[0]);
            if (Messages.showYesNoDialog((String)message, (String)title, (String)(yes = ApplicationBundle.message((String)"restart.import.now", (Object[])new Object[0])), (String)(no = ApplicationBundle.message((String)"restart.import.later", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon()) == 0) {
                System.exit(0);
            }
        }
    }

    @NotNull
    private static File backupCurrentConfigToTempAndDelete(@NotNull Path currentConfig, @NotNull Logger log, boolean smartDelete) throws IOException {
        if (currentConfig == null) {
            ConfigImportHelper.$$$reportNull$$$0(4);
        }
        if (log == null) {
            ConfigImportHelper.$$$reportNull$$$0(5);
        }
        File tempBackupDir = FileUtil.createTempDirectory((String)ConfigImportHelper.getConfigDirName(), (String)"-backup");
        log.info("Backup config from " + currentConfig + " to " + tempBackupDir);
        FileUtil.copyDir((File)PathManager.getConfigDir().toFile(), (File)tempBackupDir);
        ConfigImportHelper.deleteCurrentConfigDir(currentConfig, log, smartDelete);
        Path pluginsDir = currentConfig.getFileSystem().getPath(PathManager.getPluginsPath(), new String[0]);
        if (Files.exists(pluginsDir, new LinkOption[0]) && !pluginsDir.startsWith(currentConfig)) {
            File pluginsBackup = new File(tempBackupDir, PLUGINS);
            log.info("Backup plugins dir separately from " + pluginsDir + " to " + pluginsBackup);
            if (pluginsBackup.mkdir()) {
                FileUtil.copyDir((File)new File(pluginsDir.toString()), (File)pluginsBackup);
                FileUtil.delete((Path)pluginsDir);
            } else {
                log.warn("Couldn't backup plugins directory to " + pluginsBackup);
            }
        }
        File file2 = tempBackupDir;
        if (file2 == null) {
            ConfigImportHelper.$$$reportNull$$$0(6);
        }
        return file2;
    }

    private static void deleteCurrentConfigDir(@NotNull Path currentConfig, @NotNull Logger log, boolean smartDelete) throws IOException {
        if (currentConfig == null) {
            ConfigImportHelper.$$$reportNull$$$0(7);
        }
        if (log == null) {
            ConfigImportHelper.$$$reportNull$$$0(8);
        }
        log.debug("Removing current config directory, smartDelete: " + smartDelete);
        if (!smartDelete) {
            FileUtil.delete((Path)currentConfig);
            return;
        }
        boolean removedViaCustomizer = false;
        try {
            Iterator<RestoreDefaultConfigCustomizer> iterator2 = ServiceLoader.load(RestoreDefaultConfigCustomizer.class).iterator();
            if (iterator2.hasNext()) {
                RestoreDefaultConfigCustomizer customizer = iterator2.next();
                log.debug("Found " + customizer);
                customizer.removeCurrentConfigDir(currentConfig);
                removedViaCustomizer = true;
            }
        }
        catch (Exception e) {
            log.warn("Couldn't remove current config dir using the customizer", (Throwable)e);
        }
        if (!removedViaCustomizer) {
            log.debug("RestoreDefaultConfigCustomizer not found, removing config directory manually...");
            FileUtil.delete((Path)currentConfig);
        }
    }

    private static void moveTempBackupToStandardBackup(@NotNull File backupToMove, @NotNull Logger log) throws IOException {
        if (backupToMove == null) {
            ConfigImportHelper.$$$reportNull$$$0(9);
        }
        if (log == null) {
            ConfigImportHelper.$$$reportNull$$$0(10);
        }
        Path backupPath = ConfigImportHelper.getBackupPath();
        log.info("Move backup from " + backupToMove + " to " + backupPath);
        FileUtil.delete((Path)backupPath);
        FileUtil.copyDir((File)backupToMove, (File)backupPath.toFile());
    }

    @NotNull
    public static Path getBackupPath() {
        Path configDir = PathManager.getConfigDir();
        Path path = configDir.resolveSibling(ConfigImportHelper.getConfigDirName() + "-backup");
        if (path == null) {
            ConfigImportHelper.$$$reportNull$$$0(11);
        }
        return path;
    }

    @NotNull
    private static String getConfigDirName() {
        String string = PathManager.getConfigDir().getFileName().toString();
        if (string == null) {
            ConfigImportHelper.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static boolean shouldAskForConfig() {
        String showImportDialog = System.getProperty(SHOW_IMPORT_CONFIG_DIALOG_PROPERTY);
        if ("force-not".equals(showImportDialog)) {
            return false;
        }
        return PluginManagerCore.isRunningFromSources() || System.getProperty("idea.config.path") != null || "true".equals(showImportDialog);
    }

    @Nullable
    private static Pair<Path, Path> showDialogAndGetOldConfigPath(@NotNull List<PathAndFileTime> guessedOldConfigDirs) {
        if (guessedOldConfigDirs == null) {
            ConfigImportHelper.$$$reportNull$$$0(13);
        }
        ImportOldConfigsPanel dialog2 = new ImportOldConfigsPanel(ContainerUtil.map(guessedOldConfigDirs, it -> it.path), ConfigImportHelper::findConfigDirectoryByPath);
        dialog2.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        AppUIUtil.updateWindowIcon(dialog2);
        Ref result2 = new Ref();
        SplashManager.executeWithHiddenSplash(dialog2, () -> {
            dialog2.setVisible(true);
            result2.set(dialog2.getSelectedFile());
            dialog2.dispose();
        });
        return (Pair)result2.get();
    }

    public static boolean isFirstSession() {
        return Boolean.getBoolean(FIRST_SESSION_KEY);
    }

    public static boolean isSettingsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ConfigImportHelper.$$$reportNull$$$0(14);
        }
        return FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)ArchiveFileType.INSTANCE);
    }

    public static boolean isConfigImported() {
        return Boolean.getBoolean(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY);
    }

    static boolean isValidSettingsFile(@NotNull File file2) {
        boolean bl;
        if (file2 == null) {
            ConfigImportHelper.$$$reportNull$$$0(15);
        }
        ZipFile zip = new ZipFile(file2);
        try {
            bl = zip.getEntry("IntelliJ IDEA Global Settings") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ignored) {
                return false;
            }
        }
        zip.close();
        return bl;
    }

    public static boolean isConfigDirectory(@NotNull Path candidate) {
        if (candidate == null) {
            ConfigImportHelper.$$$reportNull$$$0(16);
        }
        return Arrays.stream(OPTIONS).anyMatch(name -> Files.exists(candidate.resolve((String)name), new LinkOption[0]));
    }

    @NotNull
    static List<PathAndFileTime> findConfigDirectories(@NotNull Path newConfigDir) {
        String productName;
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(17);
        }
        HashSet<Path> homes = new HashSet<Path>();
        homes.add(newConfigDir.getParent());
        homes.add(newConfigDir.getFileSystem().getPath(PathManager.getDefaultConfigPathFor((String)"X"), new String[0]).getParent());
        Path historic = newConfigDir.getFileSystem().getPath(ConfigImportHelper.defaultConfigPath("X2019.3"), new String[0]);
        homes.add(SystemInfo.isMac ? historic.getParent() : historic.getParent().getParent());
        String prefix = ConfigImportHelper.getPrefixFromSelector(PathManager.getPathsSelector());
        if (prefix == null) {
            prefix = ConfigImportHelper.getPrefixFromSelector(ConfigImportHelper.getNameWithVersion(newConfigDir));
        }
        if (prefix == null && (productName = ApplicationNamesInfo.getInstance().getFullProductName()) != null) {
            prefix = productName.replace(" ", "");
        }
        if (prefix == null) {
            prefix = PlatformUtils.getPlatformPrefix();
        }
        String dotPrefix = '.' + prefix;
        ArrayList<Path> candidates = new ArrayList<Path>();
        for (Path home : homes) {
            if (home == null || !Files.isDirectory(home, new LinkOption[0])) continue;
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(home);
                try {
                    for (Path path : stream) {
                        String name;
                        if (path.equals(newConfigDir) || !StringUtil.startsWithIgnoreCase((String)(name = path.getFileName().toString()), (String)prefix) && !StringUtil.startsWithIgnoreCase((String)name, (String)dotPrefix) || !Files.isDirectory(path, new LinkOption[0])) continue;
                        candidates.add(path);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException stream) {}
        }
        if (candidates.isEmpty()) {
            List<PathAndFileTime> list2 = Collections.emptyList();
            if (list2 == null) {
                ConfigImportHelper.$$$reportNull$$$0(18);
            }
            return list2;
        }
        ArrayList<PathAndFileTime> lastModified = new ArrayList<PathAndFileTime>();
        Iterator iterator2 = candidates.iterator();
        while (iterator2.hasNext()) {
            Path child2;
            Path candidate = child2 = (Path)iterator2.next();
            Path config2 = child2.resolve(CONFIG);
            if (Files.isDirectory(config2, new LinkOption[0])) {
                candidate = config2;
            }
            FileTime max = null;
            for (String name : OPTIONS) {
                try {
                    FileTime cur = Files.getLastModifiedTime(candidate.resolve(name), new LinkOption[0]);
                    if (max != null && cur.compareTo(max) <= 0) continue;
                    max = cur;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            lastModified.add(new PathAndFileTime(candidate, max != null ? max : FileTime.fromMillis(0L)));
        }
        lastModified.sort((o1, o2) -> {
            int diff = o2.fileTime.compareTo(o1.fileTime);
            if (diff == 0) {
                diff = StringUtil.naturalCompare((String)o2.path.toString(), (String)o1.path.toString());
            }
            return diff;
        });
        ArrayList<PathAndFileTime> arrayList = lastModified;
        if (arrayList == null) {
            ConfigImportHelper.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static String getNameWithVersion(Path configDir) {
        String name = configDir.getFileName().toString();
        if (CONFIG.equals(name)) {
            name = StringUtil.trimStart((String)configDir.getParent().getFileName().toString(), (String)".");
        }
        return name;
    }

    @Nullable
    private static String getPrefixFromSelector(@Nullable String nameWithSelector) {
        Matcher m;
        if (nameWithSelector != null && (m = SELECTOR_PATTERN.matcher(nameWithSelector)).matches()) {
            return m.group(1);
        }
        return null;
    }

    @Nullable
    private static Pair<Path, Path> findConfigDirectoryByPath(Path selectedDir) {
        Path configDir;
        if (ConfigImportHelper.isConfigDirectory(selectedDir)) {
            return Pair.pair((Object)selectedDir, null);
        }
        Path config2 = selectedDir.resolve(CONFIG);
        if (ConfigImportHelper.isConfigDirectory(config2)) {
            return Pair.pair((Object)config2, null);
        }
        if (Files.isDirectory(selectedDir.resolve(SystemInfo.isMac ? CONTENTS : BIN), new LinkOption[0]) && (configDir = ConfigImportHelper.getSettingsPath(selectedDir, "idea.config.path", ConfigImportHelper::defaultConfigPath)) != null && ConfigImportHelper.isConfigDirectory(configDir)) {
            return Pair.pair((Object)configDir, (Object)selectedDir);
        }
        return null;
    }

    @Nullable
    private static Path getSettingsPath(Path ideHome, String propertyName, Function<String, String> pathBySelector) {
        Path candidate;
        ArrayList<Path> files2 = new ArrayList<Path>();
        if (SystemInfo.isMac) {
            files2.add(ideHome.resolve("Contents/bin/idea.properties"));
            files2.add(ideHome.resolve("Contents/Info.plist"));
        } else {
            files2.add(ideHome.resolve("bin/idea.properties"));
            String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
            files2.add(ideHome.resolve("bin/" + scriptName + ".bat"));
            files2.add(ideHome.resolve("bin/" + scriptName + ".sh"));
        }
        for (Path file2 : files2) {
            String candidatePath;
            if (!Files.isRegularFile(file2, new LinkOption[0]) || (candidatePath = PathManager.substituteVars((String)ConfigImportHelper.getPropertyFromFile(file2, propertyName), (String)ideHome.toString())) == null || !Files.isDirectory(candidate = ideHome.getFileSystem().getPath(candidatePath, new String[0]), new LinkOption[0])) continue;
            return candidate.toAbsolutePath();
        }
        for (Path file2 : files2) {
            String selector;
            if (!Files.isRegularFile(file2, new LinkOption[0]) || (selector = ConfigImportHelper.getPropertyFromFile(file2, "idea.paths.selector")) == null || !Files.isDirectory(candidate = ideHome.getFileSystem().getPath(pathBySelector.apply(selector), new String[0]), new LinkOption[0])) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    private static String getPropertyFromFile(Path file2, String propertyName) {
        try {
            String propertyValue;
            String fileContent = new String(Files.readAllBytes(file2), StandardCharsets.UTF_8);
            String fileName = file2.getFileName().toString();
            if (fileName.endsWith(".properties")) {
                PropertyResourceBundle bundle = new PropertyResourceBundle(new StringReader(fileContent));
                return bundle.containsKey(propertyName) ? bundle.getString(propertyName) : null;
            }
            if (fileName.endsWith(".plist") && !StringUtil.isEmpty((String)(propertyValue = ConfigImportHelper.findPListKey(propertyName, fileContent)))) {
                return propertyValue;
            }
            propertyValue = ConfigImportHelper.findProperty(propertyName, fileContent);
            if (!StringUtil.isEmpty((String)propertyValue)) {
                return propertyValue;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static String findPListKey(String propertyName, String fileContent) {
        String key = "<key>" + propertyName + "</key>";
        int idx = fileContent.indexOf(key);
        if (idx > 0 && (idx = fileContent.indexOf("<string>", idx + key.length())) != -1) {
            return ConfigImportHelper.fixDirName(fileContent.substring(idx += "<string>".length(), fileContent.indexOf("</string>", idx)));
        }
        return null;
    }

    @Nullable
    private static String findProperty(String propertyName, String fileContent) {
        String prefix = propertyName + "=";
        int idx = fileContent.indexOf(prefix);
        if (idx >= 0) {
            StringBuilder configDir = new StringBuilder();
            if (fileContent.length() > (idx += prefix.length())) {
                boolean quoted;
                boolean bl = quoted = fileContent.charAt(idx) == '\"';
                if (quoted) {
                    ++idx;
                }
                while (fileContent.length() > idx && (quoted ? fileContent.charAt(idx) != '\"' : fileContent.charAt(idx) != ' ' && fileContent.charAt(idx) != '\t') && fileContent.charAt(idx) != '\n' && fileContent.charAt(idx) != '\r') {
                    configDir.append(fileContent.charAt(idx));
                    ++idx;
                }
            }
            if (configDir.length() > 0) {
                return Paths.get(ConfigImportHelper.fixDirName(configDir.toString()), new String[0]).toString();
            }
        }
        return null;
    }

    private static String fixDirName(String dir) {
        return FileUtil.expandUserHome((String)StringUtil.unquoteString((String)dir, (char)'\"'));
    }

    private static void doImport(@NotNull Path oldConfigDir, @NotNull Path newConfigDir, @Nullable Path oldIdeHome, @NotNull Logger log) {
        if (oldConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(20);
        }
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(21);
        }
        if (log == null) {
            ConfigImportHelper.$$$reportNull$$$0(22);
        }
        if (oldConfigDir.equals(newConfigDir)) {
            log.info("New config directory is the same as the old one, no import needed.");
            return;
        }
        Path oldPluginsDir = oldConfigDir.resolve(PLUGINS);
        if (!Files.isDirectory(oldPluginsDir, new LinkOption[0])) {
            oldPluginsDir = null;
            if (oldIdeHome != null) {
                oldPluginsDir = ConfigImportHelper.getSettingsPath(oldIdeHome, "idea.plugins.path", ConfigImportHelper::defaultPluginsPath);
            }
            if (oldPluginsDir == null && !Files.isDirectory(oldPluginsDir = oldConfigDir.getFileSystem().getPath(ConfigImportHelper.defaultPluginsPath(ConfigImportHelper.getNameWithVersion(oldConfigDir)), new String[0]), new LinkOption[0]) && oldPluginsDir.toString().contains("2020.1")) {
                oldPluginsDir = oldConfigDir.getFileSystem().getPath(ConfigImportHelper.defaultPluginsPath(ConfigImportHelper.getNameWithVersion(oldConfigDir).replace("2020.1", "2019.3")).replace("2019.3", "2020.1"), new String[0]);
            }
        }
        Path newPluginsDir = newConfigDir.getFileSystem().getPath(PathManager.getPluginsPath(), new String[0]);
        try {
            log.info(String.format("Importing configs: oldConfigDir=[%s], newConfigDir=[%s], oldIdeHome=[%s], oldPluginsDir=[%s], newPluginsDir=[%s]", oldConfigDir, newConfigDir, oldIdeHome, oldPluginsDir, newPluginsDir));
            ConfigImportHelper.doImport(oldConfigDir, newConfigDir, oldIdeHome, oldPluginsDir, newPluginsDir, new ConfigImportOptions(log));
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            String message = ApplicationBundle.message((String)"error.unable.to.import.settings", (Object[])new Object[]{e.getMessage()});
            Main.showMessage((String)ApplicationBundle.message((String)"title.settings.import.failed", (Object[])new Object[0]), (String)message, (boolean)false);
        }
    }

    static void doImport(@NotNull Path oldConfigDir, @NotNull Path newConfigDir, @Nullable Path oldIdeHome, @NotNull Path oldPluginsDir, @NotNull Path newPluginsDir, @NotNull ConfigImportOptions options2) throws IOException {
        if (oldConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(23);
        }
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(24);
        }
        if (oldPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(25);
        }
        if (newPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(26);
        }
        if (options2 == null) {
            ConfigImportHelper.$$$reportNull$$$0(27);
        }
        Logger log = options2.log;
        if (Files.isRegularFile(oldConfigDir, new LinkOption[0])) {
            new Decompressor.Zip(oldConfigDir.toFile()).extract(newConfigDir.toFile());
            return;
        }
        FileUtil.copyDir((File)oldConfigDir.toFile(), (File)newConfigDir.toFile(), file2 -> !ConfigImportHelper.blockImport(file2.toPath(), oldConfigDir, newConfigDir, oldPluginsDir));
        List<StartupActionScriptManager.ActionCommand> actionCommands = ConfigImportHelper.loadStartupActionScript(oldConfigDir, oldIdeHome, oldPluginsDir);
        if (!Files.isDirectory(oldPluginsDir, new LinkOption[0])) {
            log.info("non-existing plugins directory: " + oldPluginsDir);
        } else if (!ConfigImportHelper.isEmptyDirectory(newPluginsDir)) {
            log.info("non-empty plugins directory: " + newPluginsDir);
        } else {
            ConfigImportHelper.migratePlugins(oldPluginsDir, newPluginsDir, actionCommands, options2);
        }
        if (SystemInfo.isMac && (PlatformUtils.isIntelliJ() || "AndroidStudio".equals(PlatformUtils.getPlatformPrefix()))) {
            ConfigImportHelper.setKeymapIfNeeded(oldConfigDir, newConfigDir, log);
        }
        StartupActionScriptManager.executeActionScriptCommands(actionCommands, (File)oldPluginsDir.toFile(), (File)newPluginsDir.toFile());
        ConfigImportHelper.updateVMOptions(newConfigDir, log);
    }

    @NotNull
    private static List<StartupActionScriptManager.ActionCommand> loadStartupActionScript(@NotNull Path oldConfigDir, @Nullable Path oldIdeHome, @NotNull Path oldPluginsDir) throws IOException {
        if (oldConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(28);
        }
        if (oldPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(29);
        }
        if (Files.isDirectory(oldPluginsDir, new LinkOption[0])) {
            Path script;
            Path oldSystemDir = oldConfigDir.getParent().resolve(SYSTEM);
            if (!Files.isDirectory(oldSystemDir, new LinkOption[0])) {
                oldSystemDir = null;
                if (oldIdeHome != null) {
                    oldSystemDir = ConfigImportHelper.getSettingsPath(oldIdeHome, "idea.system.path", ConfigImportHelper::defaultSystemPath);
                }
                if (oldSystemDir == null) {
                    oldSystemDir = oldConfigDir.getFileSystem().getPath(ConfigImportHelper.defaultSystemPath(ConfigImportHelper.getNameWithVersion(oldConfigDir)), new String[0]);
                }
            }
            if (Files.isRegularFile(script = oldSystemDir.resolve("plugins/action.script"), new LinkOption[0])) {
                List list2 = StartupActionScriptManager.loadActionScript((Path)script);
                if (list2 == null) {
                    ConfigImportHelper.$$$reportNull$$$0(30);
                }
                return list2;
            }
        }
        List<StartupActionScriptManager.ActionCommand> list3 = Collections.emptyList();
        if (list3 == null) {
            ConfigImportHelper.$$$reportNull$$$0(31);
        }
        return list3;
    }

    private static void migratePlugins(@NotNull Path oldPluginsDir, @NotNull Path newPluginsDir, List<StartupActionScriptManager.ActionCommand> actionCommands, @NotNull ConfigImportOptions options2) throws IOException {
        if (oldPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(32);
        }
        if (newPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(33);
        }
        if (options2 == null) {
            ConfigImportHelper.$$$reportNull$$$0(34);
        }
        Logger log = options2.log;
        try {
            ArrayList<IdeaPluginDescriptorImpl> pluginsToMigrate = new ArrayList<IdeaPluginDescriptorImpl>();
            ArrayList<IdeaPluginDescriptorImpl> incompatiblePlugins = new ArrayList<IdeaPluginDescriptorImpl>();
            List<PluginId> pendingUpdates = ConfigImportHelper.collectPendingPluginUpdates(actionCommands, options2);
            PluginManagerCore.getDescriptorsToMigrate(oldPluginsDir, options2.compatibleBuildNumber, options2.bundledPluginPath, options2.brokenPluginVersions, pluginsToMigrate, incompatiblePlugins);
            ConfigImportHelper.migratePlugins(newPluginsDir, pluginsToMigrate, pendingUpdates, log);
            if (!incompatiblePlugins.isEmpty()) {
                if (options2.headless) {
                    ConfigImportHelper.downloadUpdatesForIncompatiblePlugins(newPluginsDir, options2, incompatiblePlugins, pendingUpdates, (ProgressIndicator)new EmptyProgressIndicator());
                } else {
                    ConfigImportProgressDialog dialog2 = new ConfigImportProgressDialog();
                    dialog2.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
                    AppUIUtil.updateWindowIcon(dialog2);
                    SplashManager.executeWithHiddenSplash(dialog2, () -> {
                        new Thread(() -> {
                            ConfigImportHelper.downloadUpdatesForIncompatiblePlugins(newPluginsDir, options2, incompatiblePlugins, pendingUpdates, dialog2.getIndicator());
                            SwingUtilities.invokeLater(() -> dialog2.setVisible(false));
                        }, "Plugin migration downloader").start();
                        dialog2.setVisible(true);
                    });
                }
                ConfigImportHelper.migratePlugins(newPluginsDir, incompatiblePlugins, pendingUpdates, log);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.info("Error loading list of plugins from old dir, migrating entire plugin directory");
            FileUtil.copyDir((File)oldPluginsDir.toFile(), (File)newPluginsDir.toFile());
        }
    }

    private static List<PluginId> collectPendingPluginUpdates(List<StartupActionScriptManager.ActionCommand> commands, @NotNull ConfigImportOptions options2) {
        if (options2 == null) {
            ConfigImportHelper.$$$reportNull$$$0(35);
        }
        ArrayList<PluginId> result2 = new ArrayList<PluginId>();
        for (StartupActionScriptManager.ActionCommand command : commands) {
            String source;
            if (command instanceof StartupActionScriptManager.CopyCommand) {
                source = ((StartupActionScriptManager.CopyCommand)command).getSource();
            } else {
                if (!(command instanceof StartupActionScriptManager.UnzipCommand)) continue;
                source = ((StartupActionScriptManager.UnzipCommand)command).getSource();
            }
            try {
                IdeaPluginDescriptorImpl descriptor2 = PluginDescriptorLoader.loadDescriptorFromArtifact(Paths.get(source, new String[0]), null);
                if (descriptor2 != null) {
                    result2.add(descriptor2.getPluginId());
                    continue;
                }
                options2.log.info("No plugin descriptor in pending update " + source);
            }
            catch (IOException e) {
                options2.log.info("Failed to load plugin descriptor from pending update " + source);
            }
        }
        return result2;
    }

    private static void migratePlugins(@NotNull Path newPluginsDir, List<IdeaPluginDescriptorImpl> pluginsToMigrate, List<PluginId> idsToSkip, Logger log) throws IOException {
        if (newPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(36);
        }
        for (IdeaPluginDescriptorImpl descriptor2 : pluginsToMigrate) {
            if (idsToSkip.contains(descriptor2.getPluginId())) {
                log.info("Skipping migration of plugin " + descriptor2.getPluginId() + " because there's a pending update for it");
                continue;
            }
            log.info("Migrating plugin " + descriptor2.getPluginId() + " version " + descriptor2.getVersion());
            File path = descriptor2.getPath();
            if (path.isDirectory()) {
                FileUtil.copyDir((File)path, (File)new File(newPluginsDir.toFile(), path.getName()));
                continue;
            }
            FileUtil.copy((File)path, (File)new File(newPluginsDir.toFile(), path.getName()));
        }
    }

    private static void downloadUpdatesForIncompatiblePlugins(@NotNull Path newPluginsDir, @NotNull ConfigImportOptions options2, List<IdeaPluginDescriptorImpl> incompatiblePlugins, List<PluginId> pendingUpdates, ProgressIndicator indicator) {
        if (newPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(37);
        }
        if (options2 == null) {
            ConfigImportHelper.$$$reportNull$$$0(38);
        }
        Logger log = options2.log;
        Iterator<IdeaPluginDescriptorImpl> iterator2 = incompatiblePlugins.iterator();
        while (iterator2.hasNext()) {
            IdeaPluginDescriptorImpl plugin = iterator2.next();
            if (pendingUpdates.contains(plugin.getPluginId())) {
                log.info("Skipping download of compatible version for plugin with pending update: " + plugin.getPluginId());
                iterator2.remove();
                continue;
            }
            try {
                PluginDownloader downloader = PluginDownloader.createDownloader(plugin);
                if (options2.marketplaceRequests != null) {
                    downloader.setMarketplaceRequests(options2.marketplaceRequests);
                }
                if (downloader.prepareToInstallAndLoadDescriptor(indicator, false) != null) {
                    PluginInstaller.unpackPlugin(downloader.getFile(), newPluginsDir.toFile().getPath());
                    log.info("Downloaded and unpacked compatible version of plugin " + plugin.getPluginId());
                    iterator2.remove();
                    continue;
                }
                if (!ConfigImportHelper.isBrokenPlugin(plugin, options2)) continue;
                iterator2.remove();
            }
            catch (ProcessCanceledException e) {
                log.info("Plugin download cancelled");
                break;
            }
            catch (IOException e) {
                log.info("Failed to download and install compatible version of " + plugin.getPluginId() + ": " + e.getMessage());
            }
        }
    }

    private static boolean isBrokenPlugin(IdeaPluginDescriptorImpl plugin, ConfigImportOptions options2) {
        Map<PluginId, Set<String>> versions = options2.brokenPluginVersions;
        if (versions != null) {
            return versions.get(plugin.getPluginId()).contains(plugin.getVersion());
        }
        return PluginManagerCore.isBrokenPlugin(plugin);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isEmptyDirectory(Path newPluginsDir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(newPluginsDir);){
            Path path;
            boolean hidden;
            Iterator<Path> iterator2 = stream.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                path = iterator2.next();
            } while (hidden = SystemInfo.isWindows ? Files.readAttributes(path, DosFileAttributes.class, new LinkOption[0]).isHidden() : path.getFileName().startsWith("."));
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    static void setKeymapIfNeeded(@NotNull Path oldConfigDir, @NotNull Path newConfigDir, @NotNull Logger log) {
        if (oldConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(39);
        }
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(40);
        }
        if (log == null) {
            ConfigImportHelper.$$$reportNull$$$0(41);
        }
        String nameWithVersion = ConfigImportHelper.getNameWithVersion(oldConfigDir);
        Matcher m = Pattern.compile("\\.?[^\\d]+(\\d+\\.\\d+)?").matcher(nameWithVersion);
        if (!m.matches() || VersionComparatorUtil.compare((String)"2019.1", (String)m.group(1)) < 0) {
            return;
        }
        Path keymapOptionFile = newConfigDir.resolve("options/keymap.xml");
        if (Files.exists(keymapOptionFile, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(keymapOptionFile.getParent(), new FileAttribute[0]);
            Files.write(keymapOptionFile, "<application>\n  <component name=\"KeymapManager\">\n    <active_keymap name=\"Mac OS X\" />\n  </component>\n</application>".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            log.error("Cannot set keymap", (Throwable)e);
        }
    }

    private static void updateVMOptions(Path newConfigDir, Logger log) {
        Path vmOptionsFile = newConfigDir.resolve(VMOptions.getCustomVMOptionsFileName());
        if (Files.exists(vmOptionsFile, new LinkOption[0])) {
            try {
                List<String> lines = Files.readAllLines(vmOptionsFile);
                boolean updated = false;
                ListIterator<String> i2 = lines.listIterator();
                while (i2.hasNext()) {
                    String line = i2.next().trim();
                    if (line.equals("-XX:MaxJavaStackTraceDepth=-1")) {
                        i2.set("-XX:MaxJavaStackTraceDepth=10000");
                        updated = true;
                        continue;
                    }
                    if (!line.startsWith("-agentlib:yjpagent") && !"-Xverify:none".equals(line) && !"-noverify".equals(line)) continue;
                    i2.remove();
                    updated = true;
                }
                if (updated) {
                    Files.write(vmOptionsFile, lines, new OpenOption[0]);
                }
            }
            catch (IOException e) {
                log.warn("Failed to update custom VM options file " + vmOptionsFile, (Throwable)e);
            }
        }
    }

    private static boolean blockImport(Path path, Path oldConfig, Path newConfig, Path oldPluginsDir) {
        if (oldConfig.equals(path.getParent())) {
            String name = path.getFileName().toString();
            return "user.web.token".equals(name) || name.startsWith("chrome-user-data") || Files.exists(newConfig.resolve(path.getFileName()), new LinkOption[0]) || path.startsWith(oldPluginsDir);
        }
        return false;
    }

    private static String defaultConfigPath(String selector) {
        return ConfigImportHelper.newOrUnknown(selector) ? PathManager.getDefaultConfigPathFor((String)selector) : (SystemInfo.isMac ? SystemProperties.getUserHome() + "/Library/Preferences/" + selector : SystemProperties.getUserHome() + "/." + selector + '/' + CONFIG);
    }

    private static String defaultPluginsPath(String selector) {
        return ConfigImportHelper.newOrUnknown(selector) ? PathManager.getDefaultPluginPathFor((String)selector) : (SystemInfo.isMac ? SystemProperties.getUserHome() + "/Library/Application Support/" + selector : SystemProperties.getUserHome() + "/." + selector + '/' + CONFIG + '/' + PLUGINS);
    }

    private static String defaultSystemPath(String selector) {
        return ConfigImportHelper.newOrUnknown(selector) ? PathManager.getDefaultSystemPathFor((String)selector) : (SystemInfo.isMac ? SystemProperties.getUserHome() + "/Library/Caches/" + selector : SystemProperties.getUserHome() + "/." + selector + '/' + SYSTEM);
    }

    private static boolean newOrUnknown(String selector) {
        Matcher m = SELECTOR_PATTERN.matcher(selector);
        return !m.matches() || "2020.1".compareTo(m.group(2)) <= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfigDir";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: 
            case 22: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDir";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentConfig";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/ConfigImportHelper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backupToMove";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guessedOldConfigDirs";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 20: 
            case 23: 
            case 28: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldConfigDir";
                break;
            }
            case 25: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPluginsDir";
                break;
            }
            case 26: 
            case 33: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPluginsDir";
                break;
            }
            case 27: 
            case 34: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/ConfigImportHelper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "backupCurrentConfigToTempAndDelete";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackupPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDirName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigDirectories";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "loadStartupActionScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importConfigsTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConfigOld";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doesVmOptionFileExist";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "backupCurrentConfigToTempAndDelete";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 30: 
            case 31: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deleteCurrentConfigDir";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveTempBackupToStandardBackup";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndGetOldConfigPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSettingsFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isValidSettingsFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isConfigDirectory";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findConfigDirectories";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doImport";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "loadStartupActionScript";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "migratePlugins";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "collectPendingPluginUpdates";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "downloadUpdatesForIncompatiblePlugins";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setKeymapIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ConfigImportOptions {
        final Logger log;
        boolean headless;
        BuildNumber compatibleBuildNumber = null;
        MarketplaceRequests marketplaceRequests = null;
        Path bundledPluginPath = null;
        Map<PluginId, Set<String>> brokenPluginVersions = null;

        ConfigImportOptions(Logger log) {
            this.log = log;
        }
    }

    static class PathAndFileTime {
        final Path path;
        final FileTime fileTime;

        PathAndFileTime(@NotNull Path path, @NotNull FileTime fileTime) {
            if (path == null) {
                PathAndFileTime.$$$reportNull$$$0(0);
            }
            if (fileTime == null) {
                PathAndFileTime.$$$reportNull$$$0(1);
            }
            this.path = path;
            this.fileTime = fileTime;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileTime";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/application/ConfigImportHelper$PathAndFileTime";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

