/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.search.impl;

import com.intellij.lang.Language;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.model.psi.PsiSymbolReferenceProviderBean;
import com.intellij.model.psi.impl.ReferenceProviders;
import com.intellij.model.search.CodeReferenceSearcher;
import com.intellij.model.search.LeafOccurrenceMapper;
import com.intellij.model.search.PsiSymbolReferenceSearchParameters;
import com.intellij.model.search.PsiSymbolReferenceSearcher;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchRequest;
import com.intellij.model.search.SearchService;
import com.intellij.model.search.SearchWordQueryBuilder;
import com.intellij.model.search.impl.CodeReferenceMapper;
import com.intellij.model.search.impl.ExternalReferenceMapper;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/model/search/impl/DefaultReferenceSearcher;", "Lcom/intellij/model/search/PsiSymbolReferenceSearcher;", "()V", "collectSearchRequests", "", "Lcom/intellij/util/Query;", "Lcom/intellij/model/psi/PsiSymbolReference;", "parameters", "Lcom/intellij/model/search/PsiSymbolReferenceSearchParameters;", "intellij.platform.indexing.impl"})
public final class DefaultReferenceSearcher
implements PsiSymbolReferenceSearcher {
    @NotNull
    public Collection<Query<? extends PsiSymbolReference>> collectSearchRequests(@NotNull PsiSymbolReferenceSearchParameters parameters2) {
        Intrinsics.checkParameterIsNotNull((Object)parameters2, (String)"parameters");
        Project project = parameters2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"parameters.project");
        Project project2 = project;
        SearchScope searchScope = parameters2.getSearchScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)searchScope, (String)"parameters.searchScope");
        SearchScope inputScope = searchScope;
        Symbol symbol = parameters2.getSymbol();
        Intrinsics.checkExpressionValueIsNotNull((Object)symbol, (String)"parameters.symbol");
        Symbol target2 = symbol;
        Pointer pointer = target2.createPointer();
        Intrinsics.checkExpressionValueIsNotNull((Object)pointer, (String)"target.createPointer()");
        Pointer targetPointer = pointer;
        SearchService searchService = SearchService.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)searchService, (String)"SearchService.getInstance()");
        SearchService service = searchService;
        boolean bl = false;
        List result2 = new ArrayList();
        ExtensionPointName extensionPointName = CodeReferenceSearcher.EP_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"CodeReferenceSearcher.EP_NAME");
        for (CodeReferenceSearcher searcher : extensionPointName.getExtensionList()) {
            Language language;
            SearchWordQueryBuilder builder2;
            SearchScope searchScope2;
            SearchScope searchScope3;
            SearchRequest request2;
            if (searcher.getSearchRequest(project2, target2) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)searcher.getReferencingLanguage(), (String)"searcher.referencingLanguage");
            SearchScope searchScope4 = request2.getSearchScope();
            if (searchScope4 == null || (searchScope4 = searchScope4.intersectWith(inputScope)) == null) {
                searchScope4 = searchScope3 = inputScope;
            }
            if ((searchScope2 = request2.getInjectionSearchScope()) == null || (searchScope2 = searchScope2.intersectWith(inputScope)) == null) {
                searchScope2 = inputScope;
            }
            SearchScope injectionSearchScope = searchScope2;
            LeafOccurrenceMapper mapper = new CodeReferenceMapper((Pointer<? extends Symbol>)targetPointer, searcher);
            Intrinsics.checkExpressionValueIsNotNull((Object)service.searchWord(project2, request2.getSearchString()), (String)"service.searchWord(project, request.searchString)");
            Collection collection = result2;
            Query query = builder2.inContexts(SearchContext.IN_CODE, new SearchContext[0]).inScope(searchScope3).inFilesWithLanguage(language).buildQuery(mapper);
            boolean bl2 = false;
            collection.add(query);
            collection = result2;
            query = builder2.inContexts(SearchContext.IN_CODE_HOSTS, new SearchContext[0]).inScope(injectionSearchScope).inInjections(language).buildQuery(mapper);
            bl2 = false;
            collection.add(query);
        }
        ExternalReferenceMapper mapper = new ExternalReferenceMapper((Pointer<? extends Symbol>)targetPointer);
        for (PsiSymbolReferenceProviderBean providerBean : ReferenceProviders.byTargetClass(target2.getClass())) {
            Collection requests;
            Intrinsics.checkExpressionValueIsNotNull((Object)((PsiSymbolReferenceProvider)providerBean.getInstance()).getSearchRequests(project2, target2), (String)"providerBean.instance.ge\u2026Requests(project, target)");
            for (SearchRequest request3 : requests) {
                Language language;
                SearchWordQueryBuilder builder3;
                SearchScope searchScope5;
                SearchScope searchScope6;
                Intrinsics.checkExpressionValueIsNotNull((Object)providerBean.getHostLanguage(), (String)"providerBean.getHostLanguage()");
                SearchScope searchScope7 = request3.getSearchScope();
                if (searchScope7 == null || (searchScope7 = searchScope7.intersectWith(inputScope)) == null) {
                    searchScope7 = searchScope6 = inputScope;
                }
                if ((searchScope5 = request3.getInjectionSearchScope()) == null || (searchScope5 = searchScope5.intersectWith(inputScope)) == null) {
                    searchScope5 = inputScope;
                }
                SearchScope injectionSearchScope = searchScope5;
                Intrinsics.checkExpressionValueIsNotNull((Object)service.searchWord(project2, request3.getSearchString()).inContexts(SearchContext.IN_CODE_HOSTS, new SearchContext[0]), (String)"service.searchWord(proje\u2026inContexts(IN_CODE_HOSTS)");
                Collection collection = result2;
                Query query = builder3.inScope(searchScope6).inFilesWithLanguage(language).buildQuery((LeafOccurrenceMapper)mapper);
                boolean bl3 = false;
                collection.add(query);
                collection = result2;
                query = builder3.inScope(injectionSearchScope).inInjections(language).buildQuery((LeafOccurrenceMapper)mapper);
                bl3 = false;
                collection.add(query);
            }
        }
        return result2;
    }
}

