/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.cachedValueProfiler;

import com.google.gson.stream.JsonReader;
import com.intellij.internal.cachedValueProfiler.CVPInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CVPReader {
    @NotNull
    private final JsonReader myReader;

    private CVPReader(@NotNull JsonReader reader) {
        if (reader == null) {
            CVPReader.$$$reportNull$$$0(0);
        }
        this.myReader = reader;
    }

    @NotNull
    public static List<CVPInfo> deserialize(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            CVPReader.$$$reportNull$$$0(1);
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
        List<CVPInfo> list2 = new CVPReader(reader).read();
        List<CVPInfo> list3 = list2;
        if (list3 == null) {
            CVPReader.$$$reportNull$$$0(2);
        }
        return list3;
        finally {
            reader.close();
        }
    }

    @NotNull
    private List<CVPInfo> read() throws IOException {
        ArrayList<CVPInfo> list2 = new ArrayList<CVPInfo>();
        this.myReader.beginArray();
        while (this.myReader.hasNext()) {
            list2.add(this.readInfo());
        }
        this.myReader.endArray();
        ArrayList<CVPInfo> arrayList = list2;
        if (arrayList == null) {
            CVPReader.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private CVPInfo readInfo() throws IOException {
        String origin = null;
        long totalLifeTime = 0L;
        long totalUseCount = 0L;
        long createdCount = 0L;
        this.myReader.beginObject();
        while (this.myReader.hasNext()) {
            String name = this.myReader.nextName();
            if ("origin".equals(name)) {
                origin = this.myReader.nextString();
                continue;
            }
            if ("total lifetime".equals(name)) {
                totalLifeTime = this.myReader.nextLong();
                continue;
            }
            if ("total use count".equals(name)) {
                totalUseCount = this.myReader.nextLong();
                continue;
            }
            if (!"created".equals(name)) continue;
            createdCount = this.myReader.nextLong();
        }
        this.myReader.endObject();
        return new CVPInfo(origin, totalLifeTime, totalUseCount, createdCount);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/cachedValueProfiler/CVPReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/cachedValueProfiler/CVPReader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

