/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView.nodes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class BasePsiNode<T extends PsiElement>
extends PackageDependenciesNode {
    private final SmartPsiElementPointer myPsiElementPointer;
    private Icon myIcon;

    public BasePsiNode(T element2) {
        super(element2.getProject());
        this.myPsiElementPointer = element2.isValid() ? SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(element2) : null;
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        if (this.myPsiElementPointer == null) {
            return null;
        }
        PsiElement element2 = this.myPsiElementPointer.getElement();
        return element2 != null && element2.isValid() ? element2 : null;
    }

    @Override
    public Icon getIcon() {
        PsiElement element2 = this.getPsiElement();
        if (this.myIcon == null) {
            this.myIcon = element2 != null && element2.isValid() ? element2.getIcon(3) : null;
        }
        return this.myIcon;
    }

    @Override
    @Nullable
    public Color getColor() {
        if (this.myColor == null && this.getContainingFile() != null) {
            this.myColor = FileStatusManager.getInstance((Project)this.myProject).getStatus(this.myPsiElementPointer.getVirtualFile()).getColor();
            if (this.myColor == null) {
                this.myColor = NOT_CHANGED;
            }
        }
        return this.myColor == NOT_CHANGED ? null : this.myColor;
    }

    @Override
    public int getWeight() {
        return 4;
    }

    @Override
    public int getContainingFiles() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this.isEquals()) {
            return super.equals(o);
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasePsiNode)) {
            return false;
        }
        BasePsiNode methodNode = (BasePsiNode)o;
        return Comparing.equal((Object)this.getPsiElement(), (Object)methodNode.getPsiElement());
    }

    public int hashCode() {
        PsiElement psiElement = this.getPsiElement();
        return psiElement == null ? 0 : psiElement.hashCode();
    }

    public PsiFile getContainingFile() {
        return this.myPsiElementPointer.getContainingFile();
    }

    @Override
    public boolean isValid() {
        PsiElement element2 = this.getPsiElement();
        return element2 != null && element2.isValid();
    }

    public boolean isDeprecated() {
        return false;
    }
}

