/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.ide.lightEdit.LightEditPanel;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.LightEditorManager;
import com.intellij.ide.lightEdit.menuBar.LightEditMenuBar;
import com.intellij.ide.lightEdit.statusBar.LightEditAutosaveWidget;
import com.intellij.ide.lightEdit.statusBar.LightEditEncodingWidgetWrapper;
import com.intellij.ide.lightEdit.statusBar.LightEditLineSeparatorWidgetWrapper;
import com.intellij.ide.lightEdit.statusBar.LightEditPositionWidget;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectFrameAllocatorKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.LightEditFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.CloseProjectWindowHelper;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.PopupHandler;
import java.awt.Component;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LightEditFrameWrapper
extends ProjectFrameHelper
implements Disposable,
LightEditFrame {
    private final BooleanSupplier myCloseHandler;
    private LightEditPanel myEditPanel;

    LightEditFrameWrapper(@NotNull IdeFrameImpl frame, @NotNull BooleanSupplier closeHandler) {
        if (frame == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(0);
        }
        if (closeHandler == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(1);
        }
        super(frame, null);
        this.myCloseHandler = closeHandler;
    }

    @NotNull
    LightEditPanel getLightEditPanel() {
        LightEditPanel lightEditPanel = this.myEditPanel;
        if (lightEditPanel == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(2);
        }
        return lightEditPanel;
    }

    @Override
    @NotNull
    protected IdeRootPane createIdeRootPane() {
        return new LightEditRootPane(this.getFrame(), this, this);
    }

    @Override
    protected void installDefaultProjectStatusBarWidgets(@NotNull Project project) {
        if (project == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(3);
        }
        LightEditorManager editorManager = LightEditService.getInstance().getEditorManager();
        IdeStatusBarImpl statusBar = Objects.requireNonNull(this.getStatusBar());
        statusBar.addWidget((StatusBarWidget)new LightEditPositionWidget(editorManager), StatusBar.Anchors.before((String)"FatalError"), this);
        statusBar.addWidget((StatusBarWidget)new LightEditAutosaveWidget(editorManager), StatusBar.Anchors.before((String)"FatalError"), this);
        statusBar.addWidget((StatusBarWidget)new LightEditEncodingWidgetWrapper(), StatusBar.Anchors.after((String)"Position"), this);
        statusBar.addWidget((StatusBarWidget)new LightEditLineSeparatorWidgetWrapper(), StatusBar.Anchors.before((String)"light.edit.encoding.widget"), this);
        PopupHandler.installPopupHandler((JComponent)statusBar, (String)"ViewStatusBarWidgetsGroup", (String)"StatusBarPlace");
        ApplicationManager.getApplication().invokeLater(() -> project.getService(StatusBarWidgetsManager.class));
    }

    @Override
    protected void initTitleInfoProviders(@NotNull Project project) {
        if (project == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(4);
        }
    }

    @Override
    @NotNull
    protected CloseProjectWindowHelper createCloseProjectWindowHelper() {
        return new CloseProjectWindowHelper(){

            @Override
            public void windowClosing(@Nullable Project project) {
                if (LightEditFrameWrapper.this.myCloseHandler.getAsBoolean()) {
                    super.windowClosing(project);
                }
            }
        };
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.myEditPanel);
    }

    @NotNull
    static LightEditFrameWrapper allocate(@NotNull BooleanSupplier closeHandler) {
        if (closeHandler == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(5);
        }
        LightEditFrameWrapper lightEditFrameWrapper = (LightEditFrameWrapper)((WindowManagerImpl)WindowManager.getInstance()).allocateFrame(LightEditUtil.getProject(), () -> new LightEditFrameWrapper(ProjectFrameAllocatorKt.createNewProjectFrame(false), closeHandler));
        if (lightEditFrameWrapper == null) {
            LightEditFrameWrapper.$$$reportNull$$$0(6);
        }
        return lightEditFrameWrapper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeHandler";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/LightEditFrameWrapper";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/LightEditFrameWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLightEditPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "allocate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installDefaultProjectStatusBarWidgets";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initTitleInfoProviders";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "allocate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LightEditRootPane
    extends IdeRootPane {
        LightEditRootPane(@NotNull JFrame frame, @NotNull IdeFrame frameHelper, Disposable parentDisposable) {
            if (frame == null) {
                LightEditRootPane.$$$reportNull$$$0(0);
            }
            if (frameHelper == null) {
                LightEditRootPane.$$$reportNull$$$0(1);
            }
            if (parentDisposable == null) {
                LightEditRootPane.$$$reportNull$$$0(2);
            }
            super(frame, frameHelper, parentDisposable);
        }

        @Override
        @NotNull
        protected Component getCenterComponent(@NotNull JFrame frame, @NotNull Disposable parentDisposable) {
            if (frame == null) {
                LightEditRootPane.$$$reportNull$$$0(3);
            }
            if (parentDisposable == null) {
                LightEditRootPane.$$$reportNull$$$0(4);
            }
            LightEditFrameWrapper.this.myEditPanel = new LightEditPanel();
            LightEditPanel lightEditPanel = LightEditFrameWrapper.this.myEditPanel;
            if (lightEditPanel == null) {
                LightEditRootPane.$$$reportNull$$$0(5);
            }
            return lightEditPanel;
        }

        @Override
        @NotNull
        public ToolWindowsPane getToolWindowPane() {
            throw new IllegalStateException("Tool windows are unavailable in LightEdit");
        }

        @Override
        @NotNull
        protected IdeMenuBar createMenuBar() {
            return new LightEditMenuBar();
        }

        @Override
        @NotNull
        protected IdeStatusBarImpl createStatusBar(@NotNull IdeFrame frame) {
            if (frame == null) {
                LightEditRootPane.$$$reportNull$$$0(6);
            }
            return new IdeStatusBarImpl(frame, false);
        }

        @Override
        protected void updateNorthComponents() {
        }

        @Override
        protected void installNorthComponents(@NotNull Project project) {
            if (project == null) {
                LightEditRootPane.$$$reportNull$$$0(7);
            }
        }

        @Override
        protected void deinstallNorthComponents() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frameHelper";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/lightEdit/LightEditFrameWrapper$LightEditRootPane";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/lightEdit/LightEditFrameWrapper$LightEditRootPane";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCenterComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getCenterComponent";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createStatusBar";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "installNorthComponents";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

