/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectInTargetPsiWrapper
implements SelectInTarget {
    protected final Project myProject;

    protected SelectInTargetPsiWrapper(@NotNull Project project) {
        if (project == null) {
            SelectInTargetPsiWrapper.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public abstract String toString();

    protected abstract boolean canSelect(PsiFileSystemItem var1);

    public final boolean canSelect(@NotNull SelectInContext context) {
        if (context == null) {
            SelectInTargetPsiWrapper.$$$reportNull$$$0(1);
        }
        if (!this.isContextValid(context)) {
            return false;
        }
        return this.canSelectInner(context);
    }

    protected boolean canSelectInner(@NotNull SelectInContext context) {
        PsiFileSystemItem psiFile;
        if (context == null) {
            SelectInTargetPsiWrapper.$$$reportNull$$$0(2);
        }
        return (psiFile = this.getContextPsiFile(context)) != null && this.canSelect(psiFile);
    }

    private boolean isContextValid(SelectInContext context) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        VirtualFile virtualFile = context.getVirtualFile();
        return virtualFile.isValid();
    }

    @Nullable
    protected PsiFileSystemItem getContextPsiFile(@NotNull SelectInContext context) {
        if (context == null) {
            SelectInTargetPsiWrapper.$$$reportNull$$$0(3);
        }
        VirtualFile virtualFile = context.getVirtualFile();
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
        if (psiFile != null) {
            return psiFile;
        }
        if (context.getSelectorInFile() instanceof PsiFile) {
            return (PsiFile)context.getSelectorInFile();
        }
        if (virtualFile.isDirectory()) {
            return PsiManager.getInstance((Project)this.myProject).findDirectory(virtualFile);
        }
        return null;
    }

    public final void selectIn(@NotNull SelectInContext context, boolean requestFocus) {
        if (context == null) {
            SelectInTargetPsiWrapper.$$$reportNull$$$0(4);
        }
        VirtualFile file2 = context.getVirtualFile();
        Object selector = context.getSelectorInFile();
        if (selector == null) {
            selector = PsiUtilCore.findFileSystemItem((Project)this.myProject, (VirtualFile)file2);
        }
        if (selector instanceof PsiElement) {
            PsiUtilCore.ensureValid((PsiElement)((PsiElement)selector));
            PsiElement original = ((PsiElement)selector).getOriginalElement();
            if (original != null && !original.isValid()) {
                throw new PsiInvalidElementAccessException(original, "Returned by " + selector + " of " + selector.getClass());
            }
            this.select(original, requestFocus);
        } else {
            this.select(selector, file2, requestFocus);
        }
    }

    protected abstract void select(Object var1, VirtualFile var2, boolean var3);

    @Deprecated
    protected boolean canWorkWithCustomObjects() {
        return false;
    }

    protected abstract void select(PsiElement var1, boolean var2);

    @Nullable
    protected static PsiElement findElementToSelect(PsiElement element2, PsiElement candidate) {
        PsiElement toSelect2 = candidate;
        if (toSelect2 == null) {
            if (element2 instanceof PsiFile || element2 instanceof PsiDirectory) {
                toSelect2 = element2;
            } else {
                PsiFile containingFile = element2.getContainingFile();
                if (containingFile != null) {
                    FileViewProvider viewProvider = containingFile.getViewProvider();
                    toSelect2 = viewProvider.getPsi(viewProvider.getBaseLanguage());
                }
            }
        }
        if (toSelect2 != null) {
            PsiElement originalElement = null;
            try {
                originalElement = toSelect2.getOriginalElement();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (originalElement != null) {
                toSelect2 = originalElement;
            }
        }
        return toSelect2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/impl/SelectInTargetPsiWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelectInner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextPsiFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "selectIn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

