/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeLoadingProgressAware;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class InspectionViewNavigationPanel
extends JPanel
implements InspectionTreeLoadingProgressAware {
    private final InspectionTreeNode myNode;
    private final InspectionTree myTree;
    private final JPanel myLinks;
    private int myShownChildrenCount;

    public InspectionViewNavigationPanel(InspectionTreeNode node, InspectionTree tree) {
        this.myNode = node;
        this.myTree = tree;
        this.setLayout(new BorderLayout());
        this.setBorder((Border)JBUI.Borders.empty((int)18, (int)12, (int)0, (int)0));
        String titleLabelText = InspectionViewNavigationPanel.getTitleText(true);
        this.add((Component)new JBLabel(titleLabelText), "North");
        this.myLinks = new JPanel();
        this.myLinks.setLayout(new BoxLayout(this.myLinks, 1));
        this.add("Center", this.myLinks);
        this.resetChildrenNavigation();
    }

    @Override
    public void updateLoadingProgress() {
        this.resetChildrenAndRepaint();
    }

    @Override
    public void treeLoaded() {
        this.resetChildrenAndRepaint();
    }

    @NotNull
    @Nls
    public static String getTitleText(boolean addColon) {
        if (addColon) {
            String string = InspectionsBundle.message((String)"inspections.view.select.inspection.label", (Object[])new Object[0]);
            if (string == null) {
                InspectionViewNavigationPanel.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionsBundle.message((String)"inspections.view.nothing.message", (Object[])new Object[0]);
        if (string == null) {
            InspectionViewNavigationPanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    private void resetChildrenNavigation() {
        int currentChildrenCount = this.myNode.getChildCount();
        if (this.myShownChildrenCount != currentChildrenCount) {
            this.myLinks.removeAll();
            this.myLinks.add(Box.createVerticalStrut(JBUIScale.scale((int)10)));
            for (int i2 = 0; i2 < currentChildrenCount; ++i2) {
                final InspectionTreeNode child2 = this.myNode.getChildAt(i2);
                LinkLabel link = new LinkLabel(child2.getPresentableText(), null){

                    public void doClick() {
                        InspectionViewNavigationPanel.this.myTree.selectNode(child2);
                    }
                };
                link.setBorder((Border)JBUI.Borders.empty((int)1, (int)17, (int)3, (int)1));
                this.myLinks.add((Component)link);
            }
            this.myShownChildrenCount = currentChildrenCount;
        }
    }

    private void resetChildrenAndRepaint() {
        this.resetChildrenNavigation();
        this.revalidate();
        this.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionViewNavigationPanel", "getTitleText"));
    }
}

