/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.application.options.colors.ColorAndFontDescriptionPanel;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.InspectionColorSettingsPage;
import com.intellij.application.options.colors.TextAttributesDescription;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.SeverityUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.ide.DataManager;
import com.intellij.lang.LangBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.LightColors;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBList;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeverityEditorDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(SeverityEditorDialog.class);
    private final JPanel myPanel;
    private final JList<SeverityRegistrar.SeverityBasedTextAttributes> myOptionsList;
    private final ColorAndFontDescriptionPanel myOptionsPanel;
    private SeverityRegistrar.SeverityBasedTextAttributes myCurrentSelection;
    private final SeverityRegistrar mySeverityRegistrar;
    private final boolean myCloseDialogWhenSettingsShown;
    private final CardLayout myCard;
    private final JPanel myRightPanel;
    @NonNls
    private static final String DEFAULT = "DEFAULT";
    @NonNls
    private static final String EDITABLE = "EDITABLE";

    public static void show(@NotNull Project project, @Nullable HighlightSeverity selectedSeverity, @NotNull SeverityRegistrar severityRegistrar, boolean closeDialogWhenSettingsShown, @Nullable Consumer<? super HighlightSeverity> chosenSeverityCallback) {
        HighlightInfoType type;
        SeverityEditorDialog dialog2;
        if (project == null) {
            SeverityEditorDialog.$$$reportNull$$$0(0);
        }
        if (severityRegistrar == null) {
            SeverityEditorDialog.$$$reportNull$$$0(1);
        }
        if ((dialog2 = new SeverityEditorDialog(project, selectedSeverity, severityRegistrar, closeDialogWhenSettingsShown)).showAndGet() && (type = dialog2.getSelectedType()) != null) {
            HighlightSeverity severity = type.getSeverity(null);
            if (chosenSeverityCallback != null) {
                chosenSeverityCallback.consume((Object)severity);
            }
        }
    }

    private SeverityEditorDialog(@NotNull Project project, @Nullable HighlightSeverity selectedSeverity, @NotNull SeverityRegistrar severityRegistrar, boolean closeDialogWhenSettingsShown) {
        if (project == null) {
            SeverityEditorDialog.$$$reportNull$$$0(2);
        }
        if (severityRegistrar == null) {
            SeverityEditorDialog.$$$reportNull$$$0(3);
        }
        super(project, true);
        this.myOptionsList = new JBList();
        this.myOptionsPanel = new ColorAndFontDescriptionPanel();
        this.mySeverityRegistrar = severityRegistrar;
        this.myCloseDialogWhenSettingsShown = closeDialogWhenSettingsShown;
        this.myOptionsList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
                this.setText(SingleInspectionProfilePanel.renderSeverity(((SeverityRegistrar.SeverityBasedTextAttributes)value2).getSeverity()));
                return rendererComponent;
            }
        });
        this.myOptionsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SeverityEditorDialog.this.myCurrentSelection != null) {
                    SeverityEditorDialog.this.apply(SeverityEditorDialog.this.myCurrentSelection);
                }
                SeverityEditorDialog.this.myCurrentSelection = (SeverityRegistrar.SeverityBasedTextAttributes)SeverityEditorDialog.this.myOptionsList.getSelectedValue();
                if (SeverityEditorDialog.this.myCurrentSelection != null) {
                    SeverityEditorDialog.this.reset(SeverityEditorDialog.this.myCurrentSelection);
                    SeverityEditorDialog.this.myCard.show(SeverityEditorDialog.this.myRightPanel, SeverityRegistrar.isDefaultSeverity(SeverityEditorDialog.this.myCurrentSelection.getSeverity()) ? SeverityEditorDialog.DEFAULT : SeverityEditorDialog.EDITABLE);
                }
            }
        });
        TreeUIHelper.getInstance().installListSpeedSearch(this.myOptionsList, attrs -> attrs.getSeverity().getName());
        this.myOptionsList.setSelectionMode(0);
        JPanel leftPanel = ToolbarDecorator.createDecorator(this.myOptionsList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                String name = Messages.showInputDialog((Component)SeverityEditorDialog.this.myPanel, (String)InspectionsBundle.message((String)"highlight.severity.create.dialog.name.label", (Object[])new Object[0]), (String)InspectionsBundle.message((String)"highlight.severity.create.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        return SeverityEditorDialog.this.checkNameExist(inputString);
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                if (name == null) {
                    return;
                }
                SeverityRegistrar.SeverityBasedTextAttributes newSeverityBasedTextAttributes = SeverityEditorDialog.this.createSeverity(name, CodeInsightColors.WARNINGS_ATTRIBUTES.getDefaultAttributes());
                ((DefaultListModel)SeverityEditorDialog.this.myOptionsList.getModel()).addElement(newSeverityBasedTextAttributes);
                SeverityEditorDialog.this.select(newSeverityBasedTextAttributes);
            }
        }).setMoveUpAction(button2 -> {
            this.apply(this.myCurrentSelection);
            ListUtil.moveSelectedItemsUp(this.myOptionsList);
        }).setMoveDownAction(button2 -> {
            this.apply(this.myCurrentSelection);
            ListUtil.moveSelectedItemsDown(this.myOptionsList);
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                String oldName = SeverityEditorDialog.this.myCurrentSelection.getSeverity().getName();
                String newName = Messages.showInputDialog((Component)SeverityEditorDialog.this.myPanel, (String)InspectionsBundle.message((String)"highlight.severity.create.dialog.name.label", (Object[])new Object[0]), (String)InspectionsBundle.message((String)"highlight.severity.create.dialog.title", (Object[])new Object[0]), null, (String)oldName, (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        return SeverityEditorDialog.this.checkNameExist(inputString);
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                if (newName != null && !oldName.equals(newName)) {
                    SeverityRegistrar.SeverityBasedTextAttributes newSeverityBasedTextAttributes = SeverityEditorDialog.this.createSeverity(newName, SeverityEditorDialog.this.myCurrentSelection.getAttributes());
                    int index = SeverityEditorDialog.this.myOptionsList.getSelectedIndex();
                    ((DefaultListModel)SeverityEditorDialog.this.myOptionsList.getModel()).set(index, newSeverityBasedTextAttributes);
                    SeverityEditorDialog.this.select(newSeverityBasedTextAttributes);
                }
            }
        }).setEditActionUpdater(e -> this.myCurrentSelection != null && !SeverityRegistrar.isDefaultSeverity(this.myCurrentSelection.getSeverity())).setEditActionName(LangBundle.message((String)"action.rename.text", (Object[])new Object[0])).createPanel();
        ToolbarDecorator.findRemoveButton((JComponent)leftPanel).addCustomUpdater(e -> !SeverityRegistrar.isDefaultSeverity(this.myOptionsList.getSelectedValue().getSeverity()));
        ToolbarDecorator.findUpButton((JComponent)leftPanel).addCustomUpdater(e -> {
            SeverityRegistrar.SeverityBasedTextAttributes pair;
            boolean canMove = ListUtil.canMoveSelectedItemsUp(this.myOptionsList);
            if (canMove && (pair = this.myOptionsList.getSelectedValue()) != null && SeverityRegistrar.isDefaultSeverity(pair.getSeverity())) {
                int newPosition = this.myOptionsList.getSelectedIndex() - 1;
                pair = this.myOptionsList.getModel().getElementAt(newPosition);
                if (SeverityRegistrar.isDefaultSeverity(pair.getSeverity())) {
                    canMove = false;
                }
            }
            return canMove;
        });
        ToolbarDecorator.findDownButton((JComponent)leftPanel).addCustomUpdater(e -> {
            SeverityRegistrar.SeverityBasedTextAttributes pair;
            boolean canMove = ListUtil.canMoveSelectedItemsDown(this.myOptionsList);
            if (canMove && (pair = this.myOptionsList.getSelectedValue()) != null && SeverityRegistrar.isDefaultSeverity(pair.getSeverity())) {
                int newPosition = this.myOptionsList.getSelectedIndex() + 1;
                pair = this.myOptionsList.getModel().getElementAt(newPosition);
                if (SeverityRegistrar.isDefaultSeverity(pair.getSeverity())) {
                    canMove = false;
                }
            }
            return canMove;
        });
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)leftPanel, "Center");
        this.myCard = new CardLayout();
        this.myRightPanel = new JPanel(this.myCard);
        JPanel disabled = new JPanel(new GridBagLayout());
        JButton button3 = new JButton(InspectionsBundle.message((String)"severities.default.settings.message", (Object[])new Object[0]));
        button3.addActionListener(e -> this.editColorsAndFonts());
        disabled.add((Component)button3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myRightPanel.add(DEFAULT, disabled);
        this.myRightPanel.add(EDITABLE, this.myOptionsPanel);
        this.myCard.show(this.myRightPanel, EDITABLE);
        this.myPanel.add((Component)this.myRightPanel, "East");
        this.fillList(selectedSeverity);
        this.init();
        this.setTitle(InspectionsBundle.message((String)"severities.editor.dialog.title", (Object[])new Object[0]));
        this.reset(this.myOptionsList.getSelectedValue());
    }

    @NotNull
    public SeverityRegistrar.SeverityBasedTextAttributes createSeverity(@NotNull String name, @NotNull TextAttributes parent) {
        if (name == null) {
            SeverityEditorDialog.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            SeverityEditorDialog.$$$reportNull$$$0(5);
        }
        HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(new HighlightSeverity(name, 50), TextAttributesKey.createTextAttributesKey((String)name));
        return new SeverityRegistrar.SeverityBasedTextAttributes(parent.clone(), info);
    }

    public void select(SeverityRegistrar.SeverityBasedTextAttributes newSeverityBasedTextAttributes) {
        this.myOptionsList.clearSelection();
        ScrollingUtil.selectItem(this.myOptionsList, (Object)newSeverityBasedTextAttributes);
    }

    private boolean checkNameExist(@NotNull String newName) {
        if (newName == null) {
            SeverityEditorDialog.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)newName)) {
            return false;
        }
        ListModel<SeverityRegistrar.SeverityBasedTextAttributes> listModel = this.myOptionsList.getModel();
        for (int i2 = 0; i2 < listModel.getSize(); ++i2) {
            String severityName = listModel.getElementAt((int)i2).getSeverity().myName;
            if (!Comparing.strEqual((String)severityName, (String)newName, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    private void editColorsAndFonts() {
        String toConfigure = Objects.requireNonNull(this.getSelectedType()).getSeverity(null).myName;
        if (this.myCloseDialogWhenSettingsShown) {
            this.doOKAction();
        }
        this.myOptionsList.clearSelection();
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.myPanel);
        ColorAndFontOptions.selectOrEditColor(dataContext, toConfigure, InspectionColorSettingsPage.class);
    }

    private void fillList(@Nullable HighlightSeverity severity) {
        DefaultListModel<SeverityRegistrar.SeverityBasedTextAttributes> model = new DefaultListModel<SeverityRegistrar.SeverityBasedTextAttributes>();
        ArrayList<SeverityRegistrar.SeverityBasedTextAttributes> infoTypes = new ArrayList<SeverityRegistrar.SeverityBasedTextAttributes>(SeverityUtil.getRegisteredHighlightingInfoTypes(this.mySeverityRegistrar));
        SeverityRegistrar.SeverityBasedTextAttributes preselection = null;
        for (SeverityRegistrar.SeverityBasedTextAttributes type : infoTypes) {
            model.addElement(type);
            if (!type.getSeverity().equals((Object)severity)) continue;
            preselection = type;
        }
        if (preselection == null && !infoTypes.isEmpty()) {
            preselection = (SeverityRegistrar.SeverityBasedTextAttributes)infoTypes.get(0);
        }
        this.myOptionsList.setModel(model);
        this.myOptionsList.setSelectedValue(preselection, true);
    }

    private void apply(SeverityRegistrar.SeverityBasedTextAttributes info) {
        if (info == null) {
            return;
        }
        MyTextAttributesDescription description = new MyTextAttributesDescription(info.getType().toString(), null, new TextAttributes(), info.getType().getAttributesKey());
        this.myOptionsPanel.apply((EditorSchemeAttributeDescriptor)description, null);
        Element textAttributes = new Element("temp");
        try {
            description.getTextAttributes().writeExternal(textAttributes);
            info.getAttributes().readExternal(textAttributes);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void reset(SeverityRegistrar.SeverityBasedTextAttributes info) {
        if (info == null) {
            return;
        }
        MyTextAttributesDescription description = new MyTextAttributesDescription(info.getType().toString(), null, info.getAttributes(), info.getType().getAttributesKey());
        Element textAttributes = new Element("temp");
        try {
            info.getAttributes().writeExternal(textAttributes);
            description.getTextAttributes().readExternal(textAttributes);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        this.myOptionsPanel.reset((EditorSchemeAttributeDescriptor)description);
    }

    protected void doOKAction() {
        this.apply(this.myOptionsList.getSelectedValue());
        HashSet<SeverityRegistrar.SeverityBasedTextAttributes> infoTypes = new HashSet<SeverityRegistrar.SeverityBasedTextAttributes>(SeverityUtil.getRegisteredHighlightingInfoTypes(this.mySeverityRegistrar));
        ListModel<SeverityRegistrar.SeverityBasedTextAttributes> listModel = this.myOptionsList.getModel();
        ArrayList<HighlightSeverity> order = new ArrayList<HighlightSeverity>();
        for (int i2 = listModel.getSize() - 1; i2 >= 0; --i2) {
            boolean exists;
            SeverityRegistrar.SeverityBasedTextAttributes info = listModel.getElementAt(i2);
            order.add(info.getSeverity());
            if (SeverityRegistrar.isDefaultSeverity(info.getSeverity())) continue;
            infoTypes.remove(info);
            Color stripeColor = info.getAttributes().getErrorStripeColor();
            boolean bl = exists = this.mySeverityRegistrar.getSeverity(info.getSeverity().getName()) != null;
            if (exists) {
                info.getType().getAttributesKey().getDefaultAttributes().setErrorStripeColor(stripeColor);
            } else {
                HighlightInfoType.HighlightInfoTypeImpl type = info.getType();
                TextAttributesKey key = type.getAttributesKey();
                TextAttributes defaultAttributes = key.getDefaultAttributes().clone();
                defaultAttributes.setErrorStripeColor(stripeColor);
                key = TextAttributesKey.createTextAttributesKey((String)key.getExternalName(), (TextAttributes)defaultAttributes);
                type = new HighlightInfoType.HighlightInfoTypeImpl(type.getSeverity(null), key);
                info = new SeverityRegistrar.SeverityBasedTextAttributes(info.getAttributes(), type);
            }
            this.mySeverityRegistrar.registerSeverity(info, stripeColor != null ? stripeColor : LightColors.YELLOW);
        }
        for (SeverityRegistrar.SeverityBasedTextAttributes info : infoTypes) {
            this.mySeverityRegistrar.unregisterSeverity(info.getSeverity());
        }
        this.mySeverityRegistrar.setOrder(order);
        super.doOKAction();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public HighlightInfoType getSelectedType() {
        SeverityRegistrar.SeverityBasedTextAttributes selection = this.myOptionsList.getSelectedValue();
        return selection != null ? selection.getType() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ex/SeverityEditorDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createSeverity";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNameExist";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyTextAttributesDescription
    extends TextAttributesDescription {
        MyTextAttributesDescription(String name, String group, TextAttributes attributes, TextAttributesKey type) {
            super(name, group, attributes, type, null, null, null);
        }

        @Override
        public boolean isErrorStripeEnabled() {
            return true;
        }

        @Override
        public TextAttributes getTextAttributes() {
            return super.getTextAttributes();
        }
    }
}

