/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.InlayHintsUtilsKt;
import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003H\u0016R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006$"}, d2={"Lcom/intellij/codeInsight/hints/presentation/DynamicDelegatePresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "delegate", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "(Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;)V", "value", "getDelegate", "()Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "setDelegate", "height", "", "getHeight", "()I", "listener", "Lcom/intellij/codeInsight/hints/presentation/DynamicDelegatePresentation$DelegateListener;", "width", "getWidth", "mouseClicked", "", "event", "Ljava/awt/event/MouseEvent;", "translated", "Ljava/awt/Point;", "mouseExited", "mouseMoved", "paint", "g", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toString", "", "updateState", "", "previousPresentation", "DelegateListener", "intellij.platform.lang.impl"})
public class DynamicDelegatePresentation
extends BasePresentation {
    private DelegateListener listener;
    @NotNull
    private InlayPresentation delegate;

    @NotNull
    public final InlayPresentation getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(@NotNull InlayPresentation value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        Dimension previousDim = InlayHintsUtilsKt.dimension(this.delegate);
        Dimension newDim = InlayHintsUtilsKt.dimension(value2);
        this.delegate.removeListener((PresentationListener)this.listener);
        this.delegate = value2;
        this.listener = new DelegateListener();
        value2.addListener((PresentationListener)this.listener);
        if (Intrinsics.areEqual((Object)previousDim, (Object)newDim) ^ true) {
            this.fireSizeChanged(previousDim, newDim);
        }
        InlayHintsUtilsKt.fireContentChanged((InlayPresentation)this);
    }

    public int getWidth() {
        return this.delegate.getWidth();
    }

    public int getHeight() {
        return this.delegate.getHeight();
    }

    public boolean updateState(@NotNull InlayPresentation previousPresentation) {
        Intrinsics.checkParameterIsNotNull((Object)previousPresentation, (String)"previousPresentation");
        if (!(previousPresentation instanceof DynamicDelegatePresentation)) {
            InlayHintsUtilsKt.fireUpdateEvent((InlayPresentation)this, InlayHintsUtilsKt.dimension(previousPresentation));
            return true;
        }
        return this.delegate.updateState(((DynamicDelegatePresentation)previousPresentation).delegate);
    }

    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        this.delegate.paint(g, attributes);
    }

    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)translated, (String)"translated");
        this.delegate.mouseClicked(event, translated);
    }

    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)translated, (String)"translated");
        this.delegate.mouseMoved(event, translated);
    }

    public void mouseExited() {
        this.delegate.mouseExited();
    }

    @NotNull
    public String toString() {
        return this.delegate.toString();
    }

    public DynamicDelegatePresentation(@NotNull InlayPresentation delegate) {
        Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
        this.listener = new DelegateListener();
        delegate.addListener((PresentationListener)this.listener);
        this.delegate = delegate;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/codeInsight/hints/presentation/DynamicDelegatePresentation$DelegateListener;", "Lcom/intellij/codeInsight/hints/presentation/PresentationListener;", "(Lcom/intellij/codeInsight/hints/presentation/DynamicDelegatePresentation;)V", "contentChanged", "", "area", "Ljava/awt/Rectangle;", "sizeChanged", "previous", "Ljava/awt/Dimension;", "current", "intellij.platform.lang.impl"})
    private final class DelegateListener
    implements PresentationListener {
        public void contentChanged(@NotNull Rectangle area) {
            Intrinsics.checkParameterIsNotNull((Object)area, (String)"area");
            DynamicDelegatePresentation.this.fireContentChanged(area);
        }

        public void sizeChanged(@NotNull Dimension previous, @NotNull Dimension current2) {
            Intrinsics.checkParameterIsNotNull((Object)previous, (String)"previous");
            Intrinsics.checkParameterIsNotNull((Object)current2, (String)"current");
            DynamicDelegatePresentation.this.fireSizeChanged(previous, current2);
        }
    }
}

