/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class VcsInitialization {
    private static final Logger LOG = Logger.getInstance(VcsInitialization.class);
    private final Object myLock;
    @NotNull
    private final Project myProject;
    private Status myStatus;
    private final List<VcsStartupActivity> myInitActivities;
    private final List<VcsStartupActivity> myPostActivities;
    private volatile Future<?> myFuture;
    private final ProgressIndicator myIndicator;

    VcsInitialization(@NotNull Project project) {
        if (project == null) {
            VcsInitialization.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myStatus = Status.PENDING;
        this.myInitActivities = new ArrayList<VcsStartupActivity>();
        this.myPostActivities = new ArrayList<VcsStartupActivity>();
        this.myIndicator = new StandardProgressIndicatorBase();
        this.myProject = project;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Disposable disposable = ((ProjectEx)project).getEarlyDisposable();
            Disposer.register((Disposable)disposable, () -> this.cancelBackgroundInitialization());
        }
    }

    public static VcsInitialization getInstance(Project project) {
        return (VcsInitialization)project.getService(VcsInitialization.class);
    }

    private void startInitialization() {
        this.myFuture = ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(new Task.Backgroundable(this.myProject, "VCS Initialization"){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                VcsInitialization.this.execute();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/impl/VcsInitialization$1", "run"));
            }
        }, this.myIndicator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(@NotNull VcsInitObject vcsInitObject, @NotNull Runnable runnable) {
        if (vcsInitObject == null) {
            VcsInitialization.$$$reportNull$$$0(1);
        }
        if (runnable == null) {
            VcsInitialization.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDefault()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            ProxyVcsStartupActivity activity = new ProxyVcsStartupActivity(vcsInitObject, runnable);
            if (VcsInitialization.isInitActivity(activity)) {
                if (this.myStatus == Status.PENDING) {
                    this.myInitActivities.add(activity);
                } else {
                    LOG.warn(String.format("scheduling late initialization: %s", activity));
                    BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, (Runnable)runnable);
                }
            } else if (this.myStatus == Status.PENDING || this.myStatus == Status.RUNNING_INIT) {
                this.myPostActivities.add(activity);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("scheduling late post activity: %s", activity));
                }
                BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, (Runnable)runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        LOG.assertTrue(!this.myProject.isDefault());
        try {
            this.runInitStep(Status.PENDING, Status.RUNNING_INIT, (Condition<VcsStartupActivity>)((Condition)it -> VcsInitialization.isInitActivity(it)), this.myInitActivities);
            this.runInitStep(Status.RUNNING_INIT, Status.RUNNING_POST, (Condition<VcsStartupActivity>)((Condition)it -> !VcsInitialization.isInitActivity(it)), this.myPostActivities);
        }
        finally {
            Object object = this.myLock;
            synchronized (object) {
                this.myStatus = Status.FINISHED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInitStep(@NotNull Status current, @NotNull Status next, @NotNull Condition<VcsStartupActivity> extensionFilter, @NotNull List<VcsStartupActivity> pendingActivities) {
        if (current == null) {
            VcsInitialization.$$$reportNull$$$0(3);
        }
        if (next == null) {
            VcsInitialization.$$$reportNull$$$0(4);
        }
        if (extensionFilter == null) {
            VcsInitialization.$$$reportNull$$$0(5);
        }
        if (pendingActivities == null) {
            VcsInitialization.$$$reportNull$$$0(6);
        }
        List epActivities = ContainerUtil.filter((Collection)VcsStartupActivity.EP_NAME.getExtensionList(), extensionFilter);
        ArrayList<VcsStartupActivity> activities = new ArrayList<VcsStartupActivity>();
        Object object = this.myLock;
        synchronized (object) {
            assert (this.myStatus == current);
            this.myStatus = next;
            activities.addAll(epActivities);
            activities.addAll(pendingActivities);
            pendingActivities.clear();
        }
        this.runActivities(activities);
    }

    private void runActivities(@NotNull List<VcsStartupActivity> activities) {
        Future<?> future2;
        if (activities == null) {
            VcsInitialization.$$$reportNull$$$0(7);
        }
        if ((future2 = this.myFuture) != null && future2.isCancelled()) {
            return;
        }
        Collections.sort(activities, Comparator.comparingInt(VcsStartupActivity::getOrder));
        for (VcsStartupActivity activity : activities) {
            ProgressManager.checkCanceled();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("running activity: %s", activity));
            }
            QueueProcessor.runSafely(() -> activity.runActivity(this.myProject));
        }
    }

    private void cancelBackgroundInitialization() {
        this.myIndicator.cancel();
        Future<?> future2 = this.myFuture;
        LOG.debug(String.format("cancelBackgroundInitialization() future=%s from %s with write access=%s", future2, Thread.currentThread(), ApplicationManager.getApplication().isWriteAccessAllowed()));
        if (future2 != null) {
            future2.cancel(false);
            if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                SwingUtilities.invokeLater(this::waitNotRunning);
            } else {
                this.waitNotRunning();
            }
        }
    }

    private void waitNotRunning() {
        boolean success2 = this.waitFor(status -> status == Status.PENDING || status == Status.FINISHED);
        if (!success2) {
            LOG.warn("Failed to wait for VCS initialization cancellation for project " + this.myProject, new Throwable());
        }
    }

    void waitFinished() {
        boolean success2 = this.waitFor(status -> status == Status.FINISHED);
        if (!success2) {
            LOG.error("Failed to wait for VCS initialization completion for project " + this.myProject, new Throwable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitFor(@NotNull Predicate<? super Status> predicate) {
        if (predicate == null) {
            VcsInitialization.$$$reportNull$$$0(8);
        }
        if (this.myProject.isDefault()) {
            throw new IllegalArgumentException();
        }
        long start2 = System.currentTimeMillis();
        while (System.currentTimeMillis() < start2 + 10000L) {
            Object object = this.myLock;
            synchronized (object) {
                if (predicate.test(this.myStatus)) {
                    return true;
                }
            }
            TimeoutUtil.sleep((long)10L);
        }
        return false;
    }

    private static boolean isInitActivity(@NotNull VcsStartupActivity activity) {
        if (activity == null) {
            VcsInitialization.$$$reportNull$$$0(9);
        }
        return activity.getOrder() < VcsInitObject.AFTER_COMMON.getOrder();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsInitObject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionFilter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pendingActivities";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activities";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/impl/VcsInitialization";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "runInitStep";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivities";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "waitFor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isInitActivity";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProxyVcsStartupActivity
    implements VcsStartupActivity {
        @NotNull
        private final Runnable myRunnable;
        private final int myOrder;

        private ProxyVcsStartupActivity(@NotNull VcsInitObject vcsInitObject, @NotNull Runnable runnable) {
            if (vcsInitObject == null) {
                ProxyVcsStartupActivity.$$$reportNull$$$0(0);
            }
            if (runnable == null) {
                ProxyVcsStartupActivity.$$$reportNull$$$0(1);
            }
            this.myOrder = vcsInitObject.getOrder();
            this.myRunnable = runnable;
        }

        @Override
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                ProxyVcsStartupActivity.$$$reportNull$$$0(2);
            }
            this.myRunnable.run();
        }

        @Override
        public int getOrder() {
            return this.myOrder;
        }

        public String toString() {
            return String.format("ProxyVcsStartupActivity{runnable=%s, order=%s}", this.myRunnable, this.myOrder);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcsInitObject";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/impl/VcsInitialization$ProxyVcsStartupActivity";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runActivity";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class ShutDownProjectListener
    implements ProjectManagerListener {
        ShutDownProjectListener() {
        }

        public void projectClosing(@NotNull Project project) {
            if (project == null) {
                ShutDownProjectListener.$$$reportNull$$$0(0);
            }
            if (project.isDefault()) {
                return;
            }
            VcsInitialization vcsInitialization = (VcsInitialization)project.getServiceIfCreated(VcsInitialization.class);
            if (vcsInitialization != null) {
                vcsInitialization.cancelBackgroundInitialization();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/VcsInitialization$ShutDownProjectListener", "projectClosing"));
        }
    }

    static final class StartUpActivity
    implements StartupActivity.DumbAware {
        StartUpActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                StartUpActivity.$$$reportNull$$$0(0);
            }
            if (project.isDefault()) {
                return;
            }
            VcsInitialization vcsInitialization = (VcsInitialization)project.getService(VcsInitialization.class);
            vcsInitialization.startInitialization();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/VcsInitialization$StartUpActivity", "runActivity"));
        }
    }

    private static enum Status {
        PENDING,
        RUNNING_INIT,
        RUNNING_POST,
        FINISHED;

    }
}

