/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.SimpleApplicationBootstrapperKt;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.ApplicationLoader;
import com.intellij.idea.Main;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.ui.IconManager;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0000\u001a\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"doLoadApp", "", "setupEventQueue", "Lkotlin/Function0;", "loadHeadlessAppInUnitTestMode", "intellij.platform.testFramework"})
public final class SimpleApplicationBootstrapperKt {
    public static final void loadHeadlessAppInUnitTestMode() {
        SimpleApplicationBootstrapperKt.doLoadApp((Function0<Unit>)((Function0)loadHeadlessAppInUnitTestMode.1.INSTANCE));
    }

    public static final void doLoadApp(@NotNull Function0<Unit> setupEventQueue) {
        Intrinsics.checkParameterIsNotNull(setupEventQueue, (String)"setupEventQueue");
        boolean isHeadless = true;
        if (Intrinsics.areEqual((Object)System.getProperty("java.awt.headless"), (Object)"false")) {
            isHeadless = false;
        } else {
            System.setProperty("java.awt.headless", "true");
        }
        Main.setHeadlessInTestMode((boolean)isHeadless);
        PluginManagerCore.isUnitTestMode = true;
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
        CompletableFuture loadedPluginFuture2 = CompletableFuture.supplyAsync(doLoadApp.loadedPluginFuture.1.INSTANCE, AppExecutorUtil.getAppExecutorService());
        setupEventQueue.invoke();
        ApplicationImpl app = new ApplicationImpl(true, true, isHeadless, true);
        if (SystemProperties.getBooleanProperty((String)"tests.assertOnMissedCache", (boolean)true)) {
            RecursionManager.assertOnMissedCache((Disposable)((Disposable)app));
        }
        IconManager.activate();
        List plugins = null;
        try {
            CompletableFuture completableFuture = loadedPluginFuture2;
            Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"loadedPluginFuture");
            Object t = ApplicationLoader.registerRegistryAndInitStore((CompletableFuture)ApplicationLoader.registerAppComponents(completableFuture, (ApplicationImpl)app), (ApplicationImpl)app).get(40L, TimeUnit.SECONDS);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"registerRegistryAndInitS\u2026get(40, TimeUnit.SECONDS)");
            plugins = (List)t;
            Executor boundedExecutor = ApplicationLoader.createExecutorToPreloadServices();
            Registry.getInstance().markAsLoaded();
            CompletableFuture preloadServiceFuture = ApplicationLoader.preloadServices$default((List)plugins, (ComponentManagerImpl)((ComponentManagerImpl)app), (String)"", (boolean)false, (Executor)boundedExecutor, (int)8, null);
            app.loadComponents(null);
            ((CompletableFuture)preloadServiceFuture.thenCompose(new Function<T, CompletionStage<U>>(app, boundedExecutor){
                final /* synthetic */ ApplicationImpl $app;
                final /* synthetic */ Executor $boundedExecutor;

                @NotNull
                public final CompletableFuture<Void> apply(@Nullable Void it) {
                    return ApplicationLoader.callAppInitialized((Application)((Application)this.$app), (Executor)this.$boundedExecutor);
                }
                {
                    this.$app = applicationImpl;
                    this.$boundedExecutor = executor;
                }
            })).get(40L, TimeUnit.SECONDS);
            PersistentFS persistentFS = PersistentFS.getInstance();
            if (persistentFS == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl");
            }
            ((PersistentFSImpl)persistentFS).cleanPersistedContents();
        }
        catch (TimeoutException e) {
            throw (Throwable)new RuntimeException("Cannot preload services in 40 seconds: " + ThreadDumper.dumpThreadsToString(), e);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
        catch (InterruptedException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
    }
}

