/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.json5.codeinsight;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.JsonDialectUtil;
import com.intellij.json.codeinsight.JsonStandardComplianceInspection;
import com.intellij.json.json5.Json5Language;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class Json5StandardComplianceInspection
extends JsonStandardComplianceInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            Json5StandardComplianceInspection.$$$reportNull$$$0(0);
        }
        if (!(JsonDialectUtil.getLanguageOrDefaultJson((PsiElement)holder.getFile()) instanceof Json5Language)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                Json5StandardComplianceInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new StandardJson5ValidatingElementVisitor(holder);
    }

    @Override
    public JComponent createOptionsPanel() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/json5/codeinsight/Json5StandardComplianceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/json5/codeinsight/Json5StandardComplianceInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StandardJson5ValidatingElementVisitor
    extends JsonStandardComplianceInspection.StandardJsonValidatingElementVisitor {
        StandardJson5ValidatingElementVisitor(ProblemsHolder holder) {
            super(holder);
        }

        @Override
        protected boolean allowComments() {
            return true;
        }

        @Override
        protected boolean allowSingleQuotes() {
            return true;
        }

        @Override
        protected boolean allowIdentifierPropertyNames() {
            return true;
        }

        @Override
        protected boolean allowTrailingCommas() {
            return true;
        }

        @Override
        protected boolean allowNanInfinity() {
            return true;
        }

        @Override
        protected boolean isValidPropertyName(@NotNull PsiElement literal) {
            if (literal == null) {
                StandardJson5ValidatingElementVisitor.$$$reportNull$$$0(0);
            }
            if (literal instanceof JsonLiteral) {
                String textWithoutHostEscaping = JsonPsiUtil.getElementTextWithoutHostEscaping(literal);
                return textWithoutHostEscaping.startsWith("\"") || textWithoutHostEscaping.startsWith("'");
            }
            if (literal instanceof JsonReferenceExpression) {
                return StringUtil.isJavaIdentifier((String)literal.getText());
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/json/json5/codeinsight/Json5StandardComplianceInspection$StandardJson5ValidatingElementVisitor", "isValidPropertyName"));
        }
    }
}

