/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.ui.SimpleColoredText;
import com.intellij.util.Consumer;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionConfigBean;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LanguageInjectionSupport {
    public static final ExtensionPointName<LanguageInjectionSupport> EP_NAME = ExtensionPointName.create((String)"org.intellij.intelliLang.languageSupport");
    public static final ExtensionPointName<LanguageInjectionConfigBean> CONFIG_EP_NAME = ExtensionPointName.create((String)"org.intellij.intelliLang.injectionConfig");
    public static final Key<InjectedLanguage> TEMPORARY_INJECTED_LANGUAGE = Key.create((String)"TEMPORARY_INJECTED_LANGUAGE");
    public static final Key<LanguageInjectionSupport> INJECTOR_SUPPORT = Key.create((String)"INJECTOR_SUPPORT");
    public static final Key<LanguageInjectionSupport> SETTINGS_EDITOR = Key.create((String)"SETTINGS_EDITOR");

    @NonNls
    @NotNull
    public abstract String getId();

    public abstract Class<?> @NotNull [] getPatternClasses();

    public abstract boolean isApplicableTo(PsiLanguageInjectionHost var1);

    public abstract boolean useDefaultInjector(PsiLanguageInjectionHost var1);

    public abstract boolean useDefaultCommentInjector();

    @Nullable
    public abstract BaseInjection findCommentInjection(@NotNull PsiElement var1, @Nullable Ref<? super PsiElement> var2);

    public abstract boolean addInjectionInPlace(Language var1, PsiLanguageInjectionHost var2);

    public abstract boolean removeInjectionInPlace(PsiLanguageInjectionHost var1);

    public boolean removeInjection(PsiElement psiElement) {
        return psiElement instanceof PsiLanguageInjectionHost && this.removeInjectionInPlace((PsiLanguageInjectionHost)psiElement);
    }

    public abstract boolean editInjectionInPlace(PsiLanguageInjectionHost var1);

    public abstract BaseInjection createInjection(Element var1);

    public abstract void setupPresentation(BaseInjection var1, SimpleColoredText var2, boolean var3);

    public abstract Configurable[] createSettings(Project var1, Configuration var2);

    public abstract AnAction[] createAddActions(Project var1, Consumer<? super BaseInjection> var2);

    public abstract AnAction createEditAction(Project var1, Factory<? extends BaseInjection> var2);
}

