/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalShellCommandHandlerHelper;
import org.jetbrains.plugins.terminal.TerminalUsageTriggerCollector;
import org.jetbrains.plugins.terminal.TerminalUtil;

public class ShellTerminalWidget
extends JBTerminalWidget {
    private static final Logger LOG = Logger.getInstance(ShellTerminalWidget.class);
    private final Project myProject;
    private boolean myEscapePressed;
    private String myCommandHistoryFilePath;
    private boolean myPromptUpdateNeeded;
    private String myPrompt;
    private final Queue<String> myPendingCommandsToExecute;
    private final TerminalShellCommandHandlerHelper myShellCommandHandlerHelper;

    public ShellTerminalWidget(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider, @NotNull Disposable parent) {
        if (project == null) {
            ShellTerminalWidget.$$$reportNull$$$0(0);
        }
        if (settingsProvider == null) {
            ShellTerminalWidget.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            ShellTerminalWidget.$$$reportNull$$$0(2);
        }
        super(project, settingsProvider, parent);
        this.myEscapePressed = false;
        this.myPromptUpdateNeeded = true;
        this.myPrompt = "";
        this.myPendingCommandsToExecute = new LinkedList<String>();
        this.myProject = project;
        this.myShellCommandHandlerHelper = new TerminalShellCommandHandlerHelper(this);
        ((JBTerminalPanel)this.getTerminalPanel()).addPreKeyEventHandler(e -> {
            if (e.getID() != 401) {
                return;
            }
            if (e.getKeyCode() == 27) {
                this.myEscapePressed = true;
            }
            if (this.myPromptUpdateNeeded) {
                this.myPrompt = this.getLineAtCursor();
                if (LOG.isDebugEnabled()) {
                    LOG.info("Guessed shell prompt: " + this.myPrompt);
                }
                this.myPromptUpdateNeeded = false;
            }
            if (e.getKeyCode() == 10 || TerminalShellCommandHandlerHelper.matchedExecutorAction(e) != null) {
                TerminalUsageTriggerCollector.Companion.triggerCommandExecuted(this.myProject);
                if (this.myShellCommandHandlerHelper.processEnterKeyPressed(this.getTypedShellCommand(), (KeyEvent)e)) {
                    e.consume();
                }
                if (!e.isConsumed()) {
                    this.myPromptUpdateNeeded = true;
                    this.myEscapePressed = false;
                }
            } else {
                this.myShellCommandHandlerHelper.processKeyPressed();
            }
        });
    }

    @NotNull
    Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ShellTerminalWidget.$$$reportNull$$$0(3);
        }
        return project;
    }

    public void setCommandHistoryFilePath(@Nullable String commandHistoryFilePath) {
        this.myCommandHistoryFilePath = commandHistoryFilePath;
    }

    @Nullable
    public static String getCommandHistoryFilePath(@Nullable JBTerminalWidget terminalWidget) {
        return terminalWidget instanceof ShellTerminalWidget ? ((ShellTerminalWidget)terminalWidget).myCommandHistoryFilePath : null;
    }

    @NotNull
    public String getTypedShellCommand() {
        if (this.myPromptUpdateNeeded) {
            return "";
        }
        String line = this.getLineAtCursor();
        String string = StringUtil.trimStart((String)line, (String)this.myPrompt);
        if (string == null) {
            ShellTerminalWidget.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private String getLineAtCursor() {
        String string = this.processTerminalBuffer(textBuffer -> {
            TerminalLine line = textBuffer.getLine(this.getLineNumberAtCursor());
            return line != null ? line.getText() : "";
        });
        if (string == null) {
            ShellTerminalWidget.$$$reportNull$$$0(5);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T processTerminalBuffer(@NotNull Function<TerminalTextBuffer, T> processor) {
        if (processor == null) {
            ShellTerminalWidget.$$$reportNull$$$0(6);
        }
        TerminalTextBuffer textBuffer = this.getTerminalPanel().getTerminalTextBuffer();
        textBuffer.lock();
        try {
            T t = processor.apply(textBuffer);
            return t;
        }
        finally {
            textBuffer.unlock();
        }
    }

    int getLineNumberAtCursor() {
        TerminalTextBuffer textBuffer = this.getTerminalPanel().getTerminalTextBuffer();
        Terminal terminal = this.getTerminal();
        return Math.max(0, Math.min(terminal.getCursorY() - 1, textBuffer.getHeight() - 1));
    }

    public void executeCommand(@NotNull String shellCommand) throws IOException {
        String typedCommand;
        if (shellCommand == null) {
            ShellTerminalWidget.$$$reportNull$$$0(7);
        }
        if (!(typedCommand = this.getTypedShellCommand()).isEmpty()) {
            throw new IOException("Cannot execute command when another command is typed: " + typedCommand);
        }
        TtyConnector connector = this.getTtyConnector();
        if (connector != null) {
            this.doExecuteCommand(shellCommand, connector);
        } else {
            this.myPendingCommandsToExecute.add(shellCommand);
        }
    }

    public void setTtyConnector(@NotNull TtyConnector ttyConnector) {
        String command;
        if (ttyConnector == null) {
            ShellTerminalWidget.$$$reportNull$$$0(8);
        }
        super.setTtyConnector(ttyConnector);
        while ((command = this.myPendingCommandsToExecute.poll()) != null) {
            try {
                this.doExecuteCommand(command, ttyConnector);
            }
            catch (IOException e) {
                LOG.warn("Cannot execute " + command, (Throwable)e);
            }
        }
    }

    private void doExecuteCommand(@NotNull String shellCommand, @NotNull TtyConnector connector) throws IOException {
        if (shellCommand == null) {
            ShellTerminalWidget.$$$reportNull$$$0(9);
        }
        if (connector == null) {
            ShellTerminalWidget.$$$reportNull$$$0(10);
        }
        StringBuilder result = new StringBuilder();
        if (this.myEscapePressed) {
            result.append('\b');
        }
        String enterCode = new String(this.getTerminalStarter().getCode(10, 0), StandardCharsets.UTF_8);
        result.append(shellCommand).append(enterCode);
        connector.write(result.toString());
    }

    public boolean hasRunningCommands() throws IllegalStateException {
        TtyConnector connector = this.getTtyConnector();
        if (connector == null) {
            return false;
        }
        if (connector instanceof ProcessTtyConnector) {
            return TerminalUtil.hasRunningCommands((ProcessTtyConnector)connector);
        }
        throw new IllegalStateException("Cannot determine if there are running processes for " + connector.getClass());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/ShellTerminalWidget";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellCommand";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ttyConnector";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/ShellTerminalWidget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedShellCommand";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineAtCursor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processTerminalBuffer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTtyConnector";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doExecuteCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

