/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Couple;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.ui.UIUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.text.JTextComponent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScrollingUtil {
    private static final Logger LOG = Logger.getInstance(ScrollingUtil.class);
    @NonNls
    private static final String SCROLL_UP_ACTION_ID = "scrollUp";
    @NonNls
    private static final String SCROLL_DOWN_ACTION_ID = "scrollDown";
    @NonNls
    private static final String SELECT_PREVIOUS_ROW_ACTION_ID = "selectPreviousRow";
    @NonNls
    private static final String SELECT_NEXT_ROW_ACTION_ID = "selectNextRow";
    @NonNls
    private static final String SELECT_LAST_ROW_ACTION_ID = "selectLastRow";
    @NonNls
    private static final String SELECT_FIRST_ROW_ACTION_ID = "selectFirstRow";
    @NonNls
    private static final String MOVE_HOME_ID = "MOVE_HOME";
    @NonNls
    private static final String MOVE_END_ID = "MOVE_END";
    public static final int ROW_PADDING = 2;

    public static void selectItem(@NotNull JList<?> list, int index) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(index >= 0);
        LOG.assertTrue(index < list.getModel().getSize());
        ScrollingUtil.ensureIndexIsVisible(list, index, 0);
        list.setSelectedIndex(index);
    }

    public static void ensureSelectionExists(@NotNull JList<?> list) {
        int size;
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(1);
        }
        if ((size = list.getModel().getSize()) == 0) {
            list.clearSelection();
            return;
        }
        int selectedIndex = list.getSelectedIndex();
        if (selectedIndex < 0 || selectedIndex >= size) {
            selectedIndex = 0;
        }
        ScrollingUtil.selectItem(list, selectedIndex);
    }

    public static <T> boolean selectItem(@NotNull JList<T> list, @NotNull T item) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(2);
        }
        if (item == null) {
            ScrollingUtil.$$$reportNull$$$0(3);
        }
        ListModel<T> model = list.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            T anItem = model.getElementAt(i);
            if (!item.equals(anItem)) continue;
            ScrollingUtil.selectItem(list, i);
            return true;
        }
        return false;
    }

    public static void movePageUp(JList<?> list) {
        Rectangle cellBounds;
        int bottom;
        int visible = ScrollingUtil.getVisibleRowCount(list);
        ListSelectionModel selectionModel = list.getSelectionModel();
        if (visible <= 0) {
            ScrollingUtil.moveHome(list);
            return;
        }
        int size = list.getModel().getSize();
        int decrement = visible - 1;
        int index = Math.max(list.getSelectedIndex() - decrement, 0);
        int top = list.getFirstVisibleIndex() - decrement;
        if (top < 0) {
            top = 0;
        }
        if ((bottom = top + visible - 1) >= size) {
            bottom = size - 1;
        }
        if ((cellBounds = list.getCellBounds(top, bottom)) == null) {
            ScrollingUtil.moveHome(list);
            return;
        }
        list.scrollRectToVisible(cellBounds);
        selectionModel.setSelectionInterval(index, index);
        list.ensureIndexIsVisible(index);
    }

    public static void movePageDown(@NotNull JList<?> list) {
        Rectangle cellBounds;
        int visible;
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(4);
        }
        if ((visible = ScrollingUtil.getVisibleRowCount(list)) <= 0) {
            ScrollingUtil.moveEnd(list);
            return;
        }
        int size = list.getModel().getSize();
        int increment = visible - 1;
        int index = Math.min(list.getSelectedIndex() + increment, size - 1);
        int top = list.getFirstVisibleIndex() + increment;
        int bottom = top + visible - 1;
        if (bottom >= size) {
            bottom = size - 1;
        }
        if ((cellBounds = list.getCellBounds(top, bottom)) == null) {
            ScrollingUtil.moveEnd(list);
            return;
        }
        list.scrollRectToVisible(cellBounds);
        list.setSelectedIndex(index);
        list.ensureIndexIsVisible(index);
    }

    public static void moveHome(@NotNull JList<?> list) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(5);
        }
        list.setSelectedIndex(0);
        list.ensureIndexIsVisible(0);
    }

    public static void moveEnd(@NotNull JList<?> list) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(6);
        }
        int index = list.getModel().getSize() - 1;
        list.setSelectedIndex(index);
        list.ensureIndexIsVisible(index);
    }

    public static void ensureIndexIsVisible(@NotNull JList<?> list, int index, int moveDirection) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(7);
        }
        ScrollingUtil._ensureIndexIsVisible(list, index, moveDirection, list.getModel().getSize());
    }

    public static void ensureIndexIsVisible(@NotNull JTable table, int index, int moveDirection) {
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(8);
        }
        ScrollingUtil._ensureIndexIsVisible(table, index, moveDirection, table.getRowCount());
    }

    private static void _ensureIndexIsVisible(@NotNull JComponent c, int index, int moveDirection, int size) {
        int bottom;
        int top;
        if (c == null) {
            ScrollingUtil.$$$reportNull$$$0(9);
        }
        int visible = ScrollingUtil.visibleRowCount(c);
        if (moveDirection == 0) {
            top = index - (visible - 1) / 2;
            bottom = top + visible - 1;
        } else if (moveDirection < 0) {
            top = index - 2;
            bottom = index;
        } else {
            top = index;
            bottom = index + 2;
        }
        if (top < 0) {
            top = 0;
        }
        if (bottom >= size) {
            bottom = size - 1;
        }
        ScrollingUtil._ensureRangeIsVisible(c, top, bottom);
    }

    public static void ensureRangeIsVisible(@NotNull JList<?> list, int top, int bottom) {
        Rectangle cellBounds;
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(10);
        }
        int size = list.getModel().getSize();
        if (top < 0) {
            top = 0;
        }
        if (bottom >= size) {
            bottom = size - 1;
        }
        if ((cellBounds = list.getCellBounds(top, bottom)) != null) {
            cellBounds.x = 0;
            list.scrollRectToVisible(cellBounds);
        }
    }

    private static void _ensureRangeIsVisible(@NotNull JComponent c, int top, int bottom) {
        if (c == null) {
            ScrollingUtil.$$$reportNull$$$0(11);
        }
        if (c instanceof JList) {
            ScrollingUtil.ensureRangeIsVisible((JList)c, top, bottom);
        } else if (c instanceof JTable) {
            JTable table = (JTable)c;
            Rectangle cellBounds = ScrollingUtil.getCellBounds(table, top, bottom);
            cellBounds.x = 0;
            table.scrollRectToVisible(cellBounds);
        }
    }

    public static boolean isIndexFullyVisible(@NotNull JList<?> list, int index) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(12);
        }
        int first = list.getFirstVisibleIndex();
        int last = list.getLastVisibleIndex();
        if (index < 0 || first < 0 || last < 0 || index < first || index > last) {
            return false;
        }
        if (index > first && index < last) {
            return true;
        }
        return list.getVisibleRect().contains(list.getCellBounds(index, index));
    }

    private static int getVisibleRowCount(@NotNull JList<?> list) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(13);
        }
        return list.getLastVisibleIndex() - list.getFirstVisibleIndex() + 1;
    }

    public static void moveDown(@NotNull JList<?> list, @JdkConstants.InputEventMask int modifiers) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(14);
        }
        ScrollingUtil._moveDown(list, list.getSelectionModel(), modifiers, list.getModel().getSize(), UISettings.getInstance().getCycleScrolling());
    }

    private static void selectOrAddSelection(@NotNull ListSelectionModel selectionModel, int indexToSelect, @JdkConstants.InputEventMask int modifiers) {
        if (selectionModel == null) {
            ScrollingUtil.$$$reportNull$$$0(15);
        }
        if (selectionModel.getSelectionMode() == 0) {
            selectionModel.setSelectionInterval(indexToSelect, indexToSelect);
        } else {
            if ((modifiers & 0x40) == 0) {
                selectionModel.removeSelectionInterval(selectionModel.getMinSelectionIndex(), selectionModel.getMaxSelectionIndex());
            }
            selectionModel.addSelectionInterval(indexToSelect, indexToSelect);
        }
    }

    public static void installActions(@NotNull JList<?> list) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(16);
        }
        ScrollingUtil.installActions(list, null);
    }

    public static void installActions(@NotNull JList<?> list, @Nullable JComponent focusParent) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(17);
        }
        ActionMap actionMap = list.getActionMap();
        actionMap.put(SCROLL_UP_ACTION_ID, new MoveAction(SCROLL_UP_ACTION_ID, list));
        actionMap.put(SCROLL_DOWN_ACTION_ID, new MoveAction(SCROLL_DOWN_ACTION_ID, list));
        actionMap.put(SELECT_PREVIOUS_ROW_ACTION_ID, new MoveAction(SELECT_PREVIOUS_ROW_ACTION_ID, list));
        actionMap.put(SELECT_NEXT_ROW_ACTION_ID, new MoveAction(SELECT_NEXT_ROW_ACTION_ID, list));
        actionMap.put(SELECT_LAST_ROW_ACTION_ID, new MoveAction(SELECT_LAST_ROW_ACTION_ID, list));
        actionMap.put(SELECT_FIRST_ROW_ACTION_ID, new MoveAction(SELECT_FIRST_ROW_ACTION_ID, list));
        actionMap.put(MOVE_HOME_ID, new MoveAction(MOVE_HOME_ID, list));
        actionMap.put(MOVE_END_ID, new MoveAction(MOVE_END_ID, list));
        ScrollingUtil.maybeInstallDefaultShortcuts(list);
        ScrollingUtil.installMoveUpAction(list, focusParent);
        ScrollingUtil.installMoveDownAction(list, focusParent);
        ScrollingUtil.installMovePageUpAction(list, focusParent);
        ScrollingUtil.installMovePageDownAction(list, focusParent);
        if (!(focusParent instanceof JTextComponent)) {
            ScrollingUtil.installMoveHomeAction(list, focusParent);
            ScrollingUtil.installMoveEndAction(list, focusParent);
        }
    }

    public static void redirectExpandSelection(final @NotNull JList<?> list, @Nullable JComponent focusParent) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(18);
        }
        if (focusParent != null && focusParent != list) {
            focusParent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.isShiftDown()) {
                        if (e.getKeyCode() == 40) {
                            list.dispatchEvent(e);
                            e.consume();
                        }
                        if (e.getKeyCode() == 38) {
                            list.dispatchEvent(e);
                            e.consume();
                        }
                    }
                }
            });
        }
    }

    public static void installMoveEndAction(final @NotNull JList<?> list, @Nullable JComponent focusParent) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(19);
        }
        new ListScrollAction(CommonShortcuts.getMoveEnd(), focusParent == null ? list : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ScrollingUtil.moveEnd(list);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$2", "actionPerformed"));
            }
        };
    }

    public static void installMoveHomeAction(final @NotNull JList<?> list, @Nullable JComponent focusParent) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(20);
        }
        new ListScrollAction(CommonShortcuts.getMoveHome(), focusParent == null ? list : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ScrollingUtil.moveHome(list);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$3", "actionPerformed"));
            }
        };
    }

    public static void installMovePageDownAction(final @NotNull JList<?> list, @Nullable JComponent focusParent) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(21);
        }
        new ListScrollAction(CommonShortcuts.getMovePageDown(), focusParent == null ? list : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                ScrollingUtil.movePageDown(list);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$4", "actionPerformed"));
            }
        };
    }

    public static void installMovePageUpAction(final @NotNull JList<?> list, @Nullable JComponent focusParent) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(22);
        }
        new ListScrollAction(CommonShortcuts.getMovePageUp(), focusParent == null ? list : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                ScrollingUtil.movePageUp(list);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$5", "actionPerformed"));
            }
        };
    }

    public static void installMoveDownAction(final @NotNull JList<?> list, @Nullable JComponent focusParent) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(23);
        }
        new ListScrollAction(CommonShortcuts.getMoveDown(), focusParent == null ? list : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                ScrollingUtil.moveDown(list, 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$6", "actionPerformed"));
            }
        };
    }

    public static void installMoveUpAction(final @NotNull JList<?> list, @Nullable JComponent focusParent) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(24);
        }
        new ListScrollAction(CommonShortcuts.getMoveUp(), focusParent == null ? list : focusParent){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                ScrollingUtil.moveUp(list, 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$7", "actionPerformed"));
            }
        };
    }

    private static void maybeInstallDefaultShortcuts(@NotNull JComponent component) {
        if (component == null) {
            ScrollingUtil.$$$reportNull$$$0(25);
        }
        InputMap map = component.getInputMap(0);
        UIUtil.maybeInstall((InputMap)map, (String)SCROLL_UP_ACTION_ID, (KeyStroke)KeyStroke.getKeyStroke(33, 0));
        UIUtil.maybeInstall((InputMap)map, (String)SCROLL_DOWN_ACTION_ID, (KeyStroke)KeyStroke.getKeyStroke(34, 0));
        UIUtil.maybeInstall((InputMap)map, (String)SELECT_PREVIOUS_ROW_ACTION_ID, (KeyStroke)KeyStroke.getKeyStroke(38, 0));
        UIUtil.maybeInstall((InputMap)map, (String)SELECT_NEXT_ROW_ACTION_ID, (KeyStroke)KeyStroke.getKeyStroke(40, 0));
        UIUtil.maybeInstall((InputMap)map, (String)SELECT_FIRST_ROW_ACTION_ID, (KeyStroke)KeyStroke.getKeyStroke(36, 0));
        UIUtil.maybeInstall((InputMap)map, (String)SELECT_LAST_ROW_ACTION_ID, (KeyStroke)KeyStroke.getKeyStroke(35, 0));
        UIUtil.maybeInstall((InputMap)map, (String)MOVE_HOME_ID, (KeyStroke)KeyStroke.getKeyStroke(37, 0));
        UIUtil.maybeInstall((InputMap)map, (String)MOVE_END_ID, (KeyStroke)KeyStroke.getKeyStroke(39, 0));
    }

    public static void ensureSelectionExists(@NotNull JTable table) {
        int size;
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(26);
        }
        if ((size = table.getModel().getRowCount()) == 0) {
            table.clearSelection();
            return;
        }
        int selectedIndex = table.getSelectedRow();
        boolean reselect = false;
        if (selectedIndex < 0 || selectedIndex >= size) {
            selectedIndex = 0;
            reselect = true;
        }
        ScrollingUtil.ensureIndexIsVisible(table, selectedIndex, 0);
        if (reselect) {
            table.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    @NotNull
    private static Rectangle getCellBounds(@NotNull JTable table, int top, int bottom) {
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(27);
        }
        Rectangle rectangle = table.getCellRect(top, 0, true).union(table.getCellRect(bottom, 0, true));
        if (rectangle == null) {
            ScrollingUtil.$$$reportNull$$$0(28);
        }
        return rectangle;
    }

    private static int visibleRowCount(JComponent c) {
        if (c instanceof JList) {
            return ScrollingUtil.getVisibleRowCount((JList)c);
        }
        if (c instanceof JTable) {
            return ScrollingUtil.getVisibleRowCount((JTable)c);
        }
        return -1;
    }

    private static int getVisibleRowCount(@NotNull JTable table) {
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(29);
        }
        Rectangle visibleRect = table.getVisibleRect();
        return ScrollingUtil.getTrailingRow(table, visibleRect) - ScrollingUtil.getLeadingRow(table, visibleRect) + 1;
    }

    @NotNull
    public static Couple<Integer> getVisibleRows(@NotNull JTable table) {
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(30);
        }
        Rectangle visibleRect = table.getVisibleRect();
        Couple couple = Couple.of((Object)ScrollingUtil.getLeadingRow(table, visibleRect), (Object)ScrollingUtil.getTrailingRow(table, visibleRect));
        if (couple == null) {
            ScrollingUtil.$$$reportNull$$$0(31);
        }
        return couple;
    }

    private static int getLeadingRow(@NotNull JTable table, @NotNull Rectangle visibleRect) {
        int row;
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(32);
        }
        if (visibleRect == null) {
            ScrollingUtil.$$$reportNull$$$0(33);
        }
        if ((row = table.rowAtPoint(ScrollingUtil.getLeadingPoint(table, visibleRect))) >= 0) {
            return row;
        }
        return 0 < table.getRowCount() ? 0 : -1;
    }

    @NotNull
    private static Point getLeadingPoint(@NotNull JTable table, @NotNull Rectangle visibleRect) {
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(34);
        }
        if (visibleRect == null) {
            ScrollingUtil.$$$reportNull$$$0(35);
        }
        if (table.getComponentOrientation().isLeftToRight()) {
            return new Point(visibleRect.x, visibleRect.y);
        }
        return new Point(visibleRect.x + visibleRect.width, visibleRect.y);
    }

    public static int getReadableRow(@NotNull JTable table, int maximumHiddenPart) {
        int column;
        Rectangle visibleRect;
        int row;
        Point leadingPoint;
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(36);
        }
        if ((double)leadingPoint.y - table.getCellRect(row = table.rowAtPoint(leadingPoint = ScrollingUtil.getLeadingPoint(table, visibleRect = table.getVisibleRect())), column = table.columnAtPoint(leadingPoint), true).getY() <= (double)maximumHiddenPart) {
            return row;
        }
        return Math.min(row + 1, table.getRowCount() - 1);
    }

    public static boolean isVisible(@NotNull JTable table, int row) {
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(37);
        }
        Rectangle visibleRect = table.getVisibleRect();
        int start = ScrollingUtil.getLeadingRow(table, visibleRect);
        int end = ScrollingUtil.getTrailingRow(table, visibleRect);
        return row >= start && row <= end;
    }

    private static int getTrailingRow(@NotNull JTable table, @NotNull Rectangle visibleRect) {
        Point trailingPoint;
        int row;
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(38);
        }
        if (visibleRect == null) {
            ScrollingUtil.$$$reportNull$$$0(39);
        }
        if ((row = table.rowAtPoint(trailingPoint = table.getComponentOrientation().isLeftToRight() ? new Point(visibleRect.x, visibleRect.y + visibleRect.height - 1) : new Point(visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height - 1))) >= 0) {
            return row;
        }
        return table.getRowCount() - 1;
    }

    public static void moveDown(@NotNull JTable table, @JdkConstants.InputEventMask int modifiers, boolean cycleScrolling) {
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(40);
        }
        ScrollingUtil._moveDown(table, table.getSelectionModel(), modifiers, table.getRowCount(), cycleScrolling);
    }

    public static void moveUp(@NotNull JList<?> list, @JdkConstants.InputEventMask int modifiers) {
        if (list == null) {
            ScrollingUtil.$$$reportNull$$$0(41);
        }
        ScrollingUtil._moveUp(list, list.getSelectionModel(), list.getModel().getSize(), modifiers, UISettings.getInstance().getCycleScrolling());
    }

    public static void moveUp(@NotNull JTable table, @JdkConstants.InputEventMask int modifiers, boolean cycleScrolling) {
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(42);
        }
        ScrollingUtil._moveUp(table, table.getSelectionModel(), table.getModel().getRowCount(), modifiers, cycleScrolling);
    }

    private static void _moveDown(@NotNull JComponent c, @NotNull ListSelectionModel selectionModel, @JdkConstants.InputEventMask int modifiers, int size, boolean cycleScrolling) {
        if (c == null) {
            ScrollingUtil.$$$reportNull$$$0(43);
        }
        if (selectionModel == null) {
            ScrollingUtil.$$$reportNull$$$0(44);
        }
        ScrollingUtil._move(c, selectionModel, modifiers, size, cycleScrolling, 1);
    }

    private static void _move(@NotNull JComponent c, @NotNull ListSelectionModel selectionModel, @JdkConstants.InputEventMask int modifiers, int size, boolean cycleScrolling, int direction) {
        if (c == null) {
            ScrollingUtil.$$$reportNull$$$0(45);
        }
        if (selectionModel == null) {
            ScrollingUtil.$$$reportNull$$$0(46);
        }
        if (size == 0) {
            return;
        }
        int index = selectionModel.getLeadSelectionIndex();
        int indexToSelect = index + direction;
        if (indexToSelect < 0 || indexToSelect >= size) {
            if (cycleScrolling) {
                indexToSelect = indexToSelect < 0 ? size - 1 : 0;
            } else {
                return;
            }
        }
        ScrollingUtil._ensureIndexIsVisible(c, indexToSelect, -1, size);
        ScrollingUtil.selectOrAddSelection(selectionModel, indexToSelect, modifiers);
    }

    private static void _moveUp(@NotNull JComponent c, @NotNull ListSelectionModel selectionModel, int size, @JdkConstants.InputEventMask int modifiers, boolean cycleScrolling) {
        if (c == null) {
            ScrollingUtil.$$$reportNull$$$0(47);
        }
        if (selectionModel == null) {
            ScrollingUtil.$$$reportNull$$$0(48);
        }
        ScrollingUtil._move(c, selectionModel, modifiers, size, cycleScrolling, -1);
    }

    public static void moveHome(@NotNull JTable table) {
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(49);
        }
        table.getSelectionModel().setSelectionInterval(0, 0);
        ScrollingUtil.ensureIndexIsVisible(table, 0, 0);
    }

    public static void moveEnd(@NotNull JTable table) {
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(50);
        }
        int index = table.getModel().getRowCount() - 1;
        table.getSelectionModel().setSelectionInterval(index, index);
        ScrollingUtil.ensureIndexIsVisible(table, index, 0);
    }

    public static void movePageUp(@NotNull JTable table) {
        int visible;
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(51);
        }
        if ((visible = ScrollingUtil.getVisibleRowCount(table)) <= 0) {
            ScrollingUtil.moveHome(table);
            return;
        }
        int step = visible - 1;
        ListSelectionModel selectionModel = table.getSelectionModel();
        int index = Math.max(selectionModel.getMinSelectionIndex() - step, 0);
        int visibleIndex = ScrollingUtil.getLeadingRow(table, table.getVisibleRect());
        int top = visibleIndex - step;
        if (top < 0) {
            top = 0;
        }
        int bottom = top + visible - 1;
        ScrollingUtil._scrollAfterPageMove(table, top, bottom, index);
    }

    public static void movePageDown(@NotNull JTable table) {
        int visible;
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(52);
        }
        if ((visible = ScrollingUtil.getVisibleRowCount(table)) <= 0) {
            ScrollingUtil.moveEnd(table);
            return;
        }
        ListSelectionModel selectionModel = table.getSelectionModel();
        int step = visible - 1;
        int firstVisibleRow = ScrollingUtil.getLeadingRow(table, table.getVisibleRect());
        int top = firstVisibleRow + step;
        int bottom = top + visible - 1;
        int size = table.getModel().getRowCount();
        int index = Math.min(selectionModel.getMinSelectionIndex() + step, size - 1);
        ScrollingUtil._scrollAfterPageMove(table, top, bottom, index);
    }

    private static void _scrollAfterPageMove(@NotNull JTable table, int top, int bottom, int index) {
        int size;
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(53);
        }
        if (bottom >= (size = table.getModel().getRowCount())) {
            bottom = size - 1;
        }
        Rectangle cellBounds = ScrollingUtil.getCellBounds(table, top, bottom);
        table.scrollRectToVisible(cellBounds);
        table.getSelectionModel().setSelectionInterval(index, index);
        ScrollingUtil.ensureIndexIsVisible(table, index, 0);
    }

    public static void installActions(@NotNull JTable table) {
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(54);
        }
        ScrollingUtil.installActions(table, UISettings.getInstance().getCycleScrolling());
    }

    public static boolean isEmpty(JComponent component) {
        if (component instanceof JTable) {
            return ((JTable)component).getRowCount() < 1;
        }
        if (component instanceof JList) {
            return ((JList)component).getModel().getSize() < 1;
        }
        return false;
    }

    public static void installActions(@NotNull JTable table, boolean cycleScrolling) {
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(55);
        }
        ScrollingUtil.installActions(table, cycleScrolling, null);
    }

    public static void installActions(final @NotNull JTable table, final boolean cycleScrolling, @Nullable JComponent focusParent) {
        if (table == null) {
            ScrollingUtil.$$$reportNull$$$0(56);
        }
        ActionMap actionMap = table.getActionMap();
        actionMap.put(SCROLL_UP_ACTION_ID, new MoveAction(SCROLL_UP_ACTION_ID, table, cycleScrolling));
        actionMap.put(SCROLL_DOWN_ACTION_ID, new MoveAction(SCROLL_DOWN_ACTION_ID, table, cycleScrolling));
        actionMap.put(SELECT_PREVIOUS_ROW_ACTION_ID, new MoveAction(SELECT_PREVIOUS_ROW_ACTION_ID, table, cycleScrolling));
        actionMap.put(SELECT_NEXT_ROW_ACTION_ID, new MoveAction(SELECT_NEXT_ROW_ACTION_ID, table, cycleScrolling));
        actionMap.put(SELECT_LAST_ROW_ACTION_ID, new MoveAction(SELECT_LAST_ROW_ACTION_ID, table, cycleScrolling));
        actionMap.put(SELECT_FIRST_ROW_ACTION_ID, new MoveAction(SELECT_FIRST_ROW_ACTION_ID, table, cycleScrolling));
        ScrollingUtil.maybeInstallDefaultShortcuts(table);
        final JComponent target = focusParent == null ? table : focusParent;
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                ScrollingUtil.moveHome(table);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$8", "actionPerformed"));
            }
        }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(37, 0)), table);
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                ScrollingUtil.moveEnd(table);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$9", "actionPerformed"));
            }
        }.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(39, 0)), table);
        if (!(focusParent instanceof JTextComponent)) {
            new MyScrollingAction(table){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    ScrollingUtil.moveHome(table);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$10", "actionPerformed"));
                }
            }.registerCustomShortcutSet(CommonShortcuts.getMoveHome(), target);
            new MyScrollingAction(table){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        11.$$$reportNull$$$0(0);
                    }
                    ScrollingUtil.moveEnd(table);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$11", "actionPerformed"));
                }
            }.registerCustomShortcutSet(CommonShortcuts.getMoveEnd(), target);
        }
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    12.$$$reportNull$$$0(0);
                }
                ScrollingUtil.moveDown(table, e.getModifiers(), cycleScrolling);
            }

            @Override
            protected boolean isEnabled() {
                return super.isEnabled() && !ScrollingUtil.isMultiline(target);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$12", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.getMoveDown(), target);
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    13.$$$reportNull$$$0(0);
                }
                ScrollingUtil.moveUp(table, e.getModifiers(), cycleScrolling);
            }

            @Override
            protected boolean isEnabled() {
                return super.isEnabled() && !ScrollingUtil.isMultiline(target);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$13", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.getMoveUp(), target);
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    14.$$$reportNull$$$0(0);
                }
                ScrollingUtil.movePageUp(table);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$14", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.getMovePageUp(), target);
        new MyScrollingAction(table){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    15.$$$reportNull$$$0(0);
                }
                ScrollingUtil.movePageDown(table);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ScrollingUtil$15", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.getMovePageDown(), target);
    }

    private static boolean isMultiline(@NotNull JComponent component) {
        if (component == null) {
            ScrollingUtil.$$$reportNull$$$0(57);
        }
        return component instanceof JTextArea && ((JTextArea)component).getText().contains("\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 28: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 28: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 8: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 9: 
            case 11: 
            case 43: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 15: 
            case 44: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 25: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ScrollingUtil";
                break;
            }
            case 33: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ScrollingUtil";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellBounds";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleRows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectItem";
                break;
            }
            case 1: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "ensureSelectionExists";
                break;
            }
            case 4: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "movePageDown";
                break;
            }
            case 5: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "moveHome";
                break;
            }
            case 6: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "moveEnd";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ensureIndexIsVisible";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "_ensureIndexIsVisible";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "ensureRangeIsVisible";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "_ensureRangeIsVisible";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isIndexFullyVisible";
                break;
            }
            case 13: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleRowCount";
                break;
            }
            case 14: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "moveDown";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "selectOrAddSelection";
                break;
            }
            case 16: 
            case 17: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "installActions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "redirectExpandSelection";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "installMoveEndAction";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "installMoveHomeAction";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "installMovePageDownAction";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "installMovePageUpAction";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "installMoveDownAction";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "installMoveUpAction";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "maybeInstallDefaultShortcuts";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCellBounds";
                break;
            }
            case 28: 
            case 31: {
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleRows";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getLeadingRow";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getLeadingPoint";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getReadableRow";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getTrailingRow";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "moveUp";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "_moveDown";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "_move";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "_moveUp";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "movePageUp";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "_scrollAfterPageMove";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isMultiline";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 28: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MoveAction
    extends AbstractAction {
        private final String myId;
        private final JComponent myComponent;
        private final Boolean myCycleScrolling;

        MoveAction(@NotNull String id, @NotNull JComponent component, @Nullable Boolean cycleScrolling) {
            if (id == null) {
                MoveAction.$$$reportNull$$$0(0);
            }
            if (component == null) {
                MoveAction.$$$reportNull$$$0(1);
            }
            this.myId = id;
            this.myComponent = component;
            this.myCycleScrolling = cycleScrolling;
        }

        MoveAction(@NotNull String id, @NotNull JComponent component) {
            if (id == null) {
                MoveAction.$$$reportNull$$$0(2);
            }
            if (component == null) {
                MoveAction.$$$reportNull$$$0(3);
            }
            this(id, component, null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int modifiers = e.getModifiers();
            if (ScrollingUtil.SCROLL_UP_ACTION_ID.equals(this.myId)) {
                this.doPageUp();
            } else if (ScrollingUtil.SCROLL_DOWN_ACTION_ID.equals(this.myId)) {
                this.doPageDown();
            } else if (ScrollingUtil.SELECT_PREVIOUS_ROW_ACTION_ID.equals(this.myId)) {
                this.doMoveUp(modifiers);
            } else if (ScrollingUtil.SELECT_NEXT_ROW_ACTION_ID.equals(this.myId)) {
                this.doMoveDown(modifiers);
            } else if (ScrollingUtil.SELECT_LAST_ROW_ACTION_ID.equals(this.myId)) {
                this.doMoveEnd();
            } else if (ScrollingUtil.SELECT_FIRST_ROW_ACTION_ID.equals(this.myId)) {
                this.doMoveHome();
            } else if (ScrollingUtil.MOVE_END_ID.equals(this.myId)) {
                this.doMoveEnd();
            } else if (ScrollingUtil.MOVE_HOME_ID.equals(this.myId)) {
                this.doMoveHome();
            }
        }

        private void doMoveEnd() {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.moveEnd((JList)this.myComponent);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.moveEnd((JTable)this.myComponent);
            } else {
                throw new IllegalArgumentException("MoveEnd is not implemented for " + this.myComponent.getClass());
            }
        }

        private void doMoveHome() {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.moveHome((JList)this.myComponent);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.moveHome((JTable)this.myComponent);
            } else {
                throw new IllegalArgumentException("MoveHome is not implemented for " + this.myComponent.getClass());
            }
        }

        private void doMoveUp(@JdkConstants.InputEventMask int modifiers) {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.moveUp((JList)this.myComponent, modifiers);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.moveUp((JTable)this.myComponent, modifiers, this.isCycleScrolling());
            } else {
                throw new IllegalArgumentException("MoveUp is not implemented for " + this.myComponent.getClass());
            }
        }

        private void doMoveDown(@JdkConstants.InputEventMask int modifiers) {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.moveDown((JList)this.myComponent, modifiers);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.moveDown((JTable)this.myComponent, modifiers, this.isCycleScrolling());
            } else {
                throw new IllegalArgumentException("MoveDown is not implemented for " + this.myComponent.getClass());
            }
        }

        private void doPageUp() {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.movePageUp((JList)this.myComponent);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.movePageUp((JTable)this.myComponent);
            } else {
                throw new IllegalArgumentException("PageUp is not implemented for " + this.myComponent.getClass());
            }
        }

        private void doPageDown() {
            if (this.myComponent instanceof JList) {
                ScrollingUtil.movePageDown((JList)this.myComponent);
            } else if (this.myComponent instanceof JTable) {
                ScrollingUtil.movePageDown((JTable)this.myComponent);
            } else {
                throw new IllegalArgumentException("PageDown is not implemented for " + this.myComponent.getClass());
            }
        }

        private boolean isCycleScrolling() {
            return this.myCycleScrolling == null ? UISettings.getInstance().getCycleScrolling() : this.myCycleScrolling.booleanValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/ScrollingUtil$MoveAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class MyScrollingAction
    extends DumbAwareAction
    implements ScrollingAction {
        private final JComponent myComponent;

        MyScrollingAction(@NotNull JComponent component) {
            if (component == null) {
                MyScrollingAction.$$$reportNull$$$0(0);
            }
            this.myComponent = component;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyScrollingAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.isEnabled());
        }

        protected boolean isEnabled() {
            return SpeedSearchSupply.getSupply(this.myComponent) == null && !ScrollingUtil.isEmpty(this.myComponent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/ScrollingUtil$MyScrollingAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ListScrollAction
    extends MyScrollingAction {
        protected ListScrollAction(@NotNull ShortcutSet shortcutSet, @NotNull JComponent component) {
            if (shortcutSet == null) {
                ListScrollAction.$$$reportNull$$$0(0);
            }
            if (component == null) {
                ListScrollAction.$$$reportNull$$$0(1);
            }
            super(component);
            this.registerCustomShortcutSet(shortcutSet, component);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "shortcutSet";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/ScrollingUtil$ListScrollAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ScrollingAction
    extends DumbAware {
    }
}

