/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.model.BranchService;
import com.intellij.model.BranchedVirtualFile;
import com.intellij.model.ModelPatch;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface ModelBranch {
    @NotNull
    public static ModelPatch performInBranch(@NotNull Project project, @NotNull Consumer<ModelBranch> action) {
        if (project == null) {
            ModelBranch.$$$reportNull$$$0(0);
        }
        if (action == null) {
            ModelBranch.$$$reportNull$$$0(1);
        }
        ModelPatch modelPatch = BranchService.getInstance().performInBranch(project, action);
        if (modelPatch == null) {
            ModelBranch.$$$reportNull$$$0(2);
        }
        return modelPatch;
    }

    @Nullable
    public VirtualFile findFileCopy(@NotNull VirtualFile var1);

    @Nullable
    public <T extends PsiElement> T findPsiCopy(@NotNull T var1);

    @Nullable
    public <T extends PsiSymbolReference> T findReferenceCopy(@NotNull T var1);

    @NotNull
    public <T extends PsiElement> T obtainPsiCopy(@NotNull T var1);

    @Nullable
    public <T extends PsiElement> T findOriginalPsi(@NotNull T var1);

    @Nullable
    public VirtualFile findOriginalFile(@NotNull VirtualFile var1);

    @Nullable
    public static ModelBranch getPsiBranch(@NotNull PsiElement element) {
        if (element == null) {
            ModelBranch.$$$reportNull$$$0(3);
        }
        return ModelBranch.getFileBranch(element.getContainingFile().getViewProvider().getVirtualFile());
    }

    @Nullable
    public static ModelBranch getFileBranch(@NotNull VirtualFile file) {
        if (file == null) {
            ModelBranch.$$$reportNull$$$0(4);
        }
        return file instanceof BranchedVirtualFile ? ((BranchedVirtualFile)file).branch : null;
    }

    public long getBranchedPsiModificationCount();

    public void runAfterMerge(@NotNull Runnable var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/model/ModelBranch";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/model/ModelBranch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "performInBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performInBranch";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiBranch";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileBranch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

