/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Function;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineMarkerInfo<T extends PsiElement> {
    private static final Logger LOG = Logger.getInstance(LineMarkerInfo.class);
    protected final Icon myIcon;
    private final SmartPsiElementPointer<T> elementRef;
    public final int startOffset;
    public final int endOffset;
    public Color separatorColor;
    public SeparatorPlacement separatorPlacement;
    public RangeHighlighter highlighter;
    public final int updatePass;
    private final Function<? super T, String> myTooltipProvider;
    private AnAction myNavigateAction;
    @NotNull
    private final GutterIconRenderer.Alignment myIconAlignment;
    private final GutterIconNavigationHandler<T> myNavigationHandler;

    public LineMarkerInfo(@NotNull T element, @NotNull TextRange range, @Nullable Icon icon, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (element == null) {
            LineMarkerInfo.$$$reportNull$$$0(0);
        }
        if (range == null) {
            LineMarkerInfo.$$$reportNull$$$0(1);
        }
        if (alignment == null) {
            LineMarkerInfo.$$$reportNull$$$0(2);
        }
        this(LineMarkerInfo.createElementRef(element, range), range, icon, tooltipProvider, navHandler, alignment);
    }

    @NotNull
    private static <T extends PsiElement> SmartPsiElementPointer<T> createElementRef(@NotNull T element, @NotNull TextRange range) {
        PsiElement firstChild;
        PsiFile containingFile;
        Project project;
        TextRange topLevelRange;
        if (element == null) {
            LineMarkerInfo.$$$reportNull$$$0(3);
        }
        if (range == null) {
            LineMarkerInfo.$$$reportNull$$$0(4);
        }
        if (!(topLevelRange = InjectedLanguageManager.getInstance(project = (containingFile = element.getContainingFile()).getProject()).getTopLevelFile(containingFile).getTextRange()).contains(range)) {
            throw new IllegalArgumentException("Range must be inside file offsets " + topLevelRange + " but got: " + range);
        }
        if (!(element instanceof PsiFile) && (firstChild = element.getFirstChild()) != null) {
            String msg = "Performance warning: LineMarker is supposed to be registered for leaf elements only, but got: " + element + " (" + element.getClass() + ") instead. First child: " + firstChild + " (" + firstChild.getClass() + ")\nPlease see LineMarkerProvider#getLineMarkerInfo(PsiElement) javadoc for detailed explanations.";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(msg);
            } else {
                LOG.warn(msg);
            }
        }
        SmartPsiElementPointer<T> smartPsiElementPointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(element, containingFile);
        if (smartPsiElementPointer == null) {
            LineMarkerInfo.$$$reportNull$$$0(5);
        }
        return smartPsiElementPointer;
    }

    protected LineMarkerInfo(@NotNull SmartPsiElementPointer<T> elementRef, @NotNull TextRange range, @Nullable Icon icon, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (elementRef == null) {
            LineMarkerInfo.$$$reportNull$$$0(6);
        }
        if (range == null) {
            LineMarkerInfo.$$$reportNull$$$0(7);
        }
        if (alignment == null) {
            LineMarkerInfo.$$$reportNull$$$0(8);
        }
        this.myNavigateAction = new NavigateAction(this);
        this.myIcon = icon;
        this.myTooltipProvider = tooltipProvider;
        this.myIconAlignment = alignment;
        this.elementRef = elementRef;
        this.myNavigationHandler = navHandler;
        this.startOffset = range.getStartOffset();
        this.endOffset = range.getEndOffset();
        this.updatePass = 11;
    }

    @Deprecated
    public LineMarkerInfo(@NotNull T element, @NotNull TextRange range, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (element == null) {
            LineMarkerInfo.$$$reportNull$$$0(9);
        }
        if (range == null) {
            LineMarkerInfo.$$$reportNull$$$0(10);
        }
        if (alignment == null) {
            LineMarkerInfo.$$$reportNull$$$0(11);
        }
        this((T)element, range, icon, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, alignment);
    }

    @Deprecated
    public LineMarkerInfo(@NotNull T element, int startOffset, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (element == null) {
            LineMarkerInfo.$$$reportNull$$$0(12);
        }
        if (alignment == null) {
            LineMarkerInfo.$$$reportNull$$$0(13);
        }
        this((T)element, new TextRange(startOffset, startOffset), icon, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, alignment);
    }

    @Deprecated
    public LineMarkerInfo(@NotNull T element, int startOffset, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler) {
        if (element == null) {
            LineMarkerInfo.$$$reportNull$$$0(14);
        }
        this((T)element, new TextRange(startOffset, startOffset), icon, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, GutterIconRenderer.Alignment.RIGHT);
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public GutterIconRenderer createGutterRenderer() {
        if (this.myIcon == null) {
            return null;
        }
        return new LineMarkerGutterIconRenderer(this);
    }

    public String getLineMarkerTooltip() {
        if (this.myTooltipProvider == null) {
            return null;
        }
        T element = this.getElement();
        return element == null || !element.isValid() ? null : (String)this.myTooltipProvider.fun(element);
    }

    @Nullable
    public T getElement() {
        return this.elementRef.getElement();
    }

    void setNavigateAction(@NotNull AnAction navigateAction) {
        if (navigateAction == null) {
            LineMarkerInfo.$$$reportNull$$$0(15);
        }
        this.myNavigateAction = navigateAction;
    }

    @NotNull
    public MarkupEditorFilter getEditorFilter() {
        MarkupEditorFilter markupEditorFilter = MarkupEditorFilter.EMPTY;
        if (markupEditorFilter == null) {
            LineMarkerInfo.$$$reportNull$$$0(16);
        }
        return markupEditorFilter;
    }

    public GutterIconNavigationHandler<T> getNavigationHandler() {
        return this.myNavigationHandler;
    }

    public String toString() {
        return "(" + this.startOffset + "," + this.endOffset + ") -> " + this.elementRef + " (icon: " + this.myIcon + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignment";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/LineMarkerInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementRef";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigateAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/LineMarkerInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createElementRef";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createElementRef";
                break;
            }
            case 5: 
            case 16: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setNavigateAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LineMarkerGutterIconRenderer<T extends PsiElement>
    extends GutterIconRenderer {
        private final LineMarkerInfo<T> myInfo;

        public LineMarkerGutterIconRenderer(@NotNull LineMarkerInfo<T> info) {
            if (info == null) {
                LineMarkerGutterIconRenderer.$$$reportNull$$$0(0);
            }
            if (info.myIcon == null) {
                throw new IllegalArgumentException("Must supply not-null icon for the gutter, but got: " + info);
            }
            this.myInfo = info;
        }

        @NotNull
        public LineMarkerInfo<T> getLineMarkerInfo() {
            LineMarkerInfo<T> lineMarkerInfo = this.myInfo;
            if (lineMarkerInfo == null) {
                LineMarkerGutterIconRenderer.$$$reportNull$$$0(1);
            }
            return lineMarkerInfo;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = this.myInfo.myIcon;
            if (icon == null) {
                LineMarkerGutterIconRenderer.$$$reportNull$$$0(2);
            }
            return icon;
        }

        @Override
        public AnAction getClickAction() {
            return ((LineMarkerInfo)this.myInfo).myNavigateAction;
        }

        @Override
        public boolean isNavigateAction() {
            return ((LineMarkerInfo)this.myInfo).myNavigationHandler != null;
        }

        @Override
        public String getTooltipText() {
            try {
                return this.myInfo.getLineMarkerTooltip();
            }
            catch (IndexNotReadyException ignored) {
                return null;
            }
        }

        @Override
        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            GutterIconRenderer.Alignment alignment = ((LineMarkerInfo)this.myInfo).myIconAlignment;
            if (alignment == null) {
                LineMarkerGutterIconRenderer.$$$reportNull$$$0(3);
            }
            return alignment;
        }

        protected boolean looksTheSameAs(@NotNull LineMarkerGutterIconRenderer<?> renderer) {
            if (renderer == null) {
                LineMarkerGutterIconRenderer.$$$reportNull$$$0(4);
            }
            return this.myInfo.getElement() != null && renderer.myInfo.getElement() != null && this.myInfo.getElement() == renderer.myInfo.getElement() && Comparing.equal((Object)((LineMarkerInfo)this.myInfo).myTooltipProvider, (Object)((LineMarkerInfo)renderer.myInfo).myTooltipProvider) && Comparing.equal((Object)this.myInfo.myIcon, (Object)renderer.myInfo.myIcon);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof LineMarkerGutterIconRenderer && this.looksTheSameAs((LineMarkerGutterIconRenderer)obj);
        }

        @Override
        public int hashCode() {
            T element = this.myInfo.getElement();
            return element == null ? 0 : element.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/LineMarkerInfo$LineMarkerGutterIconRenderer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/LineMarkerInfo$LineMarkerGutterIconRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineMarkerInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlignment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "looksTheSameAs";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

