/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.Alarm;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetPreviewHint
extends LightweightHint
implements Disposable {
    private static final Key<EmmetPreviewHint> KEY = new Key("emmet.preview");
    @NotNull
    private final Editor myParentEditor;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final Alarm myAlarm;
    private boolean isDisposed;

    private EmmetPreviewHint(@NotNull JBPanel panel, @NotNull Editor editor, @NotNull Editor parentEditor) {
        if (panel == null) {
            EmmetPreviewHint.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            EmmetPreviewHint.$$$reportNull$$$0(1);
        }
        if (parentEditor == null) {
            EmmetPreviewHint.$$$reportNull$$$0(2);
        }
        super((JComponent)panel);
        this.myAlarm = new Alarm((Disposable)this);
        this.isDisposed = false;
        this.myParentEditor = parentEditor;
        this.myEditor = editor;
        final Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor((Editor)this.myParentEditor);
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event.getEditor() == EmmetPreviewHint.this.myParentEditor || event.getEditor() == EmmetPreviewHint.this.myEditor || event.getEditor() == topLevelEditor) {
                    EmmetPreviewHint.this.hide(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint$1", "editorReleased"));
            }
        }, (Disposable)this);
        this.myEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!EmmetPreviewHint.this.isDisposed && event.isWholeTextReplaced()) {
                    Pair position = EmmetPreviewHint.this.guessPosition();
                    HintManagerImpl.adjustEditorHintPosition((LightweightHint)EmmetPreviewHint.this, (Editor)EmmetPreviewHint.this.myParentEditor, (Point)((Point)position.first), (short)((Short)position.second));
                    EmmetPreviewHint.this.myEditor.getScrollingModel().scrollVertically(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint$2", "documentChanged"));
            }
        }, (Disposable)this);
    }

    public void showHint() {
        this.myParentEditor.putUserData(KEY, (Object)this);
        Pair<Point, Short> position = this.guessPosition();
        JRootPane pane = this.myParentEditor.getComponent().getRootPane();
        JComponent layeredPane = pane != null ? pane.getLayeredPane() : this.myParentEditor.getComponent();
        HintHint hintHint = new HintHint((Component)layeredPane, (Point)position.first).setAwtTooltip(true).setContentActive(true).setExplicitClose(true).setShowImmediately(true).setPreferredPosition((Short)position.second == 1 ? Balloon.Position.above : Balloon.Position.below).setTextBg(this.myParentEditor.getColorsScheme().getDefaultBackground()).setBorderInsets((Insets)JBUI.insets((int)1));
        int hintFlags = 145;
        HintManagerImpl.getInstanceImpl().showEditorHint((LightweightHint)this, this.myParentEditor, (Point)position.first, hintFlags, 0, false, hintHint);
    }

    public void updateText(@NotNull Supplier<String> contentProducer) {
        if (contentProducer == null) {
            EmmetPreviewHint.$$$reportNull$$$0(3);
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            if (!this.isDisposed) {
                String newText = (String)contentProducer.get();
                if (StringUtil.isEmpty((String)newText)) {
                    this.hide();
                } else if (!this.myEditor.getDocument().getText().equals(newText)) {
                    DocumentUtil.writeInRunUndoTransparentAction(() -> this.myEditor.getDocument().setText((CharSequence)newText));
                }
            }
        }, 100);
    }

    @NotNull
    public String getContent() {
        String string = this.myEditor.getDocument().getText();
        if (string == null) {
            EmmetPreviewHint.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static EmmetPreviewHint getExistingHint(@NotNull Editor parentEditor) {
        EmmetPreviewHint emmetPreviewHint;
        if (parentEditor == null) {
            EmmetPreviewHint.$$$reportNull$$$0(5);
        }
        if ((emmetPreviewHint = (EmmetPreviewHint)((Object)KEY.get((UserDataHolder)parentEditor))) != null) {
            if (!emmetPreviewHint.isDisposed) {
                return emmetPreviewHint;
            }
            emmetPreviewHint.hide();
        }
        return null;
    }

    @NotNull
    public static EmmetPreviewHint createHint(final @NotNull EditorEx parentEditor, @NotNull String templateText, @NotNull FileType fileType) {
        Document document;
        EditorFactory editorFactory;
        EditorEx previewEditor;
        MarkupModelEx model;
        if (parentEditor == null) {
            EmmetPreviewHint.$$$reportNull$$$0(6);
        }
        if (templateText == null) {
            EmmetPreviewHint.$$$reportNull$$$0(7);
        }
        if (fileType == null) {
            EmmetPreviewHint.$$$reportNull$$$0(8);
        }
        if ((model = (previewEditor = (EditorEx)(editorFactory = EditorFactory.getInstance()).createEditor(document = editorFactory.createDocument((CharSequence)templateText), parentEditor.getProject(), fileType, true)).getMarkupModel()) instanceof EditorMarkupModel) {
            ((EditorMarkupModel)model).setErrorStripeVisible(true);
        }
        final EditorSettings settings = previewEditor.getSettings();
        settings.setLineNumbersShown(false);
        settings.setAdditionalLinesCount(1);
        settings.setAdditionalColumnsCount(1);
        settings.setRightMarginShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setVirtualSpace(false);
        settings.setWheelFontChangeEnabled(false);
        settings.setAdditionalPageAtBottom(false);
        settings.setCaretRowShown(false);
        previewEditor.setCaretEnabled(false);
        previewEditor.setBorder((Border)JBUI.Borders.empty());
        JBPanel panel = new JBPanel(new BorderLayout()){

            @NotNull
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                Dimension parentEditorSize = parentEditor.getScrollPane().getSize();
                int maxWidth = (int)parentEditorSize.getWidth() / 3;
                int maxHeight = (int)parentEditorSize.getHeight() / 2;
                int width = settings.isUseSoftWraps() ? maxWidth : Math.min((int)size.getWidth(), maxWidth);
                int height = Math.min((int)size.getHeight(), maxHeight);
                return new Dimension(width, height);
            }

            @NotNull
            public Insets getInsets() {
                JBInsets jBInsets = JBUI.insets((int)1, (int)2, (int)0, (int)0);
                if (jBInsets == null) {
                    3.$$$reportNull$$$0(0);
                }
                return jBInsets;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint$3", "getInsets"));
            }
        };
        panel.setBackground(previewEditor.getBackgroundColor());
        panel.add((Component)previewEditor.getComponent(), (Object)"Center");
        return new EmmetPreviewHint(panel, (Editor)previewEditor, (Editor)parentEditor);
    }

    public boolean vetoesHiding() {
        return true;
    }

    public void hide(boolean ok) {
        super.hide(ok);
        ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose((Disposable)this));
    }

    public void dispose() {
        this.isDisposed = true;
        this.myAlarm.cancelAllRequests();
        EmmetPreviewHint existingBalloon = (EmmetPreviewHint)((Object)this.myParentEditor.getUserData(KEY));
        if (existingBalloon == this) {
            this.myParentEditor.putUserData(KEY, null);
        }
        if (!this.myEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor(this.myEditor);
        }
    }

    @NotNull
    private Pair<Point, Short> guessPosition() {
        boolean p2Ok;
        JRootPane rootPane = this.myParentEditor.getContentComponent().getRootPane();
        JComponent layeredPane = rootPane != null ? rootPane.getLayeredPane() : this.myParentEditor.getComponent();
        LogicalPosition logicalPosition = this.myParentEditor.getCaretModel().getLogicalPosition();
        LogicalPosition pos = new LogicalPosition(logicalPosition.line, logicalPosition.column);
        Point p1 = HintManagerImpl.getHintPosition((LightweightHint)this, (Editor)this.myParentEditor, (LogicalPosition)pos, (short)2);
        Point p2 = HintManagerImpl.getHintPosition((LightweightHint)this, (Editor)this.myParentEditor, (LogicalPosition)pos, (short)1);
        boolean p1Ok = p1.y + this.getComponent().getPreferredSize().height < layeredPane.getHeight();
        boolean bl = p2Ok = p2.y >= 0;
        if (p1Ok) {
            return new Pair((Object)p1, (Object)2);
        }
        if (p2Ok) {
            return new Pair((Object)p2, (Object)1);
        }
        int aboveSpace = p2.y;
        int underSpace = layeredPane.getHeight() - p1.y;
        return aboveSpace > underSpace ? new Pair((Object)new Point(p2.x, 0), (Object)2) : new Pair((Object)p1, (Object)1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentProducer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/EmmetPreviewHint";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/EmmetPreviewHint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExistingHint";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

