/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalFileCustomValidationRule
extends CustomValidationRule {
    private static final Logger LOG = Logger.getInstance(LocalFileCustomValidationRule.class);
    private WeakReference<CachedAllowedItems> myAllowedItemsRef;
    private final String myRuleId;
    private final Class myResourceHolder;
    private final String myRelativePath;

    protected LocalFileCustomValidationRule(@NotNull String ruleId, @NotNull Class resource, @NotNull String path) {
        if (ruleId == null) {
            LocalFileCustomValidationRule.$$$reportNull$$$0(0);
        }
        if (resource == null) {
            LocalFileCustomValidationRule.$$$reportNull$$$0(1);
        }
        if (path == null) {
            LocalFileCustomValidationRule.$$$reportNull$$$0(2);
        }
        this.myRuleId = ruleId;
        this.myResourceHolder = resource;
        this.myRelativePath = path;
    }

    @Override
    public boolean acceptRuleId(@Nullable String ruleId) {
        return this.myRuleId.equals(ruleId);
    }

    private boolean isAllowed(@NotNull String value) {
        if (value == null) {
            LocalFileCustomValidationRule.$$$reportNull$$$0(3);
        }
        CachedAllowedItems allowed = this.getAllowedItems();
        return allowed.contains(value);
    }

    @NotNull
    private synchronized CachedAllowedItems getAllowedItems() {
        CachedAllowedItems allowed = (CachedAllowedItems)SoftReference.dereference(this.myAllowedItemsRef);
        if (allowed != null) {
            CachedAllowedItems cachedAllowedItems = allowed;
            if (cachedAllowedItems == null) {
                LocalFileCustomValidationRule.$$$reportNull$$$0(4);
            }
            return cachedAllowedItems;
        }
        CachedAllowedItems items = this.create();
        this.myAllowedItemsRef = new WeakReference<CachedAllowedItems>(items);
        CachedAllowedItems cachedAllowedItems = items;
        if (cachedAllowedItems == null) {
            LocalFileCustomValidationRule.$$$reportNull$$$0(5);
        }
        return cachedAllowedItems;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private CachedAllowedItems create() {
        block11: {
            BufferedReader reader;
            block10: {
                InputStream resourceStream = this.myResourceHolder.getResourceAsStream(this.myRelativePath);
                if (resourceStream == null) {
                    throw new IOException("Resource " + this.myRelativePath + " not found");
                }
                reader = new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
                List values = FileUtil.loadLines((BufferedReader)reader);
                if (values.isEmpty()) break block10;
                CachedAllowedItems cachedAllowedItems = CachedAllowedItems.create(ContainerUtil.map2SetNotNull((Collection)values, value -> this.createValue((String)value)));
                reader.close();
                CachedAllowedItems cachedAllowedItems2 = cachedAllowedItems;
                if (cachedAllowedItems2 == null) {
                    LocalFileCustomValidationRule.$$$reportNull$$$0(6);
                }
                return cachedAllowedItems2;
            }
            try {
                reader.close();
                break block11;
                {
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        CachedAllowedItems cachedAllowedItems = CachedAllowedItems.empty();
        if (cachedAllowedItems == null) {
            LocalFileCustomValidationRule.$$$reportNull$$$0(7);
        }
        return cachedAllowedItems;
    }

    @Nullable
    protected String createValue(String value) {
        return value.trim();
    }

    @Override
    @NotNull
    protected final ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        if (data == null) {
            LocalFileCustomValidationRule.$$$reportNull$$$0(8);
        }
        if (context == null) {
            LocalFileCustomValidationRule.$$$reportNull$$$0(9);
        }
        if (LocalFileCustomValidationRule.isThirdPartyValue(data) || this.isAllowed(data)) {
            ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
            if (validationResultType == null) {
                LocalFileCustomValidationRule.$$$reportNull$$$0(10);
            }
            return validationResultType;
        }
        ValidationResultType validationResultType = ValidationResultType.REJECTED;
        if (validationResultType == null) {
            LocalFileCustomValidationRule.$$$reportNull$$$0(11);
        }
        return validationResultType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/LocalFileCustomValidationRule";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/LocalFileCustomValidationRule";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedItems";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAllowed";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doValidate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedAllowedItems {
        private final Set<String> myValues;

        private CachedAllowedItems(@NotNull Set<String> values) {
            if (values == null) {
                CachedAllowedItems.$$$reportNull$$$0(0);
            }
            this.myValues = values;
        }

        public boolean contains(@NotNull String value) {
            if (value == null) {
                CachedAllowedItems.$$$reportNull$$$0(1);
            }
            return this.myValues.contains(value);
        }

        @NotNull
        public static CachedAllowedItems create(@NotNull Set<String> values) {
            if (values == null) {
                CachedAllowedItems.$$$reportNull$$$0(2);
            }
            return new CachedAllowedItems(values);
        }

        @NotNull
        public static CachedAllowedItems empty() {
            return new CachedAllowedItems(Collections.emptySet());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/LocalFileCustomValidationRule$CachedAllowedItems";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

