/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VariantsProcessor
implements PsiScopeProcessor {
    protected final PsiElement myContext;
    @Nullable
    protected final Condition<PsiElement> myNodeFilter;
    @Nullable
    protected final Condition<String> myNameFilter;
    protected final boolean myPlainNamesOnly;
    @Nullable
    private Set<String> myAllowedNames;
    @NotNull
    private final Set<String> mySeenNames = new HashSet<String>();

    public VariantsProcessor(PsiElement context) {
        this(context, null, null, false);
    }

    public VariantsProcessor(PsiElement context, @Nullable Condition<PsiElement> nodeFilter, @Nullable Condition<String> nameFilter) {
        this(context, nodeFilter, nameFilter, false);
    }

    public VariantsProcessor(PsiElement context, @Nullable Condition<PsiElement> nodeFilter, @Nullable Condition<String> nameFilter, boolean plainNamesOnly) {
        this.myContext = context;
        this.myNodeFilter = nodeFilter;
        this.myNameFilter = nameFilter;
        this.myPlainNamesOnly = plainNamesOnly;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState substitutor) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(0);
        }
        if (substitutor == null) {
            VariantsProcessor.$$$reportNull$$$0(1);
        }
        if (this.myNodeFilter != null && !this.myNodeFilter.value((Object)element)) {
            return true;
        }
        if (element instanceof PsiNamedElement) {
            PsiNamedElement namedElement = (PsiNamedElement)element;
            String name = PyUtil.getElementNameWithoutExtension(namedElement);
            if (this.nameIsAcceptable(name)) {
                this.addElement(name, (PsiElement)namedElement);
            }
        } else if (element instanceof PyReferenceExpression) {
            PyReferenceExpression referenceExpression = (PyReferenceExpression)element;
            String name = referenceExpression.getReferencedName();
            if (this.nameIsAcceptable(name)) {
                this.addElement(name, (PsiElement)referenceExpression);
            }
        } else if (!(!(element instanceof PyImportedNameDefiner) || element instanceof PyImportElement && this.handleImportElement((PyImportElement)element))) {
            PyImportedNameDefiner definer = (PyImportedNameDefiner)element;
            for (PyElement expr : definer.iterateNames()) {
                if (expr == null || expr == this.myContext) continue;
                if (!expr.isValid()) {
                    throw new PsiInvalidElementAccessException((PsiElement)expr, "Definer: " + definer);
                }
                String name = expr instanceof PyFile ? FileUtilRt.getNameWithoutExtension((String)((PyFile)expr).getName()) : expr.getName();
                if (!this.nameIsAcceptable(name)) continue;
                this.addImportedElement(name, expr);
            }
        }
        return true;
    }

    private boolean handleImportElement(@NotNull PyImportElement importElement) {
        QualifiedName qName;
        if (importElement == null) {
            VariantsProcessor.$$$reportNull$$$0(2);
        }
        if ((qName = importElement.getImportedQName()) != null && qName.getComponentCount() == 1) {
            PsiElement resolved;
            String name;
            String string = name = importElement.getAsName() != null ? importElement.getAsName() : qName.getLastComponent();
            if (this.nameIsAcceptable(name) && (resolved = importElement.resolve()) instanceof PsiNamedElement) {
                this.addElement(name, resolved);
                return true;
            }
        }
        return false;
    }

    protected abstract void addElement(@NotNull String var1, @NotNull PsiElement var2);

    protected void addImportedElement(@NotNull String name, @NotNull PyElement element) {
        if (name == null) {
            VariantsProcessor.$$$reportNull$$$0(3);
        }
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(4);
        }
        this.addElement(name, (PsiElement)element);
    }

    protected void markAsProcessed(@NotNull String name) {
        if (name == null) {
            VariantsProcessor.$$$reportNull$$$0(5);
        }
        this.mySeenNames.add(name);
    }

    @Contract(value="null -> false")
    private boolean nameIsAcceptable(@Nullable String name) {
        if (name == null) {
            return false;
        }
        if (this.mySeenNames.contains(name)) {
            return false;
        }
        if (this.myNameFilter != null && !this.myNameFilter.value((Object)name)) {
            return false;
        }
        return this.myAllowedNames == null || this.myAllowedNames.contains(name);
    }

    public void setAllowedNames(@Nullable Collection<String> allowedNames) {
        this.myAllowedNames = allowedNames == null ? null : new HashSet<String>(allowedNames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importElement";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/resolve/VariantsProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleImportElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addImportedElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "markAsProcessed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

