/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHProjectRepositoriesManager;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0013J\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0014J\u0006\u0010\u001c\u001a\u00020\u0013J\u000e\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/github/AbstractGithubUrlGroupingAction;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "dynamicText", "Ljava/util/function/Supplier;", "", "dynamicDescription", "icon", "Ljavax/swing/Icon;", "(Ljava/util/function/Supplier;Ljava/util/function/Supplier;Ljavax/swing/Icon;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "canBePerformed", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "disableIfNoVisibleChildren", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "isEnabledAndVisible", "isPopup", "update", "intellij.vcs.github"})
public abstract class AbstractGithubUrlGroupingAction
extends ActionGroup
implements DumbAware {
    public final void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(this.isEnabledAndVisible(e));
    }

    protected boolean isEnabledAndVisible(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            return false;
        }
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GHProjectRepositoriesManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
        Collection collection = ((GHProjectRepositoriesManager)object).getKnownRepositories();
        boolean bl = false;
        return !collection.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray;
        AnActionEvent project;
        AnActionEvent anActionEvent = e;
        if (anActionEvent == null || (anActionEvent = (Project)anActionEvent.getData(CommonDataKeys.PROJECT)) == null) {
            Intrinsics.checkExpressionValueIsNotNull((Object)AnAction.EMPTY_ARRAY, (String)"AnAction.EMPTY_ARRAY");
            return AnAction.EMPTY_ARRAY;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)anActionEvent, (String)"e?.getData(CommonDataKey\u2026turn AnAction.EMPTY_ARRAY");
        AnActionEvent $this$service$iv = project = anActionEvent;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GHProjectRepositoriesManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
        Set<GHGitRepositoryMapping> repositories = ((GHProjectRepositoriesManager)object).getKnownRepositories();
        if (repositories.size() > 1) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = repositories;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GHGitRepositoryMapping gHGitRepositoryMapping = (GHGitRepositoryMapping)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                DumbAwareAction dumbAwareAction = new DumbAwareAction((GHGitRepositoryMapping)it, it.getGitRemote().getRemote().getName() + ": " + GithubUrlUtil.removeProtocolPrefix(it.getGitRemote().getUrl()), this, (Project)project){
                    final /* synthetic */ GHGitRepositoryMapping $it;
                    final /* synthetic */ AbstractGithubUrlGroupingAction this$0;
                    final /* synthetic */ Project $project$inlined;
                    {
                        this.$it = $captured_local_variable$1;
                        this.this$0 = abstractGithubUrlGroupingAction;
                        this.$project$inlined = project;
                        super($super_call_param$2);
                    }

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        this.this$0.actionPerformed(e, this.$project$inlined, this.$it);
                    }
                };
                collection.add(dumbAwareAction);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            AnAction[] anActionArray2 = thisCollection$iv.toArray(new AnAction[0]);
            if (anActionArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            anActionArray = anActionArray2;
        } else {
            anActionArray = AnAction.EMPTY_ARRAY;
            Intrinsics.checkExpressionValueIsNotNull((Object)AnAction.EMPTY_ARRAY, (String)"AnAction.EMPTY_ARRAY");
        }
        return anActionArray;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        block1: {
            Project project;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project2 == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"e.getData(CommonDataKeys.PROJECT) ?: return");
            Project $this$service$iv = project = project2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(GHProjectRepositoriesManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
            GHGitRepositoryMapping gHGitRepositoryMapping = (GHGitRepositoryMapping)CollectionsKt.singleOrNull((Iterable)((GHProjectRepositoriesManager)object).getKnownRepositories());
            if (gHGitRepositoryMapping == null) break block1;
            GHGitRepositoryMapping gHGitRepositoryMapping2 = gHGitRepositoryMapping;
            boolean bl = false;
            boolean bl2 = false;
            GHGitRepositoryMapping it = gHGitRepositoryMapping2;
            boolean bl3 = false;
            this.actionPerformed(e, project, it);
        }
    }

    public abstract void actionPerformed(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull GHGitRepositoryMapping var3);

    public final boolean canBePerformed(@NotNull DataContext context) {
        Project project;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Project project2 = (Project)context.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"context.getData(CommonDa\u2026.PROJECT) ?: return false");
        Project $this$service$iv = project = project2;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GHProjectRepositoriesManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
        return ((GHProjectRepositoriesManager)object).getKnownRepositories().size() == 1;
    }

    public final boolean isPopup() {
        return true;
    }

    public final boolean disableIfNoVisibleChildren() {
        return false;
    }

    public AbstractGithubUrlGroupingAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, @Nullable Icon icon) {
        Intrinsics.checkParameterIsNotNull(dynamicText, (String)"dynamicText");
        Intrinsics.checkParameterIsNotNull(dynamicDescription, (String)"dynamicDescription");
        super(dynamicText, dynamicDescription, icon);
    }
}

