/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtilRt;
import gnu.trove.Equality;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArrayUtil {
    public static final char[] EMPTY_CHAR_ARRAY = ArrayUtilRt.EMPTY_CHAR_ARRAY;
    public static final byte[] EMPTY_BYTE_ARRAY = ArrayUtilRt.EMPTY_BYTE_ARRAY;
    public static final int[] EMPTY_INT_ARRAY = ArrayUtilRt.EMPTY_INT_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY = ArrayUtilRt.EMPTY_STRING_ARRAY;
    public static final Class[] EMPTY_CLASS_ARRAY = ArrayUtilRt.EMPTY_CLASS_ARRAY;
    public static final long[] EMPTY_LONG_ARRAY = ArrayUtilRt.EMPTY_LONG_ARRAY;
    public static final File[] EMPTY_FILE_ARRAY = ArrayUtilRt.EMPTY_FILE_ARRAY;
    @Deprecated
    public static final CharSequence EMPTY_CHAR_SEQUENCE = new String();
    public static final ArrayFactory<String> STRING_ARRAY_FACTORY = ArrayUtil::newStringArray;
    public static final ArrayFactory<Object> OBJECT_ARRAY_FACTORY = ArrayUtil::newObjectArray;

    private ArrayUtil() {
    }

    @Contract(pure=true)
    public static byte @NotNull [] realloc(byte @NotNull [] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(0);
        }
        if (newSize == 0) {
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(1);
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        int oldSize = array.length;
        byte[] byArray = oldSize == newSize ? array : Arrays.copyOf(array, newSize);
        if (byArray == null) {
            ArrayUtil.$$$reportNull$$$0(2);
        }
        return byArray;
    }

    @Contract(pure=true)
    public static boolean @NotNull [] realloc(boolean @NotNull [] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(3);
        }
        if (newSize == 0) {
            if (ArrayUtilRt.EMPTY_BOOLEAN_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(4);
            }
            return ArrayUtilRt.EMPTY_BOOLEAN_ARRAY;
        }
        int oldSize = array.length;
        boolean[] blArray = oldSize == newSize ? array : Arrays.copyOf(array, newSize);
        if (blArray == null) {
            ArrayUtil.$$$reportNull$$$0(5);
        }
        return blArray;
    }

    @Contract(pure=true)
    public static short @NotNull [] realloc(short @NotNull [] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(6);
        }
        if (newSize == 0) {
            if (ArrayUtilRt.EMPTY_SHORT_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(7);
            }
            return ArrayUtilRt.EMPTY_SHORT_ARRAY;
        }
        int oldSize = array.length;
        short[] sArray = oldSize == newSize ? array : Arrays.copyOf(array, newSize);
        if (sArray == null) {
            ArrayUtil.$$$reportNull$$$0(8);
        }
        return sArray;
    }

    @Contract(pure=true)
    public static long @NotNull [] realloc(long @NotNull [] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(9);
        }
        if (newSize == 0) {
            if (EMPTY_LONG_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(10);
            }
            return EMPTY_LONG_ARRAY;
        }
        int oldSize = array.length;
        long[] lArray = oldSize == newSize ? array : Arrays.copyOf(array, newSize);
        if (lArray == null) {
            ArrayUtil.$$$reportNull$$$0(11);
        }
        return lArray;
    }

    @Contract(pure=true)
    public static int @NotNull [] realloc(int @NotNull [] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(12);
        }
        if (newSize == 0) {
            if (ArrayUtilRt.EMPTY_INT_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(13);
            }
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        int oldSize = array.length;
        int[] nArray = oldSize == newSize ? array : Arrays.copyOf(array, newSize);
        if (nArray == null) {
            ArrayUtil.$$$reportNull$$$0(14);
        }
        return nArray;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] realloc(T @NotNull [] array, int newSize, @NotNull ArrayFactory<? extends T> factory) {
        int oldSize;
        if (factory == null) {
            ArrayUtil.$$$reportNull$$$0(15);
        }
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(16);
        }
        if ((oldSize = array.length) == newSize) {
            if (array == null) {
                ArrayUtil.$$$reportNull$$$0(17);
            }
            return array;
        }
        T[] result = factory.create(newSize);
        if (newSize == 0) {
            if (result == null) {
                ArrayUtil.$$$reportNull$$$0(18);
            }
            return result;
        }
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(19);
        }
        return result;
    }

    @Contract(pure=true)
    public static long @NotNull [] append(long @NotNull [] array, long value) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(20);
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(21);
        }
        return array;
    }

    @Contract(pure=true)
    public static int @NotNull [] append(int @NotNull [] array, int value) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(22);
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(23);
        }
        return array;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] insert(T @NotNull [] array, int index, T value) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(24);
        }
        T[] result = ArrayUtil.newArray(ArrayUtil.getComponentType(array), array.length + 1);
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, array.length - index);
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(25);
        }
        return result;
    }

    @Contract(pure=true)
    public static int @NotNull [] insert(int @NotNull [] array, int index, int value) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(26);
        }
        int[] result = new int[array.length + 1];
        System.arraycopy(array, 0, result, 0, index);
        result[index] = value;
        System.arraycopy(array, index, result, index + 1, array.length - index);
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(27);
        }
        return result;
    }

    @Contract(pure=true)
    public static byte @NotNull [] append(byte @NotNull [] array, byte value) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(28);
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(29);
        }
        return array;
    }

    @Contract(pure=true)
    public static boolean @NotNull [] append(boolean @NotNull [] array, boolean value) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(30);
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(31);
        }
        return array;
    }

    @Contract(pure=true)
    public static char @NotNull [] realloc(char @NotNull [] array, int newSize) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(32);
        }
        if (newSize == 0) {
            if (ArrayUtilRt.EMPTY_CHAR_ARRAY == null) {
                ArrayUtil.$$$reportNull$$$0(33);
            }
            return ArrayUtilRt.EMPTY_CHAR_ARRAY;
        }
        int oldSize = array.length;
        char[] cArray = oldSize == newSize ? array : Arrays.copyOf(array, newSize);
        if (cArray == null) {
            ArrayUtil.$$$reportNull$$$0(34);
        }
        return cArray;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] toObjectArray(@NotNull Collection<? extends T> collection, @NotNull Class<T> aClass) {
        if (collection == null) {
            ArrayUtil.$$$reportNull$$$0(35);
        }
        if (aClass == null) {
            ArrayUtil.$$$reportNull$$$0(36);
        }
        T[] array = ArrayUtil.newArray(aClass, collection.size());
        T[] TArray = collection.toArray(array);
        if (TArray == null) {
            ArrayUtil.$$$reportNull$$$0(37);
        }
        return TArray;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] toObjectArray(@NotNull Class<T> aClass, Object ... source) {
        if (aClass == null) {
            ArrayUtil.$$$reportNull$$$0(38);
        }
        if (source == null) {
            ArrayUtil.$$$reportNull$$$0(39);
        }
        T[] array = ArrayUtil.newArray(aClass, source.length);
        System.arraycopy(source, 0, array, 0, array.length);
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(40);
        }
        return array;
    }

    @Contract(pure=true)
    public static Object @NotNull [] toObjectArray(@NotNull Collection<?> collection) {
        if (collection == null) {
            ArrayUtil.$$$reportNull$$$0(41);
        }
        Object[] objectArray = collection.toArray(ArrayUtilRt.EMPTY_OBJECT_ARRAY);
        if (objectArray == null) {
            ArrayUtil.$$$reportNull$$$0(42);
        }
        return objectArray;
    }

    @Contract(pure=true)
    public static int @NotNull [] toIntArray(@NotNull Collection<Integer> list) {
        if (list == null) {
            ArrayUtil.$$$reportNull$$$0(43);
        }
        int[] ret = ArrayUtil.newIntArray(list.size());
        int i = 0;
        for (Integer e : list) {
            ret[i++] = e;
        }
        if (ret == null) {
            ArrayUtil.$$$reportNull$$$0(44);
        }
        return ret;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] mergeArrays(T @NotNull [] a1, T @NotNull [] a2) {
        Class<T> class2;
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(45);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(46);
        }
        if (a1.length == 0) {
            if (a2 == null) {
                ArrayUtil.$$$reportNull$$$0(47);
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                ArrayUtil.$$$reportNull$$$0(48);
            }
            return a1;
        }
        Class<T> class1 = ArrayUtil.getComponentType(a1);
        Class<T> aClass = class1.isAssignableFrom(class2 = ArrayUtil.getComponentType(a2)) ? class1 : class2;
        T[] result = ArrayUtil.newArray(aClass, a1.length + a2.length);
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(49);
        }
        return result;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] mergeCollections(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<? extends T> factory) {
        if (c1 == null) {
            ArrayUtil.$$$reportNull$$$0(50);
        }
        if (c2 == null) {
            ArrayUtil.$$$reportNull$$$0(51);
        }
        if (factory == null) {
            ArrayUtil.$$$reportNull$$$0(52);
        }
        T[] res = factory.create(c1.size() + c2.size());
        int i = 0;
        for (T t : c1) {
            res[i++] = t;
        }
        for (T t : c2) {
            res[i++] = t;
        }
        if (res == null) {
            ArrayUtil.$$$reportNull$$$0(53);
        }
        return res;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] mergeArrays(T @NotNull [] a1, T @NotNull [] a2, @NotNull ArrayFactory<? extends T> factory) {
        if (factory == null) {
            ArrayUtil.$$$reportNull$$$0(54);
        }
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(55);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(56);
        }
        if (a1.length == 0) {
            if (a2 == null) {
                ArrayUtil.$$$reportNull$$$0(57);
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                ArrayUtil.$$$reportNull$$$0(58);
            }
            return a1;
        }
        T[] result = factory.create(a1.length + a2.length);
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(59);
        }
        return result;
    }

    @Contract(pure=true)
    public static String @NotNull [] mergeArrays(String @NotNull [] a1, String ... a2) {
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(60);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(61);
        }
        return ArrayUtil.mergeArrays(a1, a2, STRING_ARRAY_FACTORY);
    }

    @Contract(pure=true)
    public static int @NotNull [] mergeArrays(int @NotNull [] a1, int @NotNull [] a2) {
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(62);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(63);
        }
        if (a1.length == 0) {
            if (a2 == null) {
                ArrayUtil.$$$reportNull$$$0(64);
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                ArrayUtil.$$$reportNull$$$0(65);
            }
            return a1;
        }
        int[] result = new int[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(66);
        }
        return result;
    }

    @Contract(pure=true)
    public static byte @NotNull [] mergeArrays(byte @NotNull [] a1, byte @NotNull [] a2) {
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(67);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(68);
        }
        if (a1.length == 0) {
            if (a2 == null) {
                ArrayUtil.$$$reportNull$$$0(69);
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                ArrayUtil.$$$reportNull$$$0(70);
            }
            return a1;
        }
        byte[] result = new byte[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(71);
        }
        return result;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] mergeArrayAndCollection(T @NotNull [] array, @NotNull Collection<? extends T> collection, @NotNull ArrayFactory<? extends T> factory) {
        T[] array2;
        if (collection == null) {
            ArrayUtil.$$$reportNull$$$0(72);
        }
        if (factory == null) {
            ArrayUtil.$$$reportNull$$$0(73);
        }
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(74);
        }
        if (collection.isEmpty()) {
            if (array == null) {
                ArrayUtil.$$$reportNull$$$0(75);
            }
            return array;
        }
        try {
            T[] a = factory.create(collection.size());
            array2 = collection.toArray(a);
        }
        catch (ArrayStoreException e) {
            throw new RuntimeException("Bad elements in collection: " + collection, e);
        }
        if (array.length == 0) {
            if (array2 == null) {
                ArrayUtil.$$$reportNull$$$0(76);
            }
            return array2;
        }
        T[] result = factory.create(array.length + collection.size());
        System.arraycopy(array, 0, result, 0, array.length);
        System.arraycopy(array2, 0, result, array.length, array2.length);
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(77);
        }
        return result;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] append(T @NotNull [] src, @Nullable T element) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(78);
        }
        return ArrayUtil.append(src, element, ArrayUtil.getComponentType(src));
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] prepend(T element, T @NotNull [] array) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(79);
        }
        return ArrayUtil.prepend(element, array, ArrayUtil.getComponentType(array));
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] prepend(T element, T @NotNull [] array, @NotNull Class<T> type) {
        if (type == null) {
            ArrayUtil.$$$reportNull$$$0(80);
        }
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(81);
        }
        int length = array.length;
        T[] result = ArrayUtil.newArray(type, length + 1);
        System.arraycopy(array, 0, result, 1, length);
        result[0] = element;
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(82);
        }
        return result;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] prepend(T element, T @NotNull [] src, @NotNull ArrayFactory<? extends T> factory) {
        if (factory == null) {
            ArrayUtil.$$$reportNull$$$0(83);
        }
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(84);
        }
        int length = src.length;
        T[] result = factory.create(length + 1);
        System.arraycopy(src, 0, result, 1, length);
        result[0] = element;
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(85);
        }
        return result;
    }

    @Contract(pure=true)
    public static byte @NotNull [] prepend(byte element, byte @NotNull [] array) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(86);
        }
        int length = array.length;
        byte[] result = new byte[length + 1];
        result[0] = element;
        System.arraycopy(array, 0, result, 1, length);
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(87);
        }
        return result;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] append(T @NotNull [] src, T element, @NotNull ArrayFactory<? extends T> factory) {
        if (factory == null) {
            ArrayUtil.$$$reportNull$$$0(88);
        }
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(89);
        }
        int length = src.length;
        T[] result = factory.create(length + 1);
        System.arraycopy(src, 0, result, 0, length);
        result[length] = element;
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(90);
        }
        return result;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] append(T @NotNull [] src, @Nullable T element, @NotNull Class<T> componentType) {
        if (componentType == null) {
            ArrayUtil.$$$reportNull$$$0(91);
        }
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(92);
        }
        int length = src.length;
        T[] result = ArrayUtil.newArray(componentType, length + 1);
        System.arraycopy(src, 0, result, 0, length);
        result[length] = element;
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(93);
        }
        return result;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] remove(T @NotNull [] src, int idx) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(94);
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        Class<T> type = ArrayUtil.getComponentType(src);
        T[] result = ArrayUtil.newArray(type, length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(95);
        }
        return result;
    }

    public static <T> T @NotNull [] newArray(@NotNull Class<T> type, int length) {
        if (type == null) {
            ArrayUtil.$$$reportNull$$$0(96);
        }
        Object[] objectArray = (Object[])Array.newInstance(type, length);
        if (objectArray == null) {
            ArrayUtil.$$$reportNull$$$0(97);
        }
        return objectArray;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] remove(T @NotNull [] src, int idx, @NotNull ArrayFactory<? extends T> factory) {
        if (factory == null) {
            ArrayUtil.$$$reportNull$$$0(98);
        }
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(99);
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        T[] result = factory.create(length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(100);
        }
        return result;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] remove(T @NotNull [] src, T element) {
        int index;
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(101);
        }
        return (index = ArrayUtilRt.find(src, element)) == -1 ? src : (T[])ArrayUtil.remove(src, index);
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] remove(T @NotNull [] src, T element, @NotNull ArrayFactory<? extends T> factory) {
        int idx;
        if (factory == null) {
            ArrayUtil.$$$reportNull$$$0(102);
        }
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(103);
        }
        if ((idx = ArrayUtil.find(src, element)) == -1) {
            if (src == null) {
                ArrayUtil.$$$reportNull$$$0(104);
            }
            return src;
        }
        return ArrayUtil.remove(src, idx, factory);
    }

    @Contract(pure=true)
    public static int @NotNull [] remove(int @NotNull [] src, int idx) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(105);
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        int[] result = ArrayUtil.newIntArray(src.length - 1);
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(106);
        }
        return result;
    }

    @Contract(pure=true)
    public static short @NotNull [] remove(short @NotNull [] src, int idx) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(107);
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        short[] result = src.length == 1 ? ArrayUtilRt.EMPTY_SHORT_ARRAY : new short[src.length - 1];
        System.arraycopy(src, 0, result, 0, idx);
        System.arraycopy(src, idx + 1, result, idx, length - idx - 1);
        if (result == null) {
            ArrayUtil.$$$reportNull$$$0(108);
        }
        return result;
    }

    @Contract(pure=true)
    public static int find(int @NotNull [] src, int obj) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(109);
        }
        return ArrayUtil.indexOf(src, obj);
    }

    @Contract(pure=true)
    public static <T> int find(T @NotNull [] src, T obj) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(110);
        }
        return ArrayUtilRt.find(src, obj);
    }

    @Contract(pure=true)
    public static boolean startsWith(byte @NotNull [] array, byte @NotNull [] prefix) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(111);
        }
        if (prefix == null) {
            ArrayUtil.$$$reportNull$$$0(112);
        }
        if (array == prefix) {
            return true;
        }
        int length = prefix.length;
        if (array.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <E> boolean startsWith(E @NotNull [] array, E @NotNull [] subArray) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(113);
        }
        if (subArray == null) {
            ArrayUtil.$$$reportNull$$$0(114);
        }
        if (array == subArray) {
            return true;
        }
        int length = subArray.length;
        if (array.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Comparing.equal(array[i], subArray[i])) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean startsWith(byte @NotNull [] array, int start, byte @NotNull [] subArray) {
        int length;
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(115);
        }
        if (subArray == null) {
            ArrayUtil.$$$reportNull$$$0(116);
        }
        if (array.length - start < (length = subArray.length)) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array[start + i] == subArray[i]) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    @Contract(pure=true)
    public static <T> boolean equals(T @NotNull [] a1, T @NotNull [] a2, @NotNull Equality<? super T> comparator) {
        if (comparator == null) {
            ArrayUtil.$$$reportNull$$$0(117);
        }
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(118);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(119);
        }
        if (a1 == a2) {
            return true;
        }
        int length = a2.length;
        if (a1.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (comparator.equals(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean equals(T @NotNull [] a1, T @NotNull [] a2, @NotNull Comparator<? super T> comparator) {
        if (comparator == null) {
            ArrayUtil.$$$reportNull$$$0(120);
        }
        if (a1 == null) {
            ArrayUtil.$$$reportNull$$$0(121);
        }
        if (a2 == null) {
            ArrayUtil.$$$reportNull$$$0(122);
        }
        if (a1 == a2) {
            return true;
        }
        int length = a2.length;
        if (a1.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (comparator.compare(a1[i], a2[i]) == 0) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] reverseArray(T @NotNull [] array) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(123);
        }
        Object[] newArray = (Object[])array.clone();
        for (int i = 0; i < array.length; ++i) {
            newArray[array.length - i - 1] = array[i];
        }
        if (newArray == null) {
            ArrayUtil.$$$reportNull$$$0(124);
        }
        return newArray;
    }

    @Contract(pure=true)
    public static int @NotNull [] reverseArray(int @NotNull [] array) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(125);
        }
        int[] newArray = (int[])array.clone();
        for (int i = 0; i < array.length; ++i) {
            newArray[array.length - i - 1] = array[i];
        }
        if (newArray == null) {
            ArrayUtil.$$$reportNull$$$0(126);
        }
        return newArray;
    }

    @Contract(pure=true)
    public static int lexicographicCompare(String @NotNull [] obj1, String @NotNull [] obj2) {
        if (obj1 == null) {
            ArrayUtil.$$$reportNull$$$0(127);
        }
        if (obj2 == null) {
            ArrayUtil.$$$reportNull$$$0(128);
        }
        for (int i = 0; i < Math.max(obj1.length, obj2.length); ++i) {
            String o2;
            String o1 = i < obj1.length ? obj1[i] : null;
            String string = o2 = i < obj2.length ? obj2[i] : null;
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int res = o1.compareToIgnoreCase(o2);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    @Contract(pure=true)
    public static int lexicographicCompare(int @NotNull [] obj1, int @NotNull [] obj2) {
        if (obj1 == null) {
            ArrayUtil.$$$reportNull$$$0(129);
        }
        if (obj2 == null) {
            ArrayUtil.$$$reportNull$$$0(130);
        }
        for (int i = 0; i < Math.min(obj1.length, obj2.length); ++i) {
            int res = Integer.compare(obj1[i], obj2[i]);
            if (res == 0) continue;
            return res;
        }
        return Integer.compare(obj1.length, obj2.length);
    }

    @Contract(pure=true)
    public static <T> int lexicographicCompare(T @NotNull [] obj1, T @NotNull [] obj2) {
        if (obj1 == null) {
            ArrayUtil.$$$reportNull$$$0(131);
        }
        if (obj2 == null) {
            ArrayUtil.$$$reportNull$$$0(132);
        }
        for (int i = 0; i < Math.max(obj1.length, obj2.length); ++i) {
            Object o2;
            Object o1 = i < obj1.length ? obj1[i] : null;
            Object t = o2 = i < obj2.length ? (Object)obj2[i] : null;
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int res = ((Comparable)o1).compareTo(o2);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static <T> void swap(T @NotNull [] array, int i1, int i2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(133);
        }
        T t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static void swap(int @NotNull [] array, int i1, int i2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(134);
        }
        int t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static void swap(boolean @NotNull [] array, int i1, int i2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(135);
        }
        boolean t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static void swap(char @NotNull [] array, int i1, int i2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(136);
        }
        char t = array[i1];
        array[i1] = array[i2];
        array[i2] = t;
    }

    public static <T> void rotateLeft(T @NotNull [] array, int i1, int i2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(137);
        }
        T t = array[i1];
        System.arraycopy(array, i1 + 1, array, i1, i2 - i1);
        array[i2] = t;
    }

    public static <T> void rotateRight(T @NotNull [] array, int i1, int i2) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(138);
        }
        T t = array[i2];
        System.arraycopy(array, i1, array, i1 + 1, i2 - i1);
        array[i1] = t;
    }

    @Contract(pure=true)
    public static int indexOf(Object @NotNull [] objects, @Nullable Object object) {
        if (objects == null) {
            ArrayUtil.$$$reportNull$$$0(139);
        }
        return ArrayUtilRt.indexOf(objects, object, 0, objects.length);
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<? extends T> objects, T object, @NotNull BiPredicate<? super T, ? super T> predicate) {
        if (objects == null) {
            ArrayUtil.$$$reportNull$$$0(140);
        }
        if (predicate == null) {
            ArrayUtil.$$$reportNull$$$0(141);
        }
        for (int i = 0; i < objects.size(); ++i) {
            if (!predicate.test(objects.get(i), object)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int indexOf(T @NotNull [] objects, T object, @NotNull BiPredicate<T, T> comparator) {
        if (comparator == null) {
            ArrayUtil.$$$reportNull$$$0(142);
        }
        if (objects == null) {
            ArrayUtil.$$$reportNull$$$0(143);
        }
        for (int i = 0; i < objects.length; ++i) {
            if (!comparator.test(objects[i], object)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(long @NotNull [] ints, long value) {
        if (ints == null) {
            ArrayUtil.$$$reportNull$$$0(144);
        }
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(int @NotNull [] ints, int value) {
        if (ints == null) {
            ArrayUtil.$$$reportNull$$$0(145);
        }
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(byte @NotNull [] array, byte @NotNull [] pattern, int startIndex) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(146);
        }
        if (pattern == null) {
            ArrayUtil.$$$reportNull$$$0(147);
        }
        for (int i = startIndex; i <= array.length - pattern.length; ++i) {
            if (!ArrayUtil.startsWith(array, i, pattern)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(T @NotNull [] src, @Nullable T obj) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(148);
        }
        for (int i = src.length - 1; i >= 0; --i) {
            T o = src[i];
            if (!(o == null ? obj == null : o.equals(obj))) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(int @NotNull [] src, int obj) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(149);
        }
        for (int i = src.length - 1; i >= 0; --i) {
            int o = src[i];
            if (o != obj) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOfNot(int @NotNull [] src, int obj) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(150);
        }
        for (int i = src.length - 1; i >= 0; --i) {
            int o = src[i];
            if (o == obj) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(T @NotNull [] src, T obj, @NotNull BiPredicate<? super T, ? super T> predicate) {
        if (predicate == null) {
            ArrayUtil.$$$reportNull$$$0(151);
        }
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(152);
        }
        for (int i = src.length - 1; i >= 0; --i) {
            T o = src[i];
            if (!predicate.test(obj, o)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(@NotNull List<? extends T> src, T obj, @NotNull BiPredicate<? super T, ? super T> comparator) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(153);
        }
        if (comparator == null) {
            ArrayUtil.$$$reportNull$$$0(154);
        }
        for (int i = src.size() - 1; i >= 0; --i) {
            T o = src.get(i);
            if (!comparator.test(obj, o)) continue;
            return i;
        }
        return -1;
    }

    @SafeVarargs
    @Contract(pure=true)
    public static <T> boolean contains(@Nullable T o, T ... objects) {
        if (objects == null) {
            ArrayUtil.$$$reportNull$$$0(155);
        }
        return ArrayUtil.indexOf(objects, o) >= 0;
    }

    @Contract(pure=true)
    public static boolean contains(@Nullable String s, String ... strings) {
        if (strings == null) {
            ArrayUtil.$$$reportNull$$$0(156);
        }
        return ArrayUtil.indexOf(strings, s) >= 0;
    }

    @Contract(pure=true)
    public static int @NotNull [] newIntArray(int count) {
        return count == 0 ? ArrayUtilRt.EMPTY_INT_ARRAY : new int[count];
    }

    @Contract(pure=true)
    public static long @NotNull [] newLongArray(int count) {
        return count == 0 ? EMPTY_LONG_ARRAY : new long[count];
    }

    @Contract(pure=true)
    public static String @NotNull [] newStringArray(int count) {
        return count == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : new String[count];
    }

    @Contract(pure=true)
    public static Object @NotNull [] newObjectArray(int count) {
        return count == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[count];
    }

    @Contract(pure=true)
    public static <E> E @NotNull [] ensureExactSize(int count, E @NotNull [] sample) {
        if (sample == null) {
            ArrayUtil.$$$reportNull$$$0(157);
        }
        if (count == sample.length) {
            if (sample == null) {
                ArrayUtil.$$$reportNull$$$0(158);
            }
            return sample;
        }
        return ArrayUtil.newArray(ArrayUtil.getComponentType(sample), count);
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static <T> T getFirstElement(T @Nullable [] array) {
        return array != null && array.length > 0 ? (T)array[0] : null;
    }

    @Contract(value="null -> null", pure=true)
    public static <T> T getLastElement(T @Nullable [] array) {
        return array != null && array.length > 0 ? (T)array[array.length - 1] : null;
    }

    @Contract(pure=true)
    public static int getLastElement(int @Nullable [] array, int defaultValue) {
        return array == null || array.length == 0 ? defaultValue : array[array.length - 1];
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(T @Nullable [] array) {
        return array == null || array.length == 0;
    }

    @Contract(pure=true)
    public static String @NotNull [] toStringArray(@Nullable Collection<String> collection) {
        String[] stringArray = ArrayUtilRt.toStringArray(collection);
        if (stringArray == null) {
            ArrayUtil.$$$reportNull$$$0(159);
        }
        return stringArray;
    }

    public static <T> void copy(@NotNull Collection<? extends T> src, T @NotNull [] dst, int dstOffset) {
        if (src == null) {
            ArrayUtil.$$$reportNull$$$0(160);
        }
        if (dst == null) {
            ArrayUtil.$$$reportNull$$$0(161);
        }
        int i = dstOffset;
        for (T t : src) {
            dst[i++] = t;
        }
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static <T> T @Nullable [] copyOf(T @Nullable [] original) {
        if (original == null) {
            return null;
        }
        return Arrays.copyOf(original, original.length);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static boolean @Nullable [] copyOf(boolean @Nullable [] original) {
        if (original == null) {
            return null;
        }
        return original.length == 0 ? ArrayUtilRt.EMPTY_BOOLEAN_ARRAY : Arrays.copyOf(original, original.length);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static int @Nullable [] copyOf(int @Nullable [] original) {
        if (original == null) {
            return null;
        }
        return original.length == 0 ? ArrayUtilRt.EMPTY_INT_ARRAY : Arrays.copyOf(original, original.length);
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] stripTrailingNulls(T @NotNull [] array) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(162);
        }
        T[] TArray = array.length != 0 && array[array.length - 1] == null ? Arrays.copyOf(array, ArrayUtil.trailingNullsIndex(array)) : array;
        if (TArray == null) {
            ArrayUtil.$$$reportNull$$$0(163);
        }
        return TArray;
    }

    private static <T> int trailingNullsIndex(T @NotNull [] array) {
        if (array == null) {
            ArrayUtil.$$$reportNull$$$0(164);
        }
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] == null) continue;
            return i + 1;
        }
        return 0;
    }

    public static long averageAmongMedians(long @NotNull [] time, int part) {
        if (time == null) {
            ArrayUtil.$$$reportNull$$$0(165);
        }
        assert (part >= 1);
        int n = time.length;
        Arrays.sort(time);
        long total = 0L;
        int start = n / 2 - n / part / 2;
        int end = n / 2 + n / part / 2;
        for (int i = start; i < end; ++i) {
            total += time[i];
        }
        int middlePartLength = end - start;
        return middlePartLength == 0 ? 0L : total / (long)middlePartLength;
    }

    public static long averageAmongMedians(int @NotNull [] time, int part) {
        if (time == null) {
            ArrayUtil.$$$reportNull$$$0(166);
        }
        assert (part >= 1);
        int n = time.length;
        Arrays.sort(time);
        long total = 0L;
        int start = n / 2 - n / part / 2;
        int end = n / 2 + n / part / 2;
        for (int i = start; i < end; ++i) {
            total += (long)time[i];
        }
        int middlePartLength = end - start;
        return middlePartLength == 0 ? 0L : total / (long)middlePartLength;
    }

    @Contract(pure=true)
    public static int min(int[] values) {
        int min = Integer.MAX_VALUE;
        for (int value : values) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    @Contract(pure=true)
    public static int max(int[] values) {
        int max = Integer.MIN_VALUE;
        for (int value : values) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    @Contract(pure=true)
    public static int[] mergeSortedArrays(int[] a1, int[] a2, boolean mergeEqualItems) {
        int newSize = a1.length + a2.length;
        if (newSize == 0) {
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        int[] r = new int[newSize];
        int o = 0;
        int index1 = 0;
        int index2 = 0;
        while (index1 < a1.length || index2 < a2.length) {
            int e;
            if (index1 >= a1.length) {
                e = a2[index2++];
            } else if (index2 >= a2.length) {
                e = a1[index1++];
            } else {
                int element1 = a1[index1];
                int element2 = a2[index2];
                if (element1 == element2) {
                    ++index1;
                    ++index2;
                    if (mergeEqualItems) {
                        e = element1;
                    } else {
                        r[o++] = element1;
                        e = element2;
                    }
                } else if (element1 < element2) {
                    e = element1;
                    ++index1;
                } else {
                    e = element2;
                    ++index2;
                }
            }
            r[o++] = e;
        }
        return o == newSize ? r : Arrays.copyOf(r, o);
    }

    @NotNull
    public static <T> Class<T> getComponentType(T @NotNull [] collection) {
        if (collection == null) {
            ArrayUtil.$$$reportNull$$$0(167);
        }
        Class<?> clazz = collection.getClass().getComponentType();
        if (clazz == null) {
            ArrayUtil.$$$reportNull$$$0(168);
        }
        return clazz;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 82: 
            case 85: 
            case 87: 
            case 90: 
            case 93: 
            case 95: 
            case 97: 
            case 100: 
            case 104: 
            case 106: 
            case 108: 
            case 124: 
            case 126: 
            case 158: 
            case 159: 
            case 163: 
            case 168: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 82: 
            case 85: 
            case 87: 
            case 90: 
            case 93: 
            case 95: 
            case 97: 
            case 100: 
            case 104: 
            case 106: 
            case 108: 
            case 124: 
            case 126: 
            case 158: 
            case 159: 
            case 163: 
            case 168: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 82: 
            case 85: 
            case 87: 
            case 90: 
            case 93: 
            case 95: 
            case 97: 
            case 100: 
            case 104: 
            case 106: 
            case 108: 
            case 124: 
            case 126: 
            case 158: 
            case 159: 
            case 163: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ArrayUtil";
                break;
            }
            case 15: 
            case 52: 
            case 54: 
            case 73: 
            case 83: 
            case 88: 
            case 98: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 35: 
            case 41: 
            case 72: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 45: 
            case 55: 
            case 60: 
            case 62: 
            case 67: 
            case 118: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 46: 
            case 56: 
            case 61: 
            case 63: 
            case 68: 
            case 119: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 78: 
            case 84: 
            case 89: 
            case 92: 
            case 94: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 148: 
            case 149: 
            case 150: 
            case 152: 
            case 153: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 80: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 114: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subArray";
                break;
            }
            case 117: 
            case 120: 
            case 142: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 127: 
            case 129: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj1";
                break;
            }
            case 128: 
            case 130: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj2";
                break;
            }
            case 139: 
            case 140: 
            case 143: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 141: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 144: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ints";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 165: 
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ArrayUtil";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "realloc";
                break;
            }
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 90: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "insert";
                break;
            }
            case 37: 
            case 40: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "toObjectArray";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "toIntArray";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 57: 
            case 58: 
            case 59: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeArrays";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeCollections";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeArrayAndCollection";
                break;
            }
            case 82: 
            case 85: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "prepend";
                break;
            }
            case 95: 
            case 100: 
            case 104: 
            case 106: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "remove";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "newArray";
                break;
            }
            case 124: 
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseArray";
                break;
            }
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureExactSize";
                break;
            }
            case 159: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringArray";
                break;
            }
            case 163: {
                objectArray = objectArray2;
                objectArray2[1] = "stripTrailingNulls";
                break;
            }
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "realloc";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 82: 
            case 85: 
            case 87: 
            case 90: 
            case 93: 
            case 95: 
            case 97: 
            case 100: 
            case 104: 
            case 106: 
            case 108: 
            case 124: 
            case 126: 
            case 158: 
            case 159: 
            case 163: 
            case 168: {
                break;
            }
            case 20: 
            case 22: 
            case 28: 
            case 30: 
            case 78: 
            case 88: 
            case 89: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "toObjectArray";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "toIntArray";
                break;
            }
            case 45: 
            case 46: 
            case 54: 
            case 55: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "mergeArrays";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "mergeCollections";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "mergeArrayAndCollection";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 94: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "newArray";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 123: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "reverseArray";
                break;
            }
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "lexicographicCompare";
                break;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "swap";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "rotateLeft";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "rotateRight";
                break;
            }
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 148: 
            case 149: 
            case 151: 
            case 152: 
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfNot";
                break;
            }
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "ensureExactSize";
                break;
            }
            case 160: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "stripTrailingNulls";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "trailingNullsIndex";
                break;
            }
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "averageAmongMedians";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "getComponentType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 57: 
            case 58: 
            case 59: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 82: 
            case 85: 
            case 87: 
            case 90: 
            case 93: 
            case 95: 
            case 97: 
            case 100: 
            case 104: 
            case 106: 
            case 108: 
            case 124: 
            case 126: 
            case 158: 
            case 159: 
            case 163: 
            case 168: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

