Object.assign(window.search, {"doc_urls":["index.html#mdbook","index.html#api-docs","index.html#license","cli/index.html#command-line-tool","cli/index.html#install-from-binaries","cli/index.html#install-from-source","cli/init.html#the-init-command","cli/build.html#the-build-command","cli/watch.html#the-watch-command","cli/serve.html#the-serve-command","cli/test.html#the-test-command","cli/clean.html#the-clean-command","format/index.html#format","format/summary.html#summarymd","format/config.html#configuration","format/config.html#supported-configuration-options","format/config.html#configuring-preprocessors","format/config.html#configuring-renderers","format/config.html#environment-variables","format/theme/index.html#theme","format/theme/index-hbs.html#indexhbs","format/theme/index-hbs.html#data","format/theme/index-hbs.html#handlebars-helpers","format/theme/syntax-highlighting.html#syntax-highlighting","format/theme/syntax-highlighting.html#custom-theme","format/theme/syntax-highlighting.html#hiding-code-lines","format/theme/syntax-highlighting.html#improve-default-theme","format/theme/editor.html#editor","format/theme/editor.html#customizing-the-editor","format/mathjax.html#mathjax-support","format/mdbook.html#mdbook-specific-markdown","format/mdbook.html#hiding-code-lines","format/mdbook.html#including-files","format/mdbook.html#including-portions-of-a-file","format/mdbook.html#including-a-file-but-initially-hiding-all-except-specified-lines","format/mdbook.html#inserting-runnable-rust-files","continuous-integration.html#running-mdbook-in-continuous-integration","continuous-integration.html#ensuring-your-book-builds-and-tests-pass","continuous-integration.html#deploying-your-book-to-github-pages","for_developers/index.html#for-developers","for_developers/index.html#the-build-process","for_developers/index.html#using-mdbook-as-a-library","for_developers/preprocessors.html#preprocessors","for_developers/preprocessors.html#hooking-into-mdbook","for_developers/preprocessors.html#hints-for-implementing-a-preprocessor","for_developers/backends.html#alternative-backends","for_developers/backends.html#setting-up","for_developers/backends.html#inspecting-the-book","for_developers/backends.html#enabling-the-backend","for_developers/backends.html#configuration","for_developers/backends.html#output-and-signalling-failure","for_developers/backends.html#handling-missing-backends","for_developers/backends.html#wrapping-up","misc/contributors.html#contributors"],"index":{"documentStore":{"docInfo":{"0":{"body":42,"breadcrumbs":1,"title":1},"1":{"body":18,"breadcrumbs":2,"title":2},"10":{"body":146,"breadcrumbs":5,"title":2},"11":{"body":62,"breadcrumbs":5,"title":2},"12":{"body":14,"breadcrumbs":1,"title":1},"13":{"body":228,"breadcrumbs":2,"title":1},"14":{"body":43,"breadcrumbs":2,"title":1},"15":{"body":205,"breadcrumbs":4,"title":3},"16":{"body":122,"breadcrumbs":3,"title":2},"17":{"body":756,"breadcrumbs":3,"title":2},"18":{"body":128,"breadcrumbs":3,"title":2},"19":{"body":183,"breadcrumbs":2,"title":1},"2":{"body":9,"breadcrumbs":1,"title":1},"20":{"body":25,"breadcrumbs":3,"title":1},"21":{"body":92,"breadcrumbs":3,"title":1},"22":{"body":97,"breadcrumbs":4,"title":2},"23":{"body":20,"breadcrumbs":4,"title":2},"24":{"body":45,"breadcrumbs":4,"title":2},"25":{"body":44,"breadcrumbs":5,"title":3},"26":{"body":32,"breadcrumbs":5,"title":3},"27":{"body":54,"breadcrumbs":3,"title":1},"28":{"body":30,"breadcrumbs":4,"title":2},"29":{"body":111,"breadcrumbs":3,"title":2},"3":{"body":14,"breadcrumbs":3,"title":3},"30":{"body":0,"breadcrumbs":4,"title":3},"31":{"body":29,"breadcrumbs":4,"title":3},"32":{"body":35,"breadcrumbs":3,"title":2},"33":{"body":143,"breadcrumbs":4,"title":3},"34":{"body":134,"breadcrumbs":8,"title":7},"35":{"body":51,"breadcrumbs":5,"title":4},"36":{"body":12,"breadcrumbs":4,"title":4},"37":{"body":62,"breadcrumbs":5,"title":5},"38":{"body":161,"breadcrumbs":4,"title":4},"39":{"body":50,"breadcrumbs":1,"title":1},"4":{"body":15,"breadcrumbs":2,"title":2},"40":{"body":31,"breadcrumbs":2,"title":2},"41":{"body":55,"breadcrumbs":3,"title":3},"42":{"body":39,"breadcrumbs":2,"title":1},"43":{"body":294,"breadcrumbs":3,"title":2},"44":{"body":134,"breadcrumbs":4,"title":3},"45":{"body":87,"breadcrumbs":3,"title":2},"46":{"body":94,"breadcrumbs":3,"title":2},"47":{"body":50,"breadcrumbs":3,"title":2},"48":{"body":209,"breadcrumbs":3,"title":2},"49":{"body":123,"breadcrumbs":2,"title":1},"5":{"body":109,"breadcrumbs":2,"title":2},"50":{"body":270,"breadcrumbs":4,"title":3},"51":{"body":55,"breadcrumbs":4,"title":3},"52":{"body":45,"breadcrumbs":3,"title":2},"53":{"body":48,"breadcrumbs":1,"title":1},"6":{"body":134,"breadcrumbs":5,"title":2},"7":{"body":100,"breadcrumbs":5,"title":2},"8":{"body":124,"breadcrumbs":5,"title":2},"9":{"body":201,"breadcrumbs":5,"title":2}},"docs":{"0":{"body":"mdBook is a command line tool and Rust crate to create books using Markdown files. It's very similar to Gitbook but written in Rust . What you are reading serves as an example of the output of mdBook and at the same time as a high-level documentation. mdBook is free and open source, you can find the source code on GitHub . Issues and feature requests can be posted on the GitHub issue tracker .","breadcrumbs":"mdBook","id":"0","title":"mdBook"},"1":{"body":"Alongside this book you can also read the API docs generated by Rustdoc if you would like to use mdBook as a crate or write a new renderer and need a more low-level overview.","breadcrumbs":"API docs","id":"1","title":"API docs"},"10":{"body":"When writing a book, you sometimes need to automate some tests. For example, The Rust Programming Book uses a lot of code examples that could get outdated. Therefore it is very important for them to be able to automatically test these code examples. mdBook supports a test command that will run all available tests in a book. At the moment, only rustdoc tests are supported, but this may be expanded upon in the future. Disable tests on a code block rustdoc doesn't test code blocks which contain the ignore attribute: ```rust,ignore\nfn main() {}\n``` rustdoc also doesn't test code blocks which specify a language other than Rust: ```markdown\n**Foo**: _bar_\n``` rustdoc does test code blocks which have no language specified: ```\nThis is going to cause an error!\n``` Specify a directory The test command can take a directory as an argument to use as the book's root instead of the current working directory. mdbook test path/to/book --library-path The --library-path (-L) option allows you to add directories to the library search path used by rustdoc when it builds and tests the examples. Multiple directories can be specified with multiple options (-L foo -L bar) or with a comma-delimited list (-L foo,bar). --dest-dir The --dest-dir (-d) option allows you to change the output directory for the book. Relative paths are interpreted relative to the book's root directory. If not specified it will default to the value of the build.build-dir key in book.toml, or to ./book.","breadcrumbs":"Command Line Tool » The test command","id":"10","title":"The test command"},"11":{"body":"The clean command is used to delete the generated book and any other build artifacts. mdbook clean Specify a directory The clean command can take a directory as an argument to use as the book's root instead of the current working directory. mdbook clean path/to/book --dest-dir The --dest-dir (-d) option allows you to override the book's output directory, which will be deleted by this command. Relative paths are interpreted relative to the book's root directory. If not specified it will default to the value of the build.build-dir key in book.toml, or to ./book. mdbook clean --dest-dir=path/to/book path/to/book could be absolute or relative.","breadcrumbs":"Command Line Tool » The clean command","id":"11","title":"The clean command"},"12":{"body":"In this section you will learn how to: Structure your book correctly Format your SUMMARY.md file Configure your book using book.toml Customize your theme","breadcrumbs":"Format","id":"12","title":"Format"},"13":{"body":"The summary file is used by mdBook to know what chapters to include, in what order they should appear, what their hierarchy is and where the source files are. Without this file, there is no book. Even though SUMMARY.md is a markdown file, the formatting is very strict to allow for easy parsing. Let's see how you should format your SUMMARY.md file. Structure Title It's common practice to begin with a title, generally # Summary. But it is not mandatory, the parser just ignores it. So you can too if you feel like it. Prefix Chapter Before the main numbered chapters you can add a couple of elements that will not be numbered. This is useful for forewords, introductions, etc. There are however some constraints. You can not nest prefix chapters, they should all be on the root level. And you can not add prefix chapters once you have added numbered chapters. [Title of prefix element](relative/path/to/markdown.md) Part Title: Headers can be used as a title for the following numbered chapters. This can be used to logically separate different sections of book. The title is rendered as unclickable text. Titles are optional, and the numbered chapters can be broken into as many parts as desired. Numbered Chapter Numbered chapters are the main content of the book, they will be numbered and can be nested, resulting in a nice hierarchy (chapters, sub-chapters, etc.) # Title of Part - [Title of the Chapter](relative/path/to/markdown.md) # Title of Another Part - [More Chapters](relative/path/to/markdown2.md) You can either use - or * to indicate a numbered chapter. Suffix Chapter After the numbered chapters you can add a couple of non-numbered chapters. They are the same as prefix chapters but come after the numbered chapters instead of before. All other elements are unsupported and will be ignored at best or result in an error. Other elements Separators In between chapters you can add a separator. In the HTML renderer this will result in a line being rendered in the table of contents. A separator is a line containing exclusively dashes and at least three of them: ---. Draft chapters Draft chapters are chapters without a file and thus content. The purpose of a draft chapter is to signal future chapters still to be written. Or when still laying out the structure of the book to avoid creating the files while you are still changing the structure of the book a lot. Draft chapters will be rendered in the HTML renderer as disabled links in the table of contents, as you can see for the next chapter in the table of contents on the left. Draft chapters are written like normal chapters but without writing the path to the file - [Draft chapter]()","breadcrumbs":"Format » SUMMARY.md","id":"13","title":"SUMMARY.md"},"14":{"body":"You can configure the parameters for your book in the book.toml file. Here is an example of what a book.toml file might look like: [book]\ntitle = \"Example book\"\nauthor = \"John Doe\"\ndescription = \"The example book covers examples.\" [rust]\nedition = \"2018\" [build]\nbuild-dir = \"my-example-book\"\ncreate-missing = false [preprocessor.index] [preprocessor.links] [output.html]\nadditional-css = [\"custom.css\"] [output.html.search]\nlimit-results = 15","breadcrumbs":"Format » Configuration","id":"14","title":"Configuration"},"15":{"body":"It is important to note that any relative path specified in the configuration will always be taken relative from the root of the book where the configuration file is located. General metadata This is general information about your book. title: The title of the book authors: The author(s) of the book description: A description for the book, which is added as meta information in the html <head> of each page src: By default, the source directory is found in the directory named src directly under the root folder. But this is configurable with the src key in the configuration file. language: The main language of the book, which is used as a language attribute <html lang=\"en\"> for example. book.toml [book]\ntitle = \"Example book\"\nauthors = [\"John Doe\", \"Jane Doe\"]\ndescription = \"The example book covers examples.\"\nsrc = \"my-src\" # the source files will be found in `root/my-src` instead of `root/src`\nlanguage = \"en\" Rust options Options for the Rust language, relevant to running tests and playground integration. edition : Rust edition to use by default for the code snippets. Default is \"2015\". Individual code blocks can be controlled with the edition2015 or edition2018 annotations, such as: ```rust,edition2015\n// This only works in 2015.\nlet try = true;\n``` Build options This controls the build process of your book. build-dir: The directory to put the rendered book in. By default this is book/ in the book's root directory. create-missing: By default, any missing files specified in SUMMARY.md will be created when the book is built (i.e. create-missing = true). If this is false then the build process will instead exit with an error if any files do not exist. use-default-preprocessors: Disable the default preprocessors of (links & index) by setting this option to false. If you have the same, and/or other preprocessors declared via their table of configuration, they will run instead. For clarity, with no preprocessor configuration, the default links and index will run. Setting use-default-preprocessors = false will disable these default preprocessors from running. Adding [preprocessor.links], for example, will ensure, regardless of use-default-preprocessors that links it will run.","breadcrumbs":"Format » Supported configuration options","id":"15","title":"Supported configuration options"},"16":{"body":"The following preprocessors are available and included by default: links: Expand the {{ #playground }}, {{ #include }}, and {{ #rustdoc_include }} handlebars helpers in a chapter to include the contents of a file. index: Convert all chapter files named README.md into index.md. That is to say, all README.md would be rendered to an index file index.html in the rendered book. book.toml [build]\nbuild-dir = \"build\"\ncreate-missing = false [preprocessor.links] [preprocessor.index] Custom Preprocessor Configuration Like renderers, preprocessor will need to be given its own table (e.g. [preprocessor.mathjax]). In the section, you may then pass extra configuration to the preprocessor by adding key-value pairs to the table. For example [preprocessor.links]\n# set the renderers this preprocessor will run for\nrenderers = [\"html\"]\nsome_extra_feature = true Locking a Preprocessor dependency to a renderer You can explicitly specify that a preprocessor should run for a renderer by binding the two together. [preprocessor.mathjax]\nrenderers = [\"html\"] # mathjax only makes sense with the HTML renderer Provide Your Own Command By default when you add a [preprocessor.foo] table to your book.toml file, mdbook will try to invoke the mdbook-foo executable. If you want to use a different program name or pass in command-line arguments, this behaviour can be overridden by adding a command field. [preprocessor.random]\ncommand = \"python random.py\"","breadcrumbs":"Format » Configuring Preprocessors","id":"16","title":"Configuring Preprocessors"},"17":{"body":"HTML renderer options The HTML renderer has a couple of options as well. All the options for the renderer need to be specified under the TOML table [output.html]. The following configuration options are available: theme: mdBook comes with a default theme and all the resource files needed for it. But if this option is set, mdBook will selectively overwrite the theme files with the ones found in the specified folder. default-theme: The theme color scheme to select by default in the 'Change Theme' dropdown. Defaults to light. preferred-dark-theme: The default dark theme. This theme will be used if the browser requests the dark version of the site via the 'prefers-color-scheme' CSS media query. Defaults to navy. curly-quotes: Convert straight quotes to curly quotes, except for those that occur in code blocks and code spans. Defaults to false. mathjax-support: Adds support for MathJax . Defaults to false. copy-fonts: Copies fonts.css and respective font files to the output directory and use them in the default theme. Defaults to true. google-analytics: If you use Google Analytics, this option lets you enable it by simply specifying your ID in the configuration file. additional-css: If you need to slightly change the appearance of your book without overwriting the whole style, you can specify a set of stylesheets that will be loaded after the default ones where you can surgically change the style. additional-js: If you need to add some behaviour to your book without removing the current behaviour, you can specify a set of JavaScript files that will be loaded alongside the default one. no-section-label: mdBook by defaults adds section label in table of contents column. For example, \"1.\", \"2.1\". Set this option to true to disable those labels. Defaults to false. fold: A subtable for configuring sidebar section-folding behavior. playground: A subtable for configuring various playground settings. search: A subtable for configuring the in-browser search functionality. mdBook must be compiled with the search feature enabled (on by default). git-repository-url: A url to the git repository for the book. If provided an icon link will be output in the menu bar of the book. git-repository-icon: The FontAwesome icon class to use for the git repository link. Defaults to fa-github. redirect: A subtable used for generating redirects when a page is moved. The table contains key-value pairs where the key is where the redirect file needs to be created, as an absolute path from the build directory, (e.g. /appendices/bibliography.html). The value can be any valid URI the browser should navigate to (e.g. https://rust-lang.org/, /overview.html, or ../bibliography.html). input-404: The name of the markdown file used for misssing files. The corresponding output file will be the same, with the extension replaced with html. Defaults to 404.md. site-url: The url where the book will be hosted. This is required to ensure navigation links and script/css imports in the 404 file work correctly, even when accessing urls in subdirectories. Defaults to /. Available configuration options for the [output.html.fold] table: enable: Enable section-folding. When off, all folds are open. Defaults to false. level: The higher the more folded regions are open. When level is 0, all folds are closed. Defaults to 0. Available configuration options for the [output.html.playground] table: editable: Allow editing the source code. Defaults to false. copyable: Display the copy button on code snippets. Defaults to true. copy-js: Copy JavaScript files for the editor to the output directory. Defaults to true. line-numbers Display line numbers on editable sections of code. Requires both editable and copy-js to be true. Defaults to false. Available configuration options for the [output.html.search] table: enable: Enables the search feature. Defaults to true. limit-results: The maximum number of search results. Defaults to 30. teaser-word-count: The number of words used for a search result teaser. Defaults to 30. use-boolean-and: Define the logical link between multiple search words. If true, all search words must appear in each result. Defaults to false. boost-title: Boost factor for the search result score if a search word appears in the header. Defaults to 2. boost-hierarchy: Boost factor for the search result score if a search word appears in the hierarchy. The hierarchy contains all titles of the parent documents and all parent headings. Defaults to 1. boost-paragraph: Boost factor for the search result score if a search word appears in the text. Defaults to 1. expand: True if search should match longer results e.g. search micro should match microwave. Defaults to true. heading-split-level: Search results will link to a section of the document which contains the result. Documents are split into sections by headings this level or less. Defaults to 3. (### This is a level 3 heading) copy-js: Copy JavaScript files for the search implementation to the output directory. Defaults to true. This shows all available HTML output options in the book.toml : [book]\ntitle = \"Example book\"\nauthors = [\"John Doe\", \"Jane Doe\"]\ndescription = \"The example book covers examples.\" [output.html]\ntheme = \"my-theme\"\ndefault-theme = \"light\"\npreferred-dark-theme = \"navy\"\ncurly-quotes = true\nmathjax-support = false\ncopy-fonts = true\ngoogle-analytics = \"UA-123456-7\"\nadditional-css = [\"custom.css\", \"custom2.css\"]\nadditional-js = [\"custom.js\"]\nno-section-label = false\ngit-repository-url = \"https://github.com/rust-lang/mdBook\"\ngit-repository-icon = \"fa-github\"\nsite-url = \"/example-book/\"\ninput-404 = \"not-found.md\" [output.html.fold]\nenable = false\nlevel = 0 [output.html.playground]\neditable = false\ncopy-js = true\nline-numbers = false [output.html.search]\nenable = true\nlimit-results = 30\nteaser-word-count = 30\nuse-boolean-and = true\nboost-title = 2\nboost-hierarchy = 1\nboost-paragraph = 1\nexpand = true\nheading-split-level = 3\ncopy-js = true [output.html.redirect]\n\"/appendices/bibliography.html\" = \"https://rustc-dev-guide.rust-lang.org/appendix/bibliography.html\"\n\"/other-installation-methods.html\" = \"../infra/other-installation-methods.html\" Markdown Renderer The Markdown renderer will run preprocessors and then output the resulting Markdown. This is mostly useful for debugging preprocessors, especially in conjunction with mdbook test to see the Markdown that mdbook is passing to rustdoc. The Markdown renderer is included with mdbook but disabled by default. Enable it by adding an empty table to your book.toml as follows: [output.markdown] There are no configuration options for the Markdown renderer at this time; only whether it is enabled or disabled. See the preprocessors documentation for how to specify which preprocessors should run before the Markdown renderer. Custom Renderers A custom renderer can be enabled by adding a [output.foo] table to your book.toml. Similar to preprocessors this will instruct mdbook to pass a representation of the book to mdbook-foo for rendering. See the alternative backends chapter for more detail. The custom renderer has access to all the fields within its table (i.e. anything under [output.foo]). mdBook checks for two common fields: command: The command to execute for this custom renderer. Defaults to the name of the renderer with the mdbook- prefix (such as mdbook-foo). optional: If true, then the command will be ignored if it is not installed, otherwise mdBook will fail with an error. Defaults to false.","breadcrumbs":"Format » Configuring Renderers","id":"17","title":"Configuring Renderers"},"18":{"body":"All configuration values can be overridden from the command line by setting the corresponding environment variable. Because many operating systems restrict environment variables to be alphanumeric characters or _, the configuration key needs to be formatted slightly differently to the normal foo.bar.baz form. Variables starting with MDBOOK_ are used for configuration. The key is created by removing the MDBOOK_ prefix and turning the resulting string into kebab-case. Double underscores (__) separate nested keys, while a single underscore (_) is replaced with a dash (-). For example: MDBOOK_foo -> foo MDBOOK_FOO -> foo MDBOOK_FOO__BAR -> foo.bar MDBOOK_FOO_BAR -> foo-bar MDBOOK_FOO_bar__baz -> foo-bar.baz So by setting the MDBOOK_BOOK__TITLE environment variable you can override the book's title without needing to touch your book.toml. Note: To facilitate setting more complex config items, the value of an environment variable is first parsed as JSON, falling back to a string if the parse fails. This means, if you so desired, you could override all book metadata when building the book with something like $ export MDBOOK_BOOK=\"{'title': 'My Awesome Book', authors: ['Michael-F-Bryan']}\"\n$ mdbook build The latter case may be useful in situations where mdbook is invoked from a script or CI, where it sometimes isn't possible to update the book.toml before building.","breadcrumbs":"Format » Environment Variables","id":"18","title":"Environment Variables"},"19":{"body":"The default renderer uses a handlebars template to render your markdown files and comes with a default theme included in the mdBook binary. The theme is totally customizable, you can selectively replace every file from the theme by your own by adding a theme directory next to src folder in your project root. Create a new file with the name of the file you want to override and now that file will be used instead of the default file. Here are the files you can override: index.hbs is the handlebars template. head.hbs is appended to the HTML <head> section. header.hbs content is appended on top of every book page. book.css is the style used in the output. If you want to change the design of your book, this is probably the file you want to modify. Sometimes in conjunction with index.hbs when you want to radically change the layout. book.js is mostly used to add client side functionality, like hiding / un-hiding the sidebar, changing the theme, ... highlight.js is the JavaScript that is used to highlight code snippets, you should not need to modify this. highlight.css is the theme used for the code highlighting. favicon.svg and favicon.png the favicon that will be used. The SVG version is used by newer browsers . Generally, when you want to tweak the theme, you don't need to override all the files. If you only need changes in the stylesheet, there is no point in overriding all the other files. Because custom files take precedence over built-in ones, they will not get updated with new fixes / features. Note: When you override a file, it is possible that you break some functionality. Therefore I recommend to use the file from the default theme as template and only add / modify what you need. You can copy the default theme into your source directory automatically by using mdbook init --theme just remove the files you don't want to override. If you completely replace all built-in themes, be sure to also set output.html.preferred-dark-theme in the config, which defaults to the built-in navy theme.","breadcrumbs":"Format » Theme","id":"19","title":"Theme"},"2":{"body":"mdBook, all the source code, is released under the Mozilla Public License v2.0 .","breadcrumbs":"License","id":"2","title":"License"},"20":{"body":"index.hbs is the handlebars template that is used to render the book. The markdown files are processed to html and then injected in that template. If you want to change the layout or style of your book, chances are that you will have to modify this template a little bit. Here is what you need to know.","breadcrumbs":"Format » Theme » index.hbs","id":"20","title":"index.hbs"},"21":{"body":"A lot of data is exposed to the handlebars template with the \"context\". In the handlebars template you can access this information by using {{name_of_property}} Here is a list of the properties that are exposed: language Language of the book in the form en, as specified in book.toml (if not specified, defaults to en). To use in <html lang=\"{{ language }}\"> for example. title Title of the book, as specified in book.toml chapter_title Title of the current chapter, as listed in SUMMARY.md path Relative path to the original markdown file from the source directory content This is the rendered markdown. path_to_root This is a path containing exclusively ../'s that points to the root of the book from the current file. Since the original directory structure is maintained, it is useful to prepend relative links with this path_to_root. chapters Is an array of dictionaries of the form {\"section\": \"1.2.1\", \"name\": \"name of this chapter\", \"path\": \"dir/markdown.md\"} containing all the chapters of the book. It is used for example to construct the table of contents (sidebar).","breadcrumbs":"Format » Theme » Data","id":"21","title":"Data"},"22":{"body":"In addition to the properties you can access, there are some handlebars helpers at your disposal. 1. toc The toc helper is used like this {{#toc}}{{/toc}} and outputs something that looks like this, depending on the structure of your book <ul class=\"chapter\"> <li><a href=\"link/to/file.html\">Some chapter</a></li> <li> <ul class=\"section\"> <li><a href=\"link/to/other_file.html\">Some other Chapter</a></li> </ul> </li>\n</ul> If you would like to make a toc with another structure, you have access to the chapters property containing all the data. The only limitation at the moment is that you would have to do it with JavaScript instead of with a handlebars helper. <script>\nvar chapters = {{chapters}};\n// Processing here\n</script> 2. previous / next The previous and next helpers expose a link and name property to the previous and next chapters. They are used like this {{#previous}} <a href=\"{{link}}\" class=\"nav-chapters previous\"> <i class=\"fa fa-angle-left\"></i> </a>\n{{/previous}} The inner html will only be rendered if the previous / next chapter exists. Of course the inner html can be changed to your liking. If you would like other properties or helpers exposed, please create a new issue","breadcrumbs":"Format » Theme » Handlebars Helpers","id":"22","title":"Handlebars Helpers"},"23":{"body":"For syntax highlighting I use Highlight.js with a custom theme. Automatic language detection has been turned off, so you will probably want to specify the programming language you use like this ```rust\nfn main() { // Some code\n}\n```","breadcrumbs":"Format » Theme » Syntax Highlighting","id":"23","title":"Syntax Highlighting"},"24":{"body":"Like the rest of the theme, the files used for syntax highlighting can be overridden with your own. highlight.js normally you shouldn't have to overwrite this file, unless you want to use a more recent version. highlight.css theme used by highlight.js for syntax highlighting. If you want to use another theme for highlight.js download it from their website, or make it yourself, rename it to highlight.css and put it in the theme folder of your book. Now your theme will be used instead of the default theme.","breadcrumbs":"Format » Theme » Custom theme","id":"24","title":"Custom theme"},"25":{"body":"There is a feature in mdBook that lets you hide code lines by prepending them with a #. # fn main() { let x = 5; let y = 6; println!(\"{}\", x + y);\n# } Will render as # fn main() { let x = 5; let y = 7; println!(\"{}\", x + y);\n# } At the moment, this only works for code examples that are annotated with rust. Because it would collide with semantics of some programming languages. In the future, we want to make this configurable through the book.toml so that everyone can benefit from it.","breadcrumbs":"Format » Theme » Hiding code lines","id":"25","title":"Hiding code lines"},"26":{"body":"If you think the default theme doesn't look quite right for a specific language, or could be improved. Feel free to submit a new issue explaining what you have in mind and I will take a look at it. You could also create a pull-request with the proposed improvements. Overall the theme should be light and sober, without to many flashy colors.","breadcrumbs":"Format » Theme » Improve default theme","id":"26","title":"Improve default theme"},"27":{"body":"In addition to providing runnable code playgrounds, mdBook optionally allows them to be editable. In order to enable editable code blocks, the following needs to be added to the book.toml : [output.html.playground]\neditable = true To make a specific block available for editing, the attribute editable needs to be added to it: ```rust,editable\nfn main() { let number = 5; print!(\"{}\", number);\n}\n``` The above will result in this editable playground: fn main() { let number = 5; print!(\"{}\", number);\n} Note the new Undo Changes button in the editable playgrounds.","breadcrumbs":"Format » Theme » Editor","id":"27","title":"Editor"},"28":{"body":"By default, the editor is the Ace editor, but, if desired, the functionality may be overriden by providing a different folder: [output.html.playground]\neditable = true\neditor = \"/path/to/editor\" Note that for the editor changes to function correctly, the book.js inside of the theme folder will need to be overriden as it has some couplings with the default Ace editor.","breadcrumbs":"Format » Theme » Customizing the Editor","id":"28","title":"Customizing the Editor"},"29":{"body":"mdBook has optional support for math equations through MathJax . To enable MathJax, you need to add the mathjax-support key to your book.toml under the output.html section. [output.html]\nmathjax-support = true Note: The usual delimiters MathJax uses are not yet supported. You can't currently use $$ ... $$ as delimiters and the \\[ ... \\] delimiters need an extra backslash to work. Hopefully this limitation will be lifted soon. Note: When you use double backslashes in MathJax blocks (for example in commands such as \\begin{cases} \\frac 1 2 \\\\ \\frac 3 4 \\end{cases}) you need to add two extra backslashes (e.g., \\begin{cases} \\frac 1 2 \\\\\\\\ \\frac 3 4 \\end{cases}). Inline equations Inline equations are delimited by \\\\( and \\\\). So for example, to render the following inline equation \\( \\int x dx = \\frac{x^2}{2} + C \\) you would write the following: \\\\( \\int x dx = \\frac{x^2}{2} + C \\\\) Block equations Block equations are delimited by \\\\[ and \\\\]. To render the following equation \\[ \\mu = \\frac{1}{N} \\sum_{i=0} x_i \\] you would write: \\\\[ \\mu = \\frac{1}{N} \\sum_{i=0} x_i \\\\]","breadcrumbs":"Format » MathJax Support","id":"29","title":"MathJax Support"},"3":{"body":"mdBook can be used either as a command line tool or a Rust crate . Let's focus on the command line tool capabilities first.","breadcrumbs":"Command Line Tool","id":"3","title":"Command Line Tool"},"30":{"body":"","breadcrumbs":"Format » mdBook-specific markdown","id":"30","title":"mdBook-specific markdown"},"31":{"body":"There is a feature in mdBook that lets you hide code lines by prepending them with a # in the same way that Rustdoc does . # fn main() { let x = 5; let y = 6; println!(\"{}\", x + y);\n# } Will render as # fn main() { let x = 5; let y = 7; println!(\"{}\", x + y);\n# }","breadcrumbs":"Format » Hiding code lines","id":"31","title":"Hiding code lines"},"32":{"body":"With the following syntax, you can include files into your book: {{#include file.rs}} The path to the file has to be relative from the current source file. mdBook will interpret included files as markdown. Since the include command is usually used for inserting code snippets and examples, you will often wrap the command with ``` to display the file contents without interpretting them. ```\n{{#include file.rs}}\n```","breadcrumbs":"Format » Including files","id":"32","title":"Including files"},"33":{"body":"Often you only need a specific part of the file e.g. relevant lines for an example. We support four different modes of partial includes: {{#include file.rs:2}}\n{{#include file.rs::10}}\n{{#include file.rs:2:}}\n{{#include file.rs:2:10}} The first command only includes the second line from file file.rs. The second command includes all lines up to line 10, i.e. the lines from 11 till the end of the file are omitted. The third command includes all lines from line 2, i.e. the first line is omitted. The last command includes the excerpt of file.rs consisting of lines 2 to 10. To avoid breaking your book when modifying included files, you can also include a specific section using anchors instead of line numbers. An anchor is a pair of matching lines. The line beginning an anchor must match the regex \"ANCHOR:\\s*[\\w_-]+\" and similarly the ending line must match the regex \"ANCHOR_END:\\s*[\\w_-]+\". This allows you to put anchors in any kind of commented line. Consider the following file to include: /* ANCHOR: all */ // ANCHOR: component\nstruct Paddle { hello: f32,\n}\n// ANCHOR_END: component ////////// ANCHOR: system\nimpl System for MySystem { ... }\n////////// ANCHOR_END: system /* ANCHOR_END: all */ Then in the book, all you have to do is: Here is a component:\n```rust,no_run,noplayground\n{{#include file.rs:component}}\n``` Here is a system:\n```rust,no_run,noplayground\n{{#include file.rs:system}}\n``` This is the full file.\n```rust,no_run,noplayground\n{{#include file.rs:all}}\n``` Lines containing anchor patterns inside the included anchor are ignored.","breadcrumbs":"Format » Including portions of a file","id":"33","title":"Including portions of a file"},"34":{"body":"The rustdoc_include helper is for including code from external Rust files that contain complete examples, but only initially showing particular lines specified with line numbers or anchors in the same way as with include. The lines not in the line number range or between the anchors will still be included, but they will be prefaced with #. This way, a reader can expand the snippet to see the complete example, and Rustdoc will use the complete example when you run mdbook test. For example, consider a file named file.rs that contains this Rust program: fn main() { let x = add_one(2); assert_eq!(x, 3);\n} fn add_one(num: i32) -> i32 { num + 1\n} We can include a snippet that initially shows only line 2 by using this syntax: To call the `add_one` function, we pass it an `i32` and bind the returned value to `x`: ```rust\n{{#rustdoc_include file.rs:2}}\n``` This would have the same effect as if we had manually inserted the code and hidden all but line 2 using #: To call the `add_one` function, we pass it an `i32` and bind the returned value to `x`: ```rust\n# fn main() { let x = add_one(2);\n# assert_eq!(x, 3);\n# }\n#\n# fn add_one(num: i32) -> i32 {\n# num + 1\n#}\n``` That is, it looks like this (click the \"expand\" icon to see the rest of the file): # fn main() { let x = add_one(2);\n# assert_eq!(x, 3);\n# }\n#\n# fn add_one(num: i32) -> i32 {\n# num + 1\n#}","breadcrumbs":"Format » Including a file but initially hiding all except specified lines","id":"34","title":"Including a file but initially hiding all except specified lines"},"35":{"body":"With the following syntax, you can insert runnable Rust files into your book: {{#playground file.rs}} The path to the Rust file has to be relative from the current source file. When play is clicked, the code snippet will be sent to the Rust Playground to be compiled and run. The result is sent back and displayed directly underneath the code. Here is what a rendered code snippet looks like: fn main() { println!(\"Hello World!\");\n#\n# // You can even hide lines! :D\n# println!(\"I am hidden! Expand the code snippet to see me\");\n}","breadcrumbs":"Format » Inserting runnable Rust files","id":"35","title":"Inserting runnable Rust files"},"36":{"body":"While the following examples use Travis CI, their principles should straightforwardly transfer to other continuous integration providers as well.","breadcrumbs":"Running mdbook in Continuous Integration","id":"36","title":"Running mdbook in Continuous Integration"},"37":{"body":"Here is a sample Travis CI .travis.yml configuration that ensures mdbook build and mdbook test run successfully. The key to fast CI turnaround times is caching mdbook installs, so that you aren't compiling mdbook on every CI run. language: rust\nsudo: false cache: - cargo rust: - stable before_script: - (test -x $HOME/.cargo/bin/cargo-install-update || cargo install cargo-update) - (test -x $HOME/.cargo/bin/mdbook || cargo install --vers \"^0.3\" mdbook) - cargo install-update -a script: - mdbook build path/to/mybook && mdbook test path/to/mybook","breadcrumbs":"Ensuring Your Book Builds and Tests Pass","id":"37","title":"Ensuring Your Book Builds and Tests Pass"},"38":{"body":"Following these instructions will result in your book being published to GitHub pages after a successful CI run on your repository's master branch. First, create a new GitHub \"Personal Access Token\" with the \"public_repo\" permissions (or \"repo\" for private repositories). Go to your repository's Travis CI settings page and add an environment variable named GITHUB_TOKEN that is marked secure and not shown in the logs. Then, append this snippet to your .travis.yml and update the path to the book directory: deploy: provider: pages skip-cleanup: true github-token: $GITHUB_TOKEN local-dir: path/to/mybook/book keep-history: false on: branch: master That's it! Deploying to GitHub Pages manually If your CI doesn't support GitHub pages, or you're deploying somewhere else with integrations such as Github Pages: note: you may want to use different tmp dirs : $> git worktree add /tmp/book gh-pages\n$> mdbook build\n$> rm -rf /tmp/book/* # this won't delete the .git directory\n$> cp -rp book/* /tmp/book/\n$> cd /tmp/book\n$> git add -A\n$> git commit 'new book message'\n$> git push origin gh-pages\n$> cd - Or put this into a Makefile rule: .PHONY: deploy\ndeploy: book @echo \"====> deploying to github\" git worktree add /tmp/book gh-pages rm -rf /tmp/book/* cp -rp book/* /tmp/book/ cd /tmp/book && \\ git add -A && \\ git commit -m \"deployed on $(shell date) by ${USER}\" && \\ git push origin gh-pages","breadcrumbs":"Deploying Your Book to GitHub Pages","id":"38","title":"Deploying Your Book to GitHub Pages"},"39":{"body":"While mdbook is mainly used as a command line tool, you can also import the underlying library directly and use that to manage a book. It also has a fairly flexible plugin mechanism, allowing you to create your own custom tooling and consumers (often referred to as backends ) if you need to do some analysis of the book or render it in a different format. The For Developers chapters are here to show you the more advanced usage of mdbook. The two main ways a developer can hook into the book's build process is via, Preprocessors Alternative Backends","breadcrumbs":"For Developers","id":"39","title":"For Developers"},"4":{"body":"Precompiled binaries are provided for major platforms on a best-effort basis. Visit the releases page to download the appropriate version for your platform.","breadcrumbs":"Install From Binaries","id":"4","title":"Install From Binaries"},"40":{"body":"The process of rendering a book project goes through several steps. Load the book Parse the book.toml, falling back to the default Config if it doesn't exist Load the book chapters into memory Discover which preprocessors/backends should be used Run the preprocessors Call each backend in turn","breadcrumbs":"The Build Process","id":"40","title":"The Build Process"},"41":{"body":"The mdbook binary is just a wrapper around the mdbook crate, exposing its functionality as a command-line program. As such it is quite easy to create your own programs which use mdbook internally, adding your own functionality (e.g. a custom preprocessor) or tweaking the build process. The easiest way to find out how to use the mdbook crate is by looking at the API Docs . The top level documentation explains how one would use the MDBook type to load and build a book, while the config module gives a good explanation on the configuration system.","breadcrumbs":"Using mdbook as a Library","id":"41","title":"Using mdbook as a Library"},"42":{"body":"A preprocessor is simply a bit of code which gets run immediately after the book is loaded and before it gets rendered, allowing you to update and mutate the book. Possible use cases are: Creating custom helpers like {{#include /path/to/file.md}} Updating links so [some chapter](some_chapter.md) is automatically changed to [some chapter](some_chapter.html) for the HTML renderer Substituting in latex-style expressions ($$ \\frac{1}{3} $$) with their mathjax equivalents","breadcrumbs":"For Developers » Preprocessors","id":"42","title":"Preprocessors"},"43":{"body":"MDBook uses a fairly simple mechanism for discovering third party plugins. A new table is added to book.toml (e.g. preprocessor.foo for the foo preprocessor) and then mdbook will try to invoke the mdbook-foo program as part of the build process. While preprocessors can be hard-coded to specify which backend it should be run for (e.g. it doesn't make sense for MathJax to be used for non-HTML renderers) with the preprocessor.foo.renderer key. [book]\ntitle = \"My Book\"\nauthors = [\"Michael-F-Bryan\"] [preprocessor.foo]\n# The command can also be specified manually\ncommand = \"python3 /path/to/foo.py\"\n# Only run the `foo` preprocessor for the HTML and EPUB renderer\nrenderer = [\"html\", \"epub\"] In typical unix style, all inputs to the plugin will be written to stdin as JSON and mdbook will read from stdout if it is expecting output. The easiest way to get started is by creating your own implementation of the Preprocessor trait (e.g. in lib.rs) and then creating a shell binary which translates inputs to the correct Preprocessor method. For convenience, there is an example no-op preprocessor in the examples/ directory which can easily be adapted for other preprocessors. Example no-op preprocessor // nop-preprocessors.rs use crate::nop_lib::Nop;\nuse clap::{App, Arg, ArgMatches, SubCommand};\nuse mdbook::book::Book;\nuse mdbook::errors::Error;\nuse mdbook::preprocess::{CmdPreprocessor, Preprocessor, PreprocessorContext};\nuse std::io;\nuse std::process; pub fn make_app() -> App<'static, 'static> { App::new(\"nop-preprocessor\") .about(\"A mdbook preprocessor which does precisely nothing\") .subcommand( SubCommand::with_name(\"supports\") .arg(Arg::with_name(\"renderer\").required(true)) .about(\"Check whether a renderer is supported by this preprocessor\"), )\n} fn main() { let matches = make_app().get_matches(); // Users will want to construct their own preprocessor here let preprocessor = Nop::new(); if let Some(sub_args) = matches.subcommand_matches(\"supports\") { handle_supports(&preprocessor, sub_args); } else if let Err(e) = handle_preprocessing(&preprocessor) { eprintln!(\"{}\", e); process::exit(1); }\n} fn handle_preprocessing(pre: &dyn Preprocessor) -> Result<(), Error> { let (ctx, book) = CmdPreprocessor::parse_input(io::stdin())?; if ctx.mdbook_version != mdbook::MDBOOK_VERSION { // We should probably use the `semver` crate to check compatibility // here... eprintln!( \"Warning: The {} plugin was built against version {} of mdbook, \\ but we're being called from version {}\", pre.name(), mdbook::MDBOOK_VERSION, ctx.mdbook_version ); } let processed_book = pre.run(&ctx, book)?; serde_json::to_writer(io::stdout(), &processed_book)?; Ok(())\n} fn handle_supports(pre: &dyn Preprocessor, sub_args: &ArgMatches) -> ! { let renderer = sub_args.value_of(\"renderer\").expect(\"Required argument\"); let supported = pre.supports_renderer(&renderer); // Signal whether the renderer is supported by exiting with 1 or 0. if supported { process::exit(0); } else { process::exit(1); }\n} /// The actual implementation of the `Nop` preprocessor. This would usually go\n/// in your main `lib.rs` file.\nmod nop_lib { use super::*; /// A no-op preprocessor. pub struct Nop; impl Nop { pub fn new() -> Nop { Nop } } impl Preprocessor for Nop { fn name(&self) -> &str { \"nop-preprocessor\" } fn run(&self, ctx: &PreprocessorContext, book: Book) -> Result<Book, Error> { // In testing we want to tell the preprocessor to blow up by setting a // particular config value if let Some(nop_cfg) = ctx.config.get_preprocessor(self.name()) { if nop_cfg.contains_key(\"blow-up\") { anyhow::bail!(\"Boom!!1!\"); } } // we *are* a no-op preprocessor after all Ok(book) } fn supports_renderer(&self, renderer: &str) -> bool { renderer != \"not-supported\" } }\n}","breadcrumbs":"For Developers » Hooking Into MDBook","id":"43","title":"Hooking Into MDBook"},"44":{"body":"By pulling in mdbook as a library, preprocessors can have access to the existing infrastructure for dealing with books. For example, a custom preprocessor could use the CmdPreprocessor::parse_input() function to deserialize the JSON written to stdin. Then each chapter of the Book can be mutated in-place via Book::for_each_mut() , and then written to stdout with the serde_json crate. Chapters can be accessed either directly (by recursively iterating over chapters) or via the Book::for_each_mut() convenience method. The chapter.content is just a string which happens to be markdown. While it's entirely possible to use regular expressions or do a manual find & replace, you'll probably want to process the input into something more computer-friendly. The pulldown-cmark crate implements a production-quality event-based Markdown parser, with the pulldown-cmark-to-cmark allowing you to translate events back into markdown text. The following code block shows how to remove all emphasis from markdown, without accidentally breaking the document. fn remove_emphasis( num_removed_items: &mut usize, chapter: &mut Chapter,\n) -> Result<String> { let mut buf = String::with_capacity(chapter.content.len()); let events = Parser::new(&chapter.content).filter(|e| { let should_keep = match *e { Event::Start(Tag::Emphasis) | Event::Start(Tag::Strong) | Event::End(Tag::Emphasis) | Event::End(Tag::Strong) => false, _ => true, }; if !should_keep { *num_removed_items += 1; } should_keep }); cmark(events, &mut buf, None).map(|_| buf).map_err(|err| { Error::from(format!(\"Markdown serialization failed: {}\", err)) })\n} For everything else, have a look at the complete example .","breadcrumbs":"For Developers » Hints For Implementing A Preprocessor","id":"44","title":"Hints For Implementing A Preprocessor"},"45":{"body":"A \"backend\" is simply a program which mdbook will invoke during the book rendering process. This program is passed a JSON representation of the book and configuration information via stdin. Once the backend receives this information it is free to do whatever it wants. There are already several alternative backends on GitHub which can be used as a rough example of how this is accomplished in practice. mdbook-linkcheck - a simple program for verifying the book doesn't contain any broken links mdbook-epub - an EPUB renderer mdbook-test - a program to run the book's contents through rust-skeptic to verify everything compiles and runs correctly (similar to rustdoc --test) This page will step you through creating your own alternative backend in the form of a simple word counting program. Although it will be written in Rust, there's no reason why it couldn't be accomplished using something like Python or Ruby.","breadcrumbs":"For Developers » Alternative Backends","id":"45","title":"Alternative Backends"},"46":{"body":"First you'll want to create a new binary program and add mdbook as a dependency. $ cargo new --bin mdbook-wordcount\n$ cd mdbook-wordcount\n$ cargo add mdbook When our mdbook-wordcount plugin is invoked, mdbook will send it a JSON version of RenderContext via our plugin's stdin. For convenience, there's a RenderContext::from_json() constructor which will load a RenderContext. This is all the boilerplate necessary for our backend to load the book. // src/main.rs\nextern crate mdbook; use std::io;\nuse mdbook::renderer::RenderContext; fn main() { let mut stdin = io::stdin(); let ctx = RenderContext::from_json(&mut stdin).unwrap();\n} Note: The RenderContext contains a version field. This lets backends figure out whether they are compatible with the version of mdbook it's being called by. This version comes directly from the corresponding field in mdbook's Cargo.toml. It is recommended that backends use the semver crate to inspect this field and emit a warning if there may be a compatibility issue.","breadcrumbs":"For Developers » Setting Up","id":"46","title":"Setting Up"},"47":{"body":"Now our backend has a copy of the book, lets count how many words are in each chapter! Because the RenderContext contains a Book field (book), and a Book has the Book::iter() method for iterating over all items in a Book, this step turns out to be just as easy as the first. fn main() { let mut stdin = io::stdin(); let ctx = RenderContext::from_json(&mut stdin).unwrap(); for item in ctx.book.iter() { if let BookItem::Chapter(ref ch) = *item { let num_words = count_words(ch); println!(\"{}: {}\", ch.name, num_words); } }\n} fn count_words(ch: &Chapter) -> usize { ch.content.split_whitespace().count()\n}","breadcrumbs":"For Developers » Inspecting the Book","id":"47","title":"Inspecting the Book"},"48":{"body":"Now we've got the basics running, we want to actually use it. First, install the program. $ cargo install --path . Then cd to the particular book you'd like to count the words of and update its book.toml file. [book] title = \"mdBook Documentation\" description = \"Create book from markdown files. Like Gitbook but implemented in Rust\" authors = [\"Mathieu David\", \"Michael-F-Bryan\"] + [output.html] + [output.wordcount] When it loads a book into memory, mdbook will inspect your book.toml file to try and figure out which backends to use by looking for all output.* tables. If none are provided it'll fall back to using the default HTML renderer. Notably, this means if you want to add your own custom backend you'll also need to make sure to add the HTML backend, even if its table just stays empty. Now you just need to build your book like normal, and everything should Just Work . $ mdbook build\n...\n2018-01-16 07:31:15 [INFO] (mdbook::renderer): Invoking the \"mdbook-wordcount\" renderer\nmdBook: 126\nCommand Line Tool: 224\ninit: 283\nbuild: 145\nwatch: 146\nserve: 292\ntest: 139\nFormat: 30\nSUMMARY.md: 259\nConfiguration: 784\nTheme: 304\nindex.hbs: 447\nSyntax highlighting: 314\nMathJax Support: 153\nRust code specific features: 148\nFor Developers: 788\nAlternative Backends: 710\nContributors: 85 The reason we didn't need to specify the full name/path of our wordcount backend is because mdbook will try to infer the program's name via convention. The executable for the foo backend is typically called mdbook-foo, with an associated [output.foo] entry in the book.toml. To explicitly tell mdbook what command to invoke (it may require command-line arguments or be an interpreted script), you can use the command field. [book] title = \"mdBook Documentation\" description = \"Create book from markdown files. Like Gitbook but implemented in Rust\" authors = [\"Mathieu David\", \"Michael-F-Bryan\"] [output.html] [output.wordcount]\n+ command = \"python /path/to/wordcount.py\"","breadcrumbs":"For Developers » Enabling the Backend","id":"48","title":"Enabling the Backend"},"49":{"body":"Now imagine you don't want to count the number of words on a particular chapter (it might be generated text/code, etc). The canonical way to do this is via the usual book.toml configuration file by adding items to your [output.foo] table. The Config can be treated roughly as a nested hashmap which lets you call methods like get() to access the config's contents, with a get_deserialized() convenience method for retrieving a value and automatically deserializing to some arbitrary type T. To implement this, we'll create our own serializable WordcountConfig struct which will encapsulate all configuration for this backend. First add serde and serde_derive to your Cargo.toml, $ cargo add serde serde_derive And then you can create the config struct, extern crate serde;\n#[macro_use]\nextern crate serde_derive; ... #[derive(Debug, Default, Serialize, Deserialize)]\n#[serde(default, rename_all = \"kebab-case\")]\npub struct WordcountConfig { pub ignores: Vec<String>,\n} Now we just need to deserialize the WordcountConfig from our RenderContext and then add a check to make sure we skip ignored chapters. fn main() { let mut stdin = io::stdin(); let ctx = RenderContext::from_json(&mut stdin).unwrap();\n+ let cfg: WordcountConfig = ctx.config\n+ .get_deserialized(\"output.wordcount\")\n+ .unwrap_or_default(); for item in ctx.book.iter() { if let BookItem::Chapter(ref ch) = *item {\n+ if cfg.ignores.contains(&ch.name) {\n+ continue;\n+ }\n+ let num_words = count_words(ch); println!(\"{}: {}\", ch.name, num_words); } } }","breadcrumbs":"For Developers » Configuration","id":"49","title":"Configuration"},"5":{"body":"mdBook can also be installed from source Pre-requisite mdBook is written in Rust and therefore needs to be compiled with Cargo . If you haven't already installed Rust, please go ahead and install it now. Install Crates.io version Installing mdBook is relatively easy if you already have Rust and Cargo installed. You just have to type this snippet in your terminal: cargo install mdbook This will fetch the source code for the latest release from Crates.io and compile it. You will have to add Cargo's bin directory to your PATH. Run mdbook help in your terminal to verify if it works. Congratulations, you have installed mdBook! Install Git version The git version contains all the latest bug-fixes and features, that will be released in the next version on Crates.io , if you can't wait until the next release. You can build the git version yourself. Open your terminal and navigate to the directory of you choice. We need to clone the git repository and then build it with Cargo. git clone --depth=1 https://github.com/rust-lang/mdBook.git\ncd mdBook\ncargo build --release The executable mdbook will be in the ./target/release folder, this should be added to the path.","breadcrumbs":"Install From Source","id":"5","title":"Install From Source"},"50":{"body":"While it's nice to print word counts to the terminal when a book is built, it might also be a good idea to output them to a file somewhere. mdbook tells a backend where it should place any generated output via the destination field in RenderContext . + use std::fs::{self, File};\n+ use std::io::{self, Write};\n- use std::io; use mdbook::renderer::RenderContext; use mdbook::book::{BookItem, Chapter}; fn main() { ... + let _ = fs::create_dir_all(&ctx.destination);\n+ let mut f = File::create(ctx.destination.join(\"wordcounts.txt\")).unwrap();\n+ for item in ctx.book.iter() { if let BookItem::Chapter(ref ch) = *item { ... let num_words = count_words(ch); println!(\"{}: {}\", ch.name, num_words);\n+ writeln!(f, \"{}: {}\", ch.name, num_words).unwrap(); } } } Note: There is no guarantee that the destination directory exists or is empty (mdbook may leave the previous contents to let backends do caching), so it's always a good idea to create it with fs::create_dir_all(). If the destination directory already exists, don't assume it will be empty. To allow backends to cache the results from previous runs, mdbook may leave old content in the directory. There's always the possibility that an error will occur while processing a book (just look at all the unwrap()'s we've written already), so mdbook will interpret a non-zero exit code as a rendering failure. For example, if we wanted to make sure all chapters have an even number of words, erroring out if an odd number is encountered, then you may do something like this: + use std::process; ... fn main() { ... for item in ctx.book.iter() { if let BookItem::Chapter(ref ch) = *item { ... let num_words = count_words(ch); println!(\"{}: {}\", ch.name, num_words); writeln!(f, \"{}: {}\", ch.name, num_words).unwrap(); + if cfg.deny_odds && num_words % 2 == 1 {\n+ eprintln!(\"{} has an odd number of words!\", ch.name);\n+ process::exit(1); } } } } #[derive(Debug, Default, Serialize, Deserialize)] #[serde(default, rename_all = \"kebab-case\")] pub struct WordcountConfig { pub ignores: Vec<String>,\n+ pub deny_odds: bool, } Now, if we reinstall the backend and build a book, $ cargo install --path . --force\n$ mdbook build /path/to/book\n...\n2018-01-16 21:21:39 [INFO] (mdbook::renderer): Invoking the \"wordcount\" renderer\nmdBook: 126\nCommand Line Tool: 224\ninit: 283\ninit has an odd number of words!\n2018-01-16 21:21:39 [ERROR] (mdbook::renderer): Renderer exited with non-zero return code.\n2018-01-16 21:21:39 [ERROR] (mdbook::utils): Error: Rendering failed\n2018-01-16 21:21:39 [ERROR] (mdbook::utils): Caused By: The \"mdbook-wordcount\" renderer failed As you've probably already noticed, output from the plugin's subprocess is immediately passed through to the user. It is encouraged for plugins to follow the \"rule of silence\" and only generate output when necessary (e.g. an error in generation or a warning). All environment variables are passed through to the backend, allowing you to use the usual RUST_LOG to control logging verbosity.","breadcrumbs":"For Developers » Output and Signalling Failure","id":"50","title":"Output and Signalling Failure"},"51":{"body":"If you enable a backend that isn't installed, the default behavior is to throw an error: The command wasn't found, is the \"wordcount\" backend installed? This behavior can be changed by marking the backend as optional. [book] title = \"mdBook Documentation\" description = \"Create book from markdown files. Like Gitbook but implemented in Rust\" authors = [\"Mathieu David\", \"Michael-F-Bryan\"] [output.html] [output.wordcount] command = \"python /path/to/wordcount.py\"\n+ optional = true This demotes the error to a warning, and it will instead look like this: The command was not found, but was marked as optional. Command: wordcount","breadcrumbs":"For Developers » Handling missing backends","id":"51","title":"Handling missing backends"},"52":{"body":"Although contrived, hopefully this example was enough to show how you'd create an alternative backend for mdbook. If you feel it's missing something, don't hesitate to create an issue in the issue tracker so we can improve the user guide. The existing backends mentioned towards the start of this chapter should serve as a good example of how it's done in real life, so feel free to skim through the source code or ask questions.","breadcrumbs":"For Developers » Wrapping Up","id":"52","title":"Wrapping Up"},"53":{"body":"Here is a list of the contributors who have helped improving mdBook. Big shout-out to them! mdinger Kevin ( kbknapp ) Steve Klabnik ( steveklabnik ) Adam Solove ( asolove ) Wayne Nilsen ( waynenilsen ) funnkill Fu Gangqiang ( FuGangqiang ) Michael-F-Bryan Chris Spiegel ( cspiegel ) projektir Phaiax Matt Ickstadt ( mattico ) Weihang Lo ( @weihanglo ) If you feel you're missing from this list, feel free to add yourself in a PR.","breadcrumbs":"Contributors","id":"53","title":"Contributors"},"6":{"body":"There is some minimal boilerplate that is the same for every new book. It's for this purpose that mdBook includes an init command. The init command is used like this: mdbook init When using the init command for the first time, a couple of files will be set up for you: book-test/\n├── book\n└── src ├── chapter_1.md └── SUMMARY.md The src directory is where you write your book in markdown. It contains all the source files, configuration files, etc. The book directory is where your book is rendered. All the output is ready to be uploaded to a server to be seen by your audience. The SUMMARY.md file is the most important file, it's the skeleton of your book and is discussed in more detail in another chapter Tip: Generate chapters from SUMMARY.md When a SUMMARY.md file already exists, the init command will first parse it and generate the missing files according to the paths used in the SUMMARY.md. This allows you to think and create the whole structure of your book and then let mdBook generate it for you. Specify a directory The init command can take a directory as an argument to use as the book's root instead of the current working directory. mdbook init path/to/book --theme When you use the --theme flag, the default theme will be copied into a directory called theme in your source directory so that you can modify it. The theme is selectively overwritten, this means that if you don't want to overwrite a specific file, just delete it and the default file will be used.","breadcrumbs":"Command Line Tool » The init command","id":"6","title":"The init command"},"7":{"body":"The build command is used to render your book: mdbook build It will try to parse your SUMMARY.md file to understand the structure of your book and fetch the corresponding files. The rendered output will maintain the same directory structure as the source for convenience. Large books will therefore remain structured when rendered. Specify a directory The build command can take a directory as an argument to use as the book's root instead of the current working directory. mdbook build path/to/book --open When you use the --open (-o) flag, mdbook will open the rendered book in your default web browser after building it. --dest-dir The --dest-dir (-d) option allows you to change the output directory for the book. Relative paths are interpreted relative to the book's root directory. If not specified it will default to the value of the build.build-dir key in book.toml, or to ./book. Note: The build command copies all files (excluding files with .md extension) from the source directory into the build directory.","breadcrumbs":"Command Line Tool » The build command","id":"7","title":"The build command"},"8":{"body":"The watch command is useful when you want your book to be rendered on every file change. You could repeatedly issue mdbook build every time a file is changed. But using mdbook watch once will watch your files and will trigger a build automatically whenever you modify a file. Specify a directory The watch command can take a directory as an argument to use as the book's root instead of the current working directory. mdbook watch path/to/book --open When you use the --open (-o) option, mdbook will open the rendered book in your default web browser. --dest-dir The --dest-dir (-d) option allows you to change the output directory for the book. Relative paths are interpreted relative to the book's root directory. If not specified it will default to the value of the build.build-dir key in book.toml, or to ./book. Specify exclude patterns The watch command will not automatically trigger a build for files listed in the .gitignore file in the book root directory. The .gitignore file may contain file patterns described in the gitignore documentation . This can be useful for ignoring temporary files created by some editors. Note: Only .gitignore from book root directory is used. Global $HOME/.gitignore or .gitignore files in parent directories are not used.","breadcrumbs":"Command Line Tool » The watch command","id":"8","title":"The watch command"},"9":{"body":"The serve command is used to preview a book by serving it over HTTP at localhost:3000 by default. Additionally it watches the book's directory for changes, rebuilding the book and refreshing clients for each change. A websocket connection is used to trigger the client-side refresh. Note: The serve command is for testing a book's HTML output, and is not intended to be a complete HTTP server for a website. Specify a directory The serve command can take a directory as an argument to use as the book's root instead of the current working directory. mdbook serve path/to/book Server options serve has four options: the HTTP port, the WebSocket port, the HTTP hostname to listen on, and the hostname for the browser to connect to for WebSockets. For example: suppose you have an nginx server for SSL termination which has a public address of 192.168.1.100 on port 80 and proxied that to 127.0.0.1 on port 8000. To run use the nginx proxy do: mdbook serve path/to/book -p 8000 -n 127.0.0.1 --websocket-hostname 192.168.1.100 If you were to want live reloading for this you would need to proxy the websocket calls through nginx as well from 192.168.1.100:<WS_PORT> to 127.0.0.1:<WS_PORT>. The -w flag allows for the websocket port to be configured. --open When you use the --open (-o) flag, mdbook will open the book in your default web browser after starting the server. --dest-dir The --dest-dir (-d) option allows you to change the output directory for the book. Relative paths are interpreted relative to the book's root directory. If not specified it will default to the value of the build.build-dir key in book.toml, or to ./book. Specify exclude patterns The serve command will not automatically trigger a build for files listed in the .gitignore file in the book root directory. The .gitignore file may contain file patterns described in the gitignore documentation . This can be useful for ignoring temporary files created by some editors. Note: Only .gitignore from book root directory is used. Global $HOME/.gitignore or .gitignore files in parent directories are not used.","breadcrumbs":"Command Line Tool » The serve command","id":"9","title":"The serve command"}},"length":54,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"3":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"1":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":2.0}}},"7":{":":{"3":{"1":{":":{"1":{"5":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"17":{"tf":1.7320508075688772},"43":{"tf":1.0}}},"1":{".":{"2":{".":{"1":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"33":{"tf":1.0}}},"2":{"3":{"4":{"5":{"6":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.0}}},"7":{".":{"0":{".":{"0":{".":{"1":{":":{"<":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"9":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"4":{"5":{"df":1,"docs":{"48":{"tf":1.0}}},"6":{"df":1,"docs":{"48":{"tf":1.0}}},"8":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"5":{"3":{"df":1,"docs":{"48":{"tf":1.0}}},"df":1,"docs":{"14":{"tf":1.0}}},"6":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":2.0}}},"9":{"2":{".":{"1":{"6":{"8":{".":{"1":{".":{"1":{"0":{"0":{":":{"<":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"17":{"tf":2.23606797749979},"22":{"tf":1.0},"29":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.0}}},"2":{".":{"1":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"0":{"1":{"5":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}},"8":{"df":3,"docs":{"14":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{":":{"2":{"1":{":":{"3":{"9":{"df":1,"docs":{"50":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"4":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{}},"5":{"9":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"8":{"3":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{}},"9":{"2":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":6,"docs":{"17":{"tf":1.4142135623730951},"22":{"tf":1.0},"29":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"50":{"tf":1.0}}},"3":{"0":{"4":{"df":1,"docs":{"48":{"tf":1.0}}},"df":2,"docs":{"17":{"tf":2.0},"48":{"tf":1.0}}},"1":{"4":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"17":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772}}},"4":{"0":{"4":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"17":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"4":{"7":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"5":{"df":3,"docs":{"25":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951}}},"6":{"df":2,"docs":{"25":{"tf":1.0},"31":{"tf":1.0}}},"7":{"1":{"0":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"8":{"4":{"df":1,"docs":{"48":{"tf":1.0}}},"8":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"17":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.0}}},"8":{"0":{"0":{"0":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.0}}},"5":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"_":{"_":{"df":1,"docs":{"18":{"tf":1.0}}},"b":{"a":{"df":0,"docs":{},"r":{"_":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"18":{"tf":1.4142135623730951},"44":{"tf":1.0},"50":{"tf":1.0}}},"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"\"":{"a":{"df":1,"docs":{"43":{"tf":1.0}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"27":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"17":{"tf":1.0}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"38":{"tf":1.0},"44":{"tf":1.4142135623730951},"49":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}}}}},"r":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"28":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"43":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"53":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}},"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.4142135623730951}},"e":{"(":{"2":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}},"df":12,"docs":{"10":{"tf":1.0},"13":{"tf":2.0},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"38":{"tf":2.23606797749979},"46":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"5":{"tf":1.0},"53":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"14":{"tf":1.0},"17":{"tf":2.0},"22":{"tf":1.0},"27":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":10,"docs":{"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"27":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":14,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"1":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":4,"docs":{"45":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"6":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"17":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.7320508075688772},"48":{"tf":1.0},"52":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"45":{"tf":1.0},"52":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"15":{"tf":1.0},"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}},"t":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{"\\":{"df":0,"docs":{},"s":{"*":{"[":{"\\":{"df":0,"docs":{},"w":{"_":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{":":{"\\":{"df":0,"docs":{},"s":{"*":{"[":{"\\":{"df":0,"docs":{},"w":{"_":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"33":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":2,"docs":{"33":{"tf":3.0},"34":{"tf":1.4142135623730951}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"25":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"13":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"6":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{":":{":":{"b":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"!":{"(":{"\"":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"!":{"!":{"1":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"41":{"tf":1.0}}},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\"":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"'":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":2.23606797749979}}}},"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"38":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"b":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\"":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"52":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"27":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":1,"docs":{"15":{"tf":1.0}}},"df":7,"docs":{"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"42":{"tf":1.0},"49":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":1,"docs":{"10":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.23606797749979},"27":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"13":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"18":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":12,"docs":{"17":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":2.6457513110645907},"49":{"tf":1.0},"50":{"tf":2.23606797749979},"51":{"tf":2.0},"52":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"48":{"tf":1.0}}},"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"13":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0},"42":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"33":{"tf":1.0}},"{":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"51":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"4":{"tf":1.0}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"34":{"tf":1.0}}}}}}}},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"53":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"19":{"tf":1.0},"4":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0}}}}},"d":{"df":2,"docs":{"16":{"tf":1.0},"34":{"tf":1.4142135623730951}}},"df":2,"docs":{"46":{"tf":1.0},"5":{"tf":1.0}}},"t":{"df":2,"docs":{"20":{"tf":1.0},"42":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"10":{"tf":2.0},"15":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"44":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"43":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"46":{"tf":1.0},"6":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"'":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"15":{"tf":1.0},"18":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":2.0}}},".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{},"j":{"df":2,"docs":{"19":{"tf":1.0},"28":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":19,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}},"df":37,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":2.23606797749979},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":2.23606797749979},"14":{"tf":2.23606797749979},"15":{"tf":3.605551275463989},"16":{"tf":1.0},"17":{"tf":3.1622776601683795},"18":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":2.0},"22":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":2.6457513110645907},"39":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":2.449489742783178},"44":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772},"46":{"tf":1.0},"47":{"tf":2.449489742783178},"48":{"tf":2.6457513110645907},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"6":{"tf":2.8284271247461903},"7":{"tf":2.449489742783178},"8":{"tf":2.449489742783178},"9":{"tf":2.6457513110645907}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":3,"docs":{"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"l":{"df":2,"docs":{"43":{"tf":1.0},"50":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":3.0}}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":3,"docs":{"19":{"tf":1.0},"33":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"45":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"17":{"tf":1.7320508075688772},"19":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}},"y":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"18":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0},"53":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"f":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"g":{"df":1,"docs":{"5":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":19,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":2.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":1.7320508075688772},"37":{"tf":1.7320508075688772},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"48":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"7":{"tf":2.8284271247461903},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":4,"docs":{"15":{"tf":1.0},"19":{"tf":1.7320508075688772},"43":{"tf":1.0},"50":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"17":{"tf":1.0},"27":{"tf":1.0}}}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":8,"docs":{"34":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"5":{"tf":1.0}}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"46":{"tf":1.0},"49":{"tf":1.0}}}}}}},"df":6,"docs":{"37":{"tf":2.23606797749979},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":2.23606797749979},"50":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"18":{"tf":1.4142135623730951},"42":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"10":{"tf":1.0},"50":{"tf":1.0}}}}},"d":{"df":4,"docs":{"38":{"tf":1.7320508075688772},"46":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0}}},"df":1,"docs":{"29":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"g":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"o":{"d":{"d":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"&":{"c":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":1,"docs":{"49":{"tf":1.0}}}},"h":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":2.23606797749979}}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":13,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.7320508075688772},"19":{"tf":2.0},"20":{"tf":1.0},"22":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"42":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"/":{"a":{">":{"<":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"m":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"_":{"1":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"df":13,"docs":{"13":{"tf":5.385164807134504},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"21":{"tf":2.0},"22":{"tf":2.449489742783178},"39":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":2.23606797749979},"47":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"52":{"tf":1.0},"6":{"tf":1.4142135623730951}},"s":{"]":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"2":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"17":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"53":{"tf":1.0}}}}},"i":{"df":4,"docs":{"18":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.7320508075688772},"38":{"tf":1.7320508075688772}}},"l":{"a":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"{":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"=":{"\"":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":2.449489742783178}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"34":{"tf":1.0},"35":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":1,"docs":{"44":{"tf":1.7320508075688772}}}}},"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"44":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":20,"docs":{"0":{"tf":1.0},"10":{"tf":2.449489742783178},"15":{"tf":1.4142135623730951},"17":{"tf":2.23606797749979},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"32":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":2.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"52":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"26":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":4,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"46":{"tf":1.0}}},"m":{"a":{"df":1,"docs":{"10":{"tf":1.0}},"n":{"d":{"df":20,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"11":{"tf":2.0},"16":{"tf":2.0},"17":{"tf":1.7320508075688772},"18":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"33":{"tf":2.0},"39":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"48":{"tf":2.23606797749979},"50":{"tf":1.0},"51":{"tf":2.0},"6":{"tf":2.449489742783178},"7":{"tf":2.0},"8":{"tf":2.0},"9":{"tf":2.23606797749979}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.0},"46":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":5,"docs":{"17":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"19":{"tf":1.0},"34":{"tf":1.7320508075688772},"44":{"tf":1.0},"9":{"tf":1.0}}},"x":{"df":1,"docs":{"18":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"49":{"tf":1.0}}},"df":6,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":14,"docs":{"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":2.6457513110645907},"16":{"tf":1.7320508075688772},"17":{"tf":3.1622776601683795},"18":{"tf":1.7320508075688772},"25":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.7320508075688772},"6":{"tf":1.0},"9":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"19":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"33":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"43":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":14,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"13":{"tf":2.23606797749979},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.4142135623730951},"32":{"tf":1.0},"45":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":2,"docs":{"36":{"tf":1.4142135623730951},"49":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"48":{"tf":1.0},"53":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"52":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"50":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":5,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"7":{"tf":1.0}}},"t":{"df":1,"docs":{"48":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":5,"docs":{"17":{"tf":3.3166247903554},"19":{"tf":1.0},"47":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}},"y":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"12":{"tf":1.0},"17":{"tf":1.0},"28":{"tf":1.0},"45":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"46":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"s":{"(":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"47":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":6,"docs":{"17":{"tf":1.4142135623730951},"45":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"17":{"tf":1.0},"28":{"tf":1.0},"6":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"22":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0}}}}}},"p":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"3":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":25,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"s":{"df":2,"docs":{"14":{"tf":1.0},"17":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"x":{".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"49":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":4,"docs":{"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.4142135623730951},"29":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"14":{"tf":1.0},"17":{"tf":1.0}}}}},"df":0,"docs":{},"j":{"df":1,"docs":{"17":{"tf":1.0}}}},"2":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":12,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.0},"19":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}}}},"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"17":{"tf":2.0},"19":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"13":{"tf":1.0},"18":{"tf":1.0}}}},"t":{"a":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"38":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}},"df":0,"docs":{}}}},"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"35":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":19,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"15":{"tf":3.3166247903554},"16":{"tf":1.4142135623730951},"17":{"tf":6.164414002968976},"19":{"tf":2.449489742783178},"21":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"40":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"38":{"tf":1.0},"6":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"29":{"tf":2.23606797749979}}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"o":{"d":{"d":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"16":{"tf":1.0},"22":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"38":{"tf":2.8284271247461903}}}}},"t":{"df":0,"docs":{},"h":{"=":{"1":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"49":{"tf":1.0},"50":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"17":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"44":{"tf":1.0},"49":{"tf":1.7320508075688772},"50":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}},"r":{"df":3,"docs":{"13":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0}}}},"t":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"50":{"tf":1.7320508075688772}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"17":{"tf":1.0},"6":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"17":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"39":{"tf":1.7320508075688772},"48":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"13":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0}}}}}},"r":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"=":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":9,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"38":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772}},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"15":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":14,"docs":{"10":{"tf":2.6457513110645907},"11":{"tf":2.23606797749979},"15":{"tf":2.0},"17":{"tf":2.0},"19":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"43":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"6":{"tf":2.6457513110645907},"7":{"tf":2.8284271247461903},"8":{"tf":2.8284271247461903},"9":{"tf":3.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"40":{"tf":1.0},"43":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"32":{"tf":1.0},"35":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"o":{"c":{"df":2,"docs":{"1":{"tf":1.4142135623730951},"41":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"0":{"tf":1.0},"17":{"tf":2.0},"41":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.4142135623730951},"26":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"19":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"52":{"tf":1.0}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"18":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"24":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":2.449489742783178}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"45":{"tf":1.0}}}}},"x":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":7,"docs":{"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"29":{"tf":1.0},"33":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.7320508075688772},"50":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":4,"docs":{"13":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.0},"43":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"38":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":2.23606797749979},"27":{"tf":2.6457513110645907},"28":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"5":{"df":1,"docs":{"15":{"tf":1.0}}},"8":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"17":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":2.449489742783178},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":2,"docs":{"43":{"tf":1.0},"44":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"]":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.7320508075688772}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"17":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.4142135623730951}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"17":{"tf":3.3166247903554},"27":{"tf":1.0},"29":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":1,"docs":{"33":{"tf":1.4142135623730951}},"{":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"15":{"tf":1.0},"21":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"37":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"48":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"18":{"tf":2.23606797749979},"38":{"tf":1.0},"50":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"50":{"tf":1.0}}}}}}}},"u":{"b":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":2.6457513110645907}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"(":{"df":1,"docs":{"43":{"tf":1.0}}},"df":1,"docs":{"44":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":7,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"43":{"tf":1.4142135623730951},"50":{"tf":2.6457513110645907},"51":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"c":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"49":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"35":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0}},"t":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"44":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0}}}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":20,"docs":{"0":{"tf":1.0},"10":{"tf":2.0},"14":{"tf":2.23606797749979},"15":{"tf":2.23606797749979},"16":{"tf":1.0},"17":{"tf":2.23606797749979},"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":2.0},"36":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"34":{"tf":1.0}}}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"13":{"tf":1.0},"21":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"15":{"tf":1.0},"22":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.4142135623730951},"52":{"tf":1.0},"6":{"tf":1.0}}}},"t":{"df":3,"docs":{"15":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.4142135623730951}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"26":{"tf":1.0},"41":{"tf":1.0}}}},"n":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"48":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"s":{"df":3,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"41":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"42":{"tf":1.0},"44":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"17":{"tf":1.0},"7":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"34":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951}}}}},"r":{"a":{"df":2,"docs":{"16":{"tf":1.0},"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"f":{"3":{"2":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}}},"df":2,"docs":{"17":{"tf":1.4142135623730951},"22":{"tf":1.0}},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"39":{"tf":1.0},"43":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"18":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":1.0}}},"s":{"df":7,"docs":{"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":3.605551275463989},"37":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"v":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":6,"docs":{"18":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"0":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":4,"docs":{"13":{"tf":1.0},"26":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.0},"48":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":4,"docs":{"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0}},"s":{":":{"2":{":":{"1":{"0":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"33":{"tf":1.4142135623730951},"34":{"tf":1.0}}},":":{"1":{"0":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},":":{":":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"\"":{")":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":24,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":2.8284271247461903},"14":{"tf":1.4142135623730951},"15":{"tf":2.23606797749979},"16":{"tf":2.0},"17":{"tf":3.4641016151377544},"19":{"tf":3.7416573867739413},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"32":{"tf":2.449489742783178},"33":{"tf":2.6457513110645907},"34":{"tf":2.0},"35":{"tf":2.0},"43":{"tf":1.0},"48":{"tf":2.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"6":{"tf":3.0},"7":{"tf":2.0},"8":{"tf":3.1622776601683795},"9":{"tf":2.449489742783178}}}},"n":{"d":{"df":3,"docs":{"0":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":9,"docs":{"18":{"tf":1.0},"3":{"tf":1.0},"33":{"tf":1.4142135623730951},"38":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"6":{"tf":1.4142135623730951}}}}},"x":{"df":2,"docs":{"19":{"tf":1.0},"5":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":13,"docs":{"10":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"34":{"tf":2.449489742783178},"35":{"tf":1.0},"43":{"tf":2.8284271247461903},"44":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"17":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.4142135623730951},"5":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":12,"docs":{"13":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"27":{"tf":1.0},"29":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"df":1,"docs":{"17":{"tf":1.7320508075688772}},"s":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{",":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"b":{"a":{"df":0,"docs":{},"r":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"10":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":2.0},"43":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951}}},"r":{"c":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"18":{"tf":1.0},"39":{"tf":1.0},"48":{"tf":1.0}}}},"df":3,"docs":{"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"45":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":3,"docs":{"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"51":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"r":{"df":2,"docs":{"33":{"tf":1.0},"9":{"tf":1.0}}}}},"r":{"a":{"c":{"df":1,"docs":{"29":{"tf":2.0}},"{":{"1":{"df":0,"docs":{},"}":{"df":0,"docs":{},"{":{"3":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"x":{"^":{"2":{"df":0,"docs":{},"}":{"df":0,"docs":{},"{":{"2":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":5,"docs":{"0":{"tf":1.0},"26":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{":":{":":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"50":{"tf":1.0}},"l":{"(":{"&":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":1,"docs":{"53":{"tf":1.0}},"g":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"q":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"33":{"tf":1.0},"48":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"25":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"q":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772}}}}},"t":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"49":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"42":{"tf":1.4142135623730951}}}},"h":{"df":1,"docs":{"38":{"tf":2.0}}},"i":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":3,"docs":{"0":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}}},"df":3,"docs":{"17":{"tf":2.449489742783178},"38":{"tf":3.0},"5":{"tf":2.23606797749979}},"h":{"df":0,"docs":{},"u":{"b":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}}}},"df":4,"docs":{"0":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"38":{"tf":2.8284271247461903},"45":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"8":{"tf":2.23606797749979},"9":{"tf":2.23606797749979}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"41":{"tf":1.0}},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":4,"docs":{"10":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}},"e":{"df":1,"docs":{"40":{"tf":1.0}}},"o":{"d":{"df":3,"docs":{"41":{"tf":1.0},"50":{"tf":1.4142135623730951},"52":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"52":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"r":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"d":{".":{"df":0,"docs":{},"h":{"b":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":3,"docs":{"15":{"tf":1.0},"17":{"tf":2.23606797749979},"19":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"b":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"33":{"tf":1.0}}}},"p":{"df":2,"docs":{"5":{"tf":1.0},"53":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"16":{"tf":1.0},"22":{"tf":2.449489742783178},"34":{"tf":1.0},"42":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":11,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.4142135623730951},"53":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"34":{"tf":1.0},"35":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"19":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"17":{"tf":2.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"19":{"tf":1.0},"24":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"j":{"df":3,"docs":{"19":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.7320508075688772}}}},"df":4,"docs":{"19":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"48":{"tf":1.0}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{".":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"39":{"tf":1.0},"43":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"29":{"tf":1.0},"52":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"=":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"\"":{">":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"\"":{">":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"{":{"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":12,"docs":{"13":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"17":{"tf":2.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":2.0}},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"5":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{".":{"df":3,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"33":{"tf":1.4142135623730951}}},"3":{"2":{"df":1,"docs":{"34":{"tf":2.8284271247461903}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"d":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"17":{"tf":2.0},"34":{"tf":1.0}}}}},"d":{"df":1,"docs":{"17":{"tf":1.0}},"e":{"a":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":8,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951},"17":{"tf":1.0},"33":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"42":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"33":{"tf":1.0},"43":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"17":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"51":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"39":{"tf":1.0},"6":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"26":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":9,"docs":{"13":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"19":{"tf":1.0},"32":{"tf":2.449489742783178},"33":{"tf":4.123105625617661},"34":{"tf":2.23606797749979},"42":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"b":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"48":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"m":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951}}}},"i":{"c":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}},"o":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"15":{"tf":1.4142135623730951},"21":{"tf":1.0},"45":{"tf":1.4142135623730951}}}}},"r":{"a":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"19":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.4142135623730951},"6":{"tf":2.8284271247461903}},"i":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.7320508075688772}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951}}}}},"i":{"d":{"df":2,"docs":{"28":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"17":{"tf":1.7320508075688772},"37":{"tf":2.23606797749979},"4":{"tf":1.0},"48":{"tf":1.4142135623730951},"5":{"tf":3.1622776601683795},"50":{"tf":1.0},"51":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":13,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.7320508075688772},"19":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"38":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"29":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":3,"docs":{"15":{"tf":1.0},"36":{"tf":1.4142135623730951},"38":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"32":{"tf":1.4142135623730951},"48":{"tf":1.0},"50":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":7,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.0}}}}}},"o":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":6,"docs":{"0":{"tf":1.4142135623730951},"22":{"tf":1.0},"26":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"t":{"'":{"df":7,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"18":{"tf":1.0},"47":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"50":{"tf":2.0}}},"r":{"df":2,"docs":{"44":{"tf":1.0},"47":{"tf":1.0}}}}}},"j":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"15":{"tf":1.0},"17":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.7320508075688772},"19":{"tf":1.0},"22":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0}}}}},"s":{"df":1,"docs":{"17":{"tf":2.6457513110645907}},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"18":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0}}}}}},"k":{"b":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"b":{"a":{"b":{"df":3,"docs":{"18":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"38":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}},"y":{"df":12,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"29":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"b":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"13":{"tf":1.0},"20":{"tf":1.0}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":2.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"/":{"b":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.0}}}}}},"/":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"=":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"21":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"g":{"df":7,"docs":{"10":{"tf":1.4142135623730951},"15":{"tf":2.23606797749979},"21":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"x":{"df":1,"docs":{"42":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"y":{"df":1,"docs":{"13":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}}}},"df":1,"docs":{"10":{"tf":2.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}},"v":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"\"":{">":{"<":{"/":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}},"t":{"'":{"df":2,"docs":{"13":{"tf":1.0},"3":{"tf":1.0}}},"df":6,"docs":{"17":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":2.6457513110645907},"41":{"tf":1.0}}}}}},"i":{">":{"<":{"a":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"10":{"tf":1.7320508075688772},"39":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"22":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"52":{"tf":1.0}}},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"26":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"22":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"22":{"tf":1.0},"29":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":15,"docs":{"0":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"18":{"tf":1.0},"25":{"tf":1.4142135623730951},"3":{"tf":1.7320508075688772},"31":{"tf":1.4142135623730951},"33":{"tf":3.872983346207417},"34":{"tf":2.6457513110645907},"35":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.0}}},"k":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":8,"docs":{"13":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":2.23606797749979},"21":{"tf":1.0},"22":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.0},"21":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}}}}},"o":{"a":{"d":{"df":6,"docs":{"17":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"3":{"0":{"0":{"0":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":1,"docs":{"53":{"tf":1.0}},"g":{"df":2,"docs":{"38":{"tf":1.0},"50":{"tf":1.0}},"i":{"c":{"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":10,"docs":{"14":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0}}}},"t":{"df":3,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"21":{"tf":1.0}}},"w":{"df":1,"docs":{"1":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":15,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"21":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"(":{")":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}},"df":9,"docs":{"16":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":4,"docs":{"13":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.0},"47":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"34":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":13,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":2.8284271247461903},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.0},"44":{"tf":2.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0},"6":{"tf":1.0}}}}}},"df":2,"docs":{"38":{"tf":1.0},"51":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"17":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}},"j":{"a":{"df":0,"docs":{},"x":{"df":6,"docs":{"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"29":{"tf":2.6457513110645907},"42":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"53":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"46":{"tf":1.0}}},":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{},"{":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"{":{"c":{"df":0,"docs":{},"m":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"50":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"=":{"\"":{"df":0,"docs":{},"{":{"'":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"18":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"_":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"r":{"_":{"_":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}}},"df":37,"docs":{"0":{"tf":2.0},"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":3.605551275463989},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":2.6457513110645907},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"41":{"tf":2.449489742783178},"43":{"tf":2.6457513110645907},"44":{"tf":1.0},"45":{"tf":2.0},"46":{"tf":2.8284271247461903},"48":{"tf":3.0},"5":{"tf":2.8284271247461903},"50":{"tf":2.6457513110645907},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":2.0},"7":{"tf":1.7320508075688772},"8":{"tf":2.0},"9":{"tf":1.7320508075688772}}}}}},"df":1,"docs":{"7":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"df":1,"docs":{"38":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"18":{"tf":1.0},"48":{"tf":1.0},"6":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"39":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"40":{"tf":1.0},"48":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"u":{"df":1,"docs":{"17":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"15":{"tf":1.0},"18":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":4,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":5,"docs":{"18":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0},"53":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":7,"docs":{"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":1.0}},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"o":{"d":{"df":1,"docs":{"43":{"tf":1.0}},"e":{"df":1,"docs":{"33":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":5,"docs":{"19":{"tf":1.7320508075688772},"20":{"tf":1.0},"33":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":8,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"24":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"6":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.0},"19":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":1,"docs":{"29":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"17":{"tf":1.0}}}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"42":{"tf":1.0},"44":{"tf":1.0}}}},"df":5,"docs":{"44":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}},"df":9,"docs":{"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"19":{"tf":1.0}},"g":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"5":{"tf":1.0}}}}}},"df":1,"docs":{"9":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"46":{"tf":1.0},"50":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":16,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.23606797749979},"18":{"tf":1.4142135623730951},"19":{"tf":2.0},"20":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"33":{"tf":1.0},"39":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"18":{"tf":1.0},"49":{"tf":1.0}}}},"w":{"df":9,"docs":{"1":{"tf":1.0},"19":{"tf":1.4142135623730951},"22":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"38":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":2.0},"5":{"tf":1.4142135623730951}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"x":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"13":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"13":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.4142135623730951}},"e":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"_":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"48":{"tf":1.0}}}},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"(":{"\"":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"43":{"tf":2.8284271247461903}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"13":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":12,"docs":{"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"38":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"h":{"df":1,"docs":{"43":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":7,"docs":{"19":{"tf":1.0},"24":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"47":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":2.23606797749979}},"s":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"13":{"tf":3.4641016151377544},"17":{"tf":2.23606797749979},"27":{"tf":2.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":2.0}}}}},"df":1,"docs":{"34":{"tf":1.7320508075688772}}}}},"o":{"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"50":{"tf":1.0}}}}},"df":0,"docs":{}},"d":{"d":{"df":1,"docs":{"50":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":3,"docs":{"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"k":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":1.0}}},"l":{"d":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}},"n":{"c":{"df":3,"docs":{"13":{"tf":1.0},"45":{"tf":1.0},"8":{"tf":1.0}}},"df":3,"docs":{"17":{"tf":1.7320508075688772},"19":{"tf":1.0},"41":{"tf":1.0}}},"p":{"df":1,"docs":{"43":{"tf":2.0}},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"0":{"tf":1.0},"17":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772}}},"r":{"df":1,"docs":{"18":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":11,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":2.23606797749979},"17":{"tf":3.605551275463989},"27":{"tf":1.0},"29":{"tf":1.0},"51":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"27":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"df":7,"docs":{"13":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"14":{"tf":1.0},"17":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":5,"docs":{"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":13,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":2.6457513110645907},"19":{"tf":1.0},"22":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":2.23606797749979},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":4,"docs":{"19":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"9":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0}}}}},"df":3,"docs":{"11":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":1,"docs":{"1":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"24":{"tf":1.0},"6":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}}}}}}},"p":{"a":{"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":6,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"38":{"tf":3.3166247903554},"4":{"tf":1.0},"45":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"33":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"s":{"df":5,"docs":{"13":{"tf":1.0},"18":{"tf":1.4142135623730951},"40":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"&":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{")":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"13":{"tf":1.0},"44":{"tf":1.0}}}}},"t":{"df":3,"docs":{"13":{"tf":2.0},"33":{"tf":1.0},"43":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"34":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":1,"docs":{"43":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"37":{"tf":1.0},"45":{"tf":1.0},"50":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"50":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"/":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"37":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"48":{"tf":1.0},"51":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":16,"docs":{"10":{"tf":2.0},"11":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":2.0},"32":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"33":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"44":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}}}},"y":{"df":1,"docs":{"35":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"35":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"22":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":2,"docs":{"46":{"tf":1.0},"50":{"tf":1.0}}},"df":4,"docs":{"39":{"tf":1.0},"43":{"tf":1.7320508075688772},"46":{"tf":1.0},"50":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"21":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":2.23606797749979}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"13":{"tf":1.0},"45":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"(":{"&":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"df":1,"docs":{"5":{"tf":1.0}},"f":{"a":{"c":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}},"i":{"df":0,"docs":{},"x":{"df":3,"docs":{"13":{"tf":2.23606797749979},"17":{"tf":1.0},"18":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"21":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"16":{"tf":1.0},"43":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"14":{"tf":1.0},"16":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}}}},"df":9,"docs":{"15":{"tf":2.6457513110645907},"16":{"tf":2.8284271247461903},"17":{"tf":2.23606797749979},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":4.69041575982343},"44":{"tf":1.7320508075688772}},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}},"/":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"9":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"22":{"tf":2.6457513110645907},"50":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"50":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"25":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"19":{"tf":1.0},"23":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"1":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":10,"docs":{"15":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"50":{"tf":1.0}},"e":{"d":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"48":{"tf":1.0}}},"df":10,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"21":{"tf":1.0},"22":{"tf":2.0}}}}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}}},"u":{"b":{"df":3,"docs":{"43":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":2,"docs":{"2":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"26":{"tf":1.0},"44":{"tf":1.0}}}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"13":{"tf":1.0},"6":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"t":{"df":4,"docs":{"15":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"3":{"df":1,"docs":{"43":{"tf":1.0}}},"df":4,"docs":{"16":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"41":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":2.0}}}}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"43":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}},"i":{"df":1,"docs":{"6":{"tf":1.0}}},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"45":{"tf":1.0},"48":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"45":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"19":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}}}},"l":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"32":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"2":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":2.0}}}},"df":0,"docs":{},"v":{"df":2,"docs":{"15":{"tf":1.0},"33":{"tf":1.0}}}},"o":{"a":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"44":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"24":{"tf":1.0}},"e":{"_":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"49":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":4,"docs":{"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}}}}}}}},"df":23,"docs":{"1":{"tf":1.0},"13":{"tf":2.23606797749979},"15":{"tf":1.0},"16":{"tf":3.0},"17":{"tf":3.872983346207417},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.4142135623730951},"31":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":2.8284271247461903},"45":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"50":{"tf":2.23606797749979},"6":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"44":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":1,"docs":{"38":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"17":{"tf":2.449489742783178},"38":{"tf":1.0},"5":{"tf":1.0}}},"y":{"'":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"45":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"26":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"48":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":2,"docs":{"24":{"tf":1.0},"34":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":9,"docs":{"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"17":{"tf":3.4641016151377544},"18":{"tf":1.0},"27":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"34":{"tf":1.4142135623730951},"50":{"tf":1.0}}}}}}},"f":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"m":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}}},"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":1.7320508075688772},"19":{"tf":1.0},"21":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":2.0},"9":{"tf":2.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"45":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}},"p":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}},"u":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"38":{"tf":1.0},"50":{"tf":1.0}}}},"n":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":17,"docs":{"10":{"tf":1.0},"15":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"48":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"9":{"tf":1.0}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"27":{"tf":1.0},"35":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{",":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"5":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{",":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"33":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":2,"docs":{"16":{"tf":1.0},"34":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":6,"docs":{"1":{"tf":1.0},"10":{"tf":2.23606797749979},"17":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"45":{"tf":1.0}}},"df":0,"docs":{}}},"df":14,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"23":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":2.0},"37":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"51":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":8,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"df":4,"docs":{"18":{"tf":1.0},"22":{"tf":1.4142135623730951},"37":{"tf":1.0},"48":{"tf":1.0}}}}}}},"df":1,"docs":{"21":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"10":{"tf":1.0},"17":{"tf":4.242640687119285}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":8,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.8284271247461903},"19":{"tf":1.0},"21":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"35":{"tf":1.0}},"n":{"df":1,"docs":{"6":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"43":{"tf":1.0},"46":{"tf":1.0}}}}}},"n":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"16":{"tf":1.0},"43":{"tf":1.0}}},"t":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":2.0},"18":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"49":{"tf":1.7320508075688772}},"e":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"50":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"44":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}},"v":{"df":4,"docs":{"0":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.0},"9":{"tf":3.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"6":{"tf":1.0},"9":{"tf":2.0}}}}}},"t":{"df":9,"docs":{"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":2.23606797749979},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"6":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"40":{"tf":1.0},"45":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"38":{"tf":1.0},"43":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"44":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"53":{"tf":1.0}}}},"w":{"df":5,"docs":{"17":{"tf":1.0},"34":{"tf":1.4142135623730951},"39":{"tf":1.0},"44":{"tf":1.0},"52":{"tf":1.0}},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"19":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"13":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"45":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"43":{"tf":1.0},"45":{"tf":1.4142135623730951}},"i":{"df":3,"docs":{"17":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"52":{"tf":1.0}}},"p":{"df":2,"docs":{"38":{"tf":1.0},"49":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.0},"18":{"tf":1.0}}}}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":8,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"38":{"tf":1.0},"5":{"tf":1.0}}}}}}}},"o":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"53":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"b":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"18":{"tf":1.0},"22":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"38":{"tf":1.0},"50":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":13,"docs":{"0":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.7320508075688772},"52":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":6,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.4142135623730951},"48":{"tf":1.0},"6":{"tf":1.0}},"i":{"df":14,"docs":{"10":{"tf":2.23606797749979},"11":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":2.449489742783178},"21":{"tf":1.7320508075688772},"23":{"tf":1.0},"34":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"48":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"15":{"tf":2.449489742783178},"19":{"tf":1.0},"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"18":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"df":1,"docs":{"48":{"tf":1.0}}}},"d":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"43":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"43":{"tf":1.0},"50":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":6,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"49":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.0},"44":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"40":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"53":{"tf":1.0}},"k":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"13":{"tf":1.7320508075688772},"34":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":1,"docs":{"43":{"tf":1.4142135623730951}},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"18":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"33":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.7320508075688772},"50":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":5,"docs":{"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"19":{"tf":1.0}}}}}}}}}}},"u":{"b":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"43":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"13":{"tf":1.0}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"38":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":5,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"29":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"m":{"_":{"df":0,"docs":{},"{":{"df":0,"docs":{},"i":{"=":{"0":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}},"y":{".":{"df":0,"docs":{},"m":{"d":{"df":7,"docs":{"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"15":{"tf":1.0},"21":{"tf":1.0},"48":{"tf":1.0},"6":{"tf":2.23606797749979},"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"15":{"tf":1.0},"17":{"tf":1.7320508075688772},"29":{"tf":2.23606797749979},"33":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":2.23606797749979},"48":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"19":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":6,"docs":{"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":3,"docs":{"18":{"tf":1.0},"33":{"tf":2.0},"41":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"13":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":3.0},"21":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"19":{"tf":1.0},"26":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"49":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"43":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"19":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"5":{"tf":1.7320508075688772},"50":{"tf":1.0},"9":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":10,"docs":{"10":{"tf":3.605551275463989},"15":{"tf":1.0},"17":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":2.23606797749979},"43":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"44":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":9,"docs":{"12":{"tf":1.0},"17":{"tf":3.7416573867739413},"19":{"tf":3.7416573867739413},"23":{"tf":1.0},"24":{"tf":2.6457513110645907},"26":{"tf":1.7320508075688772},"28":{"tf":1.0},"48":{"tf":1.0},"6":{"tf":2.23606797749979}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":3,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"26":{"tf":1.0},"6":{"tf":1.0}}}},"r":{"d":{"df":2,"docs":{"33":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":7,"docs":{"25":{"tf":1.0},"29":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"52":{"tf":1.0},"9":{"tf":1.0}}}}},"w":{"df":1,"docs":{"51":{"tf":1.0}}}}},"u":{"df":1,"docs":{"13":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":5,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"37":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}},"p":{"df":1,"docs":{"6":{"tf":1.0}}},"t":{"df":0,"docs":{},"l":{"df":9,"docs":{"13":{"tf":3.1622776601683795},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"17":{"tf":2.0},"18":{"tf":1.0},"21":{"tf":1.7320508075688772},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"p":{"/":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"38":{"tf":2.8284271247461903}}}}}},"df":0,"docs":{}},"df":1,"docs":{"38":{"tf":1.0}}}},"o":{"c":{"df":1,"docs":{"22":{"tf":1.7320508075688772}},"}":{"df":0,"docs":{},"}":{"df":0,"docs":{},"{":{"df":0,"docs":{},"{":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":5,"docs":{"0":{"tf":1.0},"3":{"tf":1.7320508075688772},"39":{"tf":1.4142135623730951},"48":{"tf":1.0},"50":{"tf":1.0}}}},"p":{"df":2,"docs":{"19":{"tf":1.0},"41":{"tf":1.0}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"52":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"i":{"df":3,"docs":{"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"37":{"tf":1.0},"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":5,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"7":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"e":{"df":9,"docs":{"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":4.242640687119285},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":4,"docs":{"18":{"tf":1.0},"23":{"tf":1.0},"40":{"tf":1.0},"47":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"19":{"tf":1.0},"41":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":4,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":3,"docs":{"41":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"43":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":2.0}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"29":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":1,"docs":{"19":{"tf":1.0}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"43":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{"'":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"37":{"tf":1.7320508075688772},"38":{"tf":1.0},"42":{"tf":1.4142135623730951},"48":{"tf":1.0}}}},"df":0,"docs":{}},"df":5,"docs":{"33":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}},"l":{"df":1,"docs":{"17":{"tf":2.6457513110645907}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":37,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":2.23606797749979},"15":{"tf":2.23606797749979},"16":{"tf":1.0},"17":{"tf":3.1622776601683795},"18":{"tf":1.4142135623730951},"19":{"tf":3.1622776601683795},"20":{"tf":1.0},"21":{"tf":2.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":2.23606797749979},"29":{"tf":1.7320508075688772},"3":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.7320508075688772},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":2.0},"42":{"tf":1.0},"43":{"tf":3.3166247903554},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"48":{"tf":2.0},"50":{"tf":2.6457513110645907},"6":{"tf":2.449489742783178},"7":{"tf":1.7320508075688772},"8":{"tf":2.6457513110645907},"9":{"tf":2.8284271247461903}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"38":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0}}}},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"44":{"tf":1.0},"47":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"29":{"tf":1.0},"32":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"2":{".":{"0":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":11,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"43":{"tf":1.0},"49":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":1,"docs":{"22":{"tf":1.0}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"18":{"tf":2.449489742783178},"38":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"49":{"tf":1.0},"50":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":1,"docs":{"37":{"tf":1.0}},"i":{"df":3,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"13":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"5":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":2.0},"5":{"tf":2.23606797749979}}}}}}}},"i":{"a":{"df":9,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":16,"docs":{"16":{"tf":1.0},"19":{"tf":2.449489742783178},"20":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"43":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"48":{"tf":1.0},"8":{"tf":2.6457513110645907},"9":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":6,"docs":{"31":{"tf":1.0},"34":{"tf":1.4142135623730951},"39":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0}},"n":{"df":1,"docs":{"53":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}}}}},"df":1,"docs":{"9":{"tf":1.0}},"e":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"49":{"tf":1.0}}}},"r":{"df":1,"docs":{"43":{"tf":1.0}}},"v":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.0}}}},"b":{"df":3,"docs":{"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"9":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":2.449489742783178}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"53":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"17":{"tf":1.0},"36":{"tf":1.0},"9":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"17":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"17":{"tf":1.0},"6":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"13":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.0},"44":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"49":{"tf":2.0},"50":{"tf":1.0}}}}}}}},"df":4,"docs":{"46":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951}}}}}}},"df":6,"docs":{"17":{"tf":2.8284271247461903},"45":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":2.0}}},"df":0,"docs":{},"k":{"df":12,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}},"l":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"32":{"tf":1.0},"52":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":6,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"13":{"tf":1.0},"29":{"tf":1.4142135623730951},"50":{"tf":1.0},"6":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":7,"docs":{"0":{"tf":1.0},"13":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0}}}}}}}}},"x":{"_":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":5,"docs":{"25":{"tf":2.0},"29":{"tf":1.4142135623730951},"31":{"tf":2.0},"34":{"tf":2.23606797749979},"37":{"tf":1.4142135623730951}}},"y":{"df":2,"docs":{"25":{"tf":2.0},"31":{"tf":2.0}},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":2,"docs":{"48":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0}}}},"r":{"df":2,"docs":{"38":{"tf":1.0},"53":{"tf":1.0}}},"v":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"24":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0}}}}}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}}}}},"breadcrumbs":{"root":{"0":{".":{"3":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"1":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":2.0}}},"7":{":":{"3":{"1":{":":{"1":{"5":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"17":{"tf":1.7320508075688772},"43":{"tf":1.0}}},"1":{".":{"2":{".":{"1":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"33":{"tf":1.0}}},"2":{"3":{"4":{"5":{"6":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.0}}},"7":{".":{"0":{".":{"0":{".":{"1":{":":{"<":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"9":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"4":{"5":{"df":1,"docs":{"48":{"tf":1.0}}},"6":{"df":1,"docs":{"48":{"tf":1.0}}},"8":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"5":{"3":{"df":1,"docs":{"48":{"tf":1.0}}},"df":1,"docs":{"14":{"tf":1.0}}},"6":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":2.0}}},"9":{"2":{".":{"1":{"6":{"8":{".":{"1":{".":{"1":{"0":{"0":{":":{"<":{"df":0,"docs":{},"w":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"17":{"tf":2.23606797749979},"22":{"tf":1.0},"29":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.0}}},"2":{".":{"1":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"0":{"1":{"5":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}},"8":{"df":3,"docs":{"14":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{":":{"2":{"1":{":":{"3":{"9":{"df":1,"docs":{"50":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"4":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{}},"5":{"9":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"8":{"3":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{}},"9":{"2":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":6,"docs":{"17":{"tf":1.4142135623730951},"22":{"tf":1.0},"29":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"50":{"tf":1.0}}},"3":{"0":{"4":{"df":1,"docs":{"48":{"tf":1.0}}},"df":2,"docs":{"17":{"tf":2.0},"48":{"tf":1.0}}},"1":{"4":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"17":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772}}},"4":{"0":{"4":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"17":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"4":{"7":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"5":{"df":3,"docs":{"25":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951}}},"6":{"df":2,"docs":{"25":{"tf":1.0},"31":{"tf":1.0}}},"7":{"1":{"0":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"8":{"4":{"df":1,"docs":{"48":{"tf":1.0}}},"8":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"17":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.0}}},"8":{"0":{"0":{"0":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.0}}},"5":{"df":1,"docs":{"48":{"tf":1.0}}},"df":0,"docs":{}},"_":{"_":{"df":1,"docs":{"18":{"tf":1.0}}},"b":{"a":{"df":0,"docs":{},"r":{"_":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"18":{"tf":1.4142135623730951},"44":{"tf":1.0},"50":{"tf":1.0}}},"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"\"":{"a":{"df":1,"docs":{"43":{"tf":1.0}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"27":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"17":{"tf":1.0}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"38":{"tf":1.0},"44":{"tf":1.4142135623730951},"49":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"45":{"tf":1.4142135623730951}}}}}}}},"r":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"28":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"43":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"53":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}},"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.4142135623730951}},"e":{"(":{"2":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}}},"df":12,"docs":{"10":{"tf":1.0},"13":{"tf":2.0},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"38":{"tf":2.23606797749979},"46":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"5":{"tf":1.0},"53":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"14":{"tf":1.0},"17":{"tf":2.0},"22":{"tf":1.0},"27":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"df":10,"docs":{"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"27":{"tf":1.4142135623730951},"41":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":14,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"1":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":4,"docs":{"45":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"6":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":5,"docs":{"17":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":2.0},"48":{"tf":1.0},"52":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"45":{"tf":1.0},"52":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"15":{"tf":1.0},"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}},"t":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{"\\":{"df":0,"docs":{},"s":{"*":{"[":{"\\":{"df":0,"docs":{},"w":{"_":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{":":{"\\":{"df":0,"docs":{},"s":{"*":{"[":{"\\":{"df":0,"docs":{},"w":{"_":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"33":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":2,"docs":{"33":{"tf":3.0},"34":{"tf":1.4142135623730951}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"25":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"13":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"6":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{":":{":":{"b":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"!":{"(":{"\"":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"!":{"!":{"1":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"1":{"tf":1.7320508075688772},"41":{"tf":1.0}}},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\"":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"<":{"'":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":2.23606797749979}}}},"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"38":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"b":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"(":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\"":{")":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"52":{"tf":1.0}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"df":0,"docs":{},"x":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"27":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":1,"docs":{"15":{"tf":1.0}}},"df":7,"docs":{"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"42":{"tf":1.0},"49":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":1,"docs":{"10":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.23606797749979},"27":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"13":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":5,"docs":{"18":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":12,"docs":{"17":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":2.449489742783178},"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":2.8284271247461903},"49":{"tf":1.0},"50":{"tf":2.23606797749979},"51":{"tf":2.23606797749979},"52":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"44":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"48":{"tf":1.0}}},"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"13":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"17":{"tf":1.0},"18":{"tf":1.0},"42":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"33":{"tf":1.0}},"{":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"51":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"13":{"tf":1.0},"4":{"tf":1.0}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"34":{"tf":1.0}}}}}}}},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"53":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"19":{"tf":1.0},"4":{"tf":1.7320508075688772},"41":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0}}}}},"d":{"df":2,"docs":{"16":{"tf":1.0},"34":{"tf":1.4142135623730951}}},"df":2,"docs":{"46":{"tf":1.0},"5":{"tf":1.0}}},"t":{"df":2,"docs":{"20":{"tf":1.0},"42":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"10":{"tf":2.0},"15":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"44":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"43":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"46":{"tf":1.0},"6":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"'":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"15":{"tf":1.0},"18":{"tf":1.0},"39":{"tf":1.0},"45":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":2.0}}},".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{},"j":{"df":2,"docs":{"19":{"tf":1.0},"28":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":19,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"18":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{}},"df":37,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":2.23606797749979},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":2.23606797749979},"14":{"tf":2.23606797749979},"15":{"tf":3.605551275463989},"16":{"tf":1.0},"17":{"tf":3.1622776601683795},"18":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":2.0},"22":{"tf":1.0},"24":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":2.8284271247461903},"39":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":2.449489742783178},"44":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772},"46":{"tf":1.0},"47":{"tf":2.6457513110645907},"48":{"tf":2.6457513110645907},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"6":{"tf":2.8284271247461903},"7":{"tf":2.449489742783178},"8":{"tf":2.449489742783178},"9":{"tf":2.6457513110645907}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":3,"docs":{"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"l":{"df":2,"docs":{"43":{"tf":1.0},"50":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":3.0}}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":3,"docs":{"19":{"tf":1.0},"33":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"45":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"17":{"tf":1.7320508075688772},"19":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}},"y":{"a":{"df":0,"docs":{},"n":{"df":5,"docs":{"18":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0},"53":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"f":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"g":{"df":1,"docs":{"5":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":19,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":2.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":1.7320508075688772},"37":{"tf":2.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"48":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"50":{"tf":1.4142135623730951},"7":{"tf":3.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":4,"docs":{"15":{"tf":1.0},"19":{"tf":1.7320508075688772},"43":{"tf":1.0},"50":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"17":{"tf":1.0},"27":{"tf":1.0}}}}}}}},"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":8,"docs":{"34":{"tf":1.4142135623730951},"40":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"5":{"tf":1.0}}},".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"46":{"tf":1.0},"49":{"tf":1.0}}}}}}},"df":6,"docs":{"37":{"tf":2.23606797749979},"46":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":2.23606797749979},"50":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":4,"docs":{"18":{"tf":1.4142135623730951},"42":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"10":{"tf":1.0},"50":{"tf":1.0}}}}},"d":{"df":4,"docs":{"38":{"tf":1.7320508075688772},"46":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0}}},"df":1,"docs":{"29":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"g":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"o":{"d":{"d":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"(":{"&":{"c":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":1,"docs":{"49":{"tf":1.0}}}},"h":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"e":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":2.23606797749979}}}}},"df":0,"docs":{}}},"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":13,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.7320508075688772},"19":{"tf":2.0},"20":{"tf":1.0},"22":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"42":{"tf":1.0},"51":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}},"<":{"/":{"a":{">":{"<":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"]":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"m":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"_":{"1":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"df":13,"docs":{"13":{"tf":5.385164807134504},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"21":{"tf":2.0},"22":{"tf":2.449489742783178},"39":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":2.23606797749979},"47":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"52":{"tf":1.0},"6":{"tf":1.4142135623730951}},"s":{"]":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"2":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"k":{"df":3,"docs":{"17":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"53":{"tf":1.0}}}}},"i":{"df":4,"docs":{"18":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.7320508075688772},"38":{"tf":1.7320508075688772}}},"l":{"a":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"{":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"s":{"=":{"\"":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":2.6457513110645907}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"34":{"tf":1.0},"35":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":1,"docs":{"44":{"tf":1.7320508075688772}}}}},"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":1,"docs":{"44":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":20,"docs":{"0":{"tf":1.0},"10":{"tf":2.449489742783178},"15":{"tf":1.4142135623730951},"17":{"tf":2.23606797749979},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":2.0},"27":{"tf":1.4142135623730951},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":2.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.4142135623730951},"52":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"26":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":4,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"46":{"tf":1.0}}},"m":{"a":{"df":1,"docs":{"10":{"tf":1.0}},"n":{"d":{"df":20,"docs":{"0":{"tf":1.0},"10":{"tf":2.23606797749979},"11":{"tf":2.449489742783178},"16":{"tf":2.0},"17":{"tf":1.7320508075688772},"18":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":2.0},"32":{"tf":1.4142135623730951},"33":{"tf":2.0},"39":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"48":{"tf":2.23606797749979},"50":{"tf":1.0},"51":{"tf":2.0},"6":{"tf":2.8284271247461903},"7":{"tf":2.449489742783178},"8":{"tf":2.449489742783178},"9":{"tf":2.6457513110645907}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.0},"46":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":5,"docs":{"17":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"45":{"tf":1.0},"5":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"19":{"tf":1.0},"34":{"tf":1.7320508075688772},"44":{"tf":1.0},"9":{"tf":1.0}}},"x":{"df":1,"docs":{"18":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.7320508075688772}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"49":{"tf":1.0}}},"df":6,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":14,"docs":{"12":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":2.8284271247461903},"16":{"tf":2.0},"17":{"tf":3.3166247903554},"18":{"tf":1.7320508075688772},"25":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":2.0},"6":{"tf":1.0},"9":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"19":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"33":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"43":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":14,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":9,"docs":{"13":{"tf":2.23606797749979},"16":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.4142135623730951},"32":{"tf":1.0},"45":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":2,"docs":{"36":{"tf":1.7320508075688772},"49":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"48":{"tf":1.0},"53":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"52":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"15":{"tf":1.4142135623730951},"50":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":5,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"7":{"tf":1.0}}},"t":{"df":1,"docs":{"48":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":5,"docs":{"17":{"tf":3.3166247903554},"19":{"tf":1.0},"47":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}}},"y":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"12":{"tf":1.0},"17":{"tf":1.0},"28":{"tf":1.0},"45":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"46":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"s":{"(":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"47":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":6,"docs":{"17":{"tf":1.4142135623730951},"45":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"17":{"tf":1.0},"28":{"tf":1.0},"6":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"22":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0}}}}}},"p":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"3":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"5":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":25,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"6":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"s":{"df":2,"docs":{"14":{"tf":1.0},"17":{"tf":1.7320508075688772}}}},"t":{"df":0,"docs":{},"x":{".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"49":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":4,"docs":{"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.4142135623730951},"29":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"14":{"tf":1.0},"17":{"tf":1.0}}}}},"df":0,"docs":{},"j":{"df":1,"docs":{"17":{"tf":1.0}}}},"2":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":12,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.0},"19":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"39":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}}}},"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"17":{"tf":2.0},"19":{"tf":1.0}}}},"s":{"df":0,"docs":{},"h":{"df":2,"docs":{"13":{"tf":1.0},"18":{"tf":1.0}}}},"t":{"a":{"df":2,"docs":{"21":{"tf":1.7320508075688772},"22":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"38":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}},"df":0,"docs":{}}}},"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"35":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"44":{"tf":1.0}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"17":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":19,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"15":{"tf":3.3166247903554},"16":{"tf":1.4142135623730951},"17":{"tf":6.164414002968976},"19":{"tf":2.449489742783178},"21":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"40":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"38":{"tf":1.0},"6":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"29":{"tf":2.23606797749979}}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"o":{"d":{"d":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"16":{"tf":1.0},"22":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"38":{"tf":3.0}}}}},"t":{"df":0,"docs":{},"h":{"=":{"1":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"(":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"49":{"tf":1.0},"50":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"17":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"44":{"tf":1.0},"49":{"tf":1.7320508075688772},"50":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}},"r":{"df":3,"docs":{"13":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0}}}},"t":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"50":{"tf":1.7320508075688772}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"17":{"tf":1.0},"6":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"17":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":12,"docs":{"39":{"tf":2.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"13":{"tf":1.0},"16":{"tf":1.0},"18":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0}}}}}},"r":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"=":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":9,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"38":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772}},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"15":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":14,"docs":{"10":{"tf":2.6457513110645907},"11":{"tf":2.23606797749979},"15":{"tf":2.0},"17":{"tf":2.0},"19":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"43":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"6":{"tf":2.6457513110645907},"7":{"tf":2.8284271247461903},"8":{"tf":2.8284271247461903},"9":{"tf":3.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"40":{"tf":1.0},"43":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"32":{"tf":1.0},"35":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"o":{"c":{"df":2,"docs":{"1":{"tf":1.7320508075688772},"41":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":8,"docs":{"0":{"tf":1.0},"17":{"tf":2.0},"41":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.4142135623730951},"26":{"tf":1.0},"38":{"tf":1.0},"40":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"19":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"52":{"tf":1.0}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"18":{"tf":1.0},"29":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"24":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":2.449489742783178}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"45":{"tf":1.0}}}}},"x":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"y":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":7,"docs":{"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"29":{"tf":1.0},"33":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.7320508075688772},"50":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":4,"docs":{"13":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"5":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"41":{"tf":1.0},"43":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"38":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":2.23606797749979},"27":{"tf":2.6457513110645907},"28":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"5":{"df":1,"docs":{"15":{"tf":1.0}}},"8":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"17":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":2.6457513110645907},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":2,"docs":{"43":{"tf":1.0},"44":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"]":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.7320508075688772}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"17":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.4142135623730951}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"17":{"tf":3.3166247903554},"27":{"tf":1.0},"29":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"df":1,"docs":{"33":{"tf":1.4142135623730951}},"{":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"15":{"tf":1.0},"21":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"37":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"48":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"18":{"tf":2.449489742783178},"38":{"tf":1.0},"50":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"50":{"tf":1.0}}}}}}}},"u":{"b":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":2.6457513110645907}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"(":{"df":1,"docs":{"43":{"tf":1.0}}},"df":1,"docs":{"44":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"\"":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":7,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"43":{"tf":1.4142135623730951},"50":{"tf":2.6457513110645907},"51":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"c":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"49":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"35":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0}},"t":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"44":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0}}}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":20,"docs":{"0":{"tf":1.0},"10":{"tf":2.0},"14":{"tf":2.23606797749979},"15":{"tf":2.23606797749979},"16":{"tf":1.0},"17":{"tf":2.23606797749979},"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"29":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":2.0},"36":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"34":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"13":{"tf":1.0},"21":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":7,"docs":{"15":{"tf":1.0},"22":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.4142135623730951},"52":{"tf":1.0},"6":{"tf":1.0}}}},"t":{"df":3,"docs":{"15":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.4142135623730951}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"26":{"tf":1.0},"41":{"tf":1.0}}}},"n":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"48":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"s":{"df":3,"docs":{"21":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"41":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"42":{"tf":1.0},"44":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"17":{"tf":1.0},"7":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"34":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951}}}}},"r":{"a":{"df":2,"docs":{"16":{"tf":1.0},"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"f":{"3":{"2":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}}},"df":2,"docs":{"17":{"tf":1.4142135623730951},"22":{"tf":1.0}},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"39":{"tf":1.0},"43":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"18":{"tf":1.0},"40":{"tf":1.0},"48":{"tf":1.0}}},"s":{"df":7,"docs":{"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":3.605551275463989},"37":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"v":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":6,"docs":{"18":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":7,"docs":{"0":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":4,"docs":{"13":{"tf":1.0},"26":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"5":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":6,"docs":{"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.0},"48":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":4,"docs":{"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0}},"s":{":":{"2":{":":{"1":{"0":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"33":{"tf":1.4142135623730951},"34":{"tf":1.0}}},":":{"1":{"0":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},":":{":":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"\"":{")":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":24,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":2.8284271247461903},"14":{"tf":1.4142135623730951},"15":{"tf":2.23606797749979},"16":{"tf":2.0},"17":{"tf":3.4641016151377544},"19":{"tf":3.7416573867739413},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"32":{"tf":2.6457513110645907},"33":{"tf":2.8284271247461903},"34":{"tf":2.23606797749979},"35":{"tf":2.23606797749979},"43":{"tf":1.0},"48":{"tf":2.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0},"6":{"tf":3.0},"7":{"tf":2.0},"8":{"tf":3.1622776601683795},"9":{"tf":2.449489742783178}}}},"n":{"d":{"df":3,"docs":{"0":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":9,"docs":{"18":{"tf":1.0},"3":{"tf":1.0},"33":{"tf":1.4142135623730951},"38":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"6":{"tf":1.4142135623730951}}}}},"x":{"df":2,"docs":{"19":{"tf":1.0},"5":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"6":{"tf":1.0},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":13,"docs":{"10":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"34":{"tf":2.449489742783178},"35":{"tf":1.0},"43":{"tf":2.8284271247461903},"44":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}}},"o":{"c":{"df":0,"docs":{},"u":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"17":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.4142135623730951},"5":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":12,"docs":{"13":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"27":{"tf":1.0},"29":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"df":1,"docs":{"17":{"tf":1.7320508075688772}},"s":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{",":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},".":{"b":{"a":{"df":0,"docs":{},"r":{".":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"10":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":2.0},"43":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951}}},"r":{"c":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":26,"docs":{"12":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"48":{"tf":1.0}}}},"df":3,"docs":{"18":{"tf":1.0},"21":{"tf":1.4142135623730951},"45":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":3,"docs":{"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"51":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"r":{"df":2,"docs":{"33":{"tf":1.0},"9":{"tf":1.0}}}}},"r":{"a":{"c":{"df":1,"docs":{"29":{"tf":2.0}},"{":{"1":{"df":0,"docs":{},"}":{"df":0,"docs":{},"{":{"3":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"x":{"^":{"2":{"df":0,"docs":{},"}":{"df":0,"docs":{},"{":{"2":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":5,"docs":{"0":{"tf":1.0},"26":{"tf":1.0},"45":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{":":{":":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"_":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"50":{"tf":1.0}},"l":{"(":{"&":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":1,"docs":{"53":{"tf":1.0}},"g":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"q":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"33":{"tf":1.0},"48":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"25":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"q":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772}}}}},"t":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"d":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"49":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"42":{"tf":1.4142135623730951}}}},"h":{"df":1,"docs":{"38":{"tf":2.0}}},"i":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":3,"docs":{"0":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}}},"df":3,"docs":{"17":{"tf":2.449489742783178},"38":{"tf":3.0},"5":{"tf":2.23606797749979}},"h":{"df":0,"docs":{},"u":{"b":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}}}},"df":4,"docs":{"0":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"38":{"tf":3.0},"45":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"8":{"tf":2.23606797749979},"9":{"tf":2.23606797749979}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"41":{"tf":1.0}},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":4,"docs":{"10":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"5":{"tf":1.0}},"e":{"df":1,"docs":{"40":{"tf":1.0}}},"o":{"d":{"df":3,"docs":{"41":{"tf":1.0},"50":{"tf":1.4142135623730951},"52":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"52":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"(":{"&":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}}},"b":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"r":{"d":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"d":{".":{"df":0,"docs":{},"h":{"b":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":3,"docs":{"15":{"tf":1.0},"17":{"tf":2.23606797749979},"19":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"b":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"33":{"tf":1.0}}}},"p":{"df":2,"docs":{"5":{"tf":1.0},"53":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"16":{"tf":1.0},"22":{"tf":2.6457513110645907},"34":{"tf":1.0},"42":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":11,"docs":{"14":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"33":{"tf":1.4142135623730951},"35":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.4142135623730951},"53":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"34":{"tf":1.0},"35":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"19":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"31":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"35":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"17":{"tf":2.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"19":{"tf":1.0},"24":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"j":{"df":3,"docs":{"19":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.7320508075688772}}}},"df":4,"docs":{"19":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"48":{"tf":1.0}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{".":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"39":{"tf":1.0},"43":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"29":{"tf":1.0},"52":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"=":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"\"":{">":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"\"":{">":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"{":{"df":0,"docs":{},"{":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":12,"docs":{"13":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"17":{"tf":2.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"42":{"tf":1.0},"43":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"p":{"df":1,"docs":{"9":{"tf":2.0}},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"5":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{".":{"df":3,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"33":{"tf":1.4142135623730951}}},"3":{"2":{"df":1,"docs":{"34":{"tf":2.8284271247461903}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"d":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"17":{"tf":2.0},"34":{"tf":1.0}}}}},"d":{"df":1,"docs":{"17":{"tf":1.0}},"e":{"a":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":8,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951},"17":{"tf":1.0},"33":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"42":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"33":{"tf":1.0},"43":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"17":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"51":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"39":{"tf":1.0},"6":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":3,"docs":{"26":{"tf":2.0},"52":{"tf":1.0},"53":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":9,"docs":{"13":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"19":{"tf":1.0},"32":{"tf":2.6457513110645907},"33":{"tf":4.242640687119285},"34":{"tf":2.449489742783178},"42":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"b":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"48":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"m":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"15":{"tf":1.4142135623730951},"16":{"tf":1.4142135623730951}}}},"i":{"c":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}},"o":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"15":{"tf":1.4142135623730951},"21":{"tf":1.0},"45":{"tf":1.4142135623730951}}}}},"r":{"a":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"19":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.4142135623730951},"6":{"tf":3.0}},"i":{"df":1,"docs":{"34":{"tf":2.0}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.7320508075688772}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.7320508075688772}}}}},"i":{"d":{"df":2,"docs":{"28":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":7,"docs":{"17":{"tf":1.7320508075688772},"37":{"tf":2.23606797749979},"4":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"5":{"tf":3.3166247903554},"50":{"tf":1.0},"51":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":13,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.7320508075688772},"19":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"38":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"29":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":3,"docs":{"15":{"tf":1.0},"36":{"tf":1.7320508075688772},"38":{"tf":1.0}}}},"n":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"41":{"tf":1.0}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"32":{"tf":1.4142135623730951},"48":{"tf":1.0},"50":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":7,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.0}}}}}},"o":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"18":{"tf":1.0},"51":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":6,"docs":{"0":{"tf":1.4142135623730951},"22":{"tf":1.0},"26":{"tf":1.0},"46":{"tf":1.0},"52":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"t":{"'":{"df":7,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"18":{"tf":1.0},"47":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"50":{"tf":2.0}}},"r":{"df":2,"docs":{"44":{"tf":1.0},"47":{"tf":1.0}}}}}},"j":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"15":{"tf":1.0},"17":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.7320508075688772},"19":{"tf":1.0},"22":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0}}}}},"s":{"df":1,"docs":{"17":{"tf":2.6457513110645907}},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"18":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0}}}}}},"k":{"b":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"b":{"a":{"b":{"df":3,"docs":{"18":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"38":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}},"y":{"df":12,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.7320508075688772},"29":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"b":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"13":{"tf":1.0},"20":{"tf":1.0}}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":2.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"/":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"/":{"b":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.0}}}}}},"/":{"df":0,"docs":{},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"=":{"\"":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"21":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"g":{"df":7,"docs":{"10":{"tf":1.4142135623730951},"15":{"tf":2.23606797749979},"21":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"25":{"tf":1.0},"26":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.4142135623730951}}}},"x":{"df":1,"docs":{"42":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"y":{"df":1,"docs":{"13":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.0}}}}}}},"df":1,"docs":{"10":{"tf":2.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}},"v":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"\"":{">":{"<":{"/":{"df":0,"docs":{},"i":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"13":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}},"t":{"'":{"df":2,"docs":{"13":{"tf":1.0},"3":{"tf":1.0}}},"df":6,"docs":{"17":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":5,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":2.6457513110645907},"41":{"tf":1.0}}}}}},"i":{">":{"<":{"a":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"10":{"tf":1.7320508075688772},"39":{"tf":1.0},"41":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.7320508075688772}}}}}},"df":1,"docs":{"22":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"52":{"tf":1.0}}},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"26":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"22":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"22":{"tf":1.0},"29":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":21,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"18":{"tf":1.0},"25":{"tf":1.7320508075688772},"3":{"tf":2.0},"31":{"tf":1.7320508075688772},"33":{"tf":3.872983346207417},"34":{"tf":2.8284271247461903},"35":{"tf":1.0},"39":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.4142135623730951},"50":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"k":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":8,"docs":{"13":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":2.23606797749979},"21":{"tf":1.0},"22":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.0},"21":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}}}}},"o":{"a":{"d":{"df":6,"docs":{"17":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.4142135623730951},"48":{"tf":1.0}}},"df":0,"docs":{}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{":":{"3":{"0":{"0":{"0":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":1,"docs":{"53":{"tf":1.0}},"g":{"df":2,"docs":{"38":{"tf":1.0},"50":{"tf":1.0}},"i":{"c":{"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":10,"docs":{"14":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"41":{"tf":1.0},"44":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0}}}},"t":{"df":3,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"21":{"tf":1.0}}},"w":{"df":1,"docs":{"1":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"49":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":15,"docs":{"10":{"tf":1.0},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"34":{"tf":1.7320508075688772},"35":{"tf":1.0},"39":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"21":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"_":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"(":{")":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}},"df":9,"docs":{"16":{"tf":1.0},"22":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":4,"docs":{"13":{"tf":1.0},"18":{"tf":1.0},"26":{"tf":1.0},"47":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"34":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":13,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":2.8284271247461903},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"32":{"tf":1.0},"44":{"tf":2.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0},"6":{"tf":1.0}}}}}},"df":2,"docs":{"38":{"tf":1.0},"51":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"17":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}},"j":{"a":{"df":0,"docs":{},"x":{"df":6,"docs":{"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"29":{"tf":2.8284271247461903},"42":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"53":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"46":{"tf":1.0}}},":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{":":{":":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{},"{":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"m":{"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"{":{"c":{"df":0,"docs":{},"m":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":2,"docs":{"46":{"tf":1.0},"50":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"=":{"\"":{"df":0,"docs":{},"{":{"'":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"_":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"18":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"_":{"_":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"r":{"_":{"_":{"b":{"a":{"df":0,"docs":{},"z":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}}},"df":37,"docs":{"0":{"tf":2.23606797749979},"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"13":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":3.605551275463989},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"25":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":2.6457513110645907},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"41":{"tf":2.6457513110645907},"43":{"tf":2.8284271247461903},"44":{"tf":1.0},"45":{"tf":2.0},"46":{"tf":2.8284271247461903},"48":{"tf":3.0},"5":{"tf":2.8284271247461903},"50":{"tf":2.6457513110645907},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":2.0},"7":{"tf":1.7320508075688772},"8":{"tf":2.0},"9":{"tf":1.7320508075688772}}}}}},"df":1,"docs":{"7":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"df":1,"docs":{"38":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":3,"docs":{"18":{"tf":1.0},"48":{"tf":1.0},"6":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"39":{"tf":1.0},"43":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"40":{"tf":1.0},"48":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}},"u":{"df":1,"docs":{"17":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"15":{"tf":1.0},"18":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":4,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":5,"docs":{"18":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0},"53":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"6":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":7,"docs":{"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"51":{"tf":1.4142135623730951},"52":{"tf":1.0},"53":{"tf":1.0},"6":{"tf":1.0}},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"o":{"d":{"df":1,"docs":{"43":{"tf":1.0}},"e":{"df":1,"docs":{"33":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":5,"docs":{"19":{"tf":1.7320508075688772},"20":{"tf":1.0},"33":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":8,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"24":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0},"6":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.0},"19":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":1,"docs":{"29":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"17":{"tf":1.0}}}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"42":{"tf":1.0},"44":{"tf":1.0}}}},"df":5,"docs":{"44":{"tf":2.0},"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}}}},"df":9,"docs":{"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"19":{"tf":1.0}},"g":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"5":{"tf":1.0}}}}}},"df":1,"docs":{"9":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"46":{"tf":1.0},"50":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":16,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.23606797749979},"18":{"tf":1.4142135623730951},"19":{"tf":2.0},"20":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"33":{"tf":1.0},"39":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"5":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.4142135623730951},"18":{"tf":1.0},"49":{"tf":1.0}}}},"w":{"df":9,"docs":{"1":{"tf":1.0},"19":{"tf":1.4142135623730951},"22":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"38":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}},"x":{"df":0,"docs":{},"t":{"df":4,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"22":{"tf":2.0},"5":{"tf":1.4142135623730951}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"x":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"13":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"13":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.4142135623730951}},"e":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"|":{"_":{"df":1,"docs":{"44":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"48":{"tf":1.0}}}},"p":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"(":{"\"":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"43":{"tf":2.8284271247461903}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"13":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":12,"docs":{"15":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"38":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"h":{"df":1,"docs":{"43":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":7,"docs":{"19":{"tf":1.0},"24":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"5":{"tf":1.0},"50":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"47":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":2.23606797749979}},"s":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"13":{"tf":3.4641016151377544},"17":{"tf":2.23606797749979},"27":{"tf":2.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":2.0}}}}},"df":1,"docs":{"34":{"tf":1.7320508075688772}}}}},"o":{"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.0},"50":{"tf":1.0}}}}},"df":0,"docs":{}},"d":{"d":{"df":1,"docs":{"50":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":3,"docs":{"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"k":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":1.0}}},"l":{"d":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}},"n":{"c":{"df":3,"docs":{"13":{"tf":1.0},"45":{"tf":1.0},"8":{"tf":1.0}}},"df":3,"docs":{"17":{"tf":1.7320508075688772},"19":{"tf":1.0},"41":{"tf":1.0}}},"p":{"df":1,"docs":{"43":{"tf":2.0}},"e":{"df":0,"docs":{},"n":{"df":6,"docs":{"0":{"tf":1.0},"17":{"tf":1.4142135623730951},"5":{"tf":1.0},"7":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772}}},"r":{"df":1,"docs":{"18":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":11,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":2.449489742783178},"17":{"tf":3.605551275463989},"27":{"tf":1.0},"29":{"tf":1.0},"51":{"tf":1.7320508075688772},"7":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"27":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"21":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"df":7,"docs":{"13":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"48":{"tf":1.0},"49":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"27":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"14":{"tf":1.0},"17":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":5,"docs":{"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":13,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":2.6457513110645907},"19":{"tf":1.0},"22":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":2.449489742783178},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":4,"docs":{"19":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"9":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"16":{"tf":1.0},"18":{"tf":1.0},"24":{"tf":1.0}}}}},"df":3,"docs":{"11":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":1,"docs":{"1":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"24":{"tf":1.0},"6":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}}}}}}},"p":{"a":{"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":6,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"38":{"tf":3.4641016151377544},"4":{"tf":1.0},"45":{"tf":1.0}}}},"i":{"df":0,"docs":{},"r":{"df":3,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"33":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}}}}},"s":{"df":5,"docs":{"13":{"tf":1.0},"18":{"tf":1.4142135623730951},"40":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"&":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{")":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"|":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":2,"docs":{"13":{"tf":1.0},"44":{"tf":1.0}}}}},"t":{"df":3,"docs":{"13":{"tf":2.0},"33":{"tf":1.0},"43":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"34":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":1,"docs":{"43":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"45":{"tf":1.0},"50":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"50":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"/":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"37":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":2,"docs":{"48":{"tf":1.0},"51":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"df":16,"docs":{"10":{"tf":2.0},"11":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":2.0},"32":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.4142135623730951},"50":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"33":{"tf":1.0},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}}}}},"df":1,"docs":{"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"h":{"a":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"44":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}}}},"y":{"df":1,"docs":{"35":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"35":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"22":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":2,"docs":{"46":{"tf":1.0},"50":{"tf":1.0}}},"df":4,"docs":{"39":{"tf":1.0},"43":{"tf":1.7320508075688772},"46":{"tf":1.0},"50":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"21":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":2.23606797749979}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"13":{"tf":1.0},"45":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"43":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"(":{"&":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"df":1,"docs":{"5":{"tf":1.0}},"f":{"a":{"c":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}},"i":{"df":0,"docs":{},"x":{"df":3,"docs":{"13":{"tf":2.23606797749979},"17":{"tf":1.0},"18":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"21":{"tf":1.0},"25":{"tf":1.0},"31":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"16":{"tf":1.0},"43":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":2,"docs":{"14":{"tf":1.0},"16":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.4142135623730951}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}}}}},"df":9,"docs":{"15":{"tf":2.6457513110645907},"16":{"tf":3.0},"17":{"tf":2.23606797749979},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":4.69041575982343},"44":{"tf":2.0}},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}},"/":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"9":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"22":{"tf":2.6457513110645907},"50":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"50":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":5,"docs":{"25":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":5,"docs":{"19":{"tf":1.0},"23":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"0":{"df":1,"docs":{"43":{"tf":1.0}}},"1":{"df":2,"docs":{"43":{"tf":1.4142135623730951},"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":10,"docs":{"15":{"tf":1.4142135623730951},"20":{"tf":1.0},"22":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.7320508075688772},"41":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"50":{"tf":1.0}},"e":{"d":{"_":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"48":{"tf":1.0}}},"df":10,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"23":{"tf":1.0},"25":{"tf":1.0},"34":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":1.0},"45":{"tf":2.23606797749979},"46":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"21":{"tf":1.0},"22":{"tf":2.0}}}}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":8,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}}},"u":{"b":{"df":3,"docs":{"43":{"tf":1.7320508075688772},"49":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772}},"l":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":2,"docs":{"2":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.4142135623730951}}}}}},"df":2,"docs":{"26":{"tf":1.0},"44":{"tf":1.0}}}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"13":{"tf":1.0},"6":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}},"t":{"df":4,"docs":{"15":{"tf":1.0},"24":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"3":{"df":1,"docs":{"43":{"tf":1.0}}},"df":4,"docs":{"16":{"tf":1.0},"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"52":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"41":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":2.0}}}}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"43":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}},"i":{"df":1,"docs":{"6":{"tf":1.0}}},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"52":{"tf":1.0}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"45":{"tf":1.0},"48":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"45":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"19":{"tf":1.0},"46":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}}}},"l":{"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"32":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"2":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":2.0}}}},"df":0,"docs":{},"v":{"df":2,"docs":{"15":{"tf":1.0},"33":{"tf":1.0}}}},"o":{"a":{"d":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"44":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"24":{"tf":1.0}},"e":{"_":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"49":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"46":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":4,"docs":{"46":{"tf":1.7320508075688772},"47":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}}}}}}}},"df":23,"docs":{"1":{"tf":1.0},"13":{"tf":2.23606797749979},"15":{"tf":1.0},"16":{"tf":3.0},"17":{"tf":4.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.4142135623730951},"31":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":2.8284271247461903},"45":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"50":{"tf":2.23606797749979},"6":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"a":{"c":{"df":4,"docs":{"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.4142135623730951},"44":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":1,"docs":{"38":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"17":{"tf":2.449489742783178},"38":{"tf":1.0},"5":{"tf":1.0}}},"y":{"'":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"45":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"26":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"48":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":2,"docs":{"24":{"tf":1.0},"34":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"<":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":9,"docs":{"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"17":{"tf":3.4641016151377544},"18":{"tf":1.0},"27":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"34":{"tf":1.4142135623730951},"50":{"tf":1.0}}}}}}},"f":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"m":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.0}}}},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}}}},"df":10,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":1.7320508075688772},"19":{"tf":1.0},"21":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":2.0},"9":{"tf":2.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"45":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"49":{"tf":1.0}}}}}}}},"p":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}},"u":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"38":{"tf":1.0},"50":{"tf":1.0}}}},"n":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":17,"docs":{"10":{"tf":1.0},"15":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"48":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0},"9":{"tf":1.0}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"27":{"tf":1.0},"35":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{",":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"2":{"0":{"1":{"5":{"df":1,"docs":{"15":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{",":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"33":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"o":{"c":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":2,"docs":{"16":{"tf":1.0},"34":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":6,"docs":{"1":{"tf":1.0},"10":{"tf":2.23606797749979},"17":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0},"45":{"tf":1.0}}},"df":0,"docs":{}}},"df":14,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"23":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":2.23606797749979},"37":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772},"5":{"tf":1.7320508075688772},"51":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":8,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"df":4,"docs":{"18":{"tf":1.0},"22":{"tf":1.4142135623730951},"37":{"tf":1.0},"48":{"tf":1.0}}}}}}},"df":1,"docs":{"21":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"10":{"tf":1.0},"17":{"tf":4.242640687119285}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":8,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":2.8284271247461903},"19":{"tf":1.0},"21":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"38":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"35":{"tf":1.0}},"n":{"df":1,"docs":{"6":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"43":{"tf":1.0},"46":{"tf":1.0}}}}}},"n":{"d":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"16":{"tf":1.0},"43":{"tf":1.0}}},"t":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":2.0},"18":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"49":{"tf":1.7320508075688772}},"e":{"(":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"50":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"49":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"44":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"44":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}},"v":{"df":4,"docs":{"0":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.0},"9":{"tf":3.1622776601683795}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"6":{"tf":1.0},"9":{"tf":2.0}}}}}},"t":{"df":9,"docs":{"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":2.23606797749979},"18":{"tf":1.7320508075688772},"19":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.4142135623730951},"6":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"40":{"tf":1.0},"45":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"38":{"tf":1.0},"43":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"44":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"53":{"tf":1.0}}}},"w":{"df":5,"docs":{"17":{"tf":1.0},"34":{"tf":1.4142135623730951},"39":{"tf":1.0},"44":{"tf":1.0},"52":{"tf":1.0}},"n":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"19":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"13":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"45":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"43":{"tf":1.0},"45":{"tf":1.4142135623730951}},"i":{"df":3,"docs":{"17":{"tf":1.0},"42":{"tf":1.0},"45":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}},"u":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"52":{"tf":1.0}}},"p":{"df":2,"docs":{"38":{"tf":1.0},"49":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"17":{"tf":1.0},"18":{"tf":1.0}}}}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":8,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.7320508075688772},"38":{"tf":1.0},"5":{"tf":1.0}}}}}}}},"o":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"53":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"f":{"df":0,"docs":{},"g":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"b":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"43":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":6,"docs":{"18":{"tf":1.0},"22":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"10":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"38":{"tf":1.0},"50":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":13,"docs":{"0":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"32":{"tf":1.0},"35":{"tf":1.0},"5":{"tf":2.0},"52":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":6,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"30":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"48":{"tf":1.0},"6":{"tf":1.0}},"i":{"df":14,"docs":{"10":{"tf":2.23606797749979},"11":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":2.449489742783178},"21":{"tf":1.7320508075688772},"23":{"tf":1.0},"34":{"tf":1.7320508075688772},"43":{"tf":1.4142135623730951},"48":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"9":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":3,"docs":{"15":{"tf":2.449489742783178},"19":{"tf":1.0},"6":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"18":{"tf":1.0},"43":{"tf":1.0},"52":{"tf":1.0},"9":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"43":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"df":1,"docs":{"48":{"tf":1.0}}}},"d":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"o":{":":{":":{"df":0,"docs":{},"{":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"43":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"43":{"tf":1.0},"50":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"46":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":6,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"47":{"tf":1.0},"49":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.0},"44":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"40":{"tf":1.0},"45":{"tf":1.0},"47":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"53":{"tf":1.0}},"k":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"13":{"tf":1.7320508075688772},"34":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"df":1,"docs":{"43":{"tf":1.4142135623730951}},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"c":{"a":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"(":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":2,"docs":{"18":{"tf":1.4142135623730951},"44":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"33":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.7320508075688772},"50":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.7320508075688772},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":5,"docs":{"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"19":{"tf":1.0}}}}}}}}}}},"u":{"b":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"43":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"\"":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":1,"docs":{"43":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"13":{"tf":1.0}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"38":{"tf":1.0}},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{},"h":{"df":5,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"29":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"m":{"_":{"df":0,"docs":{},"{":{"df":0,"docs":{},"i":{"=":{"0":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}},"y":{".":{"df":0,"docs":{},"m":{"d":{"df":7,"docs":{"12":{"tf":1.0},"13":{"tf":2.0},"15":{"tf":1.0},"21":{"tf":1.0},"48":{"tf":1.0},"6":{"tf":2.23606797749979},"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"17":{"tf":1.7320508075688772},"29":{"tf":2.449489742783178},"33":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":2.23606797749979},"48":{"tf":1.0}},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"43":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":4,"docs":{"19":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":6,"docs":{"23":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":3,"docs":{"18":{"tf":1.0},"33":{"tf":2.0},"41":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"13":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.7320508075688772},"17":{"tf":3.0},"21":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"19":{"tf":1.0},"26":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"49":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"43":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"19":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"8":{"tf":1.0},"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"5":{"tf":1.7320508075688772},"50":{"tf":1.0},"9":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":10,"docs":{"10":{"tf":3.7416573867739413},"15":{"tf":1.0},"17":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":2.449489742783178},"43":{"tf":1.0},"45":{"tf":1.4142135623730951},"48":{"tf":1.0},"6":{"tf":1.0},"9":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"/":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"44":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":14,"docs":{"12":{"tf":1.0},"17":{"tf":3.7416573867739413},"19":{"tf":3.872983346207417},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":3.0},"25":{"tf":1.0},"26":{"tf":2.23606797749979},"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"48":{"tf":1.0},"6":{"tf":2.23606797749979}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":3,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":4,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"26":{"tf":1.0},"6":{"tf":1.0}}}},"r":{"d":{"df":2,"docs":{"33":{"tf":1.0},"43":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"13":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"13":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":7,"docs":{"25":{"tf":1.0},"29":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"52":{"tf":1.0},"9":{"tf":1.0}}}}},"w":{"df":1,"docs":{"51":{"tf":1.0}}}}},"u":{"df":1,"docs":{"13":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":5,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"37":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}}},"p":{"df":1,"docs":{"6":{"tf":1.0}}},"t":{"df":0,"docs":{},"l":{"df":9,"docs":{"13":{"tf":3.1622776601683795},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"17":{"tf":2.0},"18":{"tf":1.0},"21":{"tf":1.7320508075688772},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"p":{"/":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"38":{"tf":2.8284271247461903}}}}}},"df":0,"docs":{}},"df":1,"docs":{"38":{"tf":1.0}}}},"o":{"c":{"df":1,"docs":{"22":{"tf":1.7320508075688772}},"}":{"df":0,"docs":{},"}":{"df":0,"docs":{},"{":{"df":0,"docs":{},"{":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"22":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":11,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":1.0},"3":{"tf":2.0},"39":{"tf":1.4142135623730951},"48":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"p":{"df":2,"docs":{"19":{"tf":1.0},"41":{"tf":1.0}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"52":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"43":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"43":{"tf":1.0},"44":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"i":{"df":3,"docs":{"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"37":{"tf":1.0},"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":5,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.4142135623730951},"7":{"tf":1.0}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}}}},"u":{"df":0,"docs":{},"e":{"df":9,"docs":{"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":4.242640687119285},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"38":{"tf":1.0},"44":{"tf":1.0},"51":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":4,"docs":{"18":{"tf":1.0},"23":{"tf":1.0},"40":{"tf":1.0},"47":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"19":{"tf":1.0},"41":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":4,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"29":{"tf":1.0},"39":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":3,"docs":{"41":{"tf":1.0},"49":{"tf":1.0},"5":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"43":{"tf":1.0},"48":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":2.0}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"29":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":1,"docs":{"19":{"tf":1.0}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"43":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"24":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{"'":{"df":1,"docs":{"50":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"37":{"tf":1.7320508075688772},"38":{"tf":1.0},"42":{"tf":1.4142135623730951},"48":{"tf":1.0}}}},"df":0,"docs":{}},"df":5,"docs":{"33":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"6":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}},"l":{"df":1,"docs":{"17":{"tf":2.6457513110645907}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":37,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"10":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":2.23606797749979},"15":{"tf":2.23606797749979},"16":{"tf":1.0},"17":{"tf":3.1622776601683795},"18":{"tf":1.4142135623730951},"19":{"tf":3.1622776601683795},"20":{"tf":1.0},"21":{"tf":2.0},"22":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"24":{"tf":2.23606797749979},"29":{"tf":1.7320508075688772},"3":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.7320508075688772},"36":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":2.23606797749979},"42":{"tf":1.0},"43":{"tf":3.3166247903554},"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"48":{"tf":2.0},"50":{"tf":2.6457513110645907},"6":{"tf":2.449489742783178},"7":{"tf":1.7320508075688772},"8":{"tf":2.6457513110645907},"9":{"tf":2.8284271247461903}},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"38":{"tf":1.0},"43":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.0}}}},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"44":{"tf":1.0},"47":{"tf":1.0}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"29":{"tf":1.0},"32":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"2":{".":{"0":{"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":11,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.4142135623730951},"18":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"43":{"tf":1.0},"49":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":1,"docs":{"22":{"tf":1.0}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"18":{"tf":2.6457513110645907},"38":{"tf":1.0},"50":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"<":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"49":{"tf":1.0},"50":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":1,"docs":{"37":{"tf":1.0}},"i":{"df":3,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"13":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"45":{"tf":1.4142135623730951},"5":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":7,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0},"4":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":2.0},"5":{"tf":2.23606797749979}}}}}}}},"i":{"a":{"df":9,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":16,"docs":{"16":{"tf":1.0},"19":{"tf":2.449489742783178},"20":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"43":{"tf":1.0},"46":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"48":{"tf":1.0},"8":{"tf":2.8284271247461903},"9":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":6,"docs":{"31":{"tf":1.0},"34":{"tf":1.4142135623730951},"39":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0}},"n":{"df":1,"docs":{"53":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}}}}},"df":1,"docs":{"9":{"tf":1.0}},"e":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"49":{"tf":1.0}}}},"r":{"df":1,"docs":{"43":{"tf":1.0}}},"v":{"df":2,"docs":{"48":{"tf":1.0},"50":{"tf":1.0}}}},"b":{"df":3,"docs":{"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"24":{"tf":1.0},"9":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":2.449489742783178}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"53":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"17":{"tf":1.0},"36":{"tf":1.0},"9":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"8":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"17":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"17":{"tf":1.0},"6":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"13":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"18":{"tf":1.0},"26":{"tf":1.0},"32":{"tf":1.0},"44":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"49":{"tf":2.0},"50":{"tf":1.0}}}}}}}},"df":4,"docs":{"46":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951}}}}}}},"df":6,"docs":{"17":{"tf":2.8284271247461903},"45":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":2.0}}},"df":0,"docs":{},"k":{"df":12,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.0},"48":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"38":{"tf":1.4142135623730951}}}}}},"l":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"32":{"tf":1.0},"52":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":6,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"13":{"tf":1.0},"29":{"tf":1.4142135623730951},"50":{"tf":1.0},"6":{"tf":1.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"df":0,"docs":{},"f":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":7,"docs":{"0":{"tf":1.0},"13":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"5":{"tf":1.0},"50":{"tf":1.0}}}}}}}}},"x":{"_":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":5,"docs":{"25":{"tf":2.0},"29":{"tf":1.4142135623730951},"31":{"tf":2.0},"34":{"tf":2.23606797749979},"37":{"tf":1.4142135623730951}}},"y":{"df":2,"docs":{"25":{"tf":2.0},"31":{"tf":2.0}},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":2,"docs":{"48":{"tf":1.0},"52":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"44":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0}}}},"r":{"df":2,"docs":{"38":{"tf":1.0},"53":{"tf":1.0}}},"v":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"24":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0}}}}}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"50":{"tf":1.4142135623730951}}}}}}}},"title":{"root":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"45":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"45":{"tf":1.0},"48":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":3,"docs":{"37":{"tf":1.0},"38":{"tf":1.0},"47":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"37":{"tf":1.0},"40":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"25":{"tf":1.0},"31":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":7,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"3":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"49":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"36":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"24":{"tf":1.0},"28":{"tf":1.0}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"21":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"o":{"c":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"18":{"tf":1.0}}}}}}}},"x":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{}}},"f":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":4,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"38":{"tf":1.0}}},"df":0,"docs":{}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"51":{"tf":1.0}},"e":{"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":3,"docs":{"25":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"43":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":3,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{".":{"df":0,"docs":{},"h":{"b":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"4":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":4,"docs":{"25":{"tf":1.0},"3":{"tf":1.0},"31":{"tf":1.0},"34":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":5,"docs":{"0":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"50":{"tf":1.0}}}}}}}},"p":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"38":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"16":{"tf":1.0},"42":{"tf":1.0},"44":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.0}}}},"t":{"df":1,"docs":{"46":{"tf":1.0}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"5":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"30":{"tf":1.0}},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"29":{"tf":1.0}}}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"37":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"19":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"46":{"tf":1.0},"52":{"tf":1.0}}},"s":{"df":1,"docs":{"41":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"52":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":20,"teaser_word_count":30},"search_options":{"bool":"AND","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":2},"title":{"boost":2}}}});