function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { UI_SETTINGS } from '../../../../data/public';
export var addHelpMenuToAppChrome = function addHelpMenuToAppChrome(chrome, docLinks) {
  chrome.setHelpExtension({
    appName: i18n.translate('visualize.helpMenu.appName', {
      defaultMessage: 'Visualize'
    }),
    links: [{
      linkType: 'documentation',
      href: "".concat(docLinks.ELASTIC_WEBSITE_URL, "guide/en/kibana/").concat(docLinks.DOC_LINK_VERSION, "/visualize.html")
    }]
  });
};
export var addBadgeToAppChrome = function addBadgeToAppChrome(chrome) {
  chrome.setBadge({
    text: i18n.translate('visualize.badge.readOnly.text', {
      defaultMessage: 'Read only'
    }),
    tooltip: i18n.translate('visualize.badge.readOnly.tooltip', {
      defaultMessage: 'Unable to save visualizations'
    }),
    iconType: 'glasses'
  });
};
export var getDefaultQuery = function getDefaultQuery(_ref) {
  var localStorage = _ref.localStorage,
      uiSettings = _ref.uiSettings;
  return {
    query: '',
    language: localStorage.get('kibana.userQueryLanguage') || uiSettings.get(UI_SETTINGS.SEARCH_QUERY_LANGUAGE)
  };
};
export var visStateToEditorState = function visStateToEditorState(_ref2, services) {
  var _vis$data$searchSourc, _vis$data$searchSourc2;

  var vis = _ref2.vis,
      savedVis = _ref2.savedVis;
  var savedVisState = services.visualizations.convertFromSerializedVis(vis.serialize());
  return {
    uiState: savedVis.uiStateJSON ? JSON.parse(savedVis.uiStateJSON) : vis.uiState.toJSON(),
    query: ((_vis$data$searchSourc = vis.data.searchSource) === null || _vis$data$searchSourc === void 0 ? void 0 : _vis$data$searchSourc.getOwnField('query')) || getDefaultQuery(services),
    filters: ((_vis$data$searchSourc2 = vis.data.searchSource) === null || _vis$data$searchSourc2 === void 0 ? void 0 : _vis$data$searchSourc2.getOwnField('filter')) || [],
    vis: _objectSpread(_objectSpread({}, savedVisState.visState), {}, {
      title: vis.title
    }),
    linked: !!savedVis.savedSearchId
  };
};