function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { get } from 'lodash';
import { i18n } from '@kbn/i18n';
import { PersistedState } from '../../../../plugins/visualizations/public';
import { getTypes, getIndexPatterns, getFilterManager, getSearch } from '../services';
export var visualization = function visualization() {
  return {
    name: 'visualization',
    type: 'render',
    help: i18n.translate('visualizations.functions.visualization.help', {
      defaultMessage: 'A simple visualization'
    }),
    args: {
      // TODO: Below `help` keys should be internationalized once this function
      // TODO: is moved to visualizations plugin.
      index: {
        types: ['string', 'null'],
        default: null,
        help: 'Index'
      },
      metricsAtAllLevels: {
        types: ['boolean'],
        default: false,
        help: 'Metrics levels'
      },
      partialRows: {
        types: ['boolean'],
        default: false,
        help: 'Partial rows'
      },
      type: {
        types: ['string'],
        default: '',
        help: 'Type'
      },
      schemas: {
        types: ['string'],
        default: '"{}"',
        help: 'Schemas'
      },
      visConfig: {
        types: ['string'],
        default: '"{}"',
        help: 'Visualization configuration'
      },
      uiState: {
        types: ['string'],
        default: '"{}"',
        help: 'User interface state'
      },
      aggConfigs: {
        types: ['string'],
        default: '"{}"',
        help: 'Aggregation configurations'
      }
    },
    fn: function fn(input, args, _ref) {
      return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var inspectorAdapters, visConfigParams, schemas, visType, indexPattern, uiStateParams, uiState, aggConfigsState, aggs;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                inspectorAdapters = _ref.inspectorAdapters;
                visConfigParams = args.visConfig ? JSON.parse(args.visConfig) : {};
                schemas = args.schemas ? JSON.parse(args.schemas) : {};
                visType = getTypes().get(args.type || 'histogram');

                if (!args.index) {
                  _context.next = 10;
                  break;
                }

                _context.next = 7;
                return getIndexPatterns().get(args.index);

              case 7:
                _context.t0 = _context.sent;
                _context.next = 11;
                break;

              case 10:
                _context.t0 = null;

              case 11:
                indexPattern = _context.t0;
                uiStateParams = args.uiState ? JSON.parse(args.uiState) : {};
                uiState = new PersistedState(uiStateParams);
                aggConfigsState = args.aggConfigs ? JSON.parse(args.aggConfigs) : [];
                aggs = indexPattern ? getSearch().aggs.createAggConfigs(indexPattern, aggConfigsState) : undefined;

                if (!(typeof visType.requestHandler === 'function')) {
                  _context.next = 20;
                  break;
                }

                _context.next = 19;
                return visType.requestHandler({
                  partialRows: args.partialRows,
                  metricsAtAllLevels: args.metricsAtAllLevels,
                  index: indexPattern,
                  visParams: visConfigParams,
                  timeRange: get(input, 'timeRange', null),
                  query: get(input, 'query', null),
                  filters: get(input, 'filters', null),
                  uiState: uiState,
                  inspectorAdapters: inspectorAdapters,
                  queryFilter: getFilterManager(),
                  forceFetch: true,
                  aggs: aggs
                });

              case 19:
                input = _context.sent;

              case 20:
                if (!(typeof visType.responseHandler === 'function')) {
                  _context.next = 25;
                  break;
                }

                if (input.columns) {
                  // assign schemas to aggConfigs
                  input.columns.forEach(function (column) {
                    if (column.aggConfig) {
                      column.aggConfig.aggConfigs.schemas = visType.schemas.all;
                    }
                  });
                  Object.keys(schemas).forEach(function (key) {
                    schemas[key].forEach(function (i) {
                      if (input.columns[i] && input.columns[i].aggConfig) {
                        input.columns[i].aggConfig.schema = key;
                      }
                    });
                  });
                }

                _context.next = 24;
                return visType.responseHandler(input, visConfigParams.dimensions);

              case 24:
                input = _context.sent;

              case 25:
                return _context.abrupt("return", {
                  type: 'render',
                  as: 'visualization',
                  value: {
                    visData: input,
                    visType: args.type || '',
                    visConfig: visConfigParams
                  }
                });

              case 26:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }))();
    }
  };
};