function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback } from 'react';
import { EuiPanel, EuiTitle, EuiSpacer } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { SelectOption, SwitchOption } from '../../../../../charts/public';
import { LabelOptions } from './label_options';

function CategoryAxisPanel(_ref) {
  var axis = _ref.axis,
      onPositionChanged = _ref.onPositionChanged,
      vis = _ref.vis,
      setCategoryAxis = _ref.setCategoryAxis;
  var setAxis = useCallback(function (paramName, value) {
    var updatedAxis = _objectSpread(_objectSpread({}, axis), {}, _defineProperty({}, paramName, value));

    setCategoryAxis(updatedAxis);
  }, [setCategoryAxis, axis]);
  var setPosition = useCallback(function (paramName, value) {
    setAxis(paramName, value);
    onPositionChanged(value);
  }, [setAxis, onPositionChanged]);
  var setAxisLabel = useCallback(function (paramName, value) {
    var labels = _objectSpread(_objectSpread({}, axis.labels), {}, _defineProperty({}, paramName, value));

    setAxis('labels', labels);
  }, [axis.labels, setAxis]);
  return /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeVislib.controls.pointSeries.categoryAxis.xAxisTitle",
    defaultMessage: "X-axis"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(SelectOption, {
    label: i18n.translate('visTypeVislib.controls.pointSeries.categoryAxis.positionLabel', {
      defaultMessage: 'Position'
    }),
    options: vis.type.editorConfig.collections.positions,
    paramName: "position",
    value: axis.position,
    setValue: setPosition,
    "data-test-subj": "categoryAxisPosition"
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeVislib.controls.pointSeries.categoryAxis.showLabel', {
      defaultMessage: 'Show axis lines and labels'
    }),
    paramName: "show",
    value: axis.show,
    setValue: setAxis
  }), axis.show && /*#__PURE__*/React.createElement(LabelOptions, {
    axisLabels: axis.labels,
    axisFilterCheckboxName: "xAxisFilterLabelsCheckbox".concat(axis.id),
    setAxisLabel: setAxisLabel
  }));
}

export { CategoryAxisPanel };