function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiPanel, EuiSpacer, EuiTitle } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { SwitchOption, TextInputOption } from '../../../../../charts/public';

function LabelsPanel(_ref) {
  var stateParams = _ref.stateParams,
      setValue = _ref.setValue,
      setGaugeValue = _ref.setGaugeValue;
  return /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeVislib.controls.gaugeOptions.labelsTitle",
    defaultMessage: "Labels"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeVislib.controls.gaugeOptions.showLabelsLabel', {
      defaultMessage: 'Show labels'
    }),
    paramName: "show",
    value: stateParams.gauge.labels.show,
    setValue: function setValue(paramName, value) {
      return setGaugeValue('labels', _objectSpread(_objectSpread({}, stateParams.gauge.labels), {}, _defineProperty({}, paramName, value)));
    }
  }), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(TextInputOption, {
    disabled: !stateParams.gauge.labels.show,
    label: i18n.translate('visTypeVislib.controls.gaugeOptions.subTextLabel', {
      defaultMessage: 'Sub label'
    }),
    paramName: "subText",
    value: stateParams.gauge.style.subText,
    setValue: function setValue(paramName, value) {
      return setGaugeValue('style', _objectSpread(_objectSpread({}, stateParams.gauge.style), {}, _defineProperty({}, paramName, value)));
    }
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    disabled: !stateParams.gauge.labels.show,
    label: i18n.translate('visTypeVislib.controls.gaugeOptions.displayWarningsLabel', {
      defaultMessage: 'Display warnings'
    }),
    tooltip: i18n.translate('visTypeVislib.controls.gaugeOptions.switchWarningsTooltip', {
      defaultMessage: 'Turns on/off warnings. When turned on, a warning will be shown if not all labels could be displayed.'
    }),
    paramName: "isDisplayWarning",
    value: stateParams.isDisplayWarning,
    setValue: setValue
  }));
}

export { LabelsPanel };