function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { get } from 'lodash';
import { i18n } from '@kbn/i18n';
import { getTimelionRequestHandler } from './helpers/timelion_request_handler';
import { TIMELION_VIS_NAME } from './timelion_vis_type';
export var getTimelionVisualizationConfig = function getTimelionVisualizationConfig(dependencies) {
  return {
    name: 'timelion_vis',
    type: 'render',
    inputTypes: ['kibana_context', 'null'],
    help: i18n.translate('timelion.function.help', {
      defaultMessage: 'Timelion visualization'
    }),
    args: {
      expression: {
        types: ['string'],
        aliases: ['_'],
        default: '".es(*)"',
        help: ''
      },
      interval: {
        types: ['string'],
        default: 'auto',
        help: ''
      }
    },
    fn: function fn(input, args) {
      return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var timelionRequestHandler, visParams, response;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                timelionRequestHandler = getTimelionRequestHandler(dependencies);
                visParams = {
                  expression: args.expression,
                  interval: args.interval
                };
                _context.next = 4;
                return timelionRequestHandler({
                  timeRange: get(input, 'timeRange'),
                  query: get(input, 'query'),
                  filters: get(input, 'filters'),
                  visParams: visParams,
                  forceFetch: true
                });

              case 4:
                response = _context.sent;
                response.visType = TIMELION_VIS_NAME;
                return _context.abrupt("return", {
                  type: 'render',
                  as: 'visualization',
                  value: {
                    visParams: visParams,
                    visType: TIMELION_VIS_NAME,
                    visData: response
                  }
                });

              case 7:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }))();
    }
  };
};