/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// inner angular imports
// these are necessary to bootstrap the local angular.
// They can stay even after NP cutover
import angular from 'angular'; // required for `ngSanitize` angular module

import 'angular-sanitize';
import 'angular-recursion';
import { i18nDirective, i18nFilter, I18nProvider } from '@kbn/i18n/angular';
import { initAngularBootstrap, PaginateDirectiveProvider, PaginateControlsDirectiveProvider, PrivateProvider, watchMultiDecorator, KbnAccessibleClickProvider } from '../../kibana_legacy/public';
initAngularBootstrap();
var thirdPartyAngularDependencies = ['ngSanitize', 'ui.bootstrap', 'RecursionHelper'];
export function getAngularModule(name, core, context) {
  var uiModule = getInnerAngular(name, core);
  return uiModule;
}
var initialized = false;
export function getInnerAngular() {
  var name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'kibana/table_vis';
  var core = arguments.length > 1 ? arguments[1] : undefined;

  if (!initialized) {
    createLocalPrivateModule();
    createLocalI18nModule();
    createLocalConfigModule(core.uiSettings);
    createLocalPaginateModule();
    initialized = true;
  }

  return angular.module(name, [].concat(thirdPartyAngularDependencies, ['tableVisPaginate', 'tableVisConfig', 'tableVisPrivate', 'tableVisI18n'])).config(watchMultiDecorator).directive('kbnAccessibleClick', KbnAccessibleClickProvider);
}

function createLocalPrivateModule() {
  angular.module('tableVisPrivate', []).provider('Private', PrivateProvider);
}

function createLocalConfigModule(uiSettings) {
  angular.module('tableVisConfig', []).provider('config', function () {
    return {
      $get: function $get() {
        return {
          get: function get(value) {
            return uiSettings ? uiSettings.get(value) : undefined;
          },
          // set method is used in agg_table mocha test
          set: function set(key, value) {
            return uiSettings ? uiSettings.set(key, value) : undefined;
          }
        };
      }
    };
  });
}

function createLocalI18nModule() {
  angular.module('tableVisI18n', []).provider('i18n', I18nProvider).filter('i18n', i18nFilter).directive('i18nId', i18nDirective);
}

function createLocalPaginateModule() {
  angular.module('tableVisPaginate', []).directive('paginate', PaginateDirectiveProvider).directive('paginateControls', PaginateControlsDirectiveProvider);
}