function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { ActionInternal } from '../actions';
import { TriggerInternal } from '../triggers/trigger_internal';
export var UiActionsService = function UiActionsService() {
  var _this = this;

  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref$triggers = _ref.triggers,
      _triggers = _ref$triggers === void 0 ? new Map() : _ref$triggers,
      _ref$actions = _ref.actions,
      _actions = _ref$actions === void 0 ? new Map() : _ref$actions,
      _ref$triggerToActions = _ref.triggerToActions,
      _triggerToActions = _ref$triggerToActions === void 0 ? new Map() : _ref$triggerToActions;

  _classCallCheck(this, UiActionsService);

  _defineProperty(this, "triggers", void 0);

  _defineProperty(this, "actions", void 0);

  _defineProperty(this, "triggerToActions", void 0);

  _defineProperty(this, "registerTrigger", function (trigger) {
    if (_this.triggers.has(trigger.id)) {
      throw new Error("Trigger [trigger.id = ".concat(trigger.id, "] already registered."));
    }

    var triggerInternal = new TriggerInternal(_this, trigger);

    _this.triggers.set(trigger.id, triggerInternal);

    _this.triggerToActions.set(trigger.id, []);
  });

  _defineProperty(this, "getTrigger", function (triggerId) {
    var trigger = _this.triggers.get(triggerId);

    if (!trigger) {
      throw new Error("Trigger [triggerId = ".concat(triggerId, "] does not exist."));
    }

    return trigger.contract;
  });

  _defineProperty(this, "registerAction", function (definition) {
    if (_this.actions.has(definition.id)) {
      throw new Error("Action [action.id = ".concat(definition.id, "] already registered."));
    }

    var action = new ActionInternal(definition);

    _this.actions.set(action.id, action);

    return action;
  });

  _defineProperty(this, "unregisterAction", function (actionId) {
    if (!_this.actions.has(actionId)) {
      throw new Error("Action [action.id = ".concat(actionId, "] is not registered."));
    }

    _this.actions.delete(actionId);
  });

  _defineProperty(this, "attachAction", function (triggerId, actionId) {
    var trigger = _this.triggers.get(triggerId);

    if (!trigger) {
      throw new Error("No trigger [triggerId = ".concat(triggerId, "] exists, for attaching action [actionId = ").concat(actionId, "]."));
    }

    var actionIds = _this.triggerToActions.get(triggerId);

    if (!actionIds.find(function (id) {
      return id === actionId;
    })) {
      _this.triggerToActions.set(triggerId, [].concat(_toConsumableArray(actionIds), [actionId]));
    }
  });

  _defineProperty(this, "detachAction", function (triggerId, actionId) {
    var trigger = _this.triggers.get(triggerId);

    if (!trigger) {
      throw new Error("No trigger [triggerId = ".concat(triggerId, "] exists, for detaching action [actionId = ").concat(actionId, "]."));
    }

    var actionIds = _this.triggerToActions.get(triggerId);

    _this.triggerToActions.set(triggerId, actionIds.filter(function (id) {
      return id !== actionId;
    }));
  });

  _defineProperty(this, "addTriggerAction", function (triggerId, action) {
    if (!_this.actions.has(action.id)) _this.registerAction(action);

    _this.attachAction(triggerId, action.id);
  });

  _defineProperty(this, "getAction", function (id) {
    if (!_this.actions.has(id)) {
      throw new Error("Action [action.id = ".concat(id, "] not registered."));
    }

    return _this.actions.get(id);
  });

  _defineProperty(this, "getTriggerActions", function (triggerId) {
    // This line checks if trigger exists, otherwise throws.
    _this.getTrigger(triggerId);

    var actionIds = _this.triggerToActions.get(triggerId);

    var actions = actionIds.map(function (actionId) {
      return _this.actions.get(actionId);
    }).filter(Boolean);
    return actions;
  });

  _defineProperty(this, "getTriggerCompatibleActions", /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(triggerId, context) {
      var actions, isCompatibles;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              actions = _this.getTriggerActions(triggerId);
              _context.next = 3;
              return Promise.all(actions.map(function (action) {
                return action.isCompatible(context);
              }));

            case 3:
              isCompatibles = _context.sent;
              return _context.abrupt("return", actions.reduce(function (acc, action, i) {
                return isCompatibles[i] ? [].concat(_toConsumableArray(acc), [action]) : acc;
              }, []));

            case 5:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function (_x, _x2) {
      return _ref2.apply(this, arguments);
    };
  }());

  _defineProperty(this, "executeTriggerActions", /*#__PURE__*/function () {
    var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(triggerId, context) {
      var trigger;
      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              trigger = _this.getTrigger(triggerId);
              _context2.next = 3;
              return trigger.exec(context);

            case 3:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    }));

    return function (_x3, _x4) {
      return _ref3.apply(this, arguments);
    };
  }());

  _defineProperty(this, "clear", function () {
    _this.actions.clear();

    _this.triggers.clear();

    _this.triggerToActions.clear();
  });

  _defineProperty(this, "fork", function () {
    var triggers = new Map();
    var actions = new Map();
    var triggerToActions = new Map();

    var _iterator = _createForOfIteratorHelper(_this.triggers.entries()),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var _step$value = _slicedToArray(_step.value, 2),
            key = _step$value[0],
            value = _step$value[1];

        triggers.set(key, value);
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    var _iterator2 = _createForOfIteratorHelper(_this.actions.entries()),
        _step2;

    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var _step2$value = _slicedToArray(_step2.value, 2),
            _key = _step2$value[0],
            _value = _step2$value[1];

        actions.set(_key, _value);
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }

    var _iterator3 = _createForOfIteratorHelper(_this.triggerToActions.entries()),
        _step3;

    try {
      for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
        var _step3$value = _slicedToArray(_step3.value, 2),
            _key2 = _step3$value[0],
            _value2 = _step3$value[1];

        triggerToActions.set(_key2, _toConsumableArray(_value2));
      }
    } catch (err) {
      _iterator3.e(err);
    } finally {
      _iterator3.f();
    }

    return new UiActionsService({
      triggers: triggers,
      actions: actions,
      triggerToActions: triggerToActions
    });
  });

  this.triggers = _triggers;
  this.actions = _actions;
  this.triggerToActions = _triggerToActions;
};