function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { PureComponent } from 'react';
import _ from 'lodash';
import { injectI18n } from '@kbn/i18n/react';
import { EuiFieldText, EuiComboBox } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormRow } from './form_row';

var ListControlUi = /*#__PURE__*/function (_PureComponent) {
  _inherits(ListControlUi, _PureComponent);

  var _super = _createSuper(ListControlUi);

  function ListControlUi(props) {
    var _this;

    _classCallCheck(this, ListControlUi);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "isMounted", false);

    _defineProperty(_assertThisInitialized(_this), "state", {
      isLoading: false
    });

    _defineProperty(_assertThisInitialized(_this), "textInput", void 0);

    _defineProperty(_assertThisInitialized(_this), "componentDidMount", function () {
      if (_this.textInput) {
        _this.textInput.setAttribute('focusable', 'false'); // remove when #59039 is fixed

      }

      _this.isMounted = true;
    });

    _defineProperty(_assertThisInitialized(_this), "componentWillUnmount", function () {
      _this.isMounted = false;
    });

    _defineProperty(_assertThisInitialized(_this), "setTextInputRef", function (ref) {
      _this.textInput = ref;
    });

    _defineProperty(_assertThisInitialized(_this), "handleOnChange", function (selectedOptions) {
      var selectedValues = selectedOptions.map(function (_ref) {
        var value = _ref.value;
        return value;
      });

      _this.props.stageFilter(_this.props.controlIndex, selectedValues);
    });

    _defineProperty(_assertThisInitialized(_this), "debouncedFetch", _.debounce( /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(searchValue) {
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                if (!_this.props.fetchOptions) {
                  _context.next = 3;
                  break;
                }

                _context.next = 3;
                return _this.props.fetchOptions(searchValue);

              case 3:
                if (_this.isMounted) {
                  _this.setState({
                    isLoading: false
                  });
                }

              case 4:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function (_x) {
        return _ref2.apply(this, arguments);
      };
    }(), 300));

    _defineProperty(_assertThisInitialized(_this), "onSearchChange", function (searchValue) {
      _this.setState({
        isLoading: true
      }, _this.debouncedFetch.bind(null, searchValue));
    });

    _this.textInput = null;
    return _this;
  }

  _createClass(ListControlUi, [{
    key: "renderControl",
    value: function renderControl() {
      var _this$props$options,
          _this2 = this;

      var intl = this.props.intl;

      if (this.props.disableMsg) {
        return /*#__PURE__*/React.createElement(EuiFieldText, {
          "aria-label": intl.formatMessage({
            id: 'inputControl.vis.listControl.selectTextPlaceholder',
            defaultMessage: 'Select...'
          }),
          placeholder: intl.formatMessage({
            id: 'inputControl.vis.listControl.selectTextPlaceholder',
            defaultMessage: 'Select...'
          }),
          disabled: true
        });
      }

      var options = (_this$props$options = this.props.options) === null || _this$props$options === void 0 ? void 0 : _this$props$options.map(function (option) {
        return _defineProperty({
          label: _this2.props.formatOptionLabel(option).toString(),
          value: option
        }, 'data-test-subj', "option_".concat(option.toString().replace(' ', '_')));
      }).sort(function (a, b) {
        return a.label.toLowerCase().localeCompare(b.label.toLowerCase());
      });
      var selectedOptions = this.props.selectedOptions.map(function (selectedOption) {
        return {
          label: _this2.props.formatOptionLabel(selectedOption).toString(),
          value: selectedOption
        };
      });
      return /*#__PURE__*/React.createElement(EuiComboBox, {
        placeholder: intl.formatMessage({
          id: 'inputControl.vis.listControl.selectPlaceholder',
          defaultMessage: 'Select...'
        }),
        options: options,
        isLoading: this.state.isLoading,
        async: this.props.dynamicOptions,
        onSearchChange: this.props.dynamicOptions ? this.onSearchChange : undefined,
        selectedOptions: selectedOptions,
        onChange: this.handleOnChange,
        singleSelection: !this.props.multiselect,
        "data-test-subj": "listControlSelect".concat(this.props.controlIndex),
        inputRef: this.setTextInputRef
      });
    }
  }, {
    key: "render",
    value: function render() {
      var partialResultsWarningMessage = i18n.translate('inputControl.vis.listControl.partialResultsWarningMessage', {
        defaultMessage: 'Terms list might be incomplete because the request is taking too long. ' + 'Adjust the autocomplete settings in kibana.yml for complete results.'
      });
      return /*#__PURE__*/React.createElement(FormRow, {
        id: this.props.id,
        label: this.props.label,
        warningMsg: this.props.partialResults ? partialResultsWarningMessage : undefined,
        controlIndex: this.props.controlIndex,
        disableMsg: this.props.disableMsg
      }, this.renderControl());
    }
  }]);

  return ListControlUi;
}(PureComponent);

_defineProperty(ListControlUi, "defaultProps", {
  dynamicOptions: false,
  multiselect: true,
  selectedOptions: [],
  options: []
});

export var ListControl = injectI18n(ListControlUi);