function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState } from 'react'; // @ts-ignore

import { EuiInMemoryTable, EuiButtonIcon } from '@elastic/eui'; // @ts-ignore

import { RIGHT_ALIGNMENT } from '@elastic/eui/lib/services';
import { i18n } from '@kbn/i18n';
import { ShardFailureDescription } from './shard_failure_description';
import { getFailureSummaryText } from './shard_failure_description_header';
export function ShardFailureTable(_ref) {
  var failures = _ref.failures;
  var itemList = failures.map(function (failure, idx) {
    return _objectSpread(_objectSpread({}, {
      id: String(idx)
    }), failure);
  });
  var initalMap = {};

  var _useState = useState(initalMap),
      _useState2 = _slicedToArray(_useState, 2),
      expandMap = _useState2[0],
      setExpandMap = _useState2[1];

  var columns = [{
    align: RIGHT_ALIGNMENT,
    width: '40px',
    isExpander: true,
    render: function render(item) {
      var failureSummeryText = getFailureSummaryText(item);
      var collapseLabel = i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tableRowCollapse', {
        defaultMessage: 'Collapse {rowDescription}',
        description: 'Collapse a row of a table with failures',
        values: {
          rowDescription: failureSummeryText
        }
      });
      var expandLabel = i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tableRowExpand', {
        defaultMessage: 'Expand {rowDescription}',
        description: 'Expand a row of a table with failures',
        values: {
          rowDescription: failureSummeryText
        }
      });
      return /*#__PURE__*/React.createElement(EuiButtonIcon, {
        onClick: function onClick() {
          // toggle displaying the expanded view of the given list item
          var map = Object.assign({}, expandMap);

          if (map[item.id]) {
            delete map[item.id];
          } else {
            map[item.id] = /*#__PURE__*/React.createElement(ShardFailureDescription, item);
          }

          setExpandMap(map);
        },
        "aria-label": expandMap[item.id] ? collapseLabel : expandLabel,
        iconType: expandMap[item.id] ? 'arrowUp' : 'arrowDown'
      });
    }
  }, {
    field: 'shard',
    name: i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tableColShard', {
      defaultMessage: 'Shard'
    }),
    sortable: true,
    truncateText: true,
    width: '80px'
  }, {
    field: 'index',
    name: i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tableColIndex', {
      defaultMessage: 'Index'
    }),
    sortable: true,
    truncateText: true
  }, {
    field: 'node',
    name: i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tableColNode', {
      defaultMessage: 'Node'
    }),
    sortable: true,
    truncateText: true
  }, {
    field: 'reason.type',
    name: i18n.translate('data.search.searchSource.fetch.shardsFailedModal.tableColReason', {
      defaultMessage: 'Reason'
    }),
    truncateText: true
  }];
  return /*#__PURE__*/React.createElement(EuiInMemoryTable, {
    itemId: "id",
    items: itemList,
    columns: columns,
    pagination: true,
    sorting: {
      sort: {
        field: 'index',
        direction: 'desc'
      }
    },
    itemIdToExpandedRowMap: expandMap
  });
}