function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiPopover, EuiPopoverTitle, EuiPopoverFooter, EuiButtonEmpty, EuiButton, EuiFlexGroup, EuiFlexItem, EuiListGroup, EuiPagination, EuiText, EuiSpacer, EuiIcon } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import React, { useCallback, useEffect, useState, Fragment, useRef } from 'react';
import { sortBy } from 'lodash';
import { SavedQueryListItem } from './saved_query_list_item';
var perPage = 50;
export function SavedQueryManagementComponent(_ref) {
  var showSaveQuery = _ref.showSaveQuery,
      loadedSavedQuery = _ref.loadedSavedQuery,
      onSave = _ref.onSave,
      onSaveAsNew = _ref.onSaveAsNew,
      onLoad = _ref.onLoad,
      onClearSavedQuery = _ref.onClearSavedQuery,
      savedQueryService = _ref.savedQueryService;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isOpen = _useState2[0],
      setIsOpen = _useState2[1];

  var _useState3 = useState([]),
      _useState4 = _slicedToArray(_useState3, 2),
      savedQueries = _useState4[0],
      setSavedQueries = _useState4[1];

  var _useState5 = useState(0),
      _useState6 = _slicedToArray(_useState5, 2),
      count = _useState6[0],
      setTotalCount = _useState6[1];

  var _useState7 = useState(0),
      _useState8 = _slicedToArray(_useState7, 2),
      activePage = _useState8[0],
      setActivePage = _useState8[1];

  var cancelPendingListingRequest = useRef(function () {});
  useEffect(function () {
    var fetchCountAndSavedQueries = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var requestGotCancelled, _yield$savedQueryServ, savedQueryCount, savedQueryItems, sortedSavedQueryItems;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                cancelPendingListingRequest.current();
                requestGotCancelled = false;

                cancelPendingListingRequest.current = function () {
                  requestGotCancelled = true;
                };

                _context.next = 5;
                return savedQueryService.findSavedQueries('', perPage, activePage + 1);

              case 5:
                _yield$savedQueryServ = _context.sent;
                savedQueryCount = _yield$savedQueryServ.total;
                savedQueryItems = _yield$savedQueryServ.queries;

                if (!requestGotCancelled) {
                  _context.next = 10;
                  break;
                }

                return _context.abrupt("return");

              case 10:
                sortedSavedQueryItems = sortBy(savedQueryItems, 'attributes.title');
                setTotalCount(savedQueryCount);
                setSavedQueries(sortedSavedQueryItems);

              case 13:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function fetchCountAndSavedQueries() {
        return _ref2.apply(this, arguments);
      };
    }();

    if (isOpen) {
      fetchCountAndSavedQueries();
    }
  }, [isOpen, activePage, savedQueryService]);
  var handleTogglePopover = useCallback(function () {
    return setIsOpen(function (currentState) {
      return !currentState;
    });
  }, [setIsOpen]);
  var handleClosePopover = useCallback(function () {
    return setIsOpen(false);
  }, []);
  var handleSave = useCallback(function () {
    handleClosePopover();
    onSave();
  }, [handleClosePopover, onSave]);
  var handleSaveAsNew = useCallback(function () {
    handleClosePopover();
    onSaveAsNew();
  }, [handleClosePopover, onSaveAsNew]);
  var handleSelect = useCallback(function (savedQueryToSelect) {
    handleClosePopover();
    onLoad(savedQueryToSelect);
  }, [handleClosePopover, onLoad]);
  var handleDelete = useCallback(function (savedQueryToDelete) {
    var onDeleteSavedQuery = /*#__PURE__*/function () {
      var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(savedQuery) {
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                cancelPendingListingRequest.current();
                setSavedQueries(savedQueries.filter(function (currentSavedQuery) {
                  return currentSavedQuery.id !== savedQuery.id;
                }));

                if (loadedSavedQuery && loadedSavedQuery.id === savedQuery.id) {
                  onClearSavedQuery();
                }

                _context2.next = 5;
                return savedQueryService.deleteSavedQuery(savedQuery.id);

              case 5:
                setActivePage(0);

              case 6:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      return function onDeleteSavedQuery(_x) {
        return _ref3.apply(this, arguments);
      };
    }();

    onDeleteSavedQuery(savedQueryToDelete);
    handleClosePopover();
  }, [handleClosePopover, loadedSavedQuery, onClearSavedQuery, savedQueries, savedQueryService]);
  var savedQueryDescriptionText = i18n.translate('data.search.searchBar.savedQueryDescriptionText', {
    defaultMessage: 'Save query text and filters that you want to use again.'
  });
  var noSavedQueriesDescriptionText = i18n.translate('data.search.searchBar.savedQueryNoSavedQueriesText', {
    defaultMessage: 'There are no saved queries.'
  }) + ' ' + savedQueryDescriptionText;
  var savedQueryPopoverTitleText = i18n.translate('data.search.searchBar.savedQueryPopoverTitleText', {
    defaultMessage: 'Saved Queries'
  });

  var goToPage = function goToPage(pageNumber) {
    setActivePage(pageNumber);
  };

  var savedQueryPopoverButton = /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    onClick: handleTogglePopover,
    "aria-label": i18n.translate('data.search.searchBar.savedQueryPopoverButtonText', {
      defaultMessage: 'See saved queries'
    }),
    title: i18n.translate('data.search.searchBar.savedQueryPopoverButtonText', {
      defaultMessage: 'See saved queries'
    }),
    "data-test-subj": "saved-query-management-popover-button"
  }, /*#__PURE__*/React.createElement(EuiIcon, {
    type: "save",
    className: "euiQuickSelectPopover__buttonText"
  }), /*#__PURE__*/React.createElement(EuiIcon, {
    type: "arrowDown"
  }));

  var savedQueryRows = function savedQueryRows() {
    var savedQueriesWithoutCurrent = savedQueries.filter(function (savedQuery) {
      if (!loadedSavedQuery) return true;
      return savedQuery.id !== loadedSavedQuery.id;
    });
    var savedQueriesReordered = loadedSavedQuery && savedQueriesWithoutCurrent.length !== savedQueries.length ? [loadedSavedQuery].concat(_toConsumableArray(savedQueriesWithoutCurrent)) : _toConsumableArray(savedQueriesWithoutCurrent);
    return savedQueriesReordered.map(function (savedQuery) {
      return /*#__PURE__*/React.createElement(SavedQueryListItem, {
        key: savedQuery.id,
        savedQuery: savedQuery,
        isSelected: !!loadedSavedQuery && loadedSavedQuery.id === savedQuery.id,
        onSelect: handleSelect,
        onDelete: handleDelete,
        showWriteOperations: !!showSaveQuery
      });
    });
  };

  return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiPopover, {
    id: "savedQueryPopover",
    button: savedQueryPopoverButton,
    isOpen: isOpen,
    closePopover: handleClosePopover,
    anchorPosition: "downLeft",
    panelPaddingSize: "none",
    buffer: -8,
    ownFocus: true,
    repositionOnScroll: true
  }, /*#__PURE__*/React.createElement("div", {
    className: "kbnSavedQueryManagement__popover",
    "data-test-subj": "saved-query-management-popover"
  }, /*#__PURE__*/React.createElement(EuiPopoverTitle, {
    id: 'savedQueryManagementPopoverTitle'
  }, savedQueryPopoverTitleText), savedQueries.length > 0 ? /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiText, {
    size: "s",
    color: "subdued",
    className: "kbnSavedQueryManagement__text"
  }, /*#__PURE__*/React.createElement("p", null, savedQueryDescriptionText)), /*#__PURE__*/React.createElement("div", {
    className: "kbnSavedQueryManagement__listWrapper"
  }, /*#__PURE__*/React.createElement(EuiListGroup, {
    flush: true,
    className: "kbnSavedQueryManagement__list",
    "aria-labelledby": 'savedQueryManagementPopoverTitle'
  }, savedQueryRows())), /*#__PURE__*/React.createElement(EuiPagination, {
    className: "kbnSavedQueryManagement__pagination",
    pageCount: Math.ceil(count / perPage),
    activePage: activePage,
    onPageClick: goToPage
  })) : /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiText, {
    size: "s",
    color: "subdued",
    className: "kbnSavedQueryManagement__text"
  }, /*#__PURE__*/React.createElement("p", null, noSavedQueriesDescriptionText)), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/React.createElement(EuiPopoverFooter, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    direction: "rowReverse",
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false,
    wrap: true
  }, showSaveQuery && loadedSavedQuery && /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButton, {
    size: "s",
    fill: true,
    onClick: handleSave,
    "aria-label": i18n.translate('data.search.searchBar.savedQueryPopoverSaveChangesButtonAriaLabel', {
      defaultMessage: 'Save changes to {title}',
      values: {
        title: loadedSavedQuery.attributes.title
      }
    }),
    "data-test-subj": "saved-query-management-save-changes-button"
  }, i18n.translate('data.search.searchBar.savedQueryPopoverSaveChangesButtonText', {
    defaultMessage: 'Save changes'
  }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButton, {
    size: "s",
    onClick: handleSaveAsNew,
    "aria-label": i18n.translate('data.search.searchBar.savedQueryPopoverSaveAsNewButtonAriaLabel', {
      defaultMessage: 'Save as new saved query'
    }),
    "data-test-subj": "saved-query-management-save-as-new-button"
  }, i18n.translate('data.search.searchBar.savedQueryPopoverSaveAsNewButtonText', {
    defaultMessage: 'Save as new'
  })))), showSaveQuery && !loadedSavedQuery && /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButton, {
    size: "s",
    fill: true,
    onClick: handleSave,
    "aria-label": i18n.translate('data.search.searchBar.savedQueryPopoverSaveButtonAriaLabel', {
      defaultMessage: 'Save a new saved query'
    }),
    "data-test-subj": "saved-query-management-save-button"
  }, i18n.translate('data.search.searchBar.savedQueryPopoverSaveButtonText', {
    defaultMessage: 'Save current query'
  }))), /*#__PURE__*/React.createElement(EuiFlexItem, null), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, loadedSavedQuery && /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    size: "s",
    flush: "left",
    onClick: onClearSavedQuery,
    "aria-label": i18n.translate('data.search.searchBar.savedQueryPopoverClearButtonAriaLabel', {
      defaultMessage: 'Clear current saved query'
    }),
    "data-test-subj": "saved-query-management-clear-button"
  }, i18n.translate('data.search.searchBar.savedQueryPopoverClearButtonText', {
    defaultMessage: 'Clear'
  }))))))));
}