function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback, useEffect, useMemo, useState, useRef } from 'react';
import { i18n } from '@kbn/i18n';
import { memoize } from 'lodash';
import moment from 'moment';
import { keys, EuiSpacer, EuiIcon, EuiTitle, EuiFlexItem, EuiFlexGroup, EuiButtonEmpty, EuiButton } from '@elastic/eui';
import { useServicesContext } from '../../contexts';
import { HistoryViewer } from './history_viewer';
import { useEditorReadContext } from '../../contexts/editor_context';
import { useRestoreRequestFromHistory } from '../../hooks';
var CHILD_ELEMENT_PREFIX = 'historyReq';
export function ConsoleHistory(_ref) {
  var close = _ref.close;

  var _useServicesContext = useServicesContext(),
      history = _useServicesContext.services.history;

  var _useEditorReadContext = useEditorReadContext(),
      readOnlySettings = _useEditorReadContext.settings;

  var _useState = useState(history.getHistory()),
      _useState2 = _slicedToArray(_useState, 2),
      requests = _useState2[0],
      setPastRequests = _useState2[1];

  var clearHistory = useCallback(function () {
    history.clearHistory();
    setPastRequests(history.getHistory());
  }, [history]);
  var listRef = useRef(null);

  var _useState3 = useState(null),
      _useState4 = _slicedToArray(_useState3, 2),
      viewingReq = _useState4[0],
      setViewingReq = _useState4[1];

  var _useState5 = useState(0),
      _useState6 = _slicedToArray(_useState5, 2),
      selectedIndex = _useState6[0],
      setSelectedIndex = _useState6[1];

  var selectedReq = useRef(null);
  var describeReq = useMemo(function () {
    var _describeReq = function _describeReq(req) {
      var endpoint = req.endpoint;
      var date = moment(req.time);
      var formattedDate = date.format('MMM D');

      if (date.diff(moment(), 'days') > -7) {
        formattedDate = date.fromNow();
      }

      return "".concat(endpoint, " (").concat(formattedDate, ")");
    };

    _describeReq.cache = new WeakMap();
    return memoize(_describeReq);
  }, []);
  var scrollIntoView = useCallback(function (idx) {
    var activeDescendant = listRef.current.querySelector("#".concat(CHILD_ELEMENT_PREFIX).concat(idx));

    if (activeDescendant) {
      activeDescendant.scrollIntoView();
    }
  }, []);
  var initialize = useCallback(function () {
    var nextSelectedIndex = 0;
    describeReq.cache = new WeakMap();
    setViewingReq(requests[nextSelectedIndex]);
    selectedReq.current = requests[nextSelectedIndex];
    setSelectedIndex(nextSelectedIndex);
    scrollIntoView(nextSelectedIndex);
  }, [describeReq, requests, scrollIntoView]);

  var clear = function clear() {
    clearHistory();
    initialize();
  };

  var restoreRequestFromHistory = useRestoreRequestFromHistory();
  useEffect(function () {
    initialize();
  }, [initialize]);
  useEffect(function () {
    var done = history.change(setPastRequests);
    return function () {
      return done();
    };
  }, [history]);
  /* eslint-disable */

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", {
    className: "conHistory"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "s"
  }, /*#__PURE__*/React.createElement("h2", null, i18n.translate('console.historyPage.pageTitle', {
    defaultMessage: 'History'
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement("div", {
    className: "conHistory__body"
  }, /*#__PURE__*/React.createElement("ul", {
    ref: listRef,
    onKeyDown: function onKeyDown(ev) {
      if (ev.key === keys.ENTER) {
        restoreRequestFromHistory(selectedReq.current);
        return;
      }

      var currentIdx = selectedIndex;

      if (ev.key === keys.ARROW_UP) {
        ev.preventDefault();
        --currentIdx;
      } else if (ev.key === keys.ARROW_DOWN) {
        ev.preventDefault();
        ++currentIdx;
      }

      var nextSelectedIndex = Math.min(Math.max(0, currentIdx), requests.length - 1);
      setViewingReq(requests[nextSelectedIndex]);
      selectedReq.current = requests[nextSelectedIndex];
      setSelectedIndex(nextSelectedIndex);
      scrollIntoView(nextSelectedIndex);
    },
    role: "listbox",
    className: "list-group conHistory__reqs",
    tabIndex: 0,
    "aria-activedescendant": "".concat(CHILD_ELEMENT_PREFIX).concat(selectedIndex),
    "aria-label": i18n.translate('console.historyPage.requestListAriaLabel', {
      defaultMessage: 'History of sent requests'
    })
  }, requests.map(function (req, idx) {
    var reqDescription = describeReq(req);
    var isSelected = viewingReq === req;
    return (
      /*#__PURE__*/
      // Ignore a11y issues on li's
      // eslint-disable-next-line
      React.createElement("li", {
        key: idx,
        id: "".concat(CHILD_ELEMENT_PREFIX).concat(idx),
        className: "list-group-item conHistory__req ".concat(isSelected ? 'conHistory__req-selected' : ''),
        onClick: function onClick() {
          setViewingReq(req);
          selectedReq.current = req;
          setSelectedIndex(idx);
        },
        role: "option",
        onMouseEnter: function onMouseEnter() {
          return setViewingReq(req);
        },
        onMouseLeave: function onMouseLeave() {
          return setViewingReq(selectedReq.current);
        },
        onDoubleClick: function onDoubleClick() {
          return restoreRequestFromHistory(selectedReq.current);
        },
        "aria-label": i18n.translate('console.historyPage.itemOfRequestListAriaLabel', {
          defaultMessage: 'Request: {historyItem}',
          values: {
            historyItem: reqDescription
          }
        }),
        "aria-selected": isSelected
      }, reqDescription, /*#__PURE__*/React.createElement("span", {
        className: "conHistory__reqIcon"
      }, /*#__PURE__*/React.createElement(EuiIcon, {
        type: "arrowRight"
      })))
    );
  })), /*#__PURE__*/React.createElement("div", {
    className: "conHistory__body__spacer"
  }), /*#__PURE__*/React.createElement(HistoryViewer, {
    settings: readOnlySettings,
    req: viewingReq
  })), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    color: "danger",
    onClick: function onClick() {
      return clear();
    }
  }, i18n.translate('console.historyPage.clearHistoryButtonLabel', {
    defaultMessage: 'Clear'
  }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    color: "primary",
    onClick: function onClick() {
      return close();
    }
  }, i18n.translate('console.historyPage.closehistoryButtonLabel', {
    defaultMessage: 'Close'
  }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButton, {
    color: "primary",
    disabled: !selectedReq,
    onClick: function onClick() {
      return restoreRequestFromHistory(selectedReq.current);
    }
  }, i18n.translate('console.historyPage.applyHistoryButtonLabel', {
    defaultMessage: 'Apply'
  }))))))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }));
}