function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { PersistedLog } from './persisted_log';
import { createLogKey } from './create_log_key';

/** @internal */
export var RecentlyAccessedService = /*#__PURE__*/function () {
  function RecentlyAccessedService() {
    _classCallCheck(this, RecentlyAccessedService);
  }

  _createClass(RecentlyAccessedService, [{
    key: "start",
    value: function () {
      var _start = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref) {
        var http, logKey, history;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                http = _ref.http;
                _context.next = 3;
                return createLogKey('recentlyAccessed', http.basePath.get());

              case 3:
                logKey = _context.sent;
                history = new PersistedLog(logKey, {
                  maxLength: 20,
                  isEqual: function isEqual(oldItem, newItem) {
                    return oldItem.id === newItem.id;
                  }
                });
                return _context.abrupt("return", {
                  /** Adds a new item to the history. */
                  add: function add(link, label, id) {
                    history.add({
                      link: link,
                      label: label,
                      id: id
                    });
                  },

                  /** Gets the current array of history items. */
                  get: function get() {
                    return history.get();
                  },

                  /** Gets an observable of the current array of history items. */
                  get$: function get$() {
                    return history.get$();
                  }
                });

              case 6:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function start(_x) {
        return _start.apply(this, arguments);
      }

      return start;
    }()
  }]);

  return RecentlyAccessedService;
}();
/**
 * {@link ChromeRecentlyAccessed | APIs} for recently accessed history.
 * @public
 */