function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect, useCallback, useMemo, useState } from 'react';
import PropTypes from "prop-types";
import { createPortal } from 'react-dom';
import { enqueueStateChange } from '../../services/react';
import { EuiMutationObserver } from '../observer/mutation_observer';

function noop() {}

function getElementText(element) {
  return 'innerText' in element ? element.innerText : // (this line left here to satisfy Prettier since a ts-ignore is used on the next line)
  // @ts-ignore TypeScript thinks element.innerText always exists, however it doesn't in jest/jsdom enviornment
  element.textContent || undefined;
}

export var EuiDataGridInMemoryRenderer = function EuiDataGridInMemoryRenderer(_ref) {
  var inMemory = _ref.inMemory,
      columns = _ref.columns,
      rowCount = _ref.rowCount,
      renderCellValue = _ref.renderCellValue,
      onCellRender = _ref.onCellRender;

  var _useState = useState(function () {
    return document.createDocumentFragment();
  }),
      _useState2 = _slicedToArray(_useState, 1),
      documentFragment = _useState2[0];

  var cells = useMemo(function () {
    var CellElement = renderCellValue;
    var cells = [];

    var _loop = function _loop(i) {
      cells.push(columns.map(function (column) {
        var skipThisColumn = inMemory.skipColumns && inMemory.skipColumns.indexOf(column.id) !== -1;

        if (skipThisColumn) {
          return null;
        }

        var isExpandable = column.isExpandable !== undefined ? column.isExpandable : true;
        return React.createElement("div", {
          key: "".concat(i, "-").concat(column.id),
          "data-dg-row": i,
          "data-dg-column": column.id
        }, React.createElement(CellElement, {
          rowIndex: i,
          columnId: column.id,
          setCellProps: noop,
          isExpandable: isExpandable,
          isExpanded: false,
          isDetails: false
        }));
      }).filter(function (cell) {
        return cell != null;
      }));
    };

    for (var i = 0; i < rowCount; i++) {
      _loop(i);
    }

    return cells;
  }, [rowCount, columns, inMemory.skipColumns, renderCellValue]);
  var onMutation = useCallback(function (records) {
    var _loop2 = function _loop2(i) {
      var record = records[i];
      var target = record.target;

      while (true) {
        if (target == null) return "continue|recordLoop"; // somehow hit the document fragment

        if (target.nodeType === Node.ELEMENT_NODE && target.hasAttribute('data-dg-row')) {
          // target is the cell wrapping div
          break;
        }

        target = target.parentElement;
      }

      var cellDiv = target;
      var rowIndex = parseInt(cellDiv.getAttribute('data-dg-row'), 10);
      var column = cellDiv.getAttribute('data-dg-column');
      enqueueStateChange(function () {
        return onCellRender(rowIndex, column, getElementText(cellDiv));
      });
    };

    recordLoop: for (var i = 0; i < records.length; i++) {
      var _ret = _loop2(i);

      if (_ret === "continue|recordLoop") continue recordLoop;
    }
  }, [onCellRender]);
  useEffect(function () {
    var cellDivs = documentFragment.childNodes[0].childNodes;

    for (var i = 0; i < cellDivs.length; i++) {
      var cellDiv = cellDivs[i];

      var _rowIndex = parseInt(cellDiv.getAttribute('data-dg-row'), 10);

      var column = cellDiv.getAttribute('data-dg-column');
      onCellRender(_rowIndex, column, getElementText(cellDiv));
    } // changes to documentFragment.children is reflected by `cells`
    // eslint-disable-next-line react-hooks/exhaustive-deps

  }, [onCellRender, cells]);
  return createPortal(React.createElement(EuiMutationObserver, {
    onMutation: onMutation,
    observerOptions: {
      characterData: true,
      subtree: true,
      attributes: true,
      childList: true
    }
  }, function (ref) {
    return React.createElement("div", {
      ref: ref
    }, cells);
  }), documentFragment);
};
EuiDataGridInMemoryRenderer.propTypes = {
  inMemory: PropTypes.shape({
    /**
        Given the data flow Sorting->Pagination:
        Each step can be performed by service calls or in-memory by the grid.
        However, we cannot allow any service calls after an in-memory operation.
        E.g. if Pagination requires a service call the grid cannot perform
        in-memory Sorting. This means a single value representing the
        service / in-memory boundary can be used. Thus there are four states for in-memory's level:
        * "enhancements" - no in-memory operations, but use the available data to enhance the grid
        * "pagination" - only pagination is performed in-memory
        * "sorting" - sorting & pagination is performed in-memory
     */
    level: PropTypes.oneOf(["enhancements", "pagination", "sorting"]).isRequired,

    /**
       * An array of column ids for the in-memory processing to skip
       */
    skipColumns: PropTypes.arrayOf(PropTypes.string.isRequired)
  }).isRequired,
  columns: PropTypes.arrayOf(PropTypes.shape({
    /**
       * The unique identifier for this column
       */
    id: PropTypes.string.isRequired,

    /**
       * A `ReactNode` used when rendering the column header. When providing complicated content, please make sure to utilize CSS to respect truncation as space allows. Check the docs example.
       */
    display: PropTypes.node,

    /**
       * A Schema to use for the column. Built-in values are ['boolean', 'currency', 'datetime', 'numeric', 'json'] but can be expanded by defining your own #EuiDataGrid `schemaDetectors` (for in-memory detection). In general, it is advised to pass in a value here when you are sure of the schema ahead of time, so that you don't need to rely on the automatic detection.
       */
    schema: PropTypes.string,

    /**
       * Defaults to true. Defines whether or not the column's cells can be expanded with a popup onClick / keydown.
       */
    isExpandable: PropTypes.bool,

    /**
       * Whether this column's width can be changed by the user, defaults to true
       */
    isResizable: PropTypes.bool,

    /**
       * Initial width (in pixels) of the column
       */
    initialWidth: PropTypes.number,

    /**
       * Whether this column is sortable
       */
    isSortable: PropTypes.bool,

    /**
       * Default sort direction of the column
       */
    defaultSortDirection: PropTypes.oneOf(["asc", "desc"]),

    /**
       * Display name as text for column. This can be used to display column name in column selector and column sorting where `display` won't be used. If not used `id` will be shown as column name in column selector and column sorting.
       */
    displayAsText: PropTypes.string
  }).isRequired).isRequired,
  rowCount: PropTypes.number.isRequired,
  renderCellValue: PropTypes.oneOfType([PropTypes.func.isRequired, PropTypes.func.isRequired]).isRequired,
  onCellRender: PropTypes.func.isRequired
};