"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var canvas_1 = require("../../../../../renderers/canvas");
var spec_1 = require("../../../state/utils/spec");
var debug_1 = require("../utils/debug");
var line_1 = require("./line");
var tick_1 = require("./tick");
var tick_label_1 = require("./tick_label");
var title_1 = require("./title");
function renderAxes(ctx, props) {
    var axesVisibleTicks = props.axesVisibleTicks, axesSpecs = props.axesSpecs, axesTicksDimensions = props.axesTicksDimensions, axesPositions = props.axesPositions, axisStyle = props.axisStyle, debug = props.debug, chartDimensions = props.chartDimensions;
    axesVisibleTicks.forEach(function (ticks, axisId) {
        var axisSpec = spec_1.getSpecsById(axesSpecs, axisId);
        var axisTicksDimensions = axesTicksDimensions.get(axisId);
        var axisPosition = axesPositions.get(axisId);
        if (!ticks || !axisSpec || !axisTicksDimensions || !axisPosition) {
            return;
        }
        renderAxis(ctx, {
            axisSpec: axisSpec,
            axisTicksDimensions: axisTicksDimensions,
            axisPosition: axisPosition,
            ticks: ticks,
            axisConfig: axisStyle,
            debug: debug,
            chartDimensions: chartDimensions,
        });
    });
}
exports.renderAxes = renderAxes;
function renderAxis(ctx, props) {
    canvas_1.withContext(ctx, function (ctx) {
        var ticks = props.ticks, axisPosition = props.axisPosition, debug = props.debug;
        ctx.translate(axisPosition.left, axisPosition.top);
        if (debug) {
            debug_1.renderDebugRect(ctx, {
                x: 0,
                y: 0,
                width: axisPosition.width,
                height: axisPosition.height,
            });
        }
        canvas_1.withContext(ctx, function (ctx) {
            line_1.renderLine(ctx, props);
        });
        canvas_1.withContext(ctx, function (ctx) {
            ticks.forEach(function (tick) {
                tick_1.renderTick(ctx, tick, props);
            });
        });
        canvas_1.withContext(ctx, function (ctx) {
            ticks
                .filter(function (tick) { return tick.label !== null; })
                .forEach(function (tick) {
                tick_label_1.renderTickLabel(ctx, tick, props);
            });
        });
        canvas_1.withContext(ctx, function (ctx) {
            title_1.renderTitle(ctx, props);
        });
    });
}
//# sourceMappingURL=index.js.map