/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.util.IndentingWriter;

public class RegisterFormatter {
    @Nonnull
    public final BaksmaliOptions options;
    public final int registerCount;
    public final int parameterRegisterCount;

    public RegisterFormatter(@Nonnull BaksmaliOptions options, int registerCount, int parameterRegisterCount) {
        this.options = options;
        this.registerCount = registerCount;
        this.parameterRegisterCount = parameterRegisterCount;
    }

    public void writeRegisterRange(IndentingWriter writer, int startRegister, int lastRegister) throws IOException {
        if (this.options.parameterRegisters) {
            assert (startRegister <= lastRegister);
            if (startRegister >= this.registerCount - this.parameterRegisterCount) {
                writer.write("{p");
                writer.printSignedIntAsDec(startRegister - (this.registerCount - this.parameterRegisterCount));
                writer.write(" .. p");
                writer.printSignedIntAsDec(lastRegister - (this.registerCount - this.parameterRegisterCount));
                writer.write(125);
                return;
            }
        }
        writer.write("{v");
        writer.printSignedIntAsDec(startRegister);
        writer.write(" .. v");
        writer.printSignedIntAsDec(lastRegister);
        writer.write(125);
    }

    public void writeTo(IndentingWriter writer, int register) throws IOException {
        if (this.options.parameterRegisters && register >= this.registerCount - this.parameterRegisterCount) {
            writer.write(112);
            writer.printSignedIntAsDec(register - (this.registerCount - this.parameterRegisterCount));
            return;
        }
        writer.write(118);
        writer.printSignedIntAsDec(register);
    }
}

