import{Keys}from'./KeyboardShortcut.js';import{ElementFocusRestorer,markBeingEdited}from'./UIUtils.js';export class InplaceEditor{static startEditing(element,config){if(!InplaceEditor._defaultInstance){InplaceEditor._defaultInstance=new InplaceEditor();}
return InplaceEditor._defaultInstance.startEditing(element,config);}
editorContent(editingContext){const element=editingContext.element;if(element.tagName==='INPUT'&&element.type==='text'){return element.value;}
return element.textContent;}
setUpEditor(editingContext){const element=editingContext.element;element.classList.add('editing');element.setAttribute('contenteditable','plaintext-only');const oldRole=element.getAttribute('role');UI.ARIAUtils.markAsTextBox(element);editingContext.oldRole=oldRole;const oldTabIndex=element.getAttribute('tabIndex');if(typeof oldTabIndex!=='number'||oldTabIndex<0){element.tabIndex=0;}
this._focusRestorer=new ElementFocusRestorer(element);editingContext.oldTabIndex=oldTabIndex;}
closeEditor(editingContext){const element=editingContext.element;element.classList.remove('editing');element.removeAttribute('contenteditable');if(typeof editingContext.oldRole!=='string'){element.removeAttribute('role');}else{element.role=editingContext.oldRole;}
if(typeof editingContext.oldTabIndex!=='number'){element.removeAttribute('tabIndex');}else{element.tabIndex=editingContext.oldTabIndex;}
element.scrollTop=0;element.scrollLeft=0;}
cancelEditing(editingContext){const element=editingContext.element;if(element.tagName==='INPUT'&&element.type==='text'){element.value=editingContext.oldText;}else{element.textContent=editingContext.oldText;}}
augmentEditingHandle(editingContext,handle){}
startEditing(element,config){if(!markBeingEdited(element,true)){return null;}
config=config||new InplaceEditor.Config(function(){},function(){});const editingContext={element:element,config:config};const committedCallback=config.commitHandler;const cancelledCallback=config.cancelHandler;const pasteCallback=config.pasteHandler;const context=config.context;let moveDirection='';const self=this;this.setUpEditor(editingContext);editingContext.oldText=this.editorContent(editingContext);function blurEventListener(e){if(config.blurHandler&&!config.blurHandler(element,e)){return;}
editingCommitted.call(element);}
function cleanUpAfterEditing(){markBeingEdited(element,false);element.removeEventListener('blur',blurEventListener,false);element.removeEventListener('keydown',keyDownEventListener,true);if(pasteCallback){element.removeEventListener('paste',pasteEventListener,true);}
if(self._focusRestorer){self._focusRestorer.restore();}
self.closeEditor(editingContext);}
function editingCancelled(){self.cancelEditing(editingContext);cleanUpAfterEditing();cancelledCallback(this,context);}
function editingCommitted(){cleanUpAfterEditing();committedCallback(this,self.editorContent(editingContext),editingContext.oldText,context,moveDirection);}
function defaultFinishHandler(event){if(isEnterKey(event)){return'commit';}else if(event.keyCode===Keys.Esc.code||event.key==='Escape'){return'cancel';}else if(event.key==='Tab'){return'move-'+(event.shiftKey?'backward':'forward');}
return'';}
function handleEditingResult(result,event){if(result==='commit'){editingCommitted.call(element);event.consume(true);}else if(result==='cancel'){editingCancelled.call(element);event.consume(true);}else if(result&&result.startsWith('move-')){moveDirection=result.substring(5);if(event.key==='Tab'){event.consume(true);}
blurEventListener();}}
function pasteEventListener(event){const result=pasteCallback(event);handleEditingResult(result,event);}
function keyDownEventListener(event){let result=defaultFinishHandler(event);if(!result&&config.postKeydownFinishHandler){result=config.postKeydownFinishHandler(event);}
handleEditingResult(result,event);}
element.addEventListener('blur',blurEventListener,false);element.addEventListener('keydown',keyDownEventListener,true);if(pasteCallback){element.addEventListener('paste',pasteEventListener,true);}
const handle={cancel:editingCancelled.bind(element),commit:editingCommitted.bind(element)};this.augmentEditingHandle(editingContext,handle);return handle;}}
export class Config{constructor(commitHandler,cancelHandler,context,blurHandler){this.commitHandler=commitHandler;this.cancelHandler=cancelHandler;this.context=context;this.blurHandler=blurHandler;this.pasteHandler;this.postKeydownFinishHandler;}
setPasteHandler(pasteHandler){this.pasteHandler=pasteHandler;}
setPostKeydownFinishHandler(postKeydownFinishHandler){this.postKeydownFinishHandler=postKeydownFinishHandler;}}