/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.ObjectWithId;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Specification;

public class FreeColModFile
extends FreeColDataFile
implements ObjectWithId {
    protected static final String SPECIFICATION_FILE = "specification.xml";
    protected static final String MOD_DESCRIPTOR_FILE = "mod.xml";
    private static final FileFilter fileFilter = FreeColModFile.makeFileFilter("mod.xml", "fmd", "zip");
    private String id;
    private String parent;

    public FreeColModFile(File file) throws IOException {
        super(file);
        this.readModDescriptor();
    }

    public InputStream getSpecificationInputStream() throws IOException {
        try {
            return this.getInputStream(SPECIFICATION_FILE);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public Specification getSpecification() throws IOException {
        try (InputStream si = this.getSpecificationInputStream();){
            Specification specification = si == null ? null : new Specification(si);
            return specification;
        }
    }

    private InputStream getModDescriptorInputStream() throws IOException {
        return this.getInputStream(MOD_DESCRIPTOR_FILE);
    }

    protected void readModDescriptor() throws IOException {
        try (FreeColXMLReader xr = new FreeColXMLReader(this.getModDescriptorInputStream());){
            xr.nextTag();
            this.id = xr.readId();
            this.parent = xr.getAttribute("parent", null);
        }
        catch (XMLStreamException xse) {
            throw new IOException(xse);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getParent() {
        return this.parent;
    }

    public static FileFilter getFileFilter() {
        return fileFilter;
    }
}

