/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.samples;

import com.coremedia.iso.boxes.Container;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.TrackBox;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.Logger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMp4SampleList
extends AbstractList<Sample> {
    private static final Logger LOG = Logger.getLogger(DefaultMp4SampleList.class);
    Container topLevel;
    TrackBox trackBox = null;
    SoftReference<ByteBuffer>[] cache = null;
    int[] chunkNumsStartSampleNum;
    long[] chunkOffsets;
    long[] chunkSizes;
    long[][] sampleOffsetsWithinChunks;
    SampleSizeBox ssb;
    int lastChunk = 0;

    /*
     * Unable to fully structure code
     */
    public DefaultMp4SampleList(long track, Container topLevel) {
        super();
        this.topLevel = topLevel;
        movieBox = topLevel.getBoxes(MovieBox.class).get(0);
        trackBoxes = movieBox.getBoxes(TrackBox.class);
        for (TrackBox tb : trackBoxes) {
            if (tb.getTrackHeaderBox().getTrackId() != track) continue;
            this.trackBox = tb;
        }
        if (this.trackBox == null) {
            throw new RuntimeException("This MP4 does not contain track " + track);
        }
        this.chunkOffsets = this.trackBox.getSampleTableBox().getChunkOffsetBox().getChunkOffsets();
        this.chunkSizes = new long[this.chunkOffsets.length];
        this.cache = new SoftReference[this.chunkOffsets.length];
        Arrays.fill(this.cache, new SoftReference<Object>(null));
        this.sampleOffsetsWithinChunks = new long[this.chunkOffsets.length][];
        this.ssb = this.trackBox.getSampleTableBox().getSampleSizeBox();
        s2chunkEntries = this.trackBox.getSampleTableBox().getSampleToChunkBox().getEntries();
        entries = s2chunkEntries.toArray(new SampleToChunkBox.Entry[s2chunkEntries.size()]);
        s2cIndex = 0;
        next = entries[s2cIndex++];
        currentChunkNo = 0;
        currentSamplePerChunk = 0;
        nextFirstChunk = next.getFirstChunk();
        nextSamplePerChunk = CastUtils.l2i(next.getSamplesPerChunk());
        currentSampleNo = 1;
        lastSampleNo = this.size();
        do {
            if ((long)(++currentChunkNo) == nextFirstChunk) {
                currentSamplePerChunk = nextSamplePerChunk;
                if (entries.length > s2cIndex) {
                    next = entries[s2cIndex++];
                    nextSamplePerChunk = CastUtils.l2i(next.getSamplesPerChunk());
                    nextFirstChunk = next.getFirstChunk();
                } else {
                    nextSamplePerChunk = -1;
                    nextFirstChunk = 0x7FFFFFFFFFFFFFFFL;
                }
            }
            this.sampleOffsetsWithinChunks[currentChunkNo - 1] = new long[currentSamplePerChunk];
        } while ((currentSampleNo += currentSamplePerChunk) <= lastSampleNo);
        this.chunkNumsStartSampleNum = new int[currentChunkNo + 1];
        s2cIndex = 0;
        next = entries[s2cIndex++];
        currentChunkNo = 0;
        currentSamplePerChunk = 0;
        nextFirstChunk = next.getFirstChunk();
        nextSamplePerChunk = CastUtils.l2i(next.getSamplesPerChunk());
        currentSampleNo = 1;
        do {
            this.chunkNumsStartSampleNum[currentChunkNo++] = currentSampleNo;
            if ((long)currentChunkNo != nextFirstChunk) continue;
            currentSamplePerChunk = nextSamplePerChunk;
            if (entries.length > s2cIndex) {
                next = entries[s2cIndex++];
                nextSamplePerChunk = CastUtils.l2i(next.getSamplesPerChunk());
                nextFirstChunk = next.getFirstChunk();
                continue;
            }
            nextSamplePerChunk = -1;
            nextFirstChunk = 0x7FFFFFFFFFFFFFFFL;
        } while ((currentSampleNo += currentSamplePerChunk) <= lastSampleNo);
        this.chunkNumsStartSampleNum[currentChunkNo] = 0x7FFFFFFF;
        currentChunkNo = 0;
        sampleSum = 0L;
        i = 1;
        ** GOTO lbl78
        {
            ++currentChunkNo;
            sampleSum = 0L;
            do {
                if (i == this.chunkNumsStartSampleNum[currentChunkNo]) continue block3;
                v0 = currentChunkNo - 1;
                this.chunkSizes[v0] = this.chunkSizes[v0] + this.ssb.getSampleSizeAtIndex(i - 1);
                sampleOffsetsWithinChunkscurrentChunkNo = this.sampleOffsetsWithinChunks[currentChunkNo - 1];
                chunkNumsStartSampleNumcurrentChunkNo = this.chunkNumsStartSampleNum[currentChunkNo - 1];
                sampleOffsetsWithinChunkscurrentChunkNo[i - chunkNumsStartSampleNumcurrentChunkNo] = sampleSum;
                sampleSum += this.ssb.getSampleSizeAtIndex(i - 1);
                ++i;
lbl78:
                // 2 sources

            } while ((long)i <= this.ssb.getSampleCount());
        }
    }

    synchronized int getChunkForSample(int index) {
        int sampleNum = index + 1;
        if (sampleNum >= this.chunkNumsStartSampleNum[this.lastChunk] && sampleNum < this.chunkNumsStartSampleNum[this.lastChunk + 1]) {
            return this.lastChunk;
        }
        if (sampleNum < this.chunkNumsStartSampleNum[this.lastChunk]) {
            this.lastChunk = 0;
            while (this.chunkNumsStartSampleNum[this.lastChunk + 1] <= sampleNum) {
                ++this.lastChunk;
            }
            return this.lastChunk;
        }
        ++this.lastChunk;
        while (this.chunkNumsStartSampleNum[this.lastChunk + 1] <= sampleNum) {
            ++this.lastChunk;
        }
        return this.lastChunk;
    }

    @Override
    public Sample get(int index) {
        if ((long)index >= this.ssb.getSampleCount()) {
            throw new IndexOutOfBoundsException();
        }
        return new SampleImpl(index);
    }

    @Override
    public int size() {
        return CastUtils.l2i(this.trackBox.getSampleTableBox().getSampleSizeBox().getSampleCount());
    }

    class SampleImpl
    implements Sample {
        private int index;

        public SampleImpl(int index) {
            this.index = index;
        }

        public void writeTo(WritableByteChannel channel) throws IOException {
            channel.write(this.asByteBuffer());
        }

        public long getSize() {
            return DefaultMp4SampleList.this.ssb.getSampleSizeAtIndex(this.index);
        }

        public synchronized ByteBuffer asByteBuffer() {
            ByteBuffer chunkBuffer;
            int chunkNumber = DefaultMp4SampleList.this.getChunkForSample(this.index);
            SoftReference<ByteBuffer> chunkBufferSr = DefaultMp4SampleList.this.cache[chunkNumber];
            int chunkStartSample = DefaultMp4SampleList.this.chunkNumsStartSampleNum[chunkNumber] - 1;
            int sampleInChunk = this.index - chunkStartSample;
            long[] sampleOffsetsWithinChunk = DefaultMp4SampleList.this.sampleOffsetsWithinChunks[CastUtils.l2i(chunkNumber)];
            long offsetWithInChunk = sampleOffsetsWithinChunk[sampleInChunk];
            if (chunkBufferSr == null || (chunkBuffer = chunkBufferSr.get()) == null) {
                try {
                    chunkBuffer = DefaultMp4SampleList.this.topLevel.getByteBuffer(DefaultMp4SampleList.this.chunkOffsets[CastUtils.l2i(chunkNumber)], sampleOffsetsWithinChunk[sampleOffsetsWithinChunk.length - 1] + DefaultMp4SampleList.this.ssb.getSampleSizeAtIndex(chunkStartSample + sampleOffsetsWithinChunk.length - 1));
                    DefaultMp4SampleList.this.cache[chunkNumber] = new SoftReference<ByteBuffer>(chunkBuffer);
                }
                catch (IOException e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    LOG.logError(sw.toString());
                    throw new IndexOutOfBoundsException(e.getMessage());
                }
            }
            ByteBuffer b = (ByteBuffer)((ByteBuffer)chunkBuffer.duplicate().position(CastUtils.l2i(offsetWithInChunk))).slice().limit(CastUtils.l2i(DefaultMp4SampleList.this.ssb.getSampleSizeAtIndex(this.index)));
            return b;
        }

        public String toString() {
            return "Sample(index: " + this.index + " size: " + DefaultMp4SampleList.this.ssb.getSampleSizeAtIndex(this.index) + ")";
        }
    }
}

