/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.OneNoteDirectFileResource;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

class OneNoteLegacyDumpStrings {
    public static int MIN_STRING_LENGTH = 8;
    public static float ACCEPTABLE_ALPHA_TO_OTHER_CHAR_RATIO = 0.6f;
    OneNoteDirectFileResource oneNoteDirectFileResource;
    XHTMLContentHandler xhtml;

    public OneNoteLegacyDumpStrings(OneNoteDirectFileResource oneNoteDirectFileResource, XHTMLContentHandler xhtml) {
        this.oneNoteDirectFileResource = oneNoteDirectFileResource;
        this.xhtml = xhtml;
    }

    public void dump() throws TikaException, SAXException {
        this.dumpAscii();
        this.dumpUtf16LE();
    }

    private void dumpAscii() throws SAXException, TikaException {
        try {
            this.oneNoteDirectFileResource.position(0L);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int b = this.oneNoteDirectFileResource.read();
            while (b != -1) {
                if (b >= 32 && b < 127) {
                    os.write(b);
                } else {
                    if (os.size() >= MIN_STRING_LENGTH) {
                        this.writeIfUseful(os);
                    }
                    os.reset();
                }
                b = this.oneNoteDirectFileResource.read();
            }
            if (os.size() >= MIN_STRING_LENGTH) {
                this.writeIfUseful(os);
            }
        }
        catch (IOException e) {
            throw new TikaException("Could not extract text from legacy OneNote document", (Throwable)e);
        }
    }

    private void dumpUtf16LE() throws SAXException, TikaException {
        try {
            this.oneNoteDirectFileResource.position(0L);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            long sz = this.oneNoteDirectFileResource.size();
            for (long i = 0L; i < sz - 1L; ++i) {
                this.oneNoteDirectFileResource.position(i);
                int c1 = this.oneNoteDirectFileResource.read();
                int c2 = this.oneNoteDirectFileResource.read();
                if (c1 == 0 && c2 >= 32 && c2 < 127) {
                    ++i;
                    os.write(c2);
                    continue;
                }
                if (os.size() >= MIN_STRING_LENGTH) {
                    this.writeIfUseful(os);
                }
                os.reset();
            }
            if (os.size() >= MIN_STRING_LENGTH) {
                this.writeIfUseful(os);
            }
        }
        catch (IOException e) {
            throw new TikaException("Could not extract text from legacy OneNote document", (Throwable)e);
        }
    }

    private void writeIfUseful(ByteArrayOutputStream os) throws SAXException {
        String str = new String(os.toByteArray(), StandardCharsets.US_ASCII);
        String[] spl = str.split(" ");
        if (spl.length > 1) {
            int numAlpha = 0;
            for (int i = 0; i < str.length(); ++i) {
                if (!Character.isAlphabetic(str.charAt(i)) && !Character.isWhitespace(i)) continue;
                ++numAlpha;
            }
            float ratioAlphaToOtherChars = (float)numAlpha / (float)str.length();
            if (ratioAlphaToOtherChars > ACCEPTABLE_ALPHA_TO_OTHER_CHAR_RATIO) {
                this.xhtml.characters(str);
                this.xhtml.characters("\n");
            }
        }
    }
}

